/*
 * Decompiled with CFR 0.152.
 */
package mb.pie.api;

import java.io.Serializable;
import mb.pie.api.ExecContext;
import mb.pie.api.STaskDef;
import mb.pie.api.StringUtil;
import mb.pie.api.Supplier;
import mb.pie.api.Task;
import mb.pie.api.TaskDef;
import mb.pie.api.TaskDefs;
import org.checkerframework.checker.nullness.qual.Nullable;

public class STask<O extends Serializable>
implements Supplier<O>,
Serializable {
    public final String id;
    public final Serializable input;

    public <I extends Serializable> STask(TaskDef<I, O> taskDef, I input) {
        this.id = taskDef.getId();
        this.input = input;
    }

    public <I extends Serializable> STask(STaskDef<I, O> sTaskDef, I input) {
        this.id = sTaskDef.id;
        this.input = input;
    }

    public STask(String id, Serializable input) {
        this.id = id;
        this.input = input;
    }

    public Task<O> toTask(TaskDefs taskDefs) {
        @Nullable TaskDef<?, ?> taskDef = taskDefs.getTaskDef(this.id);
        if (taskDef == null) {
            throw new RuntimeException("Cannot get task definition for id " + this.id + "; task definition with that id does not exist");
        }
        return new Task(taskDef, this.input);
    }

    @Override
    public O get(ExecContext context) {
        return context.require(this);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        STask sTask = (STask)o;
        if (!this.id.equals(sTask.id)) {
            return false;
        }
        return this.input.equals(sTask.input);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.input.hashCode();
        return result;
    }

    public String toShortString(int maxLength) {
        return this.id + "(" + StringUtil.toShortString(this.input.toString(), maxLength) + ")";
    }

    public String toString() {
        return this.toShortString(2048);
    }
}

