/*
 * Decompiled with CFR 0.152.
 */
package mb.pie.api;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import mb.pie.api.ExecContext;
import mb.pie.api.Supplier;
import mb.pie.api.stamp.ResourceStamper;
import mb.resource.ReadableResource;
import mb.resource.ResourceKey;

public class ResourceBytesSupplier
implements Supplier<byte[]> {
    private final ResourceKey key;
    private final ResourceStamper<ReadableResource> stamper;

    public ResourceBytesSupplier(ResourceKey key, ResourceStamper<ReadableResource> stamper) {
        this.key = key;
        this.stamper = stamper;
    }

    @Override
    public byte[] get(ExecContext context) {
        try {
            return context.require(this.key, this.stamper).readBytes();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceBytesSupplier that = (ResourceBytesSupplier)o;
        return this.key.equals(that.key) && this.stamper.equals(that.stamper);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.stamper);
    }

    public String toString() {
        return "ResourceBytesProvider{key=" + this.key + ", stamper=" + this.stamper + '}';
    }
}

