/*
 * Decompiled with CFR 0.152.
 */
package mb.pie.api;

import java.io.Serializable;
import mb.pie.api.ExecContext;
import mb.pie.api.Function;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MappedFunctionOutput<T extends Serializable, R extends @Nullable Serializable, A extends @Nullable Serializable>
implements Function<T, A> {
    private final Function<T, R> function;
    private final Function<? super R, ? extends A> after;

    public MappedFunctionOutput(Function<T, R> function, Function<? super R, ? extends A> after) {
        this.function = function;
        this.after = after;
    }

    @Override
    public A apply(ExecContext context, T input) {
        R result = this.function.apply(context, input);
        return this.after.apply(context, result);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MappedFunctionOutput mappedFunctionOutput = (MappedFunctionOutput)o;
        if (!this.function.equals(mappedFunctionOutput.function)) {
            return false;
        }
        return this.after.equals(mappedFunctionOutput.after);
    }

    public int hashCode() {
        int result = this.function.hashCode();
        result = 31 * result + this.after.hashCode();
        return result;
    }

    public String toString() {
        return "MappedFunctionOutput(" + this.function + ", " + this.after + ")";
    }
}

