/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.impl.diff;

import com.google.common.collect.Multimap;
import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import mb.p_raffrayi.impl.diff.IDifferOps;
import mb.p_raffrayi.impl.diff.IScopeGraphDiffer;
import mb.p_raffrayi.impl.diff.ScopeDiff;
import mb.scopegraph.oopsla20.IScopeGraph;
import mb.scopegraph.oopsla20.diff.BiMap;
import mb.scopegraph.oopsla20.diff.Edge;
import mb.scopegraph.oopsla20.diff.ScopeGraphDiff;
import mb.scopegraph.oopsla20.reference.EdgeOrData;
import mb.scopegraph.patching.IPatchCollection;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.future.CompletableFuture;
import org.metaborg.util.future.IFuture;

public class RemovingDiffer<S, L, D>
implements IScopeGraphDiffer<S, L, D> {
    private IScopeGraph.Immutable<S, L, D> previousGraph;
    private final IDifferOps<S, L, D> differOps;

    public RemovingDiffer(IScopeGraph.Immutable<S, L, D> previousGraph, IDifferOps<S, L, D> differOps) {
        this.previousGraph = previousGraph;
        this.differOps = differOps;
    }

    @Override
    public IFuture<ScopeGraphDiff<S, L, D>> diff(List<S> currentRootScopes, List<S> previousRootScopes) {
        Map.Transient removedScopes = CapsuleUtil.transientMap();
        Set.Transient removedEdges = CapsuleUtil.transientSet();
        LinkedList<S> queue = new LinkedList<S>(previousRootScopes);
        while (!queue.isEmpty()) {
            Object scope = queue.remove();
            Object datum = this.previousGraph.getData(scope).orElse(this.differOps.embed(scope));
            removedScopes.__put(scope, datum);
            for (Object label : this.previousGraph.getLabels()) {
                for (Object tgt : this.previousGraph.getEdges(scope, label)) {
                    removedEdges.__insert(new Edge(scope, label, tgt));
                    if (removedScopes.containsKey(tgt)) continue;
                    queue.add(tgt);
                }
            }
        }
        return CompletableFuture.completedFuture(new ScopeGraphDiff(BiMap.Immutable.of(), BiMap.Immutable.of(), CapsuleUtil.immutableMap(), CapsuleUtil.immutableSet(), removedScopes.freeze(), removedEdges.freeze()));
    }

    @Override
    public IFuture<ScopeGraphDiff<S, L, D>> diff(IScopeGraph.Immutable<S, L, D> initiallyMatchedGraph, Collection<S> scopes, Collection<S> sharedScopes, IPatchCollection.Immutable<S> patches, Collection<S> openScopes, Multimap<S, EdgeOrData<L>> openEdges) {
        throw new IllegalStateException("Removing differ cannot be used with initial scopegraph.");
    }

    @Override
    public boolean matchScopes(BiMap.Immutable<S> scopes) {
        return true;
    }

    @Override
    public void typeCheckerFinished() {
    }

    @Override
    public IFuture<Optional<S>> match(S previousScope) {
        return CompletableFuture.completedFuture(Optional.empty());
    }

    @Override
    public IFuture<ScopeDiff<S, L, D>> scopeDiff(S previousScope, L label) {
        return CompletableFuture.completedFuture(ScopeDiff.builder().build());
    }
}

