/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import mb.p_raffrayi.IRecordedQuery;
import mb.p_raffrayi.IUnitResult;
import mb.p_raffrayi.IUnitStats;
import mb.p_raffrayi.impl.AUnitResult;
import mb.scopegraph.oopsla20.IScopeGraph;
import mb.scopegraph.oopsla20.diff.ScopeGraphDiff;

public final class UnitResult<S, L, D, R>
extends AUnitResult<S, L, D, R>
implements Serializable {
    private final String id;
    private final IScopeGraph.Immutable<S, L, D> scopeGraph;
    private final ImmutableSet<IRecordedQuery<S, L, D>> queries;
    private final ImmutableList<S> rootScopes;
    private final ImmutableSet<S> scopes;
    @Nullable
    private final R result;
    @Nullable
    private final ScopeGraphDiff<S, L, D> diff;
    private final ImmutableList<Throwable> failures;
    private final ImmutableMap<String, IUnitResult<S, L, D, ?>> subUnitResults;
    @Nullable
    private final IUnitStats stats;
    private final IUnitResult.TransitionTrace stateTransitionTrace;
    private int hashCode;
    private volatile transient long lazyInitBitmap;
    private static final long ALL_FAILURES_LAZY_INIT_BIT = 1L;
    private transient List<Throwable> allFailures;
    private static final long serialVersionUID = 42L;

    private UnitResult(String id, IScopeGraph.Immutable<S, L, D> scopeGraph, Iterable<? extends IRecordedQuery<S, L, D>> queries, Iterable<? extends S> rootScopes, Iterable<? extends S> scopes, @Nullable R result, Iterable<? extends Throwable> failures, Map<String, ? extends IUnitResult<S, L, D, ?>> subUnitResults, @Nullable IUnitStats stats) {
        this.id = Objects.requireNonNull(id, "id");
        this.scopeGraph = Objects.requireNonNull(scopeGraph, "scopeGraph");
        this.queries = ImmutableSet.copyOf(queries);
        this.rootScopes = ImmutableList.copyOf(rootScopes);
        this.scopes = ImmutableSet.copyOf(scopes);
        this.result = result;
        this.failures = ImmutableList.copyOf(failures);
        this.subUnitResults = ImmutableMap.copyOf(subUnitResults);
        this.stats = stats;
        this.diff = null;
        this.stateTransitionTrace = Objects.requireNonNull(super.stateTransitionTrace(), "stateTransitionTrace");
    }

    private UnitResult(Builder<S, L, D, R> builder) {
        this.id = ((Builder)builder).id;
        this.scopeGraph = ((Builder)builder).scopeGraph;
        this.queries = ((Builder)builder).queries.build();
        this.rootScopes = ((Builder)builder).rootScopes.build();
        this.scopes = ((Builder)builder).scopes.build();
        this.result = ((Builder)builder).result;
        this.diff = ((Builder)builder).diff;
        this.failures = ((Builder)builder).failures.build();
        this.subUnitResults = ((Builder)builder).subUnitResults.build();
        this.stats = ((Builder)builder).stats;
        this.stateTransitionTrace = ((Builder)builder).stateTransitionTrace != null ? ((Builder)builder).stateTransitionTrace : Objects.requireNonNull(super.stateTransitionTrace(), "stateTransitionTrace");
    }

    private UnitResult(String id, IScopeGraph.Immutable<S, L, D> scopeGraph, ImmutableSet<IRecordedQuery<S, L, D>> queries, ImmutableList<S> rootScopes, ImmutableSet<S> scopes, @Nullable R result, @Nullable ScopeGraphDiff<S, L, D> diff, ImmutableList<Throwable> failures, ImmutableMap<String, IUnitResult<S, L, D, ?>> subUnitResults, @Nullable IUnitStats stats, IUnitResult.TransitionTrace stateTransitionTrace) {
        this.id = id;
        this.scopeGraph = scopeGraph;
        this.queries = queries;
        this.rootScopes = rootScopes;
        this.scopes = scopes;
        this.result = result;
        this.diff = diff;
        this.failures = failures;
        this.subUnitResults = subUnitResults;
        this.stats = stats;
        this.stateTransitionTrace = stateTransitionTrace;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public IScopeGraph.Immutable<S, L, D> scopeGraph() {
        return this.scopeGraph;
    }

    @Override
    public ImmutableSet<IRecordedQuery<S, L, D>> queries() {
        return this.queries;
    }

    @Override
    public ImmutableList<S> rootScopes() {
        return this.rootScopes;
    }

    @Override
    public ImmutableSet<S> scopes() {
        return this.scopes;
    }

    @Override
    @Nullable
    public R result() {
        return this.result;
    }

    @Override
    @Nullable
    public ScopeGraphDiff<S, L, D> diff() {
        return this.diff;
    }

    public ImmutableList<Throwable> failures() {
        return this.failures;
    }

    @Override
    public ImmutableMap<String, IUnitResult<S, L, D, ?>> subUnitResults() {
        return this.subUnitResults;
    }

    @Override
    @Nullable
    public IUnitStats stats() {
        return this.stats;
    }

    @Override
    public IUnitResult.TransitionTrace stateTransitionTrace() {
        return this.stateTransitionTrace;
    }

    public final UnitResult<S, L, D, R> withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new UnitResult<S, L, D, R>(newValue, this.scopeGraph, this.queries, this.rootScopes, this.scopes, this.result, this.diff, this.failures, this.subUnitResults, this.stats, this.stateTransitionTrace);
    }

    public final UnitResult<S, L, D, R> withScopeGraph(IScopeGraph.Immutable<S, L, D> value) {
        if (this.scopeGraph == value) {
            return this;
        }
        IScopeGraph.Immutable<S, L, D> newValue = Objects.requireNonNull(value, "scopeGraph");
        return new UnitResult<S, L, D, R>(this.id, newValue, this.queries, this.rootScopes, this.scopes, this.result, this.diff, this.failures, this.subUnitResults, this.stats, this.stateTransitionTrace);
    }

    @SafeVarargs
    public final UnitResult<S, L, D, R> withQueries(IRecordedQuery<S, L, D> ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new UnitResult<S, L, D, R>(this.id, this.scopeGraph, newValue, this.rootScopes, this.scopes, this.result, this.diff, this.failures, this.subUnitResults, this.stats, this.stateTransitionTrace);
    }

    public final UnitResult<S, L, D, R> withQueries(Iterable<? extends IRecordedQuery<S, L, D>> elements) {
        if (this.queries == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new UnitResult<S, L, D, R>(this.id, this.scopeGraph, newValue, this.rootScopes, this.scopes, this.result, this.diff, this.failures, this.subUnitResults, this.stats, this.stateTransitionTrace);
    }

    @SafeVarargs
    public final UnitResult<S, L, D, R> withRootScopes(S ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new UnitResult<S, L, D, R>(this.id, this.scopeGraph, this.queries, newValue, this.scopes, this.result, this.diff, this.failures, this.subUnitResults, this.stats, this.stateTransitionTrace);
    }

    public final UnitResult<S, L, D, R> withRootScopes(Iterable<? extends S> elements) {
        if (this.rootScopes == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new UnitResult<S, L, D, R>(this.id, this.scopeGraph, this.queries, newValue, this.scopes, this.result, this.diff, this.failures, this.subUnitResults, this.stats, this.stateTransitionTrace);
    }

    @SafeVarargs
    public final UnitResult<S, L, D, R> withScopes(S ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new UnitResult<S, L, D, R>(this.id, this.scopeGraph, this.queries, this.rootScopes, newValue, this.result, this.diff, this.failures, this.subUnitResults, this.stats, this.stateTransitionTrace);
    }

    public final UnitResult<S, L, D, R> withScopes(Iterable<? extends S> elements) {
        if (this.scopes == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new UnitResult<S, L, D, R>(this.id, this.scopeGraph, this.queries, this.rootScopes, newValue, this.result, this.diff, this.failures, this.subUnitResults, this.stats, this.stateTransitionTrace);
    }

    public final UnitResult<S, L, D, R> withResult(@Nullable R value) {
        if (this.result == value) {
            return this;
        }
        return new UnitResult<S, L, D, R>(this.id, this.scopeGraph, this.queries, this.rootScopes, this.scopes, value, this.diff, this.failures, this.subUnitResults, this.stats, this.stateTransitionTrace);
    }

    public final UnitResult<S, L, D, R> withDiff(@Nullable ScopeGraphDiff<S, L, D> value) {
        if (this.diff == value) {
            return this;
        }
        return new UnitResult<S, L, D, R>(this.id, this.scopeGraph, this.queries, this.rootScopes, this.scopes, this.result, value, this.failures, this.subUnitResults, this.stats, this.stateTransitionTrace);
    }

    public final UnitResult<S, L, D, R> withFailures(Throwable ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new UnitResult<S, L, D, R>(this.id, this.scopeGraph, this.queries, this.rootScopes, this.scopes, this.result, this.diff, (ImmutableList<Throwable>)newValue, this.subUnitResults, this.stats, this.stateTransitionTrace);
    }

    public final UnitResult<S, L, D, R> withFailures(Iterable<? extends Throwable> elements) {
        if (this.failures == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new UnitResult<S, L, D, R>(this.id, this.scopeGraph, this.queries, this.rootScopes, this.scopes, this.result, this.diff, (ImmutableList<Throwable>)newValue, this.subUnitResults, this.stats, this.stateTransitionTrace);
    }

    public final UnitResult<S, L, D, R> withSubUnitResults(Map<String, ? extends IUnitResult<S, L, D, ?>> entries) {
        if (this.subUnitResults == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new UnitResult<S, L, D, R>(this.id, this.scopeGraph, this.queries, this.rootScopes, this.scopes, this.result, this.diff, this.failures, newValue, this.stats, this.stateTransitionTrace);
    }

    public final UnitResult<S, L, D, R> withStats(@Nullable IUnitStats value) {
        if (this.stats == value) {
            return this;
        }
        return new UnitResult<S, L, D, R>(this.id, this.scopeGraph, this.queries, this.rootScopes, this.scopes, this.result, this.diff, this.failures, this.subUnitResults, value, this.stateTransitionTrace);
    }

    public final UnitResult<S, L, D, R> withStateTransitionTrace(IUnitResult.TransitionTrace value) {
        if (this.stateTransitionTrace == value) {
            return this;
        }
        IUnitResult.TransitionTrace newValue = Objects.requireNonNull(value, "stateTransitionTrace");
        if (this.stateTransitionTrace.equals((Object)newValue)) {
            return this;
        }
        return new UnitResult<S, L, D, R>(this.id, this.scopeGraph, this.queries, this.rootScopes, this.scopes, this.result, this.diff, this.failures, this.subUnitResults, this.stats, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UnitResult && this.equalTo((UnitResult)another);
    }

    private boolean equalTo(UnitResult<?, ?, ?, ?> another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.id.equals(another.id) && this.scopeGraph.equals(another.scopeGraph) && this.queries.equals(another.queries) && this.rootScopes.equals(another.rootScopes) && this.scopes.equals(another.scopes) && Objects.equals(this.result, another.result) && this.failures.equals(another.failures) && this.subUnitResults.equals(another.subUnitResults) && Objects.equals(this.stats, another.stats) && this.stateTransitionTrace.equals((Object)another.stateTransitionTrace);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.scopeGraph.hashCode();
        h += (h << 5) + this.queries.hashCode();
        h += (h << 5) + this.rootScopes.hashCode();
        h += (h << 5) + this.scopes.hashCode();
        h += (h << 5) + Objects.hashCode(this.result);
        h += (h << 5) + this.failures.hashCode();
        h += (h << 5) + this.subUnitResults.hashCode();
        h += (h << 5) + Objects.hashCode(this.stats);
        h += (h << 5) + this.stateTransitionTrace.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"UnitResult").omitNullValues().add("id", (Object)this.id).add("scopeGraph", this.scopeGraph).add("queries", this.queries).add("rootScopes", this.rootScopes).add("scopes", this.scopes).add("result", this.result).add("failures", this.failures).add("subUnitResults", this.subUnitResults).add("stats", (Object)this.stats).add("stateTransitionTrace", (Object)this.stateTransitionTrace).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Throwable> allFailures() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            UnitResult unitResult = this;
            synchronized (unitResult) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.allFailures = Objects.requireNonNull(super.allFailures(), "allFailures");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.allFailures;
    }

    public static <S, L, D, R> UnitResult<S, L, D, R> of(String id, IScopeGraph.Immutable<S, L, D> scopeGraph, Set<IRecordedQuery<S, L, D>> queries, List<S> rootScopes, Set<S> scopes, @Nullable R result, List<Throwable> failures, Map<String, IUnitResult<S, L, D, ?>> subUnitResults, @Nullable IUnitStats stats) {
        return UnitResult.of(id, scopeGraph, queries, rootScopes, scopes, result, failures, subUnitResults, stats);
    }

    public static <S, L, D, R> UnitResult<S, L, D, R> of(String id, IScopeGraph.Immutable<S, L, D> scopeGraph, Iterable<? extends IRecordedQuery<S, L, D>> queries, Iterable<? extends S> rootScopes, Iterable<? extends S> scopes, @Nullable R result, Iterable<? extends Throwable> failures, Map<String, ? extends IUnitResult<S, L, D, ?>> subUnitResults, @Nullable IUnitStats stats) {
        return new UnitResult<S, L, D, R>(id, scopeGraph, queries, rootScopes, scopes, result, failures, subUnitResults, stats);
    }

    public static <S, L, D, R> UnitResult<S, L, D, R> copyOf(AUnitResult<S, L, D, R> instance) {
        if (instance instanceof UnitResult) {
            return (UnitResult)instance;
        }
        return UnitResult.builder().from(instance).build();
    }

    public static <S, L, D, R> Builder<S, L, D, R> builder() {
        return new Builder();
    }

    /* synthetic */ UnitResult(Builder builder, UnitResult unitResult) {
        this(builder);
    }

    public static final class Builder<S, L, D, R> {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_SCOPE_GRAPH = 2L;
        private long initBits = 3L;
        private String id;
        private IScopeGraph.Immutable<S, L, D> scopeGraph;
        private ImmutableSet.Builder<IRecordedQuery<S, L, D>> queries = ImmutableSet.builder();
        private ImmutableList.Builder<S> rootScopes = ImmutableList.builder();
        private ImmutableSet.Builder<S> scopes = ImmutableSet.builder();
        private R result;
        private ScopeGraphDiff<S, L, D> diff;
        private ImmutableList.Builder<Throwable> failures = ImmutableList.builder();
        private ImmutableMap.Builder<String, IUnitResult<S, L, D, ?>> subUnitResults = ImmutableMap.builder();
        private IUnitStats stats;
        private IUnitResult.TransitionTrace stateTransitionTrace;

        private Builder() {
        }

        public final Builder<S, L, D, R> from(AUnitResult<S, L, D, R> instance) {
            ScopeGraphDiff<S, L, D> diffValue;
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.scopeGraph(instance.scopeGraph());
            this.addAllQueries(instance.queries());
            this.addAllRootScopes(instance.rootScopes());
            this.addAllScopes(instance.scopes());
            R resultValue = instance.result();
            if (resultValue != null) {
                this.result(resultValue);
            }
            if ((diffValue = instance.diff()) != null) {
                this.diff(diffValue);
            }
            this.addAllFailures(instance.failures());
            this.putAllSubUnitResults(instance.subUnitResults());
            IUnitStats statsValue = instance.stats();
            if (statsValue != null) {
                this.stats(statsValue);
            }
            this.stateTransitionTrace(instance.stateTransitionTrace());
            return this;
        }

        public final Builder<S, L, D, R> id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<S, L, D, R> scopeGraph(IScopeGraph.Immutable<S, L, D> scopeGraph) {
            this.scopeGraph = Objects.requireNonNull(scopeGraph, "scopeGraph");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder<S, L, D, R> addQueries(IRecordedQuery<S, L, D> element) {
            this.queries.add(element);
            return this;
        }

        @SafeVarargs
        public final Builder<S, L, D, R> addQueries(IRecordedQuery<S, L, D> ... elements) {
            this.queries.add((Object[])elements);
            return this;
        }

        public final Builder<S, L, D, R> queries(Iterable<? extends IRecordedQuery<S, L, D>> elements) {
            this.queries = ImmutableSet.builder();
            return this.addAllQueries(elements);
        }

        public final Builder<S, L, D, R> addAllQueries(Iterable<? extends IRecordedQuery<S, L, D>> elements) {
            this.queries.addAll(elements);
            return this;
        }

        public final Builder<S, L, D, R> addRootScopes(S element) {
            this.rootScopes.add(element);
            return this;
        }

        @SafeVarargs
        public final Builder<S, L, D, R> addRootScopes(S ... elements) {
            this.rootScopes.add((Object[])elements);
            return this;
        }

        public final Builder<S, L, D, R> rootScopes(Iterable<? extends S> elements) {
            this.rootScopes = ImmutableList.builder();
            return this.addAllRootScopes(elements);
        }

        public final Builder<S, L, D, R> addAllRootScopes(Iterable<? extends S> elements) {
            this.rootScopes.addAll(elements);
            return this;
        }

        public final Builder<S, L, D, R> addScopes(S element) {
            this.scopes.add(element);
            return this;
        }

        @SafeVarargs
        public final Builder<S, L, D, R> addScopes(S ... elements) {
            this.scopes.add((Object[])elements);
            return this;
        }

        public final Builder<S, L, D, R> scopes(Iterable<? extends S> elements) {
            this.scopes = ImmutableSet.builder();
            return this.addAllScopes(elements);
        }

        public final Builder<S, L, D, R> addAllScopes(Iterable<? extends S> elements) {
            this.scopes.addAll(elements);
            return this;
        }

        public final Builder<S, L, D, R> result(@Nullable R result) {
            this.result = result;
            return this;
        }

        public final Builder<S, L, D, R> diff(@Nullable ScopeGraphDiff<S, L, D> diff) {
            this.diff = diff;
            return this;
        }

        public final Builder<S, L, D, R> addFailures(Throwable element) {
            this.failures.add((Object)element);
            return this;
        }

        public final Builder<S, L, D, R> addFailures(Throwable ... elements) {
            this.failures.add((Object[])elements);
            return this;
        }

        public final Builder<S, L, D, R> failures(Iterable<? extends Throwable> elements) {
            this.failures = ImmutableList.builder();
            return this.addAllFailures(elements);
        }

        public final Builder<S, L, D, R> addAllFailures(Iterable<? extends Throwable> elements) {
            this.failures.addAll(elements);
            return this;
        }

        public final Builder<S, L, D, R> putSubUnitResults(String key, IUnitResult<S, L, D, ?> value) {
            this.subUnitResults.put((Object)key, value);
            return this;
        }

        public final Builder<S, L, D, R> putSubUnitResults(Map.Entry<String, ? extends IUnitResult<S, L, D, ?>> entry) {
            this.subUnitResults.put(entry);
            return this;
        }

        public final Builder<S, L, D, R> subUnitResults(Map<String, ? extends IUnitResult<S, L, D, ?>> entries) {
            this.subUnitResults = ImmutableMap.builder();
            return this.putAllSubUnitResults(entries);
        }

        public final Builder<S, L, D, R> putAllSubUnitResults(Map<String, ? extends IUnitResult<S, L, D, ?>> entries) {
            this.subUnitResults.putAll(entries);
            return this;
        }

        public final Builder<S, L, D, R> stats(@Nullable IUnitStats stats) {
            this.stats = stats;
            return this;
        }

        public final Builder<S, L, D, R> stateTransitionTrace(IUnitResult.TransitionTrace stateTransitionTrace) {
            this.stateTransitionTrace = Objects.requireNonNull(stateTransitionTrace, "stateTransitionTrace");
            return this;
        }

        public UnitResult<S, L, D, R> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new UnitResult(this, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("scopeGraph");
            }
            return "Cannot build UnitResult, some of required attributes are not set " + attributes;
        }
    }
}

