/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.util.graph.alg.misc.memory;

import io.usethesource.capsule.Map;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import mb.nabl2.util.graph.alg.misc.memory.IMemoryView;

public class MapBackedMemoryView<T>
implements IMemoryView<T> {
    private Map.Immutable<T, Integer> wrapped;

    public MapBackedMemoryView(Map.Immutable<T, Integer> wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public Iterator<T> iterator() {
        return this.wrapped.keySet().iterator();
    }

    @Override
    public int getCount(T value) {
        return this.getCountUnsafe(value);
    }

    @Override
    public int getCountUnsafe(Object value) {
        Integer count = (Integer)this.wrapped.get(value);
        return count == null ? 0 : count;
    }

    @Override
    public boolean containsNonZero(T value) {
        return this.wrapped.containsKey(value);
    }

    @Override
    public boolean containsNonZeroUnsafe(Object value) {
        return this.wrapped.containsKey(value);
    }

    @Override
    public int size() {
        return this.wrapped.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    @Override
    public Set<T> distinctValues() {
        return this.wrapped.keySet();
    }

    @Override
    public Map.Immutable<T, Integer> asMap() {
        return this.wrapped;
    }

    @Override
    public Iterable<Map.Entry<T, Integer>> entriesWithMultiplicities() {
        return this.wrapped.entrySet();
    }

    public int hashCode() {
        return IMemoryView.hashCode(this);
    }

    public boolean equals(Object obj) {
        return IMemoryView.equals(this, obj);
    }

    public String toString() {
        return this.wrapped.toString();
    }
}

