/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.substitution;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;

public interface ISubstitution {
    public boolean isEmpty();

    public boolean contains(ITermVar var1);

    public Set<ITermVar> domainSet();

    public Set<ITermVar> rangeSet();

    public Set<Map.Entry<ITermVar, ITerm>> entrySet();

    public ITerm apply(ITerm var1);

    default public List<ITerm> apply(List<ITerm> terms) {
        ImmutableList.Builder newTerms = ImmutableList.builderWithExpectedSize((int)terms.size());
        for (ITerm term : terms) {
            newTerms.add((Object)this.apply(term));
        }
        return newTerms.build();
    }

    public static interface Immutable
    extends ISubstitution {
        public Immutable put(ITermVar var1, ITerm var2);

        public Immutable remove(ITermVar var1);

        public Immutable removeAll(Iterable<ITermVar> var1);

        public Immutable retainAll(Iterable<ITermVar> var1);

        public Immutable compose(Immutable var1);

        public Immutable compose(ITermVar var1, ITerm var2);

        public Transient melt();
    }

    public static interface Transient
    extends ISubstitution {
        public void put(ITermVar var1, ITerm var2);

        public void remove(ITermVar var1);

        public void removeAll(Iterable<ITermVar> var1);

        public void retainAll(Iterable<ITermVar> var1);

        public void compose(Immutable var1);

        public void compose(ITermVar var1, ITerm var2);

        public Immutable freeze();
    }
}

