/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.stratego;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import mb.nabl2.terms.IApplTerm;
import mb.nabl2.terms.IAttachments;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ListTerms;
import mb.nabl2.terms.Terms;
import mb.nabl2.terms.build.AbstractApplTerm;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.TermMatch;
import mb.nabl2.terms.stratego.ITermIndex;
import mb.nabl2.terms.stratego.TermIndex;
import org.immutables.serial.Serial;
import org.immutables.value.Value;

@Value.Immutable(lazyhash=false)
@Serial.Version(value=42L)
public abstract class ATermIndex
extends AbstractApplTerm
implements ITermIndex,
IApplTerm {
    private static final String OP = "TermIndex";

    @Override
    @Value.Parameter
    public abstract String getResource();

    @Override
    @Value.Parameter
    public abstract int getId();

    public <T extends ITerm> T put(T term) {
        IAttachments.Builder attachments = term.getAttachments().toBuilder();
        attachments.put(TermIndex.class, (TermIndex)this);
        return (T)term.withAttachments(attachments.build());
    }

    @Override
    public String getOp() {
        return OP;
    }

    @Override
    @Value.Lazy
    public List<ITerm> getArgs() {
        return ImmutableList.of((Object)TermBuild.B.newString(this.getResource()), (Object)TermBuild.B.newInt(this.getId()));
    }

    public static TermMatch.IMatcher<TermIndex> matcher() {
        return TermMatch.M.preserveAttachments(TermMatch.M.appl2(OP, TermMatch.M.stringValue(), TermMatch.M.integerValue(), (t, resource, id) -> TermIndex.of(resource, id)));
    }

    @Override
    protected TermIndex check() {
        return (TermIndex)this;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TermIndex)) {
            return super.equals(other);
        }
        TermIndex that = (TermIndex)other;
        if (this.hashCode() != that.hashCode()) {
            return false;
        }
        return Objects.equals(this.getResource(), that.getResource()) && Objects.equals(this.getId(), that.getId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("@");
        sb.append(this.getResource());
        sb.append(":");
        sb.append(this.getId());
        return sb.toString();
    }

    public static Optional<TermIndex> get(ITerm term) {
        return ATermIndex.get(term.getAttachments());
    }

    public static Optional<TermIndex> get(IAttachments attachments) {
        return Optional.ofNullable(attachments.get(TermIndex.class));
    }

    public static Optional<TermIndex> find(ITerm term) {
        return ATermIndex.get(term.getAttachments()).map(Optional::of).orElseGet(() -> term.match(Terms.cases().appl(appl -> ATermIndex.find(appl.getArgs().iterator())).list(list -> list.match(ListTerms.cases().cons(cons -> ATermIndex.find(cons.getHead()).map(Optional::of).orElseGet(() -> ATermIndex.find(cons.getTail()))).otherwise(__ -> Optional.empty()))).otherwise(__ -> Optional.empty())));
    }

    private static Optional<TermIndex> find(Iterator<ITerm> termIterator) {
        if (!termIterator.hasNext()) {
            return Optional.empty();
        }
        ITerm term = termIterator.next();
        return ATermIndex.find(term).map(Optional::of).orElseGet(() -> ATermIndex.find(termIterator));
    }

    public static boolean has(ITerm term) {
        return ATermIndex.get(term).isPresent();
    }

    public static <T extends ITerm> T copy(ITerm src, T dst) {
        return (T)ATermIndex.get(src).map(o -> o.put(dst)).orElse(dst);
    }

    public static TermIndex of(String resource, int id) {
        return TermIndex.of(resource, id);
    }
}

