/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.constraints.relations;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Objects;
import mb.nabl2.constraints.messages.IMessageInfo;
import mb.nabl2.constraints.relations.ACCheckRelation;
import mb.nabl2.relations.terms.RelationName;
import mb.nabl2.terms.ITerm;

public final class CCheckRelation
extends ACCheckRelation
implements Serializable {
    private final ITerm left;
    private final RelationName relation;
    private final ITerm right;
    private final IMessageInfo messageInfo;
    private final int hashCode;
    private static final long serialVersionUID = 42L;

    private CCheckRelation(ITerm left, RelationName relation, ITerm right, IMessageInfo messageInfo) {
        this.left = Objects.requireNonNull(left, "left");
        this.relation = Objects.requireNonNull(relation, "relation");
        this.right = Objects.requireNonNull(right, "right");
        this.messageInfo = Objects.requireNonNull(messageInfo, "messageInfo");
        this.hashCode = this.computeHashCode();
    }

    private CCheckRelation(CCheckRelation original, ITerm left, RelationName relation, ITerm right, IMessageInfo messageInfo) {
        this.left = left;
        this.relation = relation;
        this.right = right;
        this.messageInfo = messageInfo;
        this.hashCode = this.computeHashCode();
    }

    @Override
    public ITerm getLeft() {
        return this.left;
    }

    @Override
    public RelationName getRelation() {
        return this.relation;
    }

    @Override
    public ITerm getRight() {
        return this.right;
    }

    @Override
    public IMessageInfo getMessageInfo() {
        return this.messageInfo;
    }

    public final CCheckRelation withLeft(ITerm value) {
        if (this.left == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "left");
        return new CCheckRelation(this, newValue, this.relation, this.right, this.messageInfo);
    }

    public final CCheckRelation withRelation(RelationName value) {
        if (this.relation == value) {
            return this;
        }
        RelationName newValue = Objects.requireNonNull(value, "relation");
        return new CCheckRelation(this, this.left, newValue, this.right, this.messageInfo);
    }

    public final CCheckRelation withRight(ITerm value) {
        if (this.right == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "right");
        return new CCheckRelation(this, this.left, this.relation, newValue, this.messageInfo);
    }

    public final CCheckRelation withMessageInfo(IMessageInfo value) {
        if (this.messageInfo == value) {
            return this;
        }
        IMessageInfo newValue = Objects.requireNonNull(value, "messageInfo");
        return new CCheckRelation(this, this.left, this.relation, this.right, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CCheckRelation && this.equalTo((CCheckRelation)another);
    }

    private boolean equalTo(CCheckRelation another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.left.equals(another.left) && this.relation.equals(another.relation) && this.right.equals(another.right) && this.messageInfo.equals(another.messageInfo);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.left.hashCode();
        h += (h << 5) + this.relation.hashCode();
        h += (h << 5) + this.right.hashCode();
        h += (h << 5) + this.messageInfo.hashCode();
        return h;
    }

    public static CCheckRelation of(ITerm left, RelationName relation, ITerm right, IMessageInfo messageInfo) {
        return new CCheckRelation(left, relation, right, messageInfo);
    }

    public static CCheckRelation copyOf(ACCheckRelation instance) {
        if (instance instanceof CCheckRelation) {
            return (CCheckRelation)instance;
        }
        return CCheckRelation.of(instance.getLeft(), instance.getRelation(), instance.getRight(), instance.getMessageInfo());
    }

    private Object readResolve() throws ObjectStreamException {
        return new CCheckRelation(this, this.left, this.relation, this.right, this.messageInfo);
    }
}

