/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.constraints.messages;

import mb.nabl2.constraints.messages.IMessageContent;
import mb.nabl2.constraints.messages.IMessageInfo;
import mb.nabl2.constraints.messages.MessageContent;
import mb.nabl2.constraints.messages.MessageInfo;
import mb.nabl2.constraints.messages.MessageKind;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.TermMatch;
import mb.nabl2.terms.stratego.TermIndex;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import org.metaborg.util.functions.Function1;

@Value.Immutable
@Serial.Version(value=42L)
public abstract class AMessageInfo
implements IMessageInfo {
    private static final String OP = "Message";

    @Override
    @Value.Parameter
    public abstract MessageKind getKind();

    @Override
    @Value.Parameter
    public abstract IMessageContent getContent();

    @Override
    @Value.Parameter
    public abstract ITerm getOriginTerm();

    @Override
    public IMessageInfo withDefaultContent(IMessageContent defaultContent) {
        return MessageInfo.of(this.getKind(), this.getContent().withDefault(defaultContent), this.getOriginTerm());
    }

    @Override
    public IMessageInfo apply(Function1<ITerm, ITerm> f) {
        return this.withContent(this.getContent().apply(f));
    }

    public static TermMatch.IMatcher<MessageInfo> matcher() {
        return TermMatch.M.appl3(OP, MessageKind.matcher(), MessageContent.matcher(), TermMatch.M.term(), (appl, kind, message, origin) -> MessageInfo.of(kind, message, origin));
    }

    public static TermMatch.IMatcher<MessageInfo> matcherOnlyOriginTerm() {
        return TermMatch.M.term(AMessageInfo::of);
    }

    public static ITerm build(IMessageInfo messageInfo) {
        return TermBuild.B.newAppl(OP, MessageKind.build(messageInfo.getKind()), messageInfo.getContent().build(), messageInfo.getOriginTerm());
    }

    public static ITerm buildOnlyOriginTerm(IMessageInfo messageInfo) {
        return messageInfo.getOriginTerm();
    }

    public static TermMatch.IMatcher<MessageInfo> matcherEditorMessage(MessageKind kind) {
        return TermMatch.M.tuple2(TermMatch.M.term(), MessageContent.matcher(), (t, origin, message) -> MessageInfo.of(kind, message, origin));
    }

    public static MessageInfo of(ITerm originTerm) {
        return MessageInfo.of(MessageKind.ERROR, MessageContent.of(), originTerm);
    }

    public static MessageInfo empty() {
        return MessageInfo.of(MessageKind.ERROR, MessageContent.of(), TermBuild.B.newTuple(new ITerm[0]));
    }

    public String toString() {
        return String.valueOf(this.getKind().name().toLowerCase()) + " " + this.getContent().toString() + " " + TermIndex.get(this.getOriginTerm());
    }
}

