/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.constraints.base;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Objects;
import mb.nabl2.constraints.IConstraint;
import mb.nabl2.constraints.base.ACConj;
import mb.nabl2.constraints.messages.IMessageInfo;

public final class CConj
extends ACConj
implements Serializable {
    private final IConstraint left;
    private final IConstraint right;
    private final IMessageInfo messageInfo;
    private final int hashCode;
    private static final long serialVersionUID = 42L;

    private CConj(IConstraint left, IConstraint right, IMessageInfo messageInfo) {
        this.left = Objects.requireNonNull(left, "left");
        this.right = Objects.requireNonNull(right, "right");
        this.messageInfo = Objects.requireNonNull(messageInfo, "messageInfo");
        this.hashCode = this.computeHashCode();
    }

    private CConj(CConj original, IConstraint left, IConstraint right, IMessageInfo messageInfo) {
        this.left = left;
        this.right = right;
        this.messageInfo = messageInfo;
        this.hashCode = this.computeHashCode();
    }

    @Override
    public IConstraint getLeft() {
        return this.left;
    }

    @Override
    public IConstraint getRight() {
        return this.right;
    }

    @Override
    public IMessageInfo getMessageInfo() {
        return this.messageInfo;
    }

    public final CConj withLeft(IConstraint value) {
        if (this.left == value) {
            return this;
        }
        IConstraint newValue = Objects.requireNonNull(value, "left");
        return new CConj(this, newValue, this.right, this.messageInfo);
    }

    public final CConj withRight(IConstraint value) {
        if (this.right == value) {
            return this;
        }
        IConstraint newValue = Objects.requireNonNull(value, "right");
        return new CConj(this, this.left, newValue, this.messageInfo);
    }

    public final CConj withMessageInfo(IMessageInfo value) {
        if (this.messageInfo == value) {
            return this;
        }
        IMessageInfo newValue = Objects.requireNonNull(value, "messageInfo");
        return new CConj(this, this.left, this.right, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CConj && this.equalTo((CConj)another);
    }

    private boolean equalTo(CConj another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.left.equals(another.left) && this.right.equals(another.right) && this.messageInfo.equals(another.messageInfo);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.left.hashCode();
        h += (h << 5) + this.right.hashCode();
        h += (h << 5) + this.messageInfo.hashCode();
        return h;
    }

    public static CConj of(IConstraint left, IConstraint right, IMessageInfo messageInfo) {
        return new CConj(left, right, messageInfo);
    }

    public static CConj copyOf(ACConj instance) {
        if (instance instanceof CConj) {
            return (CConj)instance;
        }
        return CConj.of(instance.getLeft(), instance.getRight(), instance.getMessageInfo());
    }

    private Object readResolve() throws ObjectStreamException {
        return new CConj(this, this.left, this.right, this.messageInfo);
    }
}

