/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.constraints.base;

import com.google.common.collect.ImmutableList;
import mb.nabl2.constraints.Constraints;
import mb.nabl2.constraints.base.CConj;
import mb.nabl2.constraints.base.CExists;
import mb.nabl2.constraints.base.CFalse;
import mb.nabl2.constraints.base.CNew;
import mb.nabl2.constraints.base.CTrue;
import mb.nabl2.constraints.base.IBaseConstraint;
import mb.nabl2.constraints.messages.IMessageInfo;
import mb.nabl2.constraints.messages.MessageInfo;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.TermMatch;
import mb.nabl2.terms.substitution.ISubstitution;
import org.metaborg.util.functions.Function1;

public final class BaseConstraints {
    private static final String C_FALSE = "CFalse";
    private static final String C_TRUE = "CTrue";
    private static final String C_CONJ = "CConj";
    private static final String C_EXISTS = "CExists";
    private static final String C_NEW = "CNew";

    public static TermMatch.IMatcher<IBaseConstraint> matcher() {
        return TermMatch.M.cases(TermMatch.M.appl1(C_TRUE, MessageInfo.matcherOnlyOriginTerm(), (c, origin) -> CTrue.of(origin)), TermMatch.M.appl1(C_FALSE, MessageInfo.matcher(), (c, msginfo) -> CFalse.of(msginfo)), TermMatch.M.appl2(C_CONJ, (t, u) -> Constraints.matcher().match(t, u), (t, u) -> Constraints.matcher().match(t, u), (c, c1, c2) -> CConj.of(c1, c2, MessageInfo.empty())), TermMatch.M.appl2(C_EXISTS, TermMatch.M.listElems(TermMatch.M.var()), (t, u) -> Constraints.matcher().match(t, u), (c, vars, constraint) -> CExists.of(vars, constraint, (IMessageInfo)MessageInfo.empty())), TermMatch.M.appl2(C_NEW, TermMatch.M.listElems(TermMatch.M.var()), MessageInfo.matcherOnlyOriginTerm(), (c, vars, origin) -> CNew.of(vars, (IMessageInfo)origin)));
    }

    public static ITerm build(IBaseConstraint constraint) {
        return constraint.match(IBaseConstraint.Cases.of(t -> TermBuild.B.newAppl(C_TRUE, MessageInfo.buildOnlyOriginTerm(t.getMessageInfo())), f -> TermBuild.B.newAppl(C_FALSE, MessageInfo.build(f.getMessageInfo())), c -> TermBuild.B.newAppl(C_CONJ, Constraints.build(c.getLeft()), Constraints.build(c.getRight())), e -> TermBuild.B.newAppl(C_EXISTS, TermBuild.B.newList((Iterable<? extends ITerm>)e.getEVars()), Constraints.build(e.getConstraint())), n -> TermBuild.B.newAppl(C_NEW, TermBuild.B.newList((Iterable<? extends ITerm>)n.getNVars()), MessageInfo.buildOnlyOriginTerm(n.getMessageInfo()))));
    }

    public static IBaseConstraint substitute(IBaseConstraint constraint, ISubstitution.Immutable subst) {
        return constraint.match(IBaseConstraint.Cases.of(t -> CTrue.of(t.getMessageInfo().apply(subst::apply)), f -> CFalse.of(f.getMessageInfo().apply(subst::apply)), c -> CConj.of(Constraints.substitute(c.getLeft(), subst), Constraints.substitute(c.getRight(), subst), c.getMessageInfo().apply(subst::apply)), e -> {
            ISubstitution.Immutable restrictedSubst = subst.removeAll((Iterable<ITermVar>)e.getEVars());
            return CExists.of(e.getEVars(), Constraints.substitute(e.getConstraint(), restrictedSubst), e.getMessageInfo().apply(restrictedSubst::apply));
        }, n -> CNew.of((Iterable)n.getNVars().stream().map(subst::apply).collect(ImmutableList.toImmutableList()), n.getMessageInfo().apply(subst::apply))));
    }

    public static IBaseConstraint transform(IBaseConstraint constraint, Function1<ITerm, ITerm> map) {
        return constraint.match(IBaseConstraint.Cases.of(t -> CTrue.of(t.getMessageInfo().apply(map::apply)), f -> CFalse.of(f.getMessageInfo().apply(map::apply)), c -> CConj.of(Constraints.transform(c.getLeft(), map), Constraints.transform(c.getRight(), map), c.getMessageInfo().apply(map::apply)), e -> CExists.of(e.getEVars(), Constraints.transform(e.getConstraint(), map), e.getMessageInfo().apply(map::apply)), n -> CNew.of((Iterable)n.getNVars().stream().map(map::apply).collect(ImmutableList.toImmutableList()), n.getMessageInfo().apply(map::apply))));
    }
}

