/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.constraints.ast;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Objects;
import mb.nabl2.constraints.ast.ACAstProperty;
import mb.nabl2.constraints.messages.IMessageInfo;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.stratego.TermIndex;

public final class CAstProperty
extends ACAstProperty
implements Serializable {
    private final TermIndex index;
    private final ITerm key;
    private final ITerm value;
    private final IMessageInfo messageInfo;
    private final int hashCode;
    private static final long serialVersionUID = 42L;

    private CAstProperty(TermIndex index, ITerm key, ITerm value, IMessageInfo messageInfo) {
        this.index = Objects.requireNonNull(index, "index");
        this.key = Objects.requireNonNull(key, "key");
        this.value = Objects.requireNonNull(value, "value");
        this.messageInfo = Objects.requireNonNull(messageInfo, "messageInfo");
        this.hashCode = this.computeHashCode();
    }

    private CAstProperty(CAstProperty original, TermIndex index, ITerm key, ITerm value, IMessageInfo messageInfo) {
        this.index = index;
        this.key = key;
        this.value = value;
        this.messageInfo = messageInfo;
        this.hashCode = this.computeHashCode();
    }

    @Override
    public TermIndex getIndex() {
        return this.index;
    }

    @Override
    public ITerm getKey() {
        return this.key;
    }

    @Override
    public ITerm getValue() {
        return this.value;
    }

    @Override
    public IMessageInfo getMessageInfo() {
        return this.messageInfo;
    }

    public final CAstProperty withIndex(TermIndex value) {
        if (this.index == value) {
            return this;
        }
        TermIndex newValue = Objects.requireNonNull(value, "index");
        return CAstProperty.validate(new CAstProperty(this, newValue, this.key, this.value, this.messageInfo));
    }

    public final CAstProperty withKey(ITerm value) {
        if (this.key == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "key");
        return CAstProperty.validate(new CAstProperty(this, this.index, newValue, this.value, this.messageInfo));
    }

    public final CAstProperty withValue(ITerm value) {
        if (this.value == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "value");
        return CAstProperty.validate(new CAstProperty(this, this.index, this.key, newValue, this.messageInfo));
    }

    public final CAstProperty withMessageInfo(IMessageInfo value) {
        if (this.messageInfo == value) {
            return this;
        }
        IMessageInfo newValue = Objects.requireNonNull(value, "messageInfo");
        return CAstProperty.validate(new CAstProperty(this, this.index, this.key, this.value, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CAstProperty && this.equalTo((CAstProperty)another);
    }

    private boolean equalTo(CAstProperty another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.index.equals(another.index) && this.key.equals(another.key) && this.value.equals(another.value) && this.messageInfo.equals(another.messageInfo);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.index.hashCode();
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + this.messageInfo.hashCode();
        return h;
    }

    public static CAstProperty of(TermIndex index, ITerm key, ITerm value, IMessageInfo messageInfo) {
        return CAstProperty.validate(new CAstProperty(index, key, value, messageInfo));
    }

    private static CAstProperty validate(CAstProperty instance) {
        instance.check();
        return instance;
    }

    public static CAstProperty copyOf(ACAstProperty instance) {
        if (instance instanceof CAstProperty) {
            return (CAstProperty)instance;
        }
        return CAstProperty.of(instance.getIndex(), instance.getKey(), instance.getValue(), instance.getMessageInfo());
    }

    private Object readResolve() throws ObjectStreamException {
        return CAstProperty.validate(new CAstProperty(this, this.index, this.key, this.value, this.messageInfo));
    }
}

