/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.runtime.interpreter.expressions;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import java.util.Map;
import mb.flowspec.controlflow.ICFGNode;
import mb.flowspec.controlflow.ImmutableCFGNode;
import mb.flowspec.runtime.InitValues;
import mb.flowspec.runtime.Initializable;
import mb.flowspec.runtime.interpreter.Types;
import mb.flowspec.runtime.interpreter.expressions.ExpressionNode;
import mb.flowspec.terms.TermIndex;
import org.metaborg.util.Ref;
import org.spoofax.interpreter.terms.IStrategoTerm;

@NodeChildren(value={@NodeChild(value="rhs")})
public abstract class PropNode
extends ExpressionNode
implements Initializable {
    private Map<String, Map<ICFGNode, Ref<IStrategoTerm>>> properties;
    protected final String propName;

    public PropNode(String propName) {
        this.propName = propName;
    }

    @Specialization
    protected IStrategoTerm lookup(ICFGNode rhs) {
        return this.properties.get(this.propName).get(rhs).get();
    }

    @Specialization
    protected IStrategoTerm lookup(IStrategoTerm rhs) {
        TermIndex index = TermIndex.get(rhs).get();
        ImmutableCFGNode node = ImmutableCFGNode.of(index, null, ICFGNode.Kind.Normal);
        return this.lookup(node);
    }

    @Specialization
    protected IStrategoTerm lookup(Object rhs) {
        return this.lookup(Types.asIStrategoTerm(rhs));
    }

    @Override
    public void init(InitValues initValues) {
        this.properties = initValues.properties;
    }
}

