/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.runtime.interpreter.expressions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import java.util.concurrent.locks.Lock;
import mb.flowspec.runtime.interpreter.expressions.ExpressionNode;
import mb.flowspec.runtime.interpreter.expressions.ModNode;

@GeneratedBy(value=ModNode.class)
public final class ModNodeGen
extends ModNode {
    @Node.Child
    private ExpressionNode left_;
    @Node.Child
    private ExpressionNode right_;
    @CompilerDirectives.CompilationFinal
    private int state_;

    private ModNodeGen(ExpressionNode left, ExpressionNode right) {
        this.left_ = left;
        this.right_ = right;
    }

    @Override
    public int executeInt(VirtualFrame frameValue) {
        int state = this.state_;
        if ((state & 2) == 0 && state != 0) {
            return this.executeInt_int_int0(frameValue, state);
        }
        return this.executeInt_generic1(frameValue, state);
    }

    private int executeInt_int_int0(VirtualFrame frameValue, int state) {
        int rightValue_;
        int leftValue_;
        try {
            leftValue_ = this.left_.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object rightValue = this.right_.executeGeneric(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightValue);
        }
        try {
            rightValue_ = this.right_.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(leftValue_, ex.getResult());
        }
        assert ((state & 1) != 0);
        return this.modulo(leftValue_, rightValue_);
    }

    private int executeInt_generic1(VirtualFrame frameValue, int state) {
        Object leftValue_ = this.left_.executeGeneric(frameValue);
        Object rightValue_ = this.right_.executeGeneric(frameValue);
        if ((state & 1) != 0 && leftValue_ instanceof Integer) {
            int leftValue__ = (Integer)leftValue_;
            if (rightValue_ instanceof Integer) {
                int rightValue__ = (Integer)rightValue_;
                return this.modulo(leftValue__, rightValue__);
            }
        }
        if ((state & 2) != 0) {
            return this.modulo(leftValue_, rightValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftValue_, rightValue_);
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        return this.executeInt(frameValue);
    }

    private int executeAndSpecialize(Object leftValue, Object rightValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            if (leftValue instanceof Integer) {
                int leftValue_ = (Integer)leftValue;
                if (rightValue instanceof Integer) {
                    int rightValue_ = (Integer)rightValue;
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    int n = this.modulo(leftValue_, rightValue_);
                    return n;
                }
            }
            this.state_ = state |= 2;
            lock.unlock();
            hasLock = false;
            int n = this.modulo(leftValue, rightValue);
            return n;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static ModNode create(ExpressionNode left, ExpressionNode right) {
        return new ModNodeGen(left, right);
    }
}

