/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.pojo;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.function.Function;
import oracle.pgx.common.Either;
import oracle.pgx.common.pojo.GraphConfigContainerDeserializer;
import oracle.pgx.common.util.JsonUtil;
import oracle.pgx.common.util.ObfuscationFacade;
import oracle.pgx.config.AnyFormatGraphConfigFactory;
import oracle.pgx.config.GraphConfig;

@JsonDeserialize(using=GraphConfigContainerDeserializer.class)
public class GraphConfigContainer {
    private static final ObfuscationFacade OBFUSCATION_FACADE = new ObfuscationFacade();
    private final Either<GraphConfig, String> graphConfig;

    private GraphConfigContainer(Either<GraphConfig, String> graphConfig) {
        this.graphConfig = graphConfig;
    }

    @JsonValue
    public Object getValue() {
        return this.graphConfig.map(Function.identity(), Function.identity());
    }

    public GraphConfig getGraphConfig(String password) {
        return (GraphConfig)this.graphConfig.map(Function.identity(), encrypted -> this.decrypt((String)encrypted, password));
    }

    private GraphConfig decrypt(String encrypted, String password) {
        String decrypt = OBFUSCATION_FACADE.deobfuscate(encrypted, password);
        try {
            return (GraphConfig)new DeserializerGraphConfigFactory().fromJson(decrypt);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static GraphConfigContainer createClear(GraphConfig config) {
        return new GraphConfigContainer((Either<GraphConfig, String>)Either.left((Object)config));
    }

    public static GraphConfigContainer createObfuscated(GraphConfig config, String password) {
        try {
            String json = JsonUtil.toJson((Object)config);
            String encrypted = OBFUSCATION_FACADE.obfuscate(json, password);
            return GraphConfigContainer.fromObfuscatedRaw(encrypted);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static GraphConfigContainer fromObfuscatedRaw(String encryptedGraphConfig) {
        return new GraphConfigContainer((Either<GraphConfig, String>)Either.right((Object)encryptedGraphConfig));
    }

    private static class DeserializerGraphConfigFactory
    extends AnyFormatGraphConfigFactory {
        DeserializerGraphConfigFactory() {
            super(true, true);
        }
    }
}

