/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.subgraph;

import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.beta.annotation.BetaApi;
import oracle.pgx.api.subgraph.internal.KeystoreLookup;
import oracle.pgx.config.GraphConfig;

@BetaApi
public abstract class AbstractSubgraphReader<R extends AbstractSubgraphReader<R>> {
    protected final PgxSession session;
    protected final KeystoreLookup keystoreLookup;
    protected final Function<GraphConfig, PgxFuture<PgxGraph>> readFunction;

    protected AbstractSubgraphReader(PgxSession session, KeystoreLookup keystoreLookup, Function<GraphConfig, PgxFuture<PgxGraph>> readFunction) {
        this.session = session;
        this.keystoreLookup = keystoreLookup;
        this.readFunction = readFunction;
    }

    protected abstract R getThis();

    public abstract PgxFuture<PgxGraph> loadAsync(String var1);

    public PgxFuture<PgxGraph> loadAsync() {
        return this.loadAsync(null);
    }

    public PgxGraph load(String graphName) throws ExecutionException, InterruptedException {
        return this.loadAsync(graphName).get();
    }

    public PgxGraph load() throws ExecutionException, InterruptedException {
        return this.loadAsync(null).get();
    }
}

