/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.redaction;

import java.util.Iterator;
import java.util.ServiceLoader;
import oracle.pgx.api.redaction.DefaultRedactionManager;
import oracle.pgx.api.redaction.RedactionManager;
import oracle.pgx.common.util.Plugins;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedactionManagerProvider {
    private static final Logger LOG = LoggerFactory.getLogger(RedactionManagerProvider.class);
    private static RedactionManagerProvider provider;
    private ServiceLoader<RedactionManager> loader = Plugins.loadPlugins(RedactionManager.class);
    private RedactionManager service;

    private RedactionManagerProvider() {
    }

    public static RedactionManagerProvider getInstance() {
        if (provider == null) {
            provider = new RedactionManagerProvider();
        }
        return provider;
    }

    public RedactionManager getService() {
        return this.getSingletonService();
    }

    private RedactionManager getSingletonService() {
        if (this.service != null) {
            return this.service;
        }
        Iterator<RedactionManager> serviceIterator = this.loader.iterator();
        if (serviceIterator.hasNext()) {
            this.service = serviceIterator.next();
            LOG.debug("implementation of type {} used", this.service.getClass());
        } else {
            LOG.debug("default implementation used");
            this.service = new DefaultRedactionManager();
        }
        return this.service;
    }
}

