/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal.synchronizer;

import java.sql.Connection;
import java.util.Map;
import oracle.pgx.api.internal.synchronizer.SqlGraphPropertyDefinitionReader;
import oracle.pgx.api.subgraph.internal.PgGraphConfigUtil;
import oracle.pgx.common.ImmutablePair;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.EntityProviderConfig;
import oracle.pgx.config.GraphPropertyConfig;
import oracle.pgx.config.PartitionedGraphConfig;
import oracle.pgx.config.SourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GraphPropertyDefinitions {
    private static final Logger LOG = LoggerFactory.getLogger(GraphPropertyDefinitions.class);
    private final Map<ImmutablePair<String, String>, String> definitionsByProviderAndProperty;

    private GraphPropertyDefinitions(Map<ImmutablePair<String, String>, String> definitionsByProviderAndProperty) {
        this.definitionsByProviderAndProperty = definitionsByProviderAndProperty;
    }

    private void verifyDefinitions(PartitionedGraphConfig graphConfig) {
        for (EntityProviderConfig vertexProvider : graphConfig.getVertexProviders()) {
            this.verifyDefinitionsForProvider(vertexProvider);
        }
        for (EntityProviderConfig edgeProvider : graphConfig.getEdgeProviders()) {
            this.verifyDefinitionsForProvider(edgeProvider);
        }
    }

    private void verifyDefinitionsForProvider(EntityProviderConfig provider) {
        String providerName = provider.getName();
        for (GraphPropertyConfig property : provider.getProps()) {
            if (property.getColumn() != null) continue;
            String string = this.getPropertyDefinition(providerName, property.getName());
        }
    }

    public String getPropertyDefinition(String providerName, String propertyName) {
        String definition = this.definitionsByProviderAndProperty.get(ImmutablePair.of((Object)providerName, (Object)propertyName));
        if (definition == null || definition.isEmpty()) {
            LOG.error("Expected property definition for property {} of provider {}, but no definition was found", (Object)propertyName, (Object)providerName);
            throw new IllegalStateException(ErrorMessages.getMessage((String)"PG_SQL_MISSING_PROPERTY_DEFINITION", (Object[])new Object[]{propertyName, providerName}));
        }
        return definition;
    }

    public static GraphPropertyDefinitions readDefinitions(Connection connection, PartitionedGraphConfig config) {
        LOG.debug("Reading graph property definitions");
        SourceType sourceType = PgGraphConfigUtil.getAndValidateSourceType((PartitionedGraphConfig)config);
        if (sourceType != SourceType.PG_SQL) {
            LOG.error("Unexpected graph config format: {}. This function should only be used for SQL Graphs", (Object)sourceType);
            throw new IllegalStateException(ErrorMessages.getMessage((String)"UNSUPPORTED_FORMAT", (Object[])new Object[]{sourceType}));
        }
        SqlGraphPropertyDefinitionReader definitionReader = new SqlGraphPropertyDefinitionReader(connection, config);
        GraphPropertyDefinitions definitions = new GraphPropertyDefinitions(definitionReader.getDefinitions());
        definitions.verifyDefinitions(config);
        return definitions;
    }
}

