/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal.algorithm.arguments;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import oracle.pgx.api.internal.algorithm.arguments.ArgumentAbbreviationSupport;
import oracle.pgx.common.util.ErrorMessages;

public abstract class AbstractArguments {
    private final Set<String> knownArgs = new HashSet<String>(this.getAvailableArgs());
    private final ArgumentAbbreviationSupport argsVerifier = new ArgumentAbbreviationSupport(this.knownArgs);

    protected abstract Collection<String> getAvailableArgs();

    AbstractArguments() {
    }

    public final Set<String> getKnownArgs() {
        return this.knownArgs;
    }

    public final Map<String, Object> parseArguments(Map<String, Object> receivedArgs) {
        HashMap<String, Object> translatedArguments = new HashMap<String, Object>();
        for (String arg : receivedArgs.keySet()) {
            Optional<Set<String>> matches = this.argsVerifier.getTokensFor(arg);
            Set<String> actualMatches = matches.orElseThrow(() -> new IllegalArgumentException(ErrorMessages.getMessage((String)"UNKNOWN_ARGUMENT", (Object[])new Object[]{arg, String.join((CharSequence)", ", this.getAvailableArgs())})));
            if (actualMatches.size() > 1) {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"AMBIGUOUS_ARGUMENT_NAME", (Object[])new Object[]{arg, String.join((CharSequence)",", actualMatches)}));
            }
            translatedArguments.put(actualMatches.iterator().next().toString(), receivedArgs.get(arg));
        }
        return translatedArguments;
    }
}

