/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal;

import java.util.List;
import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.ResultSetMetaData;
import oracle.pgx.api.PgqlResultElement;
import oracle.pgx.api.filter.FilterType;
import oracle.pgx.common.PgxId;
import oracle.pgx.common.types.internal.ValueType;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.GraphConfig;

public interface PgqlResultSetProxy
extends ResultSetMetaData {
    public String getId();

    public PgxId getGraphId();

    public List<? extends PgqlResultElement> getResultElements();

    public Iterable<List<Object>> getResults();

    public List<Object> getResultRow(long var1) throws PgqlException;

    public long getNumResults();

    public GraphConfig getCreatePropertyGraphConfig();

    default public int getColumnCount() {
        return this.getResultElements().size();
    }

    default public String getColumnName(int i) {
        return this.getResultElements().get(i - 1).getVarName();
    }

    public static void checkValidColumnName(ValueType nodeType, FilterType filterType, String columnName) {
        if (nodeType != ValueType.EDGE && nodeType != ValueType.VERTEX) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_COLUMN_FOR_COLLECTION_GENERATION", (Object[])new Object[]{columnName}));
        }
        if (nodeType == ValueType.EDGE && filterType != FilterType.EDGE || nodeType == ValueType.VERTEX && filterType != FilterType.VERTEX) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"WRONG_COLUMN_FOR_FILTER_TYPE", (Object[])new Object[]{columnName}));
        }
    }

    public static boolean checkColumnTypeForFilter(ValueType nodeType, FilterType filterType) {
        if (nodeType != ValueType.EDGE && nodeType != ValueType.VERTEX) {
            return false;
        }
        return !(nodeType == ValueType.EDGE && filterType != FilterType.EDGE || nodeType == ValueType.VERTEX && filterType != FilterType.VERTEX);
    }
}

