/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.stream.Stream;
import oracle.pgx.api.filter.GraphFilter;
import oracle.pgx.common.PgxId;
import oracle.pgx.common.pojo.ArgumentDeserializer;
import oracle.pgx.common.types.ArgumentType;

@JsonDeserialize(using=ArgumentDeserializer.class)
public class Argument {
    private ArgumentType type;
    private Object value;

    public static Argument createBooleanInArg(boolean value) {
        return new Argument(ArgumentType.BOOL_IN, value);
    }

    public static Argument createBooleanOutArg(String name) {
        return new Argument(ArgumentType.BOOL_OUT, name);
    }

    public static Argument createIntInArg(int value) {
        return new Argument(ArgumentType.INT_IN, value);
    }

    public static Argument createIntOutArg(String name) {
        return new Argument(ArgumentType.INT_OUT, name);
    }

    public static Argument createFloatInArg(float value) {
        return new Argument(ArgumentType.FLOAT_IN, Float.valueOf(value));
    }

    public static Argument createFloatOutArg(String name) {
        return new Argument(ArgumentType.FLOAT_OUT, name);
    }

    public static Argument createDoubleInArg(double value) {
        return new Argument(ArgumentType.DOUBLE_IN, value);
    }

    public static Argument createDoubleOutArg(String name) {
        return new Argument(ArgumentType.DOUBLE_OUT, name);
    }

    public static Argument createLongInArg(long value) {
        return new Argument(ArgumentType.LONG_IN, value);
    }

    public static Argument createLongOutArg(String name) {
        return new Argument(ArgumentType.LONG_OUT, name);
    }

    public static Argument createStringInArg(String value) {
        return new Argument(ArgumentType.STRING_IN, value);
    }

    public static Argument createStringOutArg(String name) {
        return new Argument(ArgumentType.STRING_OUT, name);
    }

    public static Argument createNodeIdInArg(Object value) {
        return new Argument(ArgumentType.NODE_ID_IN, value);
    }

    public static Argument createNodeIdOutArg(String name) {
        return new Argument(ArgumentType.NODE_ID_OUT, name);
    }

    public static Argument createEdgeIdInArg(Object value) {
        return new Argument(ArgumentType.EDGE_ID_IN, value);
    }

    public static Argument createEdgeIdOutArg(String name) {
        return new Argument(ArgumentType.EDGE_ID_OUT, name);
    }

    public static Argument createGraphArg(PgxId id) {
        return new Argument(ArgumentType.GRAPH, id);
    }

    public static Argument createNodePropertyArg(PgxId id) {
        return new Argument(ArgumentType.NODE_PROPERTY, id);
    }

    public static Argument createEdgePropertyArg(PgxId id) {
        return new Argument(ArgumentType.EDGE_PROPERTY, id);
    }

    public static Argument createCollectionArg(PgxId name) {
        return new Argument(ArgumentType.COLLECTION, name);
    }

    public static Argument createMapArg(String name) {
        return new Argument(ArgumentType.MAP, name);
    }

    public static Argument createGenericFilterArg(GraphFilter graphFilter) {
        return new Argument(ArgumentType.GENERIC_FILTER, graphFilter);
    }

    public Argument() {
    }

    private Argument(ArgumentType type, Object value) {
        this.type = type;
        this.value = value;
    }

    public void setType(ArgumentType type) {
        this.type = type;
    }

    public ArgumentType getType() {
        return this.type;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    @JsonIgnore
    public String getName() {
        Object value = this.getValue();
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @JsonIgnore
    public PgxId getAsId() {
        Object value = this.getValue();
        if (value instanceof PgxId) {
            return (PgxId)value;
        }
        return null;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Argument other = (Argument)obj;
        if (this.type != other.type) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public static PgxId[] getGraphs(Argument[] arguments) {
        return (PgxId[])Stream.of(arguments).filter(arg -> arg.getType() == ArgumentType.GRAPH).map(Argument::getAsId).toArray(PgxId[]::new);
    }

    public String toString() {
        return "Argument [type=" + this.type + ", value=" + this.value + "]";
    }
}

