/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.graphbuilder;

import java.util.Objects;
import oracle.pgx.api.EdgeBuilder;
import oracle.pgx.api.GraphBuilderImpl;
import oracle.pgx.common.util.ErrorMessages;

public class EdgeBuilderImpl<VID>
extends GraphBuilderImpl<VID>
implements EdgeBuilder<VID> {
    protected final Object id;
    private final boolean isIgnored;

    public EdgeBuilderImpl(GraphBuilderImpl<VID> base, Object id) {
        this(base, id, false);
    }

    public EdgeBuilderImpl(GraphBuilderImpl<VID> base, Object id, boolean isIgnored) {
        super(base);
        this.id = id;
        this.isIgnored = isIgnored;
    }

    @Override
    public boolean isIgnored() {
        return this.isIgnored;
    }

    @Override
    public EdgeBuilder<VID> setProperty(String key, Object value) {
        if (!this.isIgnored) {
            this.changes.setEdgeProperty(this.id, key, value);
        }
        return this;
    }

    @Override
    public EdgeBuilder<VID> setLabel(String label) {
        if (!this.isIgnored) {
            this.changes.setEdgeLabel(this.id, label);
        }
        return this;
    }

    @Override
    public long getId() {
        if (!(this.id instanceof Long)) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"UNSUPPORTED_OP_ON_NON_LONG_EDGE_IDS", (Object[])new Object[0]));
        }
        return (Long)this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EdgeBuilderImpl that = (EdgeBuilderImpl)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

