/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.frames.schema.internal.dispatchers.temporal;

import java.util.function.Function;
import oracle.pgx.api.frames.schema.datatypes.temporal.LocalDateType;
import oracle.pgx.api.frames.schema.datatypes.temporal.TemporalType;
import oracle.pgx.api.frames.schema.datatypes.temporal.TimeType;
import oracle.pgx.api.frames.schema.datatypes.temporal.TimeWithTimezoneType;
import oracle.pgx.api.frames.schema.datatypes.temporal.TimestampType;
import oracle.pgx.api.frames.schema.datatypes.temporal.TimestampWithTimezoneType;
import oracle.pgx.api.frames.schema.internal.dispatchers.DataTypeDispatcher;
import oracle.pgx.api.frames.schema.internal.dispatchers.temporal.LocalDateTypeDispatcher;
import oracle.pgx.api.frames.schema.internal.dispatchers.temporal.TimeTypeDispatcher;
import oracle.pgx.api.frames.schema.internal.dispatchers.temporal.TimeWithTimezoneTypeDispatcher;
import oracle.pgx.api.frames.schema.internal.dispatchers.temporal.TimestampTypeDispatcher;
import oracle.pgx.api.frames.schema.internal.dispatchers.temporal.TimestampWithTimezoneTypeDispatcher;

@FunctionalInterface
public interface TemporalTypeDispatcher<R>
extends Function<TemporalType, R> {
    public static <R> TemporalTypeDispatcher<R> dispatcher(final LocalDateTypeDispatcher<R> localDateTypeDispatcher, final TimestampTypeDispatcher<R> timestampTypeDispatcher, final TimestampWithTimezoneTypeDispatcher<R> timestampWithTimezoneTypeDispatcher, final TimeTypeDispatcher<R> timeTypeDispatcher, final TimeWithTimezoneTypeDispatcher<R> timeWithTimezoneTypeDispatcher) {
        return new DefaultTemporalTypeDispatcher<R>(){

            @Override
            public R applyLocalDateType(LocalDateType type) {
                return DataTypeDispatcher.applyType(localDateTypeDispatcher, type);
            }

            @Override
            public R applyTimestampType(TimestampType type) {
                return DataTypeDispatcher.applyType(timestampTypeDispatcher, type);
            }

            @Override
            public R applyTimestampWithTimezoneType(TimestampWithTimezoneType type) {
                return DataTypeDispatcher.applyType(timestampWithTimezoneTypeDispatcher, type);
            }

            @Override
            public R applyTimeType(TimeType type) {
                return DataTypeDispatcher.applyType(timeTypeDispatcher, type);
            }

            @Override
            public R applyTimeWithTimezoneType(TimeWithTimezoneType type) {
                return DataTypeDispatcher.applyType(timeWithTimezoneTypeDispatcher, type);
            }
        };
    }

    public static <R> R dispatch(LocalDateTypeDispatcher<R> localDateTypeDispatcher, TimestampTypeDispatcher<R> timestampTypeDispatcher, TimestampWithTimezoneTypeDispatcher<R> timestampWithTimezoneTypeDispatcher, TimeTypeDispatcher<R> timeTypeDispatcher, TimeWithTimezoneTypeDispatcher<R> timeWithTimezoneTypeDispatcher, TemporalType dataType) {
        return TemporalTypeDispatcher.dispatcher(localDateTypeDispatcher, timestampTypeDispatcher, timestampWithTimezoneTypeDispatcher, timeTypeDispatcher, timeWithTimezoneTypeDispatcher).apply(dataType);
    }

    public static interface DefaultTemporalTypeDispatcher<R>
    extends TemporalTypeDispatcher<R> {
        @Override
        default public R apply(TemporalType dataType) {
            if (dataType instanceof LocalDateType) {
                return (R)DataTypeDispatcher.applyType(this::applyLocalDateType, (LocalDateType)dataType);
            }
            if (dataType instanceof TimestampType) {
                return (R)DataTypeDispatcher.applyType(this::applyTimestampType, (TimestampType)dataType);
            }
            if (dataType instanceof TimestampWithTimezoneType) {
                return (R)DataTypeDispatcher.applyType(this::applyTimestampWithTimezoneType, (TimestampWithTimezoneType)dataType);
            }
            if (dataType instanceof TimeType) {
                return (R)DataTypeDispatcher.applyType(this::applyTimeType, (TimeType)dataType);
            }
            if (dataType instanceof TimeWithTimezoneType) {
                return (R)DataTypeDispatcher.applyType(this::applyTimeWithTimezoneType, (TimeWithTimezoneType)dataType);
            }
            return (R)DataTypeDispatcher.throwNoDispatcherForType(dataType);
        }

        default public R applyLocalDateType(LocalDateType type) {
            return (R)DataTypeDispatcher.throwNoDispatcherForType(type);
        }

        default public R applyTimestampType(TimestampType type) {
            return (R)DataTypeDispatcher.throwNoDispatcherForType(type);
        }

        default public R applyTimestampWithTimezoneType(TimestampWithTimezoneType type) {
            return (R)DataTypeDispatcher.throwNoDispatcherForType(type);
        }

        default public R applyTimeType(TimeType type) {
            return (R)DataTypeDispatcher.throwNoDispatcherForType(type);
        }

        default public R applyTimeWithTimezoneType(TimeWithTimezoneType type) {
            return (R)DataTypeDispatcher.throwNoDispatcherForType(type);
        }
    }
}

