/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.frames.schema.internal;

import oracle.pgx.api.frames.schema.datatypes.DataType;
import oracle.pgx.api.frames.schema.datatypes.DataTypes;
import oracle.pgx.api.frames.schema.datatypes.collection.SetType;
import oracle.pgx.api.frames.schema.datatypes.collection.VectorType;
import oracle.pgx.api.frames.schema.internal.dispatchers.DataTypeDispatcher;
import oracle.pgx.api.frames.schema.internal.dispatchers.collection.CollectionTypeDispatcher;
import oracle.pgx.api.frames.schema.internal.dispatchers.collection.VectorTypeDispatcher;
import oracle.pgx.api.frames.schema.internal.dispatchers.graph.GraphEntityTypeDispatcher;
import oracle.pgx.api.frames.schema.internal.dispatchers.numeric.NumericTypeDispatcher;
import oracle.pgx.api.frames.schema.internal.dispatchers.spatial.SpatialTypeDispatcher;
import oracle.pgx.api.frames.schema.internal.dispatchers.temporal.TemporalTypeDispatcher;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.GraphPropertyConfig;
import oracle.pgx.config.GraphPropertyConfigBuilder;

public final class DataTypeInternalUtils {
    private DataTypeInternalUtils() {
    }

    public static GraphPropertyConfig toPropertyConfig(String name, DataType dataType) {
        GraphPropertyConfigBuilder builder = new GraphPropertyConfigBuilder().setName(name);
        NumericTypeDispatcher numericDispatcher = NumericTypeDispatcher.dispatcher(integerType -> builder.setType(PropertyType.INTEGER), longType -> builder.setType(PropertyType.LONG), floatType -> builder.setType(PropertyType.FLOAT), doubleType -> builder.setType(PropertyType.DOUBLE));
        TemporalTypeDispatcher temporalTypeDispatcher = TemporalTypeDispatcher.dispatcher(localDateType -> builder.setType(PropertyType.LOCAL_DATE), timestampType -> builder.setType(PropertyType.TIMESTAMP), timestampWithTimezoneType -> builder.setType(PropertyType.TIMESTAMP_WITH_TIMEZONE), timeType -> builder.setType(PropertyType.TIME), timeWithTimezone -> builder.setType(PropertyType.TIME_WITH_TIMEZONE));
        CollectionTypeDispatcher collectionDispatcher = CollectionTypeDispatcher.dispatcher(null, vectorType -> ((GraphPropertyConfigBuilder)VectorTypeDispatcher.dispatch(integerType -> builder.setType(PropertyType.INTEGER), longType -> builder.setType(PropertyType.LONG), floatType -> builder.setType(PropertyType.FLOAT), doubleType -> builder.setType(PropertyType.DOUBLE), vectorType)).setDimension(vectorType.getDimension().intValue()));
        SpatialTypeDispatcher spatialTypeDispatcher = SpatialTypeDispatcher.dispatcher(point2dType -> builder.setType(PropertyType.POINT2D));
        GraphEntityTypeDispatcher graphDispatcher = GraphEntityTypeDispatcher.dispatcher(vertexType -> builder.setType(PropertyType.VERTEX), edgeType -> builder.setType(PropertyType.EDGE));
        return ((GraphPropertyConfigBuilder)DataTypeDispatcher.dispatch(booleanType -> builder.setType(PropertyType.BOOLEAN), stringType -> builder.setType(PropertyType.STRING), numericDispatcher, temporalTypeDispatcher, collectionDispatcher, spatialTypeDispatcher, graphDispatcher, dataType)).build();
    }

    public static DataType fromPropertyTypeAndDimension(PropertyType propertyType, int dimension) {
        if (dimension == 0) {
            return DataTypeInternalUtils.scalarTypeFromPropertyType(propertyType);
        }
        if (dimension > 0) {
            return DataTypeInternalUtils.vectorTypeFromPropertyType(propertyType, dimension);
        }
        throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_PROPERTY_DIMENSION", (Object[])new Object[0]));
    }

    private static DataType scalarTypeFromPropertyType(PropertyType propertyType) {
        switch (propertyType) {
            case BOOLEAN: {
                return DataTypes.BOOLEAN_TYPE;
            }
            case STRING: {
                return DataTypes.STRING_TYPE;
            }
            case INTEGER: {
                return DataTypes.INTEGER_TYPE;
            }
            case LONG: {
                return DataTypes.LONG_TYPE;
            }
            case FLOAT: {
                return DataTypes.FLOAT_TYPE;
            }
            case DOUBLE: {
                return DataTypes.DOUBLE_TYPE;
            }
            case VERTEX: {
                return DataTypes.VERTEX_TYPE;
            }
            case EDGE: {
                return DataTypes.EDGE_TYPE;
            }
            case LOCAL_DATE: {
                return DataTypes.LOCAL_DATE_TYPE;
            }
            case TIME: {
                return DataTypes.TIME_TYPE;
            }
            case TIMESTAMP: {
                return DataTypes.TIMESTAMP_TYPE;
            }
            case TIME_WITH_TIMEZONE: {
                return DataTypes.TIME_WITH_TIMEZONE_TYPE;
            }
            case TIMESTAMP_WITH_TIMEZONE: {
                return DataTypes.TIMESTAMP_WITH_TIMEZONE_TYPE;
            }
            case RO_STRING_SET: {
                return new SetType(DataTypes.STRING_TYPE);
            }
            case POINT2D: {
                return DataTypes.POINT2D_TYPE;
            }
        }
        throw new IllegalArgumentException(ErrorMessages.getMessage((String)"UNSUPPORTED_PROPERTY_TYPE", (Object[])new Object[]{propertyType}));
    }

    private static DataType vectorTypeFromPropertyType(PropertyType propertyType, int dimension) {
        switch (propertyType) {
            case INTEGER: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return new VectorType(DataTypeInternalUtils.scalarTypeFromPropertyType(propertyType), dimension);
            }
        }
        throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_VECTOR_TYPE", (Object[])new Object[]{propertyType}));
    }
}

