/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.frames;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.frames.PgxCsvFrameReader;
import oracle.pgx.api.frames.PgxDbFrameReader;
import oracle.pgx.api.frames.PgxFrame;
import oracle.pgx.api.frames.PgxFrameReader;
import oracle.pgx.api.frames.PgxPgbFrameReader;
import oracle.pgx.api.internal.Core;
import oracle.pgx.common.NotImplementedException;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.GraphPropertyConfig;
import oracle.pgx.config.GraphPropertyConfigBuilder;

public class PgxGenericFrameReader
extends PgxFrameReader<PgxGenericFrameReader> {
    private String frameName;
    private final List<GraphPropertyConfig> columns = new ArrayList<GraphPropertyConfig>();

    public PgxGenericFrameReader(PgxSession session, Core core, Supplier<String> keystorePathSupplier, Supplier<char[]> keystorePasswordSupplier) {
        super(session, core, keystorePathSupplier, keystorePasswordSupplier);
    }

    @Override
    protected PgxGenericFrameReader getThis() {
        return this;
    }

    @Override
    protected PgxGenericFrameReader withVectorColumn(String columnName, PropertyType type, int dimension, Object defaultValue) {
        GraphPropertyConfig propConfig = new GraphPropertyConfigBuilder().setName(columnName).setType(type).setDimension(dimension).setDefault(defaultValue).build();
        this.columns.add(propConfig);
        return this;
    }

    @Override
    protected void clearColumns() {
        this.columns.clear();
    }

    @Override
    public PgxGenericFrameReader name(String frameName) {
        this.frameName = frameName;
        return this;
    }

    public PgxFrameReader format(String format) {
        String lowerCase = format.toLowerCase();
        if (lowerCase.equals("csv")) {
            return this.csv();
        }
        if (lowerCase.equals("pgb")) {
            return this.pgb();
        }
        if (lowerCase.equals("db")) {
            return this.db();
        }
        throw new IllegalStateException(ErrorMessages.getMessage((String)"UNKNOWN_FORMAT", (Object[])new Object[]{format}));
    }

    public PgxDbFrameReader db() {
        PgxDbFrameReader reader = new PgxDbFrameReader(this.session, this.core, this.keystorePathSupplier, this.keystorePasswordSupplier);
        this.configureReader(reader);
        return reader;
    }

    public PgxCsvFrameReader csv() {
        PgxCsvFrameReader reader = new PgxCsvFrameReader(this.session, this.core, this.keystorePathSupplier, this.keystorePasswordSupplier);
        this.configureReader(reader);
        return reader;
    }

    public PgxFuture<PgxFrame> csvAsync(String ... uris) {
        return this.csv().loadAsync(uris);
    }

    public PgxFrame csv(String ... uris) throws InterruptedException, ExecutionException {
        return this.csvAsync(uris).get();
    }

    public PgxPgbFrameReader pgb() {
        PgxPgbFrameReader reader = new PgxPgbFrameReader(this.session, this.core);
        this.configureReader(reader);
        return reader;
    }

    public PgxFuture<PgxFrame> pgbAsync(String ... uris) {
        return this.pgb().loadAsync(uris);
    }

    public PgxFrame pgb(String ... uris) throws InterruptedException, ExecutionException {
        return this.pgbAsync(uris).get();
    }

    @Override
    public PgxFuture<PgxFrame> loadAsync(String ... uris) {
        throw new NotImplementedException(ErrorMessages.getMessage((String)"FRAME_FORMAT_AUTODETECTION_NOT_SUPPORTED", (Object[])new Object[0]));
    }

    private void configureReader(PgxFrameReader reader) {
        reader.name(this.frameName);
        reader.autodetectColumns(this.autodetectColumn);
        for (GraphPropertyConfig column : this.columns) {
            reader.withVectorColumn(column.getName(), column.getType(), column.getDimension(), column.getDefault());
        }
    }
}

