/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.expansion.internal;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import oracle.pgx.api.expansion.PropertyMergeStrategy;
import oracle.pgx.api.expansion.internal.PgqlGraphExpansionConfig;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="expansionType")
@JsonSubTypes(value={@JsonSubTypes.Type(value=PgqlGraphExpansionConfig.class, name="PGQL_EXPANSION")})
public abstract class GraphExpansionConfig {
    protected final GraphExpansionType expansionType;
    protected final String newGraphName;
    protected final boolean asSnapshot;
    protected final PropertyMergeStrategy vertexPropertyMergeStrategy;
    protected final PropertyMergeStrategy edgePropertyMergeStrategy;

    protected GraphExpansionConfig(String newGraphName, GraphExpansionType expansionType, boolean asSnapshot, PropertyMergeStrategy vertexPropertyMergeStrategy, PropertyMergeStrategy edgePropertyMergeStrategy) {
        this.newGraphName = newGraphName;
        this.expansionType = expansionType;
        this.asSnapshot = asSnapshot;
        this.vertexPropertyMergeStrategy = vertexPropertyMergeStrategy;
        this.edgePropertyMergeStrategy = edgePropertyMergeStrategy;
    }

    @JsonAlias(value={"asSnapshot"})
    public boolean isAsSnapshot() {
        return this.asSnapshot;
    }

    @JsonAlias(value={"graphName"})
    public String getNewGraphName() {
        return this.newGraphName;
    }

    @JsonAlias(value={"expansionType"})
    public GraphExpansionType getExpansionType() {
        return this.expansionType;
    }

    @JsonAlias(value={"vertexPropertyMergeStrategy"})
    public PropertyMergeStrategy getVertexPropertyMergeStrategy() {
        return this.vertexPropertyMergeStrategy;
    }

    @JsonAlias(value={"edgePropertyMergeStrategy"})
    public PropertyMergeStrategy getEdgePropertyMergeStrategy() {
        return this.edgePropertyMergeStrategy;
    }

    static enum GraphExpansionType {
        PGQL_EXPANSION;

    }
}

