/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import oracle.pgx.api.PgxEdge;
import oracle.pgx.api.PgxEntity;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.Property;
import oracle.pgx.api.internal.Edge;
import oracle.pgx.api.internal.Entity;
import oracle.pgx.api.internal.Vertex;
import oracle.pgx.common.types.Direction;
import oracle.pgx.common.types.EntityType;
import oracle.pgx.common.types.IdType;

public class PgxVertex<ID>
extends PgxEntity<ID> {
    static <ID> PgxVertex<ID> deserialize(PgxGraph graph, Object vertexResult) {
        if (vertexResult == null) {
            return null;
        }
        if (vertexResult instanceof Vertex) {
            return new PgxVertex<ID>(graph, (Vertex)vertexResult);
        }
        return new PgxVertex<Object>(graph, vertexResult);
    }

    PgxVertex(PgxGraph graph, Vertex vertex) {
        super(graph, (Entity)vertex);
    }

    PgxVertex(PgxGraph graph, IdType idType, ID id) {
        super(graph, id, idType, EntityType.VERTEX);
    }

    PgxVertex(PgxGraph graph, ID id) {
        super(graph, id, graph.getVertexIdType(), EntityType.VERTEX);
    }

    @Override
    final EntityType getEntityType() {
        return EntityType.VERTEX;
    }

    @Override
    protected <V> PgxFuture<? extends Property<ID, ?, V>> getPropAsync(String propertyName) {
        return this.getGraph().getVertexPropertyAsync(propertyName);
    }

    public PgxFuture<Set<String>> getLabelsAsync() {
        return this.getCore().getVertexLabels(this.getSessionContext(), this.getGraph().getId(), this.serialize()).thenApply(vertexLabels -> vertexLabels.getLabels());
    }

    public Collection<PgxVertex<ID>> getOutNeighbors() {
        return this.getOutNeighborsAsync().join();
    }

    public Collection<PgxVertex<ID>> getInNeighbors() {
        return this.getInNeighborsAsync().join();
    }

    public Collection<PgxVertex<ID>> getNeighbors(Direction direction) {
        return this.getNeighborsAsync(direction, false).join();
    }

    public Collection<PgxVertex<ID>> getNeighbors(Direction direction, boolean removeDuplicates) {
        return this.getNeighborsAsync(direction, removeDuplicates).join();
    }

    public PgxFuture<Collection<PgxVertex<ID>>> getOutNeighborsAsync() {
        return this.getNeighborsAsync(Direction.OUTGOING, false);
    }

    public PgxFuture<Collection<PgxVertex<ID>>> getInNeighborsAsync() {
        return this.getNeighborsAsync(Direction.INCOMING, false);
    }

    public PgxFuture<Collection<PgxVertex<ID>>> getNeighborsAsync(Direction direction, boolean removeDuplicates) {
        return this.getCore().getNeighbors(this.getSessionContext(), this.getGraph().getId(), this.serialize(), direction, this.getType()).thenApply(vertexContainer -> {
            AbstractCollection result = removeDuplicates ? new HashSet() : new ArrayList();
            Stream vertexStream = (Stream)vertexContainer.map(c -> PgxVertex.vertexCollectionToStream(this.getGraph(), c), c -> PgxVertex.idIteratorToStream(this.getGraph(), c));
            vertexStream.forEach(result::add);
            return result;
        });
    }

    private static <ID> Stream<PgxVertex<ID>> vertexCollectionToStream(PgxGraph graph, Collection<Vertex> collection) {
        return collection.stream().map(vertex -> new PgxVertex(graph, (Vertex)vertex));
    }

    private static <ID> Stream<PgxVertex<ID>> idIteratorToStream(PgxGraph graph, Iterable<Object> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false).map(id -> new PgxVertex<Object>(graph, id));
    }

    public Collection<PgxEdge> getOutEdges() {
        return this.getOutEdgesAsync().join();
    }

    public Collection<PgxEdge> getInEdges() {
        return this.getInEdgesAsync().join();
    }

    public long getInDegree() {
        return this.getInDegreeAsync().join();
    }

    public long getDegree() {
        return this.getDegreeAsync().join();
    }

    public long getOutDegree() {
        return this.getOutDegreeAsync().join();
    }

    public PgxFuture<Collection<PgxEdge>> getOutEdgesAsync() {
        return this.callGetEdges(Direction.OUTGOING);
    }

    public PgxFuture<Collection<PgxEdge>> getInEdgesAsync() {
        return this.callGetEdges(Direction.INCOMING);
    }

    public PgxFuture<Long> getInDegreeAsync() {
        return this.callGetEdgeCount(Direction.INCOMING);
    }

    public PgxFuture<Long> getOutDegreeAsync() {
        return this.callGetEdgeCount(Direction.OUTGOING);
    }

    public PgxFuture<Long> getDegreeAsync() {
        return this.getOutDegreeAsync();
    }

    private PgxFuture<Collection<PgxEdge>> callGetEdges(Direction direction) {
        return this.getCore().getEdges(this.getSessionContext(), this.getGraph().getId(), this.serialize(), direction).thenApply(edgesContainer -> (Collection)edgesContainer.map(c -> PgxVertex.edgeCollectionToPgxEdgeCollection(this.getGraph(), c), it -> PgxVertex.longIteratorToPgxEdgeCollection(this.getGraph(), it)));
    }

    private static Collection<PgxEdge> edgeCollectionToPgxEdgeCollection(PgxGraph g, Collection<Edge> collection) {
        return collection.stream().map(e -> new PgxEdge(g, (Edge)e)).collect(Collectors.toList());
    }

    private static Collection<PgxEdge> longIteratorToPgxEdgeCollection(PgxGraph g, PrimitiveIterator.OfLong iterator) {
        return StreamSupport.longStream(Spliterators.spliteratorUnknownSize(iterator, 0), false).mapToObj(l -> new PgxEdge(g, l)).collect(Collectors.toList());
    }

    private PgxFuture<Long> callGetEdgeCount(Direction direction) {
        return this.getCore().getEdgeCount(this.getSessionContext(), this.getGraph().getId(), this.getId(), direction);
    }

    public Set<String> getLabels() {
        return this.getLabelsAsync().join();
    }
}

