/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.client;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import oracle.pgx.api.ComponentCollection;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxVertex;
import oracle.pgx.api.VertexCollection;
import oracle.pgx.api.internal.ComponentsProxy;
import oracle.pgx.api.internal.ProxyException;
import oracle.pgx.api.internal.Vertex;
import oracle.pgx.client.RemoteUtils;
import oracle.pgx.common.PgxId;
import oracle.pgx.common.Self;
import oracle.pgx.common.marshalers.Marshalers;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.util.JsonUtil;
import oracle.pgx.config.LinkTemplate;
import org.apache.hc.client5.http.fluent.Executor;
import org.apache.hc.client5.http.fluent.Request;
import org.apache.hc.core5.net.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteComponentsProxy
implements ComponentsProxy {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteComponentsProxy.class);
    private final Executor httpExecutor;
    private final long size;
    private final URI baseUri;
    private final PgxId propertyId;
    private final PgxId componentNamespace;
    private final String componentsProxyUUID;

    public RemoteComponentsProxy(Executor httpExecutor, long size, URI baseUri, PgxId propertyId, PgxId componentNamespace, String componentsProxyUUID) {
        this.httpExecutor = httpExecutor;
        this.size = size;
        this.baseUri = baseUri;
        this.propertyId = propertyId;
        this.componentNamespace = componentNamespace;
        this.componentsProxyUUID = componentsProxyUUID;
    }

    public String getId() {
        throw new RuntimeException("getId() should never be called on RemoteComponentsProxy");
    }

    public PgxId getComponentNamespace() {
        return this.componentNamespace;
    }

    public <ID> Iterator<VertexCollection<ID>> getVertexCollectionIterator(PgxGraph graph, Function<ID, PgxVertex<ID>> vertexConstructor) {
        return new RemotePartitionIterator(graph, this.componentNamespace, this.size);
    }

    public long size() throws ProxyException {
        return this.size;
    }

    public PgxId getPropertyId() throws ProxyException {
        return this.propertyId;
    }

    public long getComponentIdForNode(Object node) throws ProxyException {
        try {
            Object nodeId = node instanceof Vertex ? JsonUtil.toJson((Object)node) : node;
            URIBuilder builder = new URIBuilder(LinkTemplate.COMPONENTS_FOR_ID.generateUrl(this.baseUri, new Object[0]));
            builder.addParameter("nodeWrapped", Boolean.valueOf(node instanceof Vertex).toString());
            builder.addParameter("nodeType", IdType.getTypeFor(nodeId.getClass()).name());
            Request r = Request.get((URI)builder.build());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Requesting {}", (Object)r);
            }
            r.addHeader("x-proxy-id", this.componentsProxyUUID);
            r.addHeader("x-node", nodeId.toString());
            Self self = (Self)RemoteUtils.parse(this.httpExecutor.execute(r), Marshalers.SELF_MARSHALER);
            return Long.valueOf(self.getId());
        }
        catch (IOException | URISyntaxException | RemoteUtils.RequestPendingException e) {
            throw new ProxyException("could not get the component ID for node " + node, (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new ProxyException(e.getCause());
        }
    }

    public final class RemotePartitionIterator<ID>
    implements Iterator<VertexCollection<ID>> {
        private final PgxGraph graph;
        private final PgxId componentNamespace;
        private final long size;
        private int curId = 0;

        RemotePartitionIterator(PgxGraph graph, PgxId componentNamespace, long size) {
            this.graph = graph;
            this.componentNamespace = componentNamespace;
            this.size = size;
        }

        @Override
        public boolean hasNext() {
            return (long)this.curId < this.size;
        }

        @Override
        public VertexCollection<ID> next() {
            return new ComponentCollection(this.graph, this.componentNamespace, (long)this.curId++);
        }
    }
}

