'''OpenGL extension NV.texture_env_combine4

Overview (from the spec)
	
	New texture environment function COMBINE4_NV allows programmable
	texture combiner operations, including
	
	    ADD                     Arg0 * Arg1 + Arg2 * Arg3
	    ADD_SIGNED_EXT          Arg0 * Arg1 + Arg2 * Arg3 - 0.5
	
	where Arg0, Arg1, Arg2 and Arg3 are derived from
	
	    ZERO                    the value 0
	    PRIMARY_COLOR_EXT       primary color of incoming fragment
	    TEXTURE                 texture color of corresponding texture unit
	    CONSTANT_EXT            texture environment constant color
	    PREVIOUS_EXT            result of previous texture environment; on
	                            texture unit 0, this maps to PRIMARY_COLOR_EXT
	    TEXTURE<n>_ARB          texture color of the <n>th texture unit
	
	In addition, the result may be scaled by 1.0, 2.0 or 4.0.

The official definition of this extension is available here:
http://oss.sgi.com/projects/ogl-sample/registry/NV/texture_env_combine4.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
EXTENSION_NAME = 'GL_NV_texture_env_combine4'
_DEPRECATED = False
GL_COMBINE4_NV = constant.Constant( 'GL_COMBINE4_NV', 0x8503 )
GL_SOURCE3_RGB_NV = constant.Constant( 'GL_SOURCE3_RGB_NV', 0x8583 )
GL_SOURCE3_ALPHA_NV = constant.Constant( 'GL_SOURCE3_ALPHA_NV', 0x858B )
GL_OPERAND3_RGB_NV = constant.Constant( 'GL_OPERAND3_RGB_NV', 0x8593 )
GL_OPERAND3_ALPHA_NV = constant.Constant( 'GL_OPERAND3_ALPHA_NV', 0x859B )


def glInitTextureEnvCombine4NV():
    '''Return boolean indicating whether this extension is available'''
    return extensions.hasGLExtension( EXTENSION_NAME )
