'''OpenGL extension NV.fragment_program2

Overview (from the spec)
	
	This extension, like the NV_fragment_program_option extension, provides
	additional fragment program functionality to extend the standard
	ARB_fragment_program language and execution environment.  ARB programs
	wishing to use this added functionality need only add:
	
	    OPTION NV_fragment_program2;
	
	to the beginning of their fragment programs.
	
	New functionality provided by this extension, above and beyond that
	already provided by the NV_fragment_program_option extension, includes:
	
	
	  * structured branching support, including data-dependent IF tests, loops
	    supporting a fixed number of iterations, and a data-dependent loop
	    exit instruction (BRK),
	
	  * subroutine calls,
	
	  * instructions to perform vector normalization, divide vector components
	    by a scalar, and perform two-component dot products (with or without a
	    scalar add),
	
	  * an instruction to perform a texture lookup with an explicit LOD,
	
	  * a loop index register for indirect access into the texture coordinate
	    attribute array, and
	
	  * a facing attribute that indicates whether the fragment is generated
	    from a front- or back-facing primitive.
	

The official definition of this extension is available here:
http://oss.sgi.com/projects/ogl-sample/registry/NV/fragment_program2.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
EXTENSION_NAME = 'GL_NV_fragment_program2'
_DEPRECATED = False
GL_MAX_PROGRAM_EXEC_INSTRUCTIONS_NV = constant.Constant( 'GL_MAX_PROGRAM_EXEC_INSTRUCTIONS_NV', 0x88F4 )
GL_MAX_PROGRAM_CALL_DEPTH_NV = constant.Constant( 'GL_MAX_PROGRAM_CALL_DEPTH_NV', 0x88F5 )
GL_MAX_PROGRAM_IF_DEPTH_NV = constant.Constant( 'GL_MAX_PROGRAM_IF_DEPTH_NV', 0x88F6 )
GL_MAX_PROGRAM_LOOP_DEPTH_NV = constant.Constant( 'GL_MAX_PROGRAM_LOOP_DEPTH_NV', 0x88F7 )
GL_MAX_PROGRAM_LOOP_COUNT_NV = constant.Constant( 'GL_MAX_PROGRAM_LOOP_COUNT_NV', 0x88F8 )


def glInitFragmentProgram2NV():
    '''Return boolean indicating whether this extension is available'''
    return extensions.hasGLExtension( EXTENSION_NAME )
