'''OpenGL extension EXT.texture_env_dot3

Overview (from the spec)
	
	Adds new operation to the texture combiner operations.
	
	    DOT3_RGB_EXT                    Arg0 <dotprod> Arg1
	    DOT3_RGBA_EXT                   Arg0 <dotprod> Arg1
	
	where Arg0, Arg1 are derived from
	
	    PRIMARY_COLOR_EXT       primary color of incoming fragment
	    TEXTURE                 texture color of corresponding texture unit
	    CONSTANT_EXT            texture environment constant color
	    PREVIOUS_EXT            result of previous texture environment; on
	                            texture unit 0, this maps to PRIMARY_COLOR_EXT
	
	This operaion can only be performed if SOURCE0_RGB_EXT,
	SOURCE1_RGB_EXT are defined.

The official definition of this extension is available here:
http://oss.sgi.com/projects/ogl-sample/registry/EXT/texture_env_dot3.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
EXTENSION_NAME = 'GL_EXT_texture_env_dot3'
_DEPRECATED = False
GL_DOT3_RGB_EXT = constant.Constant( 'GL_DOT3_RGB_EXT', 0x8740 )
GL_DOT3_RGBA_EXT = constant.Constant( 'GL_DOT3_RGBA_EXT', 0x8741 )


def glInitTextureEnvDot3EXT():
    '''Return boolean indicating whether this extension is available'''
    return extensions.hasGLExtension( EXTENSION_NAME )
