'''OpenGL extension ARB.texture_compression

This module customises the behaviour of the 
OpenGL.raw.GL.ARB.texture_compression to provide a more 
Python-friendly API
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL.ARB.texture_compression import *
### END AUTOGENERATED SECTION
from OpenGL.GL import images

for dimensions in (1,2,3):
    for function in ('glCompressedTexImage%sDARB','glCompressedTexSubImage%sDARB'):
        name = function%(dimensions,)
        globals()[ name ] = images.compressedImageFunction(
            globals()[ name ]
        )
        del name, function
    del dimensions

if glGetCompressedTexImageARB:
    def glGetCompressedTexImageARB( target, level, img=None ):
        """Retrieve a compressed texture image"""
        if img is None:
            length = glget.glGetTexLevelParameteriv(
                target, 0, 
                GL_TEXTURE_COMPRESSED_IMAGE_SIZE_ARB, 
            )
            img = arrays.ArrayDataType.zeros( (length,), constants.GL_UNSIGNED_BYTE )
        return glGetCompressedTexImageARB(target, 0, img);