from aces.materials.POSCAR import structure as Material
class structure(Material):
	def getPOSCAR(self):
		self.getMinimized();
		return """ACES POSCAR
1.0
4.27621131928 0.0 0.0
0.0 4.54139940516 0.0
0.0 0.0 11.9873875216
Se Sn
4 4
Direct
0.75 0.485037464537 0.855609685415
0.25 0.985037464537 0.644390314585
0.25 0.514962535463 0.144390314585
0.75 0.0149625354627 0.355609685415
0.75 0.0962153524605 0.125063179368
0.25 0.596215352461 0.374936820632
0.25 0.903784647539 0.874936820632
0.75 0.403784647539 0.625063179368
"""

	def csetup(self):
		from ase.dft.kpoints import ibz_points
		self.bandpoints=ibz_points['orthorhombic']
		self.bandpoints['T']=self.bandpoints['S']
		self.bandpath=["Gamma","Y","T","X","Gamma"]
		if 'setP' in dir(self) and self.setP:
			self.elements=['P','P']
	def getMinimized(self):
		return """ACES POSCAR                             
	 1.00000000000000     
		 4.2016750276879336   -0.0000000000000003    0.0000000000000000
		 0.0000000000000000    4.5635922457776719    0.0000000000000000
		 0.0000000000000000    0.0000000000000000   11.7344091633572880
	 Se   Sn
		 4     4
Direct
	0.7500000000000000  0.4774495337464972  0.8550982536090304
	0.2500000000000000  0.9774495337464975  0.6449017463909696
	0.2500000000000000  0.5225504662535025  0.1449017463909695
	0.7500000000000000  0.0225504662532043  0.3550982536090306
	0.7500000000000000  0.1140008879170425  0.1201105297117838
	0.2500000000000000  0.6140008879175468  0.3798894702882163
	0.2500000000000000  0.8859991120824532  0.8798894702882161
	0.7500000000000000  0.3859991120824530  0.6201105297117839
		"""
