# MAEC Malware Action Classes

# Copyright (c) 2015, The MITRE Corporation
# All rights reserved

# Compatible with MAEC v4.1
# Last updated 08/27/2014

import cybox
from cybox.core import Action
from cybox.objects.code_object import Code

import maec
from . import _namespace
import maec.bindings.maec_bundle as bundle_binding

class Parameter(maec.Entity):
    _namespace = _namespace
    _binding = bundle_binding
    _binding_class = bundle_binding.ParameterType

    ordinal_position = maec.TypedField("ordinal_position")
    name = maec.TypedField("name")
    value = maec.TypedField("value")

    def __init__(self):
        super(Parameter, self).__init__()

class ParameterList(maec.EntityList):
    _contained_type = Parameter
    _binding_class = bundle_binding.ParameterListType
    _binding_var = "Parameter"
    _namespace = _namespace

class APICall(maec.Entity):
    _namespace = _namespace
    _binding = bundle_binding
    _binding_class = bundle_binding.APICallType

    function_name = maec.TypedField("function_name")
    normalized_function_name = maec.TypedField("normalized_function_name")
    address = maec.TypedField("Address")
    return_value = maec.TypedField("Return_Value")
    parameters = maec.TypedField("Parameters", ParameterList)

    def __init__(self):
        super(APICall, self).__init__()

class ActionImplementation(maec.Entity):
    _namespace = _namespace
    _binding = bundle_binding
    _binding_class = bundle_binding.ActionImplementationType

    id_ = maec.TypedField("id")
    type_ = maec.TypedField("type_", key_name = "type")
    #compatible_platforms TODO: Add support
    api_call = maec.TypedField("API_Call", APICall)
    code = maec.TypedField("Code", Code, multiple = True)

    def __init__(self):
        super(ActionImplementation, self).__init__()

class MalwareAction(Action):
    _binding = bundle_binding
    _binding_class = bundle_binding.MalwareActionType
    _namespace = _namespace

    implementation = cybox.TypedField("Implementation", ActionImplementation)
    
    def __init__(self):
        super(MalwareAction, self).__init__()
        self.id_ =  maec.utils.idgen.create_id(prefix="action")


