#!/usr/bin/env python

# Copyright (C) 2009, Mathieu PASQUET <mpa@makina-corpus.com>
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

__docformat__ = 'restructuredtext en'

import os
import sys
import subprocess

dirname = os.path.abspath(os.path.dirname(__file__))
if not 'DJANGO_SETTINGS_MODULE' in os.environ:
    os.environ['DJANGO_SETTINGS_MODULE'] = 'djangotest.djangotest.settings'
os.environ['PYTHONPATH'] = ':'.join(sys.path + os.environ.get('PYTHONPATH', '').split(':'))

def wrap(script):
    sys.argv.pop(0)
    sys.exit(
        subprocess.Popen(
            [sys.executable, os.path.join(dirname, script)]+sys.argv,
            env=os.environ
        ).wait()
    )

def manage():
    wrap('manage_settings.py')
def manage():
    wrap('manage.py')

# vim:set et sts=4 ts=4 tw=80:
