# Copyright 2020 StrongDM Inc
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# Code generated by protogen. DO NOT EDIT.

import grpc
import google.rpc as rpc
import json
from google.rpc import status_pb2
from . import errors
from . import models
from google.protobuf.duration_pb2 import Duration
from google.protobuf.timestamp_pb2 import Timestamp
import datetime
from .options_pb2 import *
from .spec_pb2 import *
from .tags_pb2 import *
from .access_requests_pb2 import *
from .access_request_events_history_pb2 import *
from .access_requests_history_pb2 import *
from .drivers_pb2 import *
from .account_attachments_pb2 import *
from .account_attachments_history_pb2 import *
from .account_grants_pb2 import *
from .account_grants_history_pb2 import *
from .account_permissions_pb2 import *
from .account_resources_pb2 import *
from .account_resources_history_pb2 import *
from .accounts_pb2 import *
from .accounts_history_pb2 import *
from .activities_pb2 import *
from .approval_workflow_approvers_pb2 import *
from .approval_workflow_approvers_history_pb2 import *
from .approval_workflow_steps_pb2 import *
from .approval_workflow_steps_history_pb2 import *
from .approval_workflows_pb2 import *
from .approval_workflows_history_pb2 import *
from .control_panel_pb2 import *
from .health_checks_pb2 import *
from .identity_aliases_pb2 import *
from .identity_aliases_history_pb2 import *
from .identity_sets_pb2 import *
from .identity_sets_history_pb2 import *
from .managed_secrets_pb2 import *
from .nodes_pb2 import *
from .nodes_history_pb2 import *
from .organization_history_pb2 import *
from .peering_group_nodes_pb2 import *
from .peering_group_peers_pb2 import *
from .peering_group_resources_pb2 import *
from .peering_groups_pb2 import *
from .policies_pb2 import *
from .policies_history_pb2 import *
from .proxy_cluster_keys_pb2 import *
from .queries_pb2 import *
from .remote_identities_pb2 import *
from .remote_identities_history_pb2 import *
from .remote_identity_groups_pb2 import *
from .remote_identity_groups_history_pb2 import *
from .replays_pb2 import *
from .resources_pb2 import *
from .resources_history_pb2 import *
from .role_resources_pb2 import *
from .role_resources_history_pb2 import *
from .roles_pb2 import *
from .roles_history_pb2 import *
from .secret_engine_policy_pb2 import *
from .secret_engine_types_pb2 import *
from .secret_store_types_pb2 import *
from .secret_stores_pb2 import *
from .secret_engines_pb2 import *
from .secret_store_healths_pb2 import *
from .secret_stores_history_pb2 import *
from .workflow_approvers_pb2 import *
from .workflow_approvers_history_pb2 import *
from .workflow_assignments_pb2 import *
from .workflow_assignments_history_pb2 import *
from .workflow_roles_pb2 import *
from .workflow_roles_history_pb2 import *
from .workflows_pb2 import *
from .workflows_history_pb2 import *


def quote_filter_args(filter, *args):
    parts = filter.split("?")
    if len(parts) != len(args) + 1:
        raise errors.BadRequestError("incorrect number of replacements")
    b = ""
    for i, v in enumerate(parts):
        b += v
        if i < len(args):
            s = str(args[i])
            s = json.dumps(s)
            b += s
    return b


def convert_timestamp_to_porcelain(t):
    ts = t.ToDatetime().replace(tzinfo=datetime.timezone.utc)
    if ts == datetime.datetime(1970, 1, 1, 0, 0, 0, 0, datetime.timezone.utc):
        return None
    return ts


def convert_timestamp_to_plumbing(t):
    if t is None:
        return Timestamp()
    if t.tzinfo is None:
        t = t.astimezone(datetime.timezone.utc)
    res = Timestamp()
    res.FromDatetime(t)
    return res


def convert_duration_to_porcelain(d):
    return d.ToTimedelta()


def convert_duration_to_plumbing(d):
    res = Duration()
    if d is not None:
        res.FromTimedelta(d)
    return res


def convert_tags_to_porcelain(t):
    res = {}
    for tag in t.pairs:
        res[tag.name] = tag.value
    return res


def convert_tags_to_plumbing(t):
    tags = Tags()
    if t is None:
        return tags
    for key, value in t.items():
        pair = Tags.Pair()
        pair.name = key
        pair.value = value
        tags.pairs.append(pair)
    return tags


def convert_access_rules_to_porcelain(access_rules_json):
    if access_rules_json == "":
        return []
    return json.loads(access_rules_json)


def convert_access_rules_to_plumbing(access_rules):
    return json.dumps(access_rules)


def convert_access_rule_to_porcelain(access_rule_json):
    if access_rule_json == "":
        return {}
    return json.loads(access_rule_json)


def convert_access_rule_to_plumbing(access_rule):
    return json.dumps(access_rule)


def convert_aks_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AKS()
    porcelain.allow_resource_role_bypass = (
        plumbing.allow_resource_role_bypass)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.certificate_authority = (plumbing.certificate_authority)
    porcelain.client_certificate = (plumbing.client_certificate)
    porcelain.client_key = (plumbing.client_key)
    porcelain.discovery_enabled = (plumbing.discovery_enabled)
    porcelain.discovery_username = (plumbing.discovery_username)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.identity_alias_healthcheck_username = (
        plumbing.identity_alias_healthcheck_username)
    porcelain.identity_set_id = (plumbing.identity_set_id)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_aks_to_plumbing(porcelain):
    plumbing = AKS()
    if porcelain is None:
        return plumbing
    plumbing.allow_resource_role_bypass = (
        porcelain.allow_resource_role_bypass)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.certificate_authority = (porcelain.certificate_authority)
    plumbing.client_certificate = (porcelain.client_certificate)
    plumbing.client_key = (porcelain.client_key)
    plumbing.discovery_enabled = (porcelain.discovery_enabled)
    plumbing.discovery_username = (porcelain.discovery_username)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.identity_alias_healthcheck_username = (
        porcelain.identity_alias_healthcheck_username)
    plumbing.identity_set_id = (porcelain.identity_set_id)
    plumbing.name = (porcelain.name)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_aks_to_plumbing(porcelains):
    return [convert_aks_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_aks_to_porcelain(plumbings):
    return [convert_aks_to_porcelain(plumbing) for plumbing in plumbings]


def convert_aks_basic_auth_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AKSBasicAuth()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_aks_basic_auth_to_plumbing(porcelain):
    plumbing = AKSBasicAuth()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_aks_basic_auth_to_plumbing(porcelains):
    return [
        convert_aks_basic_auth_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_aks_basic_auth_to_porcelain(plumbings):
    return [
        convert_aks_basic_auth_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_aks_service_account_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AKSServiceAccount()
    porcelain.allow_resource_role_bypass = (
        plumbing.allow_resource_role_bypass)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.discovery_enabled = (plumbing.discovery_enabled)
    porcelain.discovery_username = (plumbing.discovery_username)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.identity_alias_healthcheck_username = (
        plumbing.identity_alias_healthcheck_username)
    porcelain.identity_set_id = (plumbing.identity_set_id)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.token = (plumbing.token)
    return porcelain


def convert_aks_service_account_to_plumbing(porcelain):
    plumbing = AKSServiceAccount()
    if porcelain is None:
        return plumbing
    plumbing.allow_resource_role_bypass = (
        porcelain.allow_resource_role_bypass)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.discovery_enabled = (porcelain.discovery_enabled)
    plumbing.discovery_username = (porcelain.discovery_username)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.identity_alias_healthcheck_username = (
        porcelain.identity_alias_healthcheck_username)
    plumbing.identity_set_id = (porcelain.identity_set_id)
    plumbing.name = (porcelain.name)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.token = (porcelain.token)
    return plumbing


def convert_repeated_aks_service_account_to_plumbing(porcelains):
    return [
        convert_aks_service_account_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_aks_service_account_to_porcelain(plumbings):
    return [
        convert_aks_service_account_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_aks_service_account_user_impersonation_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AKSServiceAccountUserImpersonation()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.token = (plumbing.token)
    return porcelain


def convert_aks_service_account_user_impersonation_to_plumbing(porcelain):
    plumbing = AKSServiceAccountUserImpersonation()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.token = (porcelain.token)
    return plumbing


def convert_repeated_aks_service_account_user_impersonation_to_plumbing(
        porcelains):
    return [
        convert_aks_service_account_user_impersonation_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_aks_service_account_user_impersonation_to_porcelain(
        plumbings):
    return [
        convert_aks_service_account_user_impersonation_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_aks_user_impersonation_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AKSUserImpersonation()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.certificate_authority = (plumbing.certificate_authority)
    porcelain.client_certificate = (plumbing.client_certificate)
    porcelain.client_key = (plumbing.client_key)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_aks_user_impersonation_to_plumbing(porcelain):
    plumbing = AKSUserImpersonation()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.certificate_authority = (porcelain.certificate_authority)
    plumbing.client_certificate = (porcelain.client_certificate)
    plumbing.client_key = (porcelain.client_key)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_aks_user_impersonation_to_plumbing(porcelains):
    return [
        convert_aks_user_impersonation_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_aks_user_impersonation_to_porcelain(plumbings):
    return [
        convert_aks_user_impersonation_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_aws_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AWS()
    porcelain.access_key = (plumbing.access_key)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthcheck_region = (plumbing.healthcheck_region)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.role_arn = (plumbing.role_arn)
    porcelain.role_external_id = (plumbing.role_external_id)
    porcelain.secret_access_key = (plumbing.secret_access_key)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_aws_to_plumbing(porcelain):
    plumbing = AWS()
    if porcelain is None:
        return plumbing
    plumbing.access_key = (porcelain.access_key)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthcheck_region = (porcelain.healthcheck_region)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.role_arn = (porcelain.role_arn)
    plumbing.role_external_id = (porcelain.role_external_id)
    plumbing.secret_access_key = (porcelain.secret_access_key)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_aws_to_plumbing(porcelains):
    return [convert_aws_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_aws_to_porcelain(plumbings):
    return [convert_aws_to_porcelain(plumbing) for plumbing in plumbings]


def convert_aws_cert_x_509_store_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AWSCertX509Store()
    porcelain.caarn = (plumbing.caArn)
    porcelain.certificatetemplatearn = (plumbing.certificateTemplateArn)
    porcelain.id = (plumbing.id)
    porcelain.issuedcertttlminutes = (plumbing.issuedCertTTLMinutes)
    porcelain.name = (plumbing.name)
    porcelain.region = (plumbing.region)
    porcelain.signingalgo = (plumbing.signingAlgo)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_aws_cert_x_509_store_to_plumbing(porcelain):
    plumbing = AWSCertX509Store()
    if porcelain is None:
        return plumbing
    plumbing.caArn = (porcelain.caarn)
    plumbing.certificateTemplateArn = (porcelain.certificatetemplatearn)
    plumbing.id = (porcelain.id)
    plumbing.issuedCertTTLMinutes = (porcelain.issuedcertttlminutes)
    plumbing.name = (porcelain.name)
    plumbing.region = (porcelain.region)
    plumbing.signingAlgo = (porcelain.signingalgo)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_aws_cert_x_509_store_to_plumbing(porcelains):
    return [
        convert_aws_cert_x_509_store_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_aws_cert_x_509_store_to_porcelain(plumbings):
    return [
        convert_aws_cert_x_509_store_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_aws_console_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AWSConsole()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.enable_env_variables = (plumbing.enable_env_variables)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.identity_alias_healthcheck_username = (
        plumbing.identity_alias_healthcheck_username)
    porcelain.identity_set_id = (plumbing.identity_set_id)
    porcelain.name = (plumbing.name)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.region = (plumbing.region)
    porcelain.role_arn = (plumbing.role_arn)
    porcelain.role_external_id = (plumbing.role_external_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.session_expiry = (plumbing.session_expiry)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_aws_console_to_plumbing(porcelain):
    plumbing = AWSConsole()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.enable_env_variables = (porcelain.enable_env_variables)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.identity_alias_healthcheck_username = (
        porcelain.identity_alias_healthcheck_username)
    plumbing.identity_set_id = (porcelain.identity_set_id)
    plumbing.name = (porcelain.name)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.region = (porcelain.region)
    plumbing.role_arn = (porcelain.role_arn)
    plumbing.role_external_id = (porcelain.role_external_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.session_expiry = (porcelain.session_expiry)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_aws_console_to_plumbing(porcelains):
    return [
        convert_aws_console_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_aws_console_to_porcelain(plumbings):
    return [
        convert_aws_console_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_aws_console_static_key_pair_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AWSConsoleStaticKeyPair()
    porcelain.access_key = (plumbing.access_key)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.identity_alias_healthcheck_username = (
        plumbing.identity_alias_healthcheck_username)
    porcelain.identity_set_id = (plumbing.identity_set_id)
    porcelain.name = (plumbing.name)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.region = (plumbing.region)
    porcelain.role_arn = (plumbing.role_arn)
    porcelain.role_external_id = (plumbing.role_external_id)
    porcelain.secret_access_key = (plumbing.secret_access_key)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.session_expiry = (plumbing.session_expiry)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_aws_console_static_key_pair_to_plumbing(porcelain):
    plumbing = AWSConsoleStaticKeyPair()
    if porcelain is None:
        return plumbing
    plumbing.access_key = (porcelain.access_key)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.identity_alias_healthcheck_username = (
        porcelain.identity_alias_healthcheck_username)
    plumbing.identity_set_id = (porcelain.identity_set_id)
    plumbing.name = (porcelain.name)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.region = (porcelain.region)
    plumbing.role_arn = (porcelain.role_arn)
    plumbing.role_external_id = (porcelain.role_external_id)
    plumbing.secret_access_key = (porcelain.secret_access_key)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.session_expiry = (porcelain.session_expiry)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_aws_console_static_key_pair_to_plumbing(porcelains):
    return [
        convert_aws_console_static_key_pair_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_aws_console_static_key_pair_to_porcelain(plumbings):
    return [
        convert_aws_console_static_key_pair_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_aws_instance_profile_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AWSInstanceProfile()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.enable_env_variables = (plumbing.enable_env_variables)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.region = (plumbing.region)
    porcelain.role_arn = (plumbing.role_arn)
    porcelain.role_external_id = (plumbing.role_external_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_aws_instance_profile_to_plumbing(porcelain):
    plumbing = AWSInstanceProfile()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.enable_env_variables = (porcelain.enable_env_variables)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.region = (porcelain.region)
    plumbing.role_arn = (porcelain.role_arn)
    plumbing.role_external_id = (porcelain.role_external_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_aws_instance_profile_to_plumbing(porcelains):
    return [
        convert_aws_instance_profile_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_aws_instance_profile_to_porcelain(plumbings):
    return [
        convert_aws_instance_profile_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_aws_store_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AWSStore()
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.region = (plumbing.region)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_aws_store_to_plumbing(porcelain):
    plumbing = AWSStore()
    if porcelain is None:
        return plumbing
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.region = (porcelain.region)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_aws_store_to_plumbing(porcelains):
    return [
        convert_aws_store_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_aws_store_to_porcelain(plumbings):
    return [convert_aws_store_to_porcelain(plumbing) for plumbing in plumbings]


def convert_access_request_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccessRequest()
    porcelain.account_id = (plumbing.account_id)
    porcelain.duration = (plumbing.duration)
    porcelain.grant_id = (plumbing.grant_id)
    porcelain.id = (plumbing.id)
    porcelain.reason = (plumbing.reason)
    porcelain.requestedduration = convert_duration_to_porcelain(
        plumbing.requestedDuration)
    porcelain.resource_id = (plumbing.resource_id)
    porcelain.resultduration = convert_duration_to_porcelain(
        plumbing.resultDuration)
    porcelain.start_from = convert_timestamp_to_porcelain(plumbing.start_from)
    porcelain.status = (plumbing.status)
    porcelain.status_at = convert_timestamp_to_porcelain(plumbing.status_at)
    porcelain.valid_until = convert_timestamp_to_porcelain(
        plumbing.valid_until)
    porcelain.workflow_id = (plumbing.workflow_id)
    return porcelain


def convert_access_request_to_plumbing(porcelain):
    plumbing = AccessRequest()
    if porcelain is None:
        return plumbing
    plumbing.account_id = (porcelain.account_id)
    plumbing.duration = (porcelain.duration)
    plumbing.grant_id = (porcelain.grant_id)
    plumbing.id = (porcelain.id)
    plumbing.reason = (porcelain.reason)
    plumbing.requestedDuration.CopyFrom(
        convert_duration_to_plumbing(porcelain.requestedduration))
    plumbing.resource_id = (porcelain.resource_id)
    plumbing.resultDuration.CopyFrom(
        convert_duration_to_plumbing(porcelain.resultduration))
    plumbing.start_from.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.start_from))
    plumbing.status = (porcelain.status)
    plumbing.status_at.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.status_at))
    plumbing.valid_until.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.valid_until))
    plumbing.workflow_id = (porcelain.workflow_id)
    return plumbing


def convert_repeated_access_request_to_plumbing(porcelains):
    return [
        convert_access_request_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_access_request_to_porcelain(plumbings):
    return [
        convert_access_request_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_access_request_config_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccessRequestConfig()
    porcelain.duration = (plumbing.duration)
    porcelain.reason = (plumbing.reason)
    porcelain.resource_id = (plumbing.resource_id)
    porcelain.start_from = convert_timestamp_to_porcelain(plumbing.start_from)
    return porcelain


def convert_access_request_config_to_plumbing(porcelain):
    plumbing = AccessRequestConfig()
    if porcelain is None:
        return plumbing
    plumbing.duration = (porcelain.duration)
    plumbing.reason = (porcelain.reason)
    plumbing.resource_id = (porcelain.resource_id)
    plumbing.start_from.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.start_from))
    return plumbing


def convert_repeated_access_request_config_to_plumbing(porcelains):
    return [
        convert_access_request_config_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_access_request_config_to_porcelain(plumbings):
    return [
        convert_access_request_config_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_access_request_event_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccessRequestEvent()
    porcelain.actor_id = (plumbing.actor_id)
    porcelain.id = (plumbing.id)
    porcelain.metadata = (plumbing.metadata)
    porcelain.request_id = (plumbing.request_id)
    porcelain.type = (plumbing.type)
    return porcelain


def convert_access_request_event_to_plumbing(porcelain):
    plumbing = AccessRequestEvent()
    if porcelain is None:
        return plumbing
    plumbing.actor_id = (porcelain.actor_id)
    plumbing.id = (porcelain.id)
    plumbing.metadata = (porcelain.metadata)
    plumbing.request_id = (porcelain.request_id)
    plumbing.type = (porcelain.type)
    return plumbing


def convert_repeated_access_request_event_to_plumbing(porcelains):
    return [
        convert_access_request_event_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_access_request_event_to_porcelain(plumbings):
    return [
        convert_access_request_event_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_access_request_event_history_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccessRequestEventHistory()
    porcelain.access_request_event = convert_access_request_event_to_porcelain(
        plumbing.access_request_event)
    porcelain.activity_id = (plumbing.activity_id)
    porcelain.deleted_at = convert_timestamp_to_porcelain(plumbing.deleted_at)
    porcelain.timestamp = convert_timestamp_to_porcelain(plumbing.timestamp)
    return porcelain


def convert_access_request_event_history_to_plumbing(porcelain):
    plumbing = AccessRequestEventHistory()
    if porcelain is None:
        return plumbing
    plumbing.access_request_event.CopyFrom(
        convert_access_request_event_to_plumbing(
            porcelain.access_request_event))
    plumbing.activity_id = (porcelain.activity_id)
    plumbing.deleted_at.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.deleted_at))
    plumbing.timestamp.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.timestamp))
    return plumbing


def convert_repeated_access_request_event_history_to_plumbing(porcelains):
    return [
        convert_access_request_event_history_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_access_request_event_history_to_porcelain(plumbings):
    return [
        convert_access_request_event_history_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_access_request_history_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccessRequestHistory()
    porcelain.access_request = convert_access_request_to_porcelain(
        plumbing.access_request)
    porcelain.activity_id = (plumbing.activity_id)
    porcelain.deleted_at = convert_timestamp_to_porcelain(plumbing.deleted_at)
    porcelain.timestamp = convert_timestamp_to_porcelain(plumbing.timestamp)
    return porcelain


def convert_access_request_history_to_plumbing(porcelain):
    plumbing = AccessRequestHistory()
    if porcelain is None:
        return plumbing
    plumbing.access_request.CopyFrom(
        convert_access_request_to_plumbing(porcelain.access_request))
    plumbing.activity_id = (porcelain.activity_id)
    plumbing.deleted_at.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.deleted_at))
    plumbing.timestamp.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.timestamp))
    return plumbing


def convert_repeated_access_request_history_to_plumbing(porcelains):
    return [
        convert_access_request_history_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_access_request_history_to_porcelain(plumbings):
    return [
        convert_access_request_history_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_access_request_list_request_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccessRequestListRequest()
    porcelain.filter = (plumbing.filter)
    return porcelain


def convert_access_request_list_request_to_plumbing(porcelain):
    plumbing = AccessRequestListRequest()
    if porcelain is None:
        return plumbing
    plumbing.filter = (porcelain.filter)
    return plumbing


def convert_repeated_access_request_list_request_to_plumbing(porcelains):
    return [
        convert_access_request_list_request_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_access_request_list_request_to_porcelain(plumbings):
    return [
        convert_access_request_list_request_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_access_request_list_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccessRequestListResponse()
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_access_request_list_response_to_plumbing(porcelain):
    plumbing = AccessRequestListResponse()
    if porcelain is None:
        return plumbing
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_access_request_list_response_to_plumbing(porcelains):
    return [
        convert_access_request_list_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_access_request_list_response_to_porcelain(plumbings):
    return [
        convert_access_request_list_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_account_to_plumbing(porcelain):
    plumbing = Account()
    if porcelain is None:
        return plumbing
    if isinstance(porcelain, models.Service):
        plumbing.service.CopyFrom(convert_service_to_plumbing(porcelain))
    if isinstance(porcelain, models.Token):
        plumbing.token.CopyFrom(convert_token_to_plumbing(porcelain))
    if isinstance(porcelain, models.User):
        plumbing.user.CopyFrom(convert_user_to_plumbing(porcelain))
    return plumbing


def convert_account_to_porcelain(plumbing):
    if plumbing is None:
        return None
    if plumbing.HasField('service'):
        return convert_service_to_porcelain(plumbing.service)
    if plumbing.HasField('token'):
        return convert_token_to_porcelain(plumbing.token)
    if plumbing.HasField('user'):
        return convert_user_to_porcelain(plumbing.user)
    raise errors.UnknownError(
        "unknown polymorphic type, please upgrade your SDK")


def convert_repeated_account_to_plumbing(porcelains):
    return [convert_account_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_account_to_porcelain(plumbings):
    return [convert_account_to_porcelain(plumbing) for plumbing in plumbings]


def convert_account_attachment_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccountAttachment()
    porcelain.account_id = (plumbing.account_id)
    porcelain.id = (plumbing.id)
    porcelain.role_id = (plumbing.role_id)
    return porcelain


def convert_account_attachment_to_plumbing(porcelain):
    plumbing = AccountAttachment()
    if porcelain is None:
        return plumbing
    plumbing.account_id = (porcelain.account_id)
    plumbing.id = (porcelain.id)
    plumbing.role_id = (porcelain.role_id)
    return plumbing


def convert_repeated_account_attachment_to_plumbing(porcelains):
    return [
        convert_account_attachment_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_account_attachment_to_porcelain(plumbings):
    return [
        convert_account_attachment_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_account_attachment_create_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccountAttachmentCreateResponse()
    porcelain.account_attachment = convert_account_attachment_to_porcelain(
        plumbing.account_attachment)
    porcelain.meta = convert_create_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_account_attachment_create_response_to_plumbing(porcelain):
    plumbing = AccountAttachmentCreateResponse()
    if porcelain is None:
        return plumbing
    plumbing.account_attachment.CopyFrom(
        convert_account_attachment_to_plumbing(porcelain.account_attachment))
    plumbing.meta.CopyFrom(
        convert_create_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_account_attachment_create_response_to_plumbing(
        porcelains):
    return [
        convert_account_attachment_create_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_account_attachment_create_response_to_porcelain(
        plumbings):
    return [
        convert_account_attachment_create_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_account_attachment_delete_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccountAttachmentDeleteResponse()
    porcelain.meta = convert_delete_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_account_attachment_delete_response_to_plumbing(porcelain):
    plumbing = AccountAttachmentDeleteResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_delete_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_account_attachment_delete_response_to_plumbing(
        porcelains):
    return [
        convert_account_attachment_delete_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_account_attachment_delete_response_to_porcelain(
        plumbings):
    return [
        convert_account_attachment_delete_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_account_attachment_get_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccountAttachmentGetResponse()
    porcelain.account_attachment = convert_account_attachment_to_porcelain(
        plumbing.account_attachment)
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_account_attachment_get_response_to_plumbing(porcelain):
    plumbing = AccountAttachmentGetResponse()
    if porcelain is None:
        return plumbing
    plumbing.account_attachment.CopyFrom(
        convert_account_attachment_to_plumbing(porcelain.account_attachment))
    plumbing.meta.CopyFrom(
        convert_get_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_account_attachment_get_response_to_plumbing(porcelains):
    return [
        convert_account_attachment_get_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_account_attachment_get_response_to_porcelain(plumbings):
    return [
        convert_account_attachment_get_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_account_attachment_history_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccountAttachmentHistory()
    porcelain.account_attachment = convert_account_attachment_to_porcelain(
        plumbing.account_attachment)
    porcelain.activity_id = (plumbing.activity_id)
    porcelain.deleted_at = convert_timestamp_to_porcelain(plumbing.deleted_at)
    porcelain.timestamp = convert_timestamp_to_porcelain(plumbing.timestamp)
    return porcelain


def convert_account_attachment_history_to_plumbing(porcelain):
    plumbing = AccountAttachmentHistory()
    if porcelain is None:
        return plumbing
    plumbing.account_attachment.CopyFrom(
        convert_account_attachment_to_plumbing(porcelain.account_attachment))
    plumbing.activity_id = (porcelain.activity_id)
    plumbing.deleted_at.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.deleted_at))
    plumbing.timestamp.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.timestamp))
    return plumbing


def convert_repeated_account_attachment_history_to_plumbing(porcelains):
    return [
        convert_account_attachment_history_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_account_attachment_history_to_porcelain(plumbings):
    return [
        convert_account_attachment_history_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_account_create_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccountCreateResponse()
    porcelain.access_key = (plumbing.access_key)
    porcelain.account = convert_account_to_porcelain(plumbing.account)
    porcelain.meta = convert_create_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.secret_key = (plumbing.secret_key)
    porcelain.token = (plumbing.token)
    return porcelain


def convert_account_create_response_to_plumbing(porcelain):
    plumbing = AccountCreateResponse()
    if porcelain is None:
        return plumbing
    plumbing.access_key = (porcelain.access_key)
    plumbing.account.CopyFrom(convert_account_to_plumbing(porcelain.account))
    plumbing.meta.CopyFrom(
        convert_create_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    plumbing.secret_key = (porcelain.secret_key)
    plumbing.token = (porcelain.token)
    return plumbing


def convert_repeated_account_create_response_to_plumbing(porcelains):
    return [
        convert_account_create_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_account_create_response_to_porcelain(plumbings):
    return [
        convert_account_create_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_account_delete_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccountDeleteResponse()
    porcelain.meta = convert_delete_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_account_delete_response_to_plumbing(porcelain):
    plumbing = AccountDeleteResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_delete_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_account_delete_response_to_plumbing(porcelains):
    return [
        convert_account_delete_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_account_delete_response_to_porcelain(plumbings):
    return [
        convert_account_delete_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_account_get_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccountGetResponse()
    porcelain.account = convert_account_to_porcelain(plumbing.account)
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_account_get_response_to_plumbing(porcelain):
    plumbing = AccountGetResponse()
    if porcelain is None:
        return plumbing
    plumbing.account.CopyFrom(convert_account_to_plumbing(porcelain.account))
    plumbing.meta.CopyFrom(
        convert_get_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_account_get_response_to_plumbing(porcelains):
    return [
        convert_account_get_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_account_get_response_to_porcelain(plumbings):
    return [
        convert_account_get_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_account_grant_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccountGrant()
    porcelain.access_rule = convert_access_rule_to_porcelain(
        plumbing.access_rule)
    porcelain.account_id = (plumbing.account_id)
    porcelain.id = (plumbing.id)
    porcelain.resource_id = (plumbing.resource_id)
    porcelain.start_from = convert_timestamp_to_porcelain(plumbing.start_from)
    porcelain.valid_until = convert_timestamp_to_porcelain(
        plumbing.valid_until)
    return porcelain


def convert_account_grant_to_plumbing(porcelain):
    plumbing = AccountGrant()
    if porcelain is None:
        return plumbing
    plumbing.access_rule = convert_access_rule_to_plumbing(
        porcelain.access_rule)
    plumbing.account_id = (porcelain.account_id)
    plumbing.id = (porcelain.id)
    plumbing.resource_id = (porcelain.resource_id)
    plumbing.start_from.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.start_from))
    plumbing.valid_until.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.valid_until))
    return plumbing


def convert_repeated_account_grant_to_plumbing(porcelains):
    return [
        convert_account_grant_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_account_grant_to_porcelain(plumbings):
    return [
        convert_account_grant_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_account_grant_create_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccountGrantCreateResponse()
    porcelain.account_grant = convert_account_grant_to_porcelain(
        plumbing.account_grant)
    porcelain.meta = convert_create_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_account_grant_create_response_to_plumbing(porcelain):
    plumbing = AccountGrantCreateResponse()
    if porcelain is None:
        return plumbing
    plumbing.account_grant.CopyFrom(
        convert_account_grant_to_plumbing(porcelain.account_grant))
    plumbing.meta.CopyFrom(
        convert_create_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_account_grant_create_response_to_plumbing(porcelains):
    return [
        convert_account_grant_create_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_account_grant_create_response_to_porcelain(plumbings):
    return [
        convert_account_grant_create_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_account_grant_delete_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccountGrantDeleteResponse()
    porcelain.meta = convert_delete_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_account_grant_delete_response_to_plumbing(porcelain):
    plumbing = AccountGrantDeleteResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_delete_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_account_grant_delete_response_to_plumbing(porcelains):
    return [
        convert_account_grant_delete_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_account_grant_delete_response_to_porcelain(plumbings):
    return [
        convert_account_grant_delete_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_account_grant_get_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccountGrantGetResponse()
    porcelain.account_grant = convert_account_grant_to_porcelain(
        plumbing.account_grant)
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_account_grant_get_response_to_plumbing(porcelain):
    plumbing = AccountGrantGetResponse()
    if porcelain is None:
        return plumbing
    plumbing.account_grant.CopyFrom(
        convert_account_grant_to_plumbing(porcelain.account_grant))
    plumbing.meta.CopyFrom(
        convert_get_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_account_grant_get_response_to_plumbing(porcelains):
    return [
        convert_account_grant_get_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_account_grant_get_response_to_porcelain(plumbings):
    return [
        convert_account_grant_get_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_account_grant_history_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccountGrantHistory()
    porcelain.account_grant = convert_account_grant_to_porcelain(
        plumbing.account_grant)
    porcelain.activity_id = (plumbing.activity_id)
    porcelain.deleted_at = convert_timestamp_to_porcelain(plumbing.deleted_at)
    porcelain.timestamp = convert_timestamp_to_porcelain(plumbing.timestamp)
    return porcelain


def convert_account_grant_history_to_plumbing(porcelain):
    plumbing = AccountGrantHistory()
    if porcelain is None:
        return plumbing
    plumbing.account_grant.CopyFrom(
        convert_account_grant_to_plumbing(porcelain.account_grant))
    plumbing.activity_id = (porcelain.activity_id)
    plumbing.deleted_at.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.deleted_at))
    plumbing.timestamp.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.timestamp))
    return plumbing


def convert_repeated_account_grant_history_to_plumbing(porcelains):
    return [
        convert_account_grant_history_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_account_grant_history_to_porcelain(plumbings):
    return [
        convert_account_grant_history_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_account_history_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccountHistory()
    porcelain.account = convert_account_to_porcelain(plumbing.account)
    porcelain.activity_id = (plumbing.activity_id)
    porcelain.deleted_at = convert_timestamp_to_porcelain(plumbing.deleted_at)
    porcelain.timestamp = convert_timestamp_to_porcelain(plumbing.timestamp)
    return porcelain


def convert_account_history_to_plumbing(porcelain):
    plumbing = AccountHistory()
    if porcelain is None:
        return plumbing
    plumbing.account.CopyFrom(convert_account_to_plumbing(porcelain.account))
    plumbing.activity_id = (porcelain.activity_id)
    plumbing.deleted_at.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.deleted_at))
    plumbing.timestamp.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.timestamp))
    return plumbing


def convert_repeated_account_history_to_plumbing(porcelains):
    return [
        convert_account_history_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_account_history_to_porcelain(plumbings):
    return [
        convert_account_history_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_account_permission_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccountPermission()
    porcelain.account_id = (plumbing.account_id)
    porcelain.granted_at = convert_timestamp_to_porcelain(plumbing.granted_at)
    porcelain.permission = (plumbing.permission)
    porcelain.scope = (plumbing.scope)
    porcelain.scoped_id = (plumbing.scoped_id)
    return porcelain


def convert_account_permission_to_plumbing(porcelain):
    plumbing = AccountPermission()
    if porcelain is None:
        return plumbing
    plumbing.account_id = (porcelain.account_id)
    plumbing.granted_at.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.granted_at))
    plumbing.permission = (porcelain.permission)
    plumbing.scope = (porcelain.scope)
    plumbing.scoped_id = (porcelain.scoped_id)
    return plumbing


def convert_repeated_account_permission_to_plumbing(porcelains):
    return [
        convert_account_permission_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_account_permission_to_porcelain(plumbings):
    return [
        convert_account_permission_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_account_resource_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccountResource()
    porcelain.account_grant_id = (plumbing.account_grant_id)
    porcelain.account_id = (plumbing.account_id)
    porcelain.created_at = convert_timestamp_to_porcelain(plumbing.created_at)
    porcelain.expires_at = convert_timestamp_to_porcelain(plumbing.expires_at)
    porcelain.granted_at = convert_timestamp_to_porcelain(plumbing.granted_at)
    porcelain.resource_id = (plumbing.resource_id)
    porcelain.role_id = (plumbing.role_id)
    return porcelain


def convert_account_resource_to_plumbing(porcelain):
    plumbing = AccountResource()
    if porcelain is None:
        return plumbing
    plumbing.account_grant_id = (porcelain.account_grant_id)
    plumbing.account_id = (porcelain.account_id)
    plumbing.created_at.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.created_at))
    plumbing.expires_at.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.expires_at))
    plumbing.granted_at.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.granted_at))
    plumbing.resource_id = (porcelain.resource_id)
    plumbing.role_id = (porcelain.role_id)
    return plumbing


def convert_repeated_account_resource_to_plumbing(porcelains):
    return [
        convert_account_resource_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_account_resource_to_porcelain(plumbings):
    return [
        convert_account_resource_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_account_resource_history_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccountResourceHistory()
    porcelain.account_resource = convert_account_resource_to_porcelain(
        plumbing.account_resource)
    porcelain.activity_id = (plumbing.activity_id)
    porcelain.deleted_at = convert_timestamp_to_porcelain(plumbing.deleted_at)
    porcelain.timestamp = convert_timestamp_to_porcelain(plumbing.timestamp)
    return porcelain


def convert_account_resource_history_to_plumbing(porcelain):
    plumbing = AccountResourceHistory()
    if porcelain is None:
        return plumbing
    plumbing.account_resource.CopyFrom(
        convert_account_resource_to_plumbing(porcelain.account_resource))
    plumbing.activity_id = (porcelain.activity_id)
    plumbing.deleted_at.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.deleted_at))
    plumbing.timestamp.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.timestamp))
    return plumbing


def convert_repeated_account_resource_history_to_plumbing(porcelains):
    return [
        convert_account_resource_history_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_account_resource_history_to_porcelain(plumbings):
    return [
        convert_account_resource_history_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_account_update_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccountUpdateResponse()
    porcelain.account = convert_account_to_porcelain(plumbing.account)
    porcelain.meta = convert_update_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_account_update_response_to_plumbing(porcelain):
    plumbing = AccountUpdateResponse()
    if porcelain is None:
        return plumbing
    plumbing.account.CopyFrom(convert_account_to_plumbing(porcelain.account))
    plumbing.meta.CopyFrom(
        convert_update_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_account_update_response_to_plumbing(porcelains):
    return [
        convert_account_update_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_account_update_response_to_porcelain(plumbings):
    return [
        convert_account_update_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_active_directory_engine_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ActiveDirectoryEngine()
    porcelain.after_read_ttl = convert_duration_to_porcelain(
        plumbing.after_read_ttl)
    porcelain.binddn = (plumbing.binddn)
    porcelain.bindpass = (plumbing.bindpass)
    porcelain.certificate = (plumbing.certificate)
    porcelain.connection_timeout = (plumbing.connection_timeout)
    porcelain.do_not_validate_timestamps = (
        plumbing.do_not_validate_timestamps)
    porcelain.id = (plumbing.id)
    porcelain.insecure_tls = (plumbing.insecure_tls)
    porcelain.key_rotation_interval_days = (
        plumbing.key_rotation_interval_days)
    porcelain.max_backoff_duration = convert_duration_to_porcelain(
        plumbing.max_backoff_duration)
    porcelain.name = (plumbing.name)
    porcelain.policy = convert_secret_engine_policy_to_porcelain(
        plumbing.policy)
    porcelain.public_key = (plumbing.public_key)
    porcelain.request_timeout = (plumbing.request_timeout)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.secret_store_root_path = (plumbing.secret_store_root_path)
    porcelain.start_tls = (plumbing.start_tls)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.ttl = convert_duration_to_porcelain(plumbing.ttl)
    porcelain.upndomain = (plumbing.upndomain)
    porcelain.url = (plumbing.url)
    porcelain.userdn = (plumbing.userdn)
    return porcelain


def convert_active_directory_engine_to_plumbing(porcelain):
    plumbing = ActiveDirectoryEngine()
    if porcelain is None:
        return plumbing
    plumbing.after_read_ttl.CopyFrom(
        convert_duration_to_plumbing(porcelain.after_read_ttl))
    plumbing.binddn = (porcelain.binddn)
    plumbing.bindpass = (porcelain.bindpass)
    plumbing.certificate = (porcelain.certificate)
    plumbing.connection_timeout = (porcelain.connection_timeout)
    plumbing.do_not_validate_timestamps = (
        porcelain.do_not_validate_timestamps)
    plumbing.id = (porcelain.id)
    plumbing.insecure_tls = (porcelain.insecure_tls)
    plumbing.key_rotation_interval_days = (
        porcelain.key_rotation_interval_days)
    plumbing.max_backoff_duration.CopyFrom(
        convert_duration_to_plumbing(porcelain.max_backoff_duration))
    plumbing.name = (porcelain.name)
    plumbing.policy.CopyFrom(
        convert_secret_engine_policy_to_plumbing(porcelain.policy))
    plumbing.public_key = (porcelain.public_key)
    plumbing.request_timeout = (porcelain.request_timeout)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.secret_store_root_path = (porcelain.secret_store_root_path)
    plumbing.start_tls = (porcelain.start_tls)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.ttl.CopyFrom(convert_duration_to_plumbing(porcelain.ttl))
    plumbing.upndomain = (porcelain.upndomain)
    plumbing.url = (porcelain.url)
    plumbing.userdn = (porcelain.userdn)
    return plumbing


def convert_repeated_active_directory_engine_to_plumbing(porcelains):
    return [
        convert_active_directory_engine_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_active_directory_engine_to_porcelain(plumbings):
    return [
        convert_active_directory_engine_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_active_directory_store_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ActiveDirectoryStore()
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.server_address = (plumbing.server_address)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_active_directory_store_to_plumbing(porcelain):
    plumbing = ActiveDirectoryStore()
    if porcelain is None:
        return plumbing
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.server_address = (porcelain.server_address)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_active_directory_store_to_plumbing(porcelains):
    return [
        convert_active_directory_store_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_active_directory_store_to_porcelain(plumbings):
    return [
        convert_active_directory_store_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_activity_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Activity()
    porcelain.actor = convert_activity_actor_to_porcelain(plumbing.actor)
    porcelain.completed_at = convert_timestamp_to_porcelain(
        plumbing.completed_at)
    porcelain.description = (plumbing.description)
    porcelain.entities = convert_repeated_activity_entity_to_porcelain(
        plumbing.entities)
    porcelain.id = (plumbing.id)
    porcelain.ip_address = (plumbing.ip_address)
    porcelain.user_agent = (plumbing.user_agent)
    porcelain.verb = (plumbing.verb)
    return porcelain


def convert_activity_to_plumbing(porcelain):
    plumbing = Activity()
    if porcelain is None:
        return plumbing
    plumbing.actor.CopyFrom(convert_activity_actor_to_plumbing(
        porcelain.actor))
    plumbing.completed_at.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.completed_at))
    plumbing.description = (porcelain.description)
    del plumbing.entities[:]
    plumbing.entities.extend(
        convert_repeated_activity_entity_to_plumbing(porcelain.entities))
    plumbing.id = (porcelain.id)
    plumbing.ip_address = (porcelain.ip_address)
    plumbing.user_agent = (porcelain.user_agent)
    plumbing.verb = (porcelain.verb)
    return plumbing


def convert_repeated_activity_to_plumbing(porcelains):
    return [
        convert_activity_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_activity_to_porcelain(plumbings):
    return [convert_activity_to_porcelain(plumbing) for plumbing in plumbings]


def convert_activity_actor_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ActivityActor()
    porcelain.activity_external_id = (plumbing.activity_external_id)
    porcelain.email = (plumbing.email)
    porcelain.first_name = (plumbing.first_name)
    porcelain.id = (plumbing.id)
    porcelain.last_name = (plumbing.last_name)
    return porcelain


def convert_activity_actor_to_plumbing(porcelain):
    plumbing = ActivityActor()
    if porcelain is None:
        return plumbing
    plumbing.activity_external_id = (porcelain.activity_external_id)
    plumbing.email = (porcelain.email)
    plumbing.first_name = (porcelain.first_name)
    plumbing.id = (porcelain.id)
    plumbing.last_name = (porcelain.last_name)
    return plumbing


def convert_repeated_activity_actor_to_plumbing(porcelains):
    return [
        convert_activity_actor_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_activity_actor_to_porcelain(plumbings):
    return [
        convert_activity_actor_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_activity_entity_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ActivityEntity()
    porcelain.email = (plumbing.email)
    porcelain.external_id = (plumbing.external_id)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.type = (plumbing.type)
    return porcelain


def convert_activity_entity_to_plumbing(porcelain):
    plumbing = ActivityEntity()
    if porcelain is None:
        return plumbing
    plumbing.email = (porcelain.email)
    plumbing.external_id = (porcelain.external_id)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.type = (porcelain.type)
    return plumbing


def convert_repeated_activity_entity_to_plumbing(porcelains):
    return [
        convert_activity_entity_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_activity_entity_to_porcelain(plumbings):
    return [
        convert_activity_entity_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_activity_get_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ActivityGetResponse()
    porcelain.activity = convert_activity_to_porcelain(plumbing.activity)
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_activity_get_response_to_plumbing(porcelain):
    plumbing = ActivityGetResponse()
    if porcelain is None:
        return plumbing
    plumbing.activity.CopyFrom(convert_activity_to_plumbing(
        porcelain.activity))
    plumbing.meta.CopyFrom(
        convert_get_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_activity_get_response_to_plumbing(porcelains):
    return [
        convert_activity_get_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_activity_get_response_to_porcelain(plumbings):
    return [
        convert_activity_get_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_aerospike_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Aerospike()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_aerospike_to_plumbing(porcelain):
    plumbing = Aerospike()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_aerospike_to_plumbing(porcelains):
    return [
        convert_aerospike_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_aerospike_to_porcelain(plumbings):
    return [convert_aerospike_to_porcelain(plumbing) for plumbing in plumbings]


def convert_amazon_eks_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AmazonEKS()
    porcelain.access_key = (plumbing.access_key)
    porcelain.allow_resource_role_bypass = (
        plumbing.allow_resource_role_bypass)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.certificate_authority = (plumbing.certificate_authority)
    porcelain.cluster_name = (plumbing.cluster_name)
    porcelain.discovery_enabled = (plumbing.discovery_enabled)
    porcelain.discovery_username = (plumbing.discovery_username)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.endpoint = (plumbing.endpoint)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.identity_alias_healthcheck_username = (
        plumbing.identity_alias_healthcheck_username)
    porcelain.identity_set_id = (plumbing.identity_set_id)
    porcelain.name = (plumbing.name)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.region = (plumbing.region)
    porcelain.role_arn = (plumbing.role_arn)
    porcelain.role_external_id = (plumbing.role_external_id)
    porcelain.secret_access_key = (plumbing.secret_access_key)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_amazon_eks_to_plumbing(porcelain):
    plumbing = AmazonEKS()
    if porcelain is None:
        return plumbing
    plumbing.access_key = (porcelain.access_key)
    plumbing.allow_resource_role_bypass = (
        porcelain.allow_resource_role_bypass)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.certificate_authority = (porcelain.certificate_authority)
    plumbing.cluster_name = (porcelain.cluster_name)
    plumbing.discovery_enabled = (porcelain.discovery_enabled)
    plumbing.discovery_username = (porcelain.discovery_username)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.endpoint = (porcelain.endpoint)
    plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.identity_alias_healthcheck_username = (
        porcelain.identity_alias_healthcheck_username)
    plumbing.identity_set_id = (porcelain.identity_set_id)
    plumbing.name = (porcelain.name)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.region = (porcelain.region)
    plumbing.role_arn = (porcelain.role_arn)
    plumbing.role_external_id = (porcelain.role_external_id)
    plumbing.secret_access_key = (porcelain.secret_access_key)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_amazon_eks_to_plumbing(porcelains):
    return [
        convert_amazon_eks_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_amazon_eks_to_porcelain(plumbings):
    return [
        convert_amazon_eks_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_amazon_eks_instance_profile_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AmazonEKSInstanceProfile()
    porcelain.allow_resource_role_bypass = (
        plumbing.allow_resource_role_bypass)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.certificate_authority = (plumbing.certificate_authority)
    porcelain.cluster_name = (plumbing.cluster_name)
    porcelain.discovery_enabled = (plumbing.discovery_enabled)
    porcelain.discovery_username = (plumbing.discovery_username)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.endpoint = (plumbing.endpoint)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.identity_alias_healthcheck_username = (
        plumbing.identity_alias_healthcheck_username)
    porcelain.identity_set_id = (plumbing.identity_set_id)
    porcelain.name = (plumbing.name)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.region = (plumbing.region)
    porcelain.role_arn = (plumbing.role_arn)
    porcelain.role_external_id = (plumbing.role_external_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_amazon_eks_instance_profile_to_plumbing(porcelain):
    plumbing = AmazonEKSInstanceProfile()
    if porcelain is None:
        return plumbing
    plumbing.allow_resource_role_bypass = (
        porcelain.allow_resource_role_bypass)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.certificate_authority = (porcelain.certificate_authority)
    plumbing.cluster_name = (porcelain.cluster_name)
    plumbing.discovery_enabled = (porcelain.discovery_enabled)
    plumbing.discovery_username = (porcelain.discovery_username)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.endpoint = (porcelain.endpoint)
    plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.identity_alias_healthcheck_username = (
        porcelain.identity_alias_healthcheck_username)
    plumbing.identity_set_id = (porcelain.identity_set_id)
    plumbing.name = (porcelain.name)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.region = (porcelain.region)
    plumbing.role_arn = (porcelain.role_arn)
    plumbing.role_external_id = (porcelain.role_external_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_amazon_eks_instance_profile_to_plumbing(porcelains):
    return [
        convert_amazon_eks_instance_profile_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_amazon_eks_instance_profile_to_porcelain(plumbings):
    return [
        convert_amazon_eks_instance_profile_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_amazon_eks_instance_profile_user_impersonation_to_porcelain(
        plumbing):
    if plumbing is None:
        return None
    porcelain = models.AmazonEKSInstanceProfileUserImpersonation()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.certificate_authority = (plumbing.certificate_authority)
    porcelain.cluster_name = (plumbing.cluster_name)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.endpoint = (plumbing.endpoint)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.region = (plumbing.region)
    porcelain.role_arn = (plumbing.role_arn)
    porcelain.role_external_id = (plumbing.role_external_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_amazon_eks_instance_profile_user_impersonation_to_plumbing(
        porcelain):
    plumbing = AmazonEKSInstanceProfileUserImpersonation()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.certificate_authority = (porcelain.certificate_authority)
    plumbing.cluster_name = (porcelain.cluster_name)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.endpoint = (porcelain.endpoint)
    plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.region = (porcelain.region)
    plumbing.role_arn = (porcelain.role_arn)
    plumbing.role_external_id = (porcelain.role_external_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_amazon_eks_instance_profile_user_impersonation_to_plumbing(
        porcelains):
    return [
        convert_amazon_eks_instance_profile_user_impersonation_to_plumbing(
            porcelain) for porcelain in porcelains
    ]


def convert_repeated_amazon_eks_instance_profile_user_impersonation_to_porcelain(
        plumbings):
    return [
        convert_amazon_eks_instance_profile_user_impersonation_to_porcelain(
            plumbing) for plumbing in plumbings
    ]


def convert_amazon_eks_user_impersonation_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AmazonEKSUserImpersonation()
    porcelain.access_key = (plumbing.access_key)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.certificate_authority = (plumbing.certificate_authority)
    porcelain.cluster_name = (plumbing.cluster_name)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.endpoint = (plumbing.endpoint)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.region = (plumbing.region)
    porcelain.role_arn = (plumbing.role_arn)
    porcelain.role_external_id = (plumbing.role_external_id)
    porcelain.secret_access_key = (plumbing.secret_access_key)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_amazon_eks_user_impersonation_to_plumbing(porcelain):
    plumbing = AmazonEKSUserImpersonation()
    if porcelain is None:
        return plumbing
    plumbing.access_key = (porcelain.access_key)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.certificate_authority = (porcelain.certificate_authority)
    plumbing.cluster_name = (porcelain.cluster_name)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.endpoint = (porcelain.endpoint)
    plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.region = (porcelain.region)
    plumbing.role_arn = (porcelain.role_arn)
    plumbing.role_external_id = (porcelain.role_external_id)
    plumbing.secret_access_key = (porcelain.secret_access_key)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_amazon_eks_user_impersonation_to_plumbing(porcelains):
    return [
        convert_amazon_eks_user_impersonation_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_amazon_eks_user_impersonation_to_porcelain(plumbings):
    return [
        convert_amazon_eks_user_impersonation_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_amazon_es_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AmazonES()
    porcelain.access_key = (plumbing.access_key)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.endpoint = (plumbing.endpoint)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.region = (plumbing.region)
    porcelain.role_arn = (plumbing.role_arn)
    porcelain.role_external_id = (plumbing.role_external_id)
    porcelain.secret_access_key = (plumbing.secret_access_key)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_amazon_es_to_plumbing(porcelain):
    plumbing = AmazonES()
    if porcelain is None:
        return plumbing
    plumbing.access_key = (porcelain.access_key)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.endpoint = (porcelain.endpoint)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.region = (porcelain.region)
    plumbing.role_arn = (porcelain.role_arn)
    plumbing.role_external_id = (porcelain.role_external_id)
    plumbing.secret_access_key = (porcelain.secret_access_key)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_amazon_es_to_plumbing(porcelains):
    return [
        convert_amazon_es_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_amazon_es_to_porcelain(plumbings):
    return [convert_amazon_es_to_porcelain(plumbing) for plumbing in plumbings]


def convert_amazon_esiam_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AmazonESIAM()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.endpoint = (plumbing.endpoint)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.region = (plumbing.region)
    porcelain.role_arn = (plumbing.role_arn)
    porcelain.role_external_id = (plumbing.role_external_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tlsrequired = (plumbing.tlsRequired)
    return porcelain


def convert_amazon_esiam_to_plumbing(porcelain):
    plumbing = AmazonESIAM()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.endpoint = (porcelain.endpoint)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.region = (porcelain.region)
    plumbing.role_arn = (porcelain.role_arn)
    plumbing.role_external_id = (porcelain.role_external_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.tlsRequired = (porcelain.tlsrequired)
    return plumbing


def convert_repeated_amazon_esiam_to_plumbing(porcelains):
    return [
        convert_amazon_esiam_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_amazon_esiam_to_porcelain(plumbings):
    return [
        convert_amazon_esiam_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_amazon_mqamqp_091_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AmazonMQAMQP091()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tls_required = (plumbing.tls_required)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_amazon_mqamqp_091_to_plumbing(porcelain):
    plumbing = AmazonMQAMQP091()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.tls_required = (porcelain.tls_required)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_amazon_mqamqp_091_to_plumbing(porcelains):
    return [
        convert_amazon_mqamqp_091_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_amazon_mqamqp_091_to_porcelain(plumbings):
    return [
        convert_amazon_mqamqp_091_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_approval_flow_approver_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ApprovalFlowApprover()
    porcelain.account_id = (plumbing.account_id)
    porcelain.reference = (plumbing.reference)
    porcelain.role_id = (plumbing.role_id)
    return porcelain


def convert_approval_flow_approver_to_plumbing(porcelain):
    plumbing = ApprovalFlowApprover()
    if porcelain is None:
        return plumbing
    plumbing.account_id = (porcelain.account_id)
    plumbing.reference = (porcelain.reference)
    plumbing.role_id = (porcelain.role_id)
    return plumbing


def convert_repeated_approval_flow_approver_to_plumbing(porcelains):
    return [
        convert_approval_flow_approver_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_approval_flow_approver_to_porcelain(plumbings):
    return [
        convert_approval_flow_approver_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_approval_flow_step_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ApprovalFlowStep()
    porcelain.approvers = convert_repeated_approval_flow_approver_to_porcelain(
        plumbing.approvers)
    porcelain.quantifier = (plumbing.quantifier)
    porcelain.skip_after = convert_duration_to_porcelain(plumbing.skip_after)
    return porcelain


def convert_approval_flow_step_to_plumbing(porcelain):
    plumbing = ApprovalFlowStep()
    if porcelain is None:
        return plumbing
    del plumbing.approvers[:]
    plumbing.approvers.extend(
        convert_repeated_approval_flow_approver_to_plumbing(
            porcelain.approvers))
    plumbing.quantifier = (porcelain.quantifier)
    plumbing.skip_after.CopyFrom(
        convert_duration_to_plumbing(porcelain.skip_after))
    return plumbing


def convert_repeated_approval_flow_step_to_plumbing(porcelains):
    return [
        convert_approval_flow_step_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_approval_flow_step_to_porcelain(plumbings):
    return [
        convert_approval_flow_step_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_approval_workflow_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ApprovalWorkflow()
    porcelain.approval_mode = (plumbing.approval_mode)
    porcelain.approval_workflow_steps = convert_repeated_approval_flow_step_to_porcelain(
        plumbing.approval_workflow_steps)
    porcelain.description = (plumbing.description)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    return porcelain


def convert_approval_workflow_to_plumbing(porcelain):
    plumbing = ApprovalWorkflow()
    if porcelain is None:
        return plumbing
    plumbing.approval_mode = (porcelain.approval_mode)
    del plumbing.approval_workflow_steps[:]
    plumbing.approval_workflow_steps.extend(
        convert_repeated_approval_flow_step_to_plumbing(
            porcelain.approval_workflow_steps))
    plumbing.description = (porcelain.description)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    return plumbing


def convert_repeated_approval_workflow_to_plumbing(porcelains):
    return [
        convert_approval_workflow_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_approval_workflow_to_porcelain(plumbings):
    return [
        convert_approval_workflow_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_approval_workflow_approver_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ApprovalWorkflowApprover()
    porcelain.account_id = (plumbing.account_id)
    porcelain.approval_flow_id = (plumbing.approval_flow_id)
    porcelain.approval_step_id = (plumbing.approval_step_id)
    porcelain.id = (plumbing.id)
    porcelain.reference = (plumbing.reference)
    porcelain.role_id = (plumbing.role_id)
    return porcelain


def convert_approval_workflow_approver_to_plumbing(porcelain):
    plumbing = ApprovalWorkflowApprover()
    if porcelain is None:
        return plumbing
    plumbing.account_id = (porcelain.account_id)
    plumbing.approval_flow_id = (porcelain.approval_flow_id)
    plumbing.approval_step_id = (porcelain.approval_step_id)
    plumbing.id = (porcelain.id)
    plumbing.reference = (porcelain.reference)
    plumbing.role_id = (porcelain.role_id)
    return plumbing


def convert_repeated_approval_workflow_approver_to_plumbing(porcelains):
    return [
        convert_approval_workflow_approver_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_approval_workflow_approver_to_porcelain(plumbings):
    return [
        convert_approval_workflow_approver_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_approval_workflow_approver_create_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ApprovalWorkflowApproverCreateResponse()
    porcelain.approval_workflow_approver = convert_approval_workflow_approver_to_porcelain(
        plumbing.approval_workflow_approver)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_approval_workflow_approver_create_response_to_plumbing(porcelain):
    plumbing = ApprovalWorkflowApproverCreateResponse()
    if porcelain is None:
        return plumbing
    plumbing.approval_workflow_approver.CopyFrom(
        convert_approval_workflow_approver_to_plumbing(
            porcelain.approval_workflow_approver))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_approval_workflow_approver_create_response_to_plumbing(
        porcelains):
    return [
        convert_approval_workflow_approver_create_response_to_plumbing(
            porcelain) for porcelain in porcelains
    ]


def convert_repeated_approval_workflow_approver_create_response_to_porcelain(
        plumbings):
    return [
        convert_approval_workflow_approver_create_response_to_porcelain(
            plumbing) for plumbing in plumbings
    ]


def convert_approval_workflow_approver_delete_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ApprovalWorkflowApproverDeleteResponse()
    porcelain.id = (plumbing.id)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_approval_workflow_approver_delete_response_to_plumbing(porcelain):
    plumbing = ApprovalWorkflowApproverDeleteResponse()
    if porcelain is None:
        return plumbing
    plumbing.id = (porcelain.id)
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_approval_workflow_approver_delete_response_to_plumbing(
        porcelains):
    return [
        convert_approval_workflow_approver_delete_response_to_plumbing(
            porcelain) for porcelain in porcelains
    ]


def convert_repeated_approval_workflow_approver_delete_response_to_porcelain(
        plumbings):
    return [
        convert_approval_workflow_approver_delete_response_to_porcelain(
            plumbing) for plumbing in plumbings
    ]


def convert_approval_workflow_approver_get_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ApprovalWorkflowApproverGetResponse()
    porcelain.approval_workflow_approver = convert_approval_workflow_approver_to_porcelain(
        plumbing.approval_workflow_approver)
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_approval_workflow_approver_get_response_to_plumbing(porcelain):
    plumbing = ApprovalWorkflowApproverGetResponse()
    if porcelain is None:
        return plumbing
    plumbing.approval_workflow_approver.CopyFrom(
        convert_approval_workflow_approver_to_plumbing(
            porcelain.approval_workflow_approver))
    plumbing.meta.CopyFrom(
        convert_get_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_approval_workflow_approver_get_response_to_plumbing(
        porcelains):
    return [
        convert_approval_workflow_approver_get_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_approval_workflow_approver_get_response_to_porcelain(
        plumbings):
    return [
        convert_approval_workflow_approver_get_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_approval_workflow_approver_history_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ApprovalWorkflowApproverHistory()
    porcelain.activity_id = (plumbing.activity_id)
    porcelain.approval_workflow_approver = convert_approval_workflow_approver_to_porcelain(
        plumbing.approval_workflow_approver)
    porcelain.deleted_at = convert_timestamp_to_porcelain(plumbing.deleted_at)
    porcelain.timestamp = convert_timestamp_to_porcelain(plumbing.timestamp)
    return porcelain


def convert_approval_workflow_approver_history_to_plumbing(porcelain):
    plumbing = ApprovalWorkflowApproverHistory()
    if porcelain is None:
        return plumbing
    plumbing.activity_id = (porcelain.activity_id)
    plumbing.approval_workflow_approver.CopyFrom(
        convert_approval_workflow_approver_to_plumbing(
            porcelain.approval_workflow_approver))
    plumbing.deleted_at.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.deleted_at))
    plumbing.timestamp.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.timestamp))
    return plumbing


def convert_repeated_approval_workflow_approver_history_to_plumbing(
        porcelains):
    return [
        convert_approval_workflow_approver_history_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_approval_workflow_approver_history_to_porcelain(
        plumbings):
    return [
        convert_approval_workflow_approver_history_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_approval_workflow_approver_list_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ApprovalWorkflowApproverListResponse()
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_approval_workflow_approver_list_response_to_plumbing(porcelain):
    plumbing = ApprovalWorkflowApproverListResponse()
    if porcelain is None:
        return plumbing
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_approval_workflow_approver_list_response_to_plumbing(
        porcelains):
    return [
        convert_approval_workflow_approver_list_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_approval_workflow_approver_list_response_to_porcelain(
        plumbings):
    return [
        convert_approval_workflow_approver_list_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_approval_workflow_create_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ApprovalWorkflowCreateResponse()
    porcelain.approval_workflow = convert_approval_workflow_to_porcelain(
        plumbing.approval_workflow)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_approval_workflow_create_response_to_plumbing(porcelain):
    plumbing = ApprovalWorkflowCreateResponse()
    if porcelain is None:
        return plumbing
    plumbing.approval_workflow.CopyFrom(
        convert_approval_workflow_to_plumbing(porcelain.approval_workflow))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_approval_workflow_create_response_to_plumbing(porcelains):
    return [
        convert_approval_workflow_create_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_approval_workflow_create_response_to_porcelain(plumbings):
    return [
        convert_approval_workflow_create_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_approval_workflow_delete_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ApprovalWorkflowDeleteResponse()
    porcelain.id = (plumbing.id)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_approval_workflow_delete_response_to_plumbing(porcelain):
    plumbing = ApprovalWorkflowDeleteResponse()
    if porcelain is None:
        return plumbing
    plumbing.id = (porcelain.id)
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_approval_workflow_delete_response_to_plumbing(porcelains):
    return [
        convert_approval_workflow_delete_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_approval_workflow_delete_response_to_porcelain(plumbings):
    return [
        convert_approval_workflow_delete_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_approval_workflow_get_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ApprovalWorkflowGetResponse()
    porcelain.approval_workflow = convert_approval_workflow_to_porcelain(
        plumbing.approval_workflow)
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_approval_workflow_get_response_to_plumbing(porcelain):
    plumbing = ApprovalWorkflowGetResponse()
    if porcelain is None:
        return plumbing
    plumbing.approval_workflow.CopyFrom(
        convert_approval_workflow_to_plumbing(porcelain.approval_workflow))
    plumbing.meta.CopyFrom(
        convert_get_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_approval_workflow_get_response_to_plumbing(porcelains):
    return [
        convert_approval_workflow_get_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_approval_workflow_get_response_to_porcelain(plumbings):
    return [
        convert_approval_workflow_get_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_approval_workflow_history_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ApprovalWorkflowHistory()
    porcelain.activity_id = (plumbing.activity_id)
    porcelain.approval_workflow = convert_approval_workflow_to_porcelain(
        plumbing.approval_workflow)
    porcelain.deleted_at = convert_timestamp_to_porcelain(plumbing.deleted_at)
    porcelain.timestamp = convert_timestamp_to_porcelain(plumbing.timestamp)
    return porcelain


def convert_approval_workflow_history_to_plumbing(porcelain):
    plumbing = ApprovalWorkflowHistory()
    if porcelain is None:
        return plumbing
    plumbing.activity_id = (porcelain.activity_id)
    plumbing.approval_workflow.CopyFrom(
        convert_approval_workflow_to_plumbing(porcelain.approval_workflow))
    plumbing.deleted_at.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.deleted_at))
    plumbing.timestamp.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.timestamp))
    return plumbing


def convert_repeated_approval_workflow_history_to_plumbing(porcelains):
    return [
        convert_approval_workflow_history_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_approval_workflow_history_to_porcelain(plumbings):
    return [
        convert_approval_workflow_history_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_approval_workflow_list_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ApprovalWorkflowListResponse()
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_approval_workflow_list_response_to_plumbing(porcelain):
    plumbing = ApprovalWorkflowListResponse()
    if porcelain is None:
        return plumbing
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_approval_workflow_list_response_to_plumbing(porcelains):
    return [
        convert_approval_workflow_list_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_approval_workflow_list_response_to_porcelain(plumbings):
    return [
        convert_approval_workflow_list_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_approval_workflow_step_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ApprovalWorkflowStep()
    porcelain.approval_flow_id = (plumbing.approval_flow_id)
    porcelain.id = (plumbing.id)
    porcelain.quantifier = (plumbing.quantifier)
    porcelain.skip_after = convert_duration_to_porcelain(plumbing.skip_after)
    porcelain.step_order = (plumbing.step_order)
    return porcelain


def convert_approval_workflow_step_to_plumbing(porcelain):
    plumbing = ApprovalWorkflowStep()
    if porcelain is None:
        return plumbing
    plumbing.approval_flow_id = (porcelain.approval_flow_id)
    plumbing.id = (porcelain.id)
    plumbing.quantifier = (porcelain.quantifier)
    plumbing.skip_after.CopyFrom(
        convert_duration_to_plumbing(porcelain.skip_after))
    plumbing.step_order = (porcelain.step_order)
    return plumbing


def convert_repeated_approval_workflow_step_to_plumbing(porcelains):
    return [
        convert_approval_workflow_step_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_approval_workflow_step_to_porcelain(plumbings):
    return [
        convert_approval_workflow_step_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_approval_workflow_step_create_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ApprovalWorkflowStepCreateResponse()
    porcelain.approval_workflow_step = convert_approval_workflow_step_to_porcelain(
        plumbing.approval_workflow_step)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_approval_workflow_step_create_response_to_plumbing(porcelain):
    plumbing = ApprovalWorkflowStepCreateResponse()
    if porcelain is None:
        return plumbing
    plumbing.approval_workflow_step.CopyFrom(
        convert_approval_workflow_step_to_plumbing(
            porcelain.approval_workflow_step))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_approval_workflow_step_create_response_to_plumbing(
        porcelains):
    return [
        convert_approval_workflow_step_create_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_approval_workflow_step_create_response_to_porcelain(
        plumbings):
    return [
        convert_approval_workflow_step_create_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_approval_workflow_step_delete_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ApprovalWorkflowStepDeleteResponse()
    porcelain.id = (plumbing.id)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_approval_workflow_step_delete_response_to_plumbing(porcelain):
    plumbing = ApprovalWorkflowStepDeleteResponse()
    if porcelain is None:
        return plumbing
    plumbing.id = (porcelain.id)
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_approval_workflow_step_delete_response_to_plumbing(
        porcelains):
    return [
        convert_approval_workflow_step_delete_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_approval_workflow_step_delete_response_to_porcelain(
        plumbings):
    return [
        convert_approval_workflow_step_delete_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_approval_workflow_step_get_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ApprovalWorkflowStepGetResponse()
    porcelain.approval_workflow_step = convert_approval_workflow_step_to_porcelain(
        plumbing.approval_workflow_step)
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_approval_workflow_step_get_response_to_plumbing(porcelain):
    plumbing = ApprovalWorkflowStepGetResponse()
    if porcelain is None:
        return plumbing
    plumbing.approval_workflow_step.CopyFrom(
        convert_approval_workflow_step_to_plumbing(
            porcelain.approval_workflow_step))
    plumbing.meta.CopyFrom(
        convert_get_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_approval_workflow_step_get_response_to_plumbing(
        porcelains):
    return [
        convert_approval_workflow_step_get_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_approval_workflow_step_get_response_to_porcelain(
        plumbings):
    return [
        convert_approval_workflow_step_get_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_approval_workflow_step_history_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ApprovalWorkflowStepHistory()
    porcelain.activity_id = (plumbing.activity_id)
    porcelain.approval_workflow_step = convert_approval_workflow_step_to_porcelain(
        plumbing.approval_workflow_step)
    porcelain.deleted_at = convert_timestamp_to_porcelain(plumbing.deleted_at)
    porcelain.timestamp = convert_timestamp_to_porcelain(plumbing.timestamp)
    return porcelain


def convert_approval_workflow_step_history_to_plumbing(porcelain):
    plumbing = ApprovalWorkflowStepHistory()
    if porcelain is None:
        return plumbing
    plumbing.activity_id = (porcelain.activity_id)
    plumbing.approval_workflow_step.CopyFrom(
        convert_approval_workflow_step_to_plumbing(
            porcelain.approval_workflow_step))
    plumbing.deleted_at.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.deleted_at))
    plumbing.timestamp.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.timestamp))
    return plumbing


def convert_repeated_approval_workflow_step_history_to_plumbing(porcelains):
    return [
        convert_approval_workflow_step_history_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_approval_workflow_step_history_to_porcelain(plumbings):
    return [
        convert_approval_workflow_step_history_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_approval_workflow_step_list_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ApprovalWorkflowStepListResponse()
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_approval_workflow_step_list_response_to_plumbing(porcelain):
    plumbing = ApprovalWorkflowStepListResponse()
    if porcelain is None:
        return plumbing
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_approval_workflow_step_list_response_to_plumbing(
        porcelains):
    return [
        convert_approval_workflow_step_list_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_approval_workflow_step_list_response_to_porcelain(
        plumbings):
    return [
        convert_approval_workflow_step_list_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_approval_workflow_update_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ApprovalWorkflowUpdateResponse()
    porcelain.approval_workflow = convert_approval_workflow_to_porcelain(
        plumbing.approval_workflow)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_approval_workflow_update_response_to_plumbing(porcelain):
    plumbing = ApprovalWorkflowUpdateResponse()
    if porcelain is None:
        return plumbing
    plumbing.approval_workflow.CopyFrom(
        convert_approval_workflow_to_plumbing(porcelain.approval_workflow))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_approval_workflow_update_response_to_plumbing(porcelains):
    return [
        convert_approval_workflow_update_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_approval_workflow_update_response_to_porcelain(plumbings):
    return [
        convert_approval_workflow_update_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_athena_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Athena()
    porcelain.access_key = (plumbing.access_key)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.output = (plumbing.output)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.region = (plumbing.region)
    porcelain.role_arn = (plumbing.role_arn)
    porcelain.role_external_id = (plumbing.role_external_id)
    porcelain.secret_access_key = (plumbing.secret_access_key)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_athena_to_plumbing(porcelain):
    plumbing = Athena()
    if porcelain is None:
        return plumbing
    plumbing.access_key = (porcelain.access_key)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.output = (porcelain.output)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.region = (porcelain.region)
    plumbing.role_arn = (porcelain.role_arn)
    plumbing.role_external_id = (porcelain.role_external_id)
    plumbing.secret_access_key = (porcelain.secret_access_key)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_athena_to_plumbing(porcelains):
    return [convert_athena_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_athena_to_porcelain(plumbings):
    return [convert_athena_to_porcelain(plumbing) for plumbing in plumbings]


def convert_athena_iam_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AthenaIAM()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.output = (plumbing.output)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.region = (plumbing.region)
    porcelain.role_arn = (plumbing.role_arn)
    porcelain.role_external_id = (plumbing.role_external_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_athena_iam_to_plumbing(porcelain):
    plumbing = AthenaIAM()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.output = (porcelain.output)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.region = (porcelain.region)
    plumbing.role_arn = (porcelain.role_arn)
    plumbing.role_external_id = (porcelain.role_external_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_athena_iam_to_plumbing(porcelains):
    return [
        convert_athena_iam_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_athena_iam_to_porcelain(plumbings):
    return [
        convert_athena_iam_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_aurora_mysql_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AuroraMysql()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.require_native_auth = (plumbing.require_native_auth)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.use_azure_single_server_usernames = (
        plumbing.use_azure_single_server_usernames)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_aurora_mysql_to_plumbing(porcelain):
    plumbing = AuroraMysql()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.require_native_auth = (porcelain.require_native_auth)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.use_azure_single_server_usernames = (
        porcelain.use_azure_single_server_usernames)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_aurora_mysql_to_plumbing(porcelains):
    return [
        convert_aurora_mysql_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_aurora_mysql_to_porcelain(plumbings):
    return [
        convert_aurora_mysql_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_aurora_mysql_iam_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AuroraMysqlIAM()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.region = (plumbing.region)
    porcelain.role_assumption_arn = (plumbing.role_assumption_arn)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_aurora_mysql_iam_to_plumbing(porcelain):
    plumbing = AuroraMysqlIAM()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.region = (porcelain.region)
    plumbing.role_assumption_arn = (porcelain.role_assumption_arn)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_aurora_mysql_iam_to_plumbing(porcelains):
    return [
        convert_aurora_mysql_iam_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_aurora_mysql_iam_to_porcelain(plumbings):
    return [
        convert_aurora_mysql_iam_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_aurora_postgres_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AuroraPostgres()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.override_database = (plumbing.override_database)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_aurora_postgres_to_plumbing(porcelain):
    plumbing = AuroraPostgres()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.override_database = (porcelain.override_database)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_aurora_postgres_to_plumbing(porcelains):
    return [
        convert_aurora_postgres_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_aurora_postgres_to_porcelain(plumbings):
    return [
        convert_aurora_postgres_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_aurora_postgres_iam_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AuroraPostgresIAM()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.override_database = (plumbing.override_database)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.region = (plumbing.region)
    porcelain.role_assumption_arn = (plumbing.role_assumption_arn)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_aurora_postgres_iam_to_plumbing(porcelain):
    plumbing = AuroraPostgresIAM()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.override_database = (porcelain.override_database)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.region = (porcelain.region)
    plumbing.role_assumption_arn = (porcelain.role_assumption_arn)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_aurora_postgres_iam_to_plumbing(porcelains):
    return [
        convert_aurora_postgres_iam_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_aurora_postgres_iam_to_porcelain(plumbings):
    return [
        convert_aurora_postgres_iam_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_azure_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Azure()
    porcelain.app_id = (plumbing.app_id)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tenant_id = (plumbing.tenant_id)
    return porcelain


def convert_azure_to_plumbing(porcelain):
    plumbing = Azure()
    if porcelain is None:
        return plumbing
    plumbing.app_id = (porcelain.app_id)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.tenant_id = (porcelain.tenant_id)
    return plumbing


def convert_repeated_azure_to_plumbing(porcelains):
    return [convert_azure_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_azure_to_porcelain(plumbings):
    return [convert_azure_to_porcelain(plumbing) for plumbing in plumbings]


def convert_azure_certificate_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AzureCertificate()
    porcelain.app_id = (plumbing.app_id)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.client_certificate = (plumbing.client_certificate)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tenant_id = (plumbing.tenant_id)
    return porcelain


def convert_azure_certificate_to_plumbing(porcelain):
    plumbing = AzureCertificate()
    if porcelain is None:
        return plumbing
    plumbing.app_id = (porcelain.app_id)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.client_certificate = (porcelain.client_certificate)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.tenant_id = (porcelain.tenant_id)
    return plumbing


def convert_repeated_azure_certificate_to_plumbing(porcelains):
    return [
        convert_azure_certificate_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_azure_certificate_to_porcelain(plumbings):
    return [
        convert_azure_certificate_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_azure_mysql_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AzureMysql()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.require_native_auth = (plumbing.require_native_auth)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.use_azure_single_server_usernames = (
        plumbing.use_azure_single_server_usernames)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_azure_mysql_to_plumbing(porcelain):
    plumbing = AzureMysql()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.require_native_auth = (porcelain.require_native_auth)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.use_azure_single_server_usernames = (
        porcelain.use_azure_single_server_usernames)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_azure_mysql_to_plumbing(porcelains):
    return [
        convert_azure_mysql_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_azure_mysql_to_porcelain(plumbings):
    return [
        convert_azure_mysql_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_azure_postgres_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AzurePostgres()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.override_database = (plumbing.override_database)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_azure_postgres_to_plumbing(porcelain):
    plumbing = AzurePostgres()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.override_database = (porcelain.override_database)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_azure_postgres_to_plumbing(porcelains):
    return [
        convert_azure_postgres_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_azure_postgres_to_porcelain(plumbings):
    return [
        convert_azure_postgres_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_azure_postgres_managed_identity_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AzurePostgresManagedIdentity()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.override_database = (plumbing.override_database)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.use_azure_single_server_usernames = (
        plumbing.use_azure_single_server_usernames)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_azure_postgres_managed_identity_to_plumbing(porcelain):
    plumbing = AzurePostgresManagedIdentity()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.override_database = (porcelain.override_database)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.use_azure_single_server_usernames = (
        porcelain.use_azure_single_server_usernames)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_azure_postgres_managed_identity_to_plumbing(porcelains):
    return [
        convert_azure_postgres_managed_identity_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_azure_postgres_managed_identity_to_porcelain(plumbings):
    return [
        convert_azure_postgres_managed_identity_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_azure_store_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AzureStore()
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.vault_uri = (plumbing.vault_uri)
    return porcelain


def convert_azure_store_to_plumbing(porcelain):
    plumbing = AzureStore()
    if porcelain is None:
        return plumbing
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.vault_uri = (porcelain.vault_uri)
    return plumbing


def convert_repeated_azure_store_to_plumbing(porcelains):
    return [
        convert_azure_store_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_azure_store_to_porcelain(plumbings):
    return [
        convert_azure_store_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_big_query_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.BigQuery()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.endpoint = (plumbing.endpoint)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port_override = (plumbing.port_override)
    porcelain.private_key = (plumbing.private_key)
    porcelain.project = (plumbing.project)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_big_query_to_plumbing(porcelain):
    plumbing = BigQuery()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.endpoint = (porcelain.endpoint)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.port_override = (porcelain.port_override)
    plumbing.private_key = (porcelain.private_key)
    plumbing.project = (porcelain.project)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_big_query_to_plumbing(porcelains):
    return [
        convert_big_query_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_big_query_to_porcelain(plumbings):
    return [convert_big_query_to_porcelain(plumbing) for plumbing in plumbings]


def convert_cassandra_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Cassandra()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tls_required = (plumbing.tls_required)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_cassandra_to_plumbing(porcelain):
    plumbing = Cassandra()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.tls_required = (porcelain.tls_required)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_cassandra_to_plumbing(porcelains):
    return [
        convert_cassandra_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_cassandra_to_porcelain(plumbings):
    return [convert_cassandra_to_porcelain(plumbing) for plumbing in plumbings]


def convert_citus_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Citus()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.override_database = (plumbing.override_database)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_citus_to_plumbing(porcelain):
    plumbing = Citus()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.override_database = (porcelain.override_database)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_citus_to_plumbing(porcelains):
    return [convert_citus_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_citus_to_porcelain(plumbings):
    return [convert_citus_to_porcelain(plumbing) for plumbing in plumbings]


def convert_click_house_http_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ClickHouseHTTP()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.url = (plumbing.url)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_click_house_http_to_plumbing(porcelain):
    plumbing = ClickHouseHTTP()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.url = (porcelain.url)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_click_house_http_to_plumbing(porcelains):
    return [
        convert_click_house_http_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_click_house_http_to_porcelain(plumbings):
    return [
        convert_click_house_http_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_click_house_my_sql_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ClickHouseMySQL()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.require_native_auth = (plumbing.require_native_auth)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_click_house_my_sql_to_plumbing(porcelain):
    plumbing = ClickHouseMySQL()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.require_native_auth = (porcelain.require_native_auth)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_click_house_my_sql_to_plumbing(porcelains):
    return [
        convert_click_house_my_sql_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_click_house_my_sql_to_porcelain(plumbings):
    return [
        convert_click_house_my_sql_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_click_house_tcp_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ClickHouseTCP()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tls_required = (plumbing.tls_required)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_click_house_tcp_to_plumbing(porcelain):
    plumbing = ClickHouseTCP()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.tls_required = (porcelain.tls_required)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_click_house_tcp_to_plumbing(porcelains):
    return [
        convert_click_house_tcp_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_click_house_tcp_to_porcelain(plumbings):
    return [
        convert_click_house_tcp_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_clustrix_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Clustrix()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.require_native_auth = (plumbing.require_native_auth)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.use_azure_single_server_usernames = (
        plumbing.use_azure_single_server_usernames)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_clustrix_to_plumbing(porcelain):
    plumbing = Clustrix()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.require_native_auth = (porcelain.require_native_auth)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.use_azure_single_server_usernames = (
        porcelain.use_azure_single_server_usernames)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_clustrix_to_plumbing(porcelains):
    return [
        convert_clustrix_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_clustrix_to_porcelain(plumbings):
    return [convert_clustrix_to_porcelain(plumbing) for plumbing in plumbings]


def convert_cockroach_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Cockroach()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.override_database = (plumbing.override_database)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_cockroach_to_plumbing(porcelain):
    plumbing = Cockroach()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.override_database = (porcelain.override_database)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_cockroach_to_plumbing(porcelains):
    return [
        convert_cockroach_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_cockroach_to_porcelain(plumbings):
    return [convert_cockroach_to_porcelain(plumbing) for plumbing in plumbings]


def convert_control_panel_get_rdpca_public_key_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ControlPanelGetRDPCAPublicKeyResponse()
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.public_key = (plumbing.public_key)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_control_panel_get_rdpca_public_key_response_to_plumbing(porcelain):
    plumbing = ControlPanelGetRDPCAPublicKeyResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_get_response_metadata_to_plumbing(porcelain.meta))
    plumbing.public_key = (porcelain.public_key)
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_control_panel_get_rdpca_public_key_response_to_plumbing(
        porcelains):
    return [
        convert_control_panel_get_rdpca_public_key_response_to_plumbing(
            porcelain) for porcelain in porcelains
    ]


def convert_repeated_control_panel_get_rdpca_public_key_response_to_porcelain(
        plumbings):
    return [
        convert_control_panel_get_rdpca_public_key_response_to_porcelain(
            plumbing) for plumbing in plumbings
    ]


def convert_control_panel_get_sshca_public_key_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ControlPanelGetSSHCAPublicKeyResponse()
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.public_key = (plumbing.public_key)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_control_panel_get_sshca_public_key_response_to_plumbing(porcelain):
    plumbing = ControlPanelGetSSHCAPublicKeyResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_get_response_metadata_to_plumbing(porcelain.meta))
    plumbing.public_key = (porcelain.public_key)
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_control_panel_get_sshca_public_key_response_to_plumbing(
        porcelains):
    return [
        convert_control_panel_get_sshca_public_key_response_to_plumbing(
            porcelain) for porcelain in porcelains
    ]


def convert_repeated_control_panel_get_sshca_public_key_response_to_porcelain(
        plumbings):
    return [
        convert_control_panel_get_sshca_public_key_response_to_porcelain(
            plumbing) for plumbing in plumbings
    ]


def convert_control_panel_verify_jwt_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ControlPanelVerifyJWTResponse()
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.valid = (plumbing.valid)
    return porcelain


def convert_control_panel_verify_jwt_response_to_plumbing(porcelain):
    plumbing = ControlPanelVerifyJWTResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_get_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    plumbing.valid = (porcelain.valid)
    return plumbing


def convert_repeated_control_panel_verify_jwt_response_to_plumbing(porcelains):
    return [
        convert_control_panel_verify_jwt_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_control_panel_verify_jwt_response_to_porcelain(plumbings):
    return [
        convert_control_panel_verify_jwt_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_couchbase_database_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.CouchbaseDatabase()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.n1ql_port = (plumbing.n1ql_port)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tls_required = (plumbing.tls_required)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_couchbase_database_to_plumbing(porcelain):
    plumbing = CouchbaseDatabase()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.n1ql_port = (porcelain.n1ql_port)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.tls_required = (porcelain.tls_required)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_couchbase_database_to_plumbing(porcelains):
    return [
        convert_couchbase_database_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_couchbase_database_to_porcelain(plumbings):
    return [
        convert_couchbase_database_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_couchbase_web_ui_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.CouchbaseWebUI()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.url = (plumbing.url)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_couchbase_web_ui_to_plumbing(porcelain):
    plumbing = CouchbaseWebUI()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.url = (porcelain.url)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_couchbase_web_ui_to_plumbing(porcelains):
    return [
        convert_couchbase_web_ui_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_couchbase_web_ui_to_porcelain(plumbings):
    return [
        convert_couchbase_web_ui_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_create_response_metadata_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.CreateResponseMetadata()
    return porcelain


def convert_create_response_metadata_to_plumbing(porcelain):
    plumbing = CreateResponseMetadata()
    if porcelain is None:
        return plumbing
    return plumbing


def convert_repeated_create_response_metadata_to_plumbing(porcelains):
    return [
        convert_create_response_metadata_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_create_response_metadata_to_porcelain(plumbings):
    return [
        convert_create_response_metadata_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_cyberark_conjur_store_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.CyberarkConjurStore()
    porcelain.appurl = (plumbing.appURL)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_cyberark_conjur_store_to_plumbing(porcelain):
    plumbing = CyberarkConjurStore()
    if porcelain is None:
        return plumbing
    plumbing.appURL = (porcelain.appurl)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_cyberark_conjur_store_to_plumbing(porcelains):
    return [
        convert_cyberark_conjur_store_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_cyberark_conjur_store_to_porcelain(plumbings):
    return [
        convert_cyberark_conjur_store_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_cyberark_pam_experimental_store_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.CyberarkPAMExperimentalStore()
    porcelain.appurl = (plumbing.appURL)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_cyberark_pam_experimental_store_to_plumbing(porcelain):
    plumbing = CyberarkPAMExperimentalStore()
    if porcelain is None:
        return plumbing
    plumbing.appURL = (porcelain.appurl)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_cyberark_pam_experimental_store_to_plumbing(porcelains):
    return [
        convert_cyberark_pam_experimental_store_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_cyberark_pam_experimental_store_to_porcelain(plumbings):
    return [
        convert_cyberark_pam_experimental_store_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_cyberark_pam_store_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.CyberarkPAMStore()
    porcelain.appurl = (plumbing.appURL)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_cyberark_pam_store_to_plumbing(porcelain):
    plumbing = CyberarkPAMStore()
    if porcelain is None:
        return plumbing
    plumbing.appURL = (porcelain.appurl)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_cyberark_pam_store_to_plumbing(porcelains):
    return [
        convert_cyberark_pam_store_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_cyberark_pam_store_to_porcelain(plumbings):
    return [
        convert_cyberark_pam_store_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_db_2_i_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.DB2I()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tls_required = (plumbing.tls_required)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_db_2_i_to_plumbing(porcelain):
    plumbing = DB2I()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.tls_required = (porcelain.tls_required)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_db_2_i_to_plumbing(porcelains):
    return [convert_db_2_i_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_db_2_i_to_porcelain(plumbings):
    return [convert_db_2_i_to_porcelain(plumbing) for plumbing in plumbings]


def convert_db_2_luw_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.DB2LUW()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_db_2_luw_to_plumbing(porcelain):
    plumbing = DB2LUW()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_db_2_luw_to_plumbing(porcelains):
    return [
        convert_db_2_luw_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_db_2_luw_to_porcelain(plumbings):
    return [convert_db_2_luw_to_porcelain(plumbing) for plumbing in plumbings]


def convert_delete_response_metadata_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.DeleteResponseMetadata()
    return porcelain


def convert_delete_response_metadata_to_plumbing(porcelain):
    plumbing = DeleteResponseMetadata()
    if porcelain is None:
        return plumbing
    return plumbing


def convert_repeated_delete_response_metadata_to_plumbing(porcelains):
    return [
        convert_delete_response_metadata_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_delete_response_metadata_to_porcelain(plumbings):
    return [
        convert_delete_response_metadata_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_delinea_store_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.DelineaStore()
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.server_url = (plumbing.server_url)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tenant_name = (plumbing.tenant_name)
    return porcelain


def convert_delinea_store_to_plumbing(porcelain):
    plumbing = DelineaStore()
    if porcelain is None:
        return plumbing
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.server_url = (porcelain.server_url)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.tenant_name = (porcelain.tenant_name)
    return plumbing


def convert_repeated_delinea_store_to_plumbing(porcelains):
    return [
        convert_delinea_store_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_delinea_store_to_porcelain(plumbings):
    return [
        convert_delinea_store_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_document_db_host_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.DocumentDBHost()
    porcelain.auth_database = (plumbing.auth_database)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_document_db_host_to_plumbing(porcelain):
    plumbing = DocumentDBHost()
    if porcelain is None:
        return plumbing
    plumbing.auth_database = (porcelain.auth_database)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_document_db_host_to_plumbing(porcelains):
    return [
        convert_document_db_host_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_document_db_host_to_porcelain(plumbings):
    return [
        convert_document_db_host_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_document_db_host_iam_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.DocumentDBHostIAM()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.region = (plumbing.region)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_document_db_host_iam_to_plumbing(porcelain):
    plumbing = DocumentDBHostIAM()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.region = (porcelain.region)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_document_db_host_iam_to_plumbing(porcelains):
    return [
        convert_document_db_host_iam_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_document_db_host_iam_to_porcelain(plumbings):
    return [
        convert_document_db_host_iam_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_document_db_replica_set_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.DocumentDBReplicaSet()
    porcelain.auth_database = (plumbing.auth_database)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.connect_to_replica = (plumbing.connect_to_replica)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.replica_set = (plumbing.replica_set)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_document_db_replica_set_to_plumbing(porcelain):
    plumbing = DocumentDBReplicaSet()
    if porcelain is None:
        return plumbing
    plumbing.auth_database = (porcelain.auth_database)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.connect_to_replica = (porcelain.connect_to_replica)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.replica_set = (porcelain.replica_set)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_document_db_replica_set_to_plumbing(porcelains):
    return [
        convert_document_db_replica_set_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_document_db_replica_set_to_porcelain(plumbings):
    return [
        convert_document_db_replica_set_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_document_db_replica_set_iam_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.DocumentDBReplicaSetIAM()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.connect_to_replica = (plumbing.connect_to_replica)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.region = (plumbing.region)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_document_db_replica_set_iam_to_plumbing(porcelain):
    plumbing = DocumentDBReplicaSetIAM()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.connect_to_replica = (porcelain.connect_to_replica)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.region = (porcelain.region)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_document_db_replica_set_iam_to_plumbing(porcelains):
    return [
        convert_document_db_replica_set_iam_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_document_db_replica_set_iam_to_porcelain(plumbings):
    return [
        convert_document_db_replica_set_iam_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_druid_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Druid()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_druid_to_plumbing(porcelain):
    plumbing = Druid()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_druid_to_plumbing(porcelains):
    return [convert_druid_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_druid_to_porcelain(plumbings):
    return [convert_druid_to_porcelain(plumbing) for plumbing in plumbings]


def convert_dynamo_db_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.DynamoDB()
    porcelain.access_key = (plumbing.access_key)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.endpoint = (plumbing.endpoint)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.region = (plumbing.region)
    porcelain.role_arn = (plumbing.role_arn)
    porcelain.role_external_id = (plumbing.role_external_id)
    porcelain.secret_access_key = (plumbing.secret_access_key)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_dynamo_db_to_plumbing(porcelain):
    plumbing = DynamoDB()
    if porcelain is None:
        return plumbing
    plumbing.access_key = (porcelain.access_key)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.endpoint = (porcelain.endpoint)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.region = (porcelain.region)
    plumbing.role_arn = (porcelain.role_arn)
    plumbing.role_external_id = (porcelain.role_external_id)
    plumbing.secret_access_key = (porcelain.secret_access_key)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_dynamo_db_to_plumbing(porcelains):
    return [
        convert_dynamo_db_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_dynamo_db_to_porcelain(plumbings):
    return [convert_dynamo_db_to_porcelain(plumbing) for plumbing in plumbings]


def convert_dynamo_dbiam_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.DynamoDBIAM()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.endpoint = (plumbing.endpoint)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.region = (plumbing.region)
    porcelain.role_arn = (plumbing.role_arn)
    porcelain.role_external_id = (plumbing.role_external_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_dynamo_dbiam_to_plumbing(porcelain):
    plumbing = DynamoDBIAM()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.endpoint = (porcelain.endpoint)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.region = (porcelain.region)
    plumbing.role_arn = (porcelain.role_arn)
    plumbing.role_external_id = (porcelain.role_external_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_dynamo_dbiam_to_plumbing(porcelains):
    return [
        convert_dynamo_dbiam_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_dynamo_dbiam_to_porcelain(plumbings):
    return [
        convert_dynamo_dbiam_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_elastic_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Elastic()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tls_required = (plumbing.tls_required)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_elastic_to_plumbing(porcelain):
    plumbing = Elastic()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.tls_required = (porcelain.tls_required)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_elastic_to_plumbing(porcelains):
    return [convert_elastic_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_elastic_to_porcelain(plumbings):
    return [convert_elastic_to_porcelain(plumbing) for plumbing in plumbings]


def convert_elasticache_redis_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ElasticacheRedis()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tls_required = (plumbing.tls_required)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_elasticache_redis_to_plumbing(porcelain):
    plumbing = ElasticacheRedis()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.tls_required = (porcelain.tls_required)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_elasticache_redis_to_plumbing(porcelains):
    return [
        convert_elasticache_redis_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_elasticache_redis_to_porcelain(plumbings):
    return [
        convert_elasticache_redis_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_gcp_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.GCP()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.keyfile = (plumbing.keyfile)
    porcelain.name = (plumbing.name)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.scopes = (plumbing.scopes)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_gcp_to_plumbing(porcelain):
    plumbing = GCP()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.keyfile = (porcelain.keyfile)
    plumbing.name = (porcelain.name)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.scopes = (porcelain.scopes)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_gcp_to_plumbing(porcelains):
    return [convert_gcp_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_gcp_to_porcelain(plumbings):
    return [convert_gcp_to_porcelain(plumbing) for plumbing in plumbings]


def convert_gcp_cert_x_509_store_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.GCPCertX509Store()
    porcelain.caid = (plumbing.caID)
    porcelain.capoolid = (plumbing.caPoolID)
    porcelain.id = (plumbing.id)
    porcelain.issuedcertttlminutes = (plumbing.issuedCertTTLMinutes)
    porcelain.location = (plumbing.location)
    porcelain.name = (plumbing.name)
    porcelain.projectid = (plumbing.projectID)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_gcp_cert_x_509_store_to_plumbing(porcelain):
    plumbing = GCPCertX509Store()
    if porcelain is None:
        return plumbing
    plumbing.caID = (porcelain.caid)
    plumbing.caPoolID = (porcelain.capoolid)
    plumbing.id = (porcelain.id)
    plumbing.issuedCertTTLMinutes = (porcelain.issuedcertttlminutes)
    plumbing.location = (porcelain.location)
    plumbing.name = (porcelain.name)
    plumbing.projectID = (porcelain.projectid)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_gcp_cert_x_509_store_to_plumbing(porcelains):
    return [
        convert_gcp_cert_x_509_store_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_gcp_cert_x_509_store_to_porcelain(plumbings):
    return [
        convert_gcp_cert_x_509_store_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_gcp_console_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.GCPConsole()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.identity_alias_healthcheck_username = (
        plumbing.identity_alias_healthcheck_username)
    porcelain.identity_set_id = (plumbing.identity_set_id)
    porcelain.name = (plumbing.name)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.session_expiry = (plumbing.session_expiry)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.workforce_pool_id = (plumbing.workforce_pool_id)
    porcelain.workforce_provider_id = (plumbing.workforce_provider_id)
    return porcelain


def convert_gcp_console_to_plumbing(porcelain):
    plumbing = GCPConsole()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.identity_alias_healthcheck_username = (
        porcelain.identity_alias_healthcheck_username)
    plumbing.identity_set_id = (porcelain.identity_set_id)
    plumbing.name = (porcelain.name)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.session_expiry = (porcelain.session_expiry)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.workforce_pool_id = (porcelain.workforce_pool_id)
    plumbing.workforce_provider_id = (porcelain.workforce_provider_id)
    return plumbing


def convert_repeated_gcp_console_to_plumbing(porcelains):
    return [
        convert_gcp_console_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_gcp_console_to_porcelain(plumbings):
    return [
        convert_gcp_console_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_gcp_store_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.GCPStore()
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.projectid = (plumbing.projectID)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_gcp_store_to_plumbing(porcelain):
    plumbing = GCPStore()
    if porcelain is None:
        return plumbing
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.projectID = (porcelain.projectid)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_gcp_store_to_plumbing(porcelains):
    return [
        convert_gcp_store_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_gcp_store_to_porcelain(plumbings):
    return [convert_gcp_store_to_porcelain(plumbing) for plumbing in plumbings]


def convert_gcpwif_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.GCPWIF()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.identity_alias_healthcheck_username = (
        plumbing.identity_alias_healthcheck_username)
    porcelain.identity_set_id = (plumbing.identity_set_id)
    porcelain.name = (plumbing.name)
    porcelain.port_override = (plumbing.port_override)
    porcelain.project_id = (plumbing.project_id)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.scopes = (plumbing.scopes)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.session_expiry = (plumbing.session_expiry)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.workforce_pool_id = (plumbing.workforce_pool_id)
    porcelain.workforce_provider_id = (plumbing.workforce_provider_id)
    return porcelain


def convert_gcpwif_to_plumbing(porcelain):
    plumbing = GCPWIF()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.identity_alias_healthcheck_username = (
        porcelain.identity_alias_healthcheck_username)
    plumbing.identity_set_id = (porcelain.identity_set_id)
    plumbing.name = (porcelain.name)
    plumbing.port_override = (porcelain.port_override)
    plumbing.project_id = (porcelain.project_id)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.scopes = (porcelain.scopes)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.session_expiry = (porcelain.session_expiry)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.workforce_pool_id = (porcelain.workforce_pool_id)
    plumbing.workforce_provider_id = (porcelain.workforce_provider_id)
    return plumbing


def convert_repeated_gcpwif_to_plumbing(porcelains):
    return [convert_gcpwif_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_gcpwif_to_porcelain(plumbings):
    return [convert_gcpwif_to_porcelain(plumbing) for plumbing in plumbings]


def convert_gateway_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Gateway()
    porcelain.bind_address = (plumbing.bind_address)
    porcelain.device = (plumbing.device)
    porcelain.gateway_filter = (plumbing.gateway_filter)
    porcelain.id = (plumbing.id)
    porcelain.listen_address = (plumbing.listen_address)
    porcelain.location = (plumbing.location)
    porcelain.maintenance_windows = convert_repeated_node_maintenance_window_to_porcelain(
        plumbing.maintenance_windows)
    porcelain.name = (plumbing.name)
    porcelain.state = (plumbing.state)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.version = (plumbing.version)
    return porcelain


def convert_gateway_to_plumbing(porcelain):
    plumbing = Gateway()
    if porcelain is None:
        return plumbing
    plumbing.bind_address = (porcelain.bind_address)
    plumbing.device = (porcelain.device)
    plumbing.gateway_filter = (porcelain.gateway_filter)
    plumbing.id = (porcelain.id)
    plumbing.listen_address = (porcelain.listen_address)
    plumbing.location = (porcelain.location)
    del plumbing.maintenance_windows[:]
    plumbing.maintenance_windows.extend(
        convert_repeated_node_maintenance_window_to_plumbing(
            porcelain.maintenance_windows))
    plumbing.name = (porcelain.name)
    plumbing.state = (porcelain.state)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.version = (porcelain.version)
    return plumbing


def convert_repeated_gateway_to_plumbing(porcelains):
    return [convert_gateway_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_gateway_to_porcelain(plumbings):
    return [convert_gateway_to_porcelain(plumbing) for plumbing in plumbings]


def convert_generate_keys_request_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.GenerateKeysRequest()
    porcelain.secret_engine_id = (plumbing.secret_engine_id)
    return porcelain


def convert_generate_keys_request_to_plumbing(porcelain):
    plumbing = GenerateKeysRequest()
    if porcelain is None:
        return plumbing
    plumbing.secret_engine_id = (porcelain.secret_engine_id)
    return plumbing


def convert_repeated_generate_keys_request_to_plumbing(porcelains):
    return [
        convert_generate_keys_request_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_generate_keys_request_to_porcelain(plumbings):
    return [
        convert_generate_keys_request_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_generate_keys_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.GenerateKeysResponse()
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_generate_keys_response_to_plumbing(porcelain):
    plumbing = GenerateKeysResponse()
    if porcelain is None:
        return plumbing
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_generate_keys_response_to_plumbing(porcelains):
    return [
        convert_generate_keys_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_generate_keys_response_to_porcelain(plumbings):
    return [
        convert_generate_keys_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_generic_response_metadata_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.GenericResponseMetadata()
    return porcelain


def convert_generic_response_metadata_to_plumbing(porcelain):
    plumbing = GenericResponseMetadata()
    if porcelain is None:
        return plumbing
    return plumbing


def convert_repeated_generic_response_metadata_to_plumbing(porcelains):
    return [
        convert_generic_response_metadata_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_generic_response_metadata_to_porcelain(plumbings):
    return [
        convert_generic_response_metadata_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_get_response_metadata_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.GetResponseMetadata()
    return porcelain


def convert_get_response_metadata_to_plumbing(porcelain):
    plumbing = GetResponseMetadata()
    if porcelain is None:
        return plumbing
    return plumbing


def convert_repeated_get_response_metadata_to_plumbing(porcelains):
    return [
        convert_get_response_metadata_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_get_response_metadata_to_porcelain(plumbings):
    return [
        convert_get_response_metadata_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_google_gke_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.GoogleGKE()
    porcelain.allow_resource_role_bypass = (
        plumbing.allow_resource_role_bypass)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.certificate_authority = (plumbing.certificate_authority)
    porcelain.discovery_enabled = (plumbing.discovery_enabled)
    porcelain.discovery_username = (plumbing.discovery_username)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.endpoint = (plumbing.endpoint)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.identity_alias_healthcheck_username = (
        plumbing.identity_alias_healthcheck_username)
    porcelain.identity_set_id = (plumbing.identity_set_id)
    porcelain.name = (plumbing.name)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.service_account_key = (plumbing.service_account_key)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_google_gke_to_plumbing(porcelain):
    plumbing = GoogleGKE()
    if porcelain is None:
        return plumbing
    plumbing.allow_resource_role_bypass = (
        porcelain.allow_resource_role_bypass)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.certificate_authority = (porcelain.certificate_authority)
    plumbing.discovery_enabled = (porcelain.discovery_enabled)
    plumbing.discovery_username = (porcelain.discovery_username)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.endpoint = (porcelain.endpoint)
    plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.identity_alias_healthcheck_username = (
        porcelain.identity_alias_healthcheck_username)
    plumbing.identity_set_id = (porcelain.identity_set_id)
    plumbing.name = (porcelain.name)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.service_account_key = (porcelain.service_account_key)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_google_gke_to_plumbing(porcelains):
    return [
        convert_google_gke_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_google_gke_to_porcelain(plumbings):
    return [
        convert_google_gke_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_google_gke_user_impersonation_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.GoogleGKEUserImpersonation()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.certificate_authority = (plumbing.certificate_authority)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.endpoint = (plumbing.endpoint)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.service_account_key = (plumbing.service_account_key)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_google_gke_user_impersonation_to_plumbing(porcelain):
    plumbing = GoogleGKEUserImpersonation()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.certificate_authority = (porcelain.certificate_authority)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.endpoint = (porcelain.endpoint)
    plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.service_account_key = (porcelain.service_account_key)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_google_gke_user_impersonation_to_plumbing(porcelains):
    return [
        convert_google_gke_user_impersonation_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_google_gke_user_impersonation_to_porcelain(plumbings):
    return [
        convert_google_gke_user_impersonation_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_greenplum_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Greenplum()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.override_database = (plumbing.override_database)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_greenplum_to_plumbing(porcelain):
    plumbing = Greenplum()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.override_database = (porcelain.override_database)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_greenplum_to_plumbing(porcelains):
    return [
        convert_greenplum_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_greenplum_to_porcelain(plumbings):
    return [convert_greenplum_to_porcelain(plumbing) for plumbing in plumbings]


def convert_http_auth_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.HTTPAuth()
    porcelain.auth_header = (plumbing.auth_header)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.default_path = (plumbing.default_path)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.headers_blacklist = (plumbing.headers_blacklist)
    porcelain.healthcheck_path = (plumbing.healthcheck_path)
    porcelain.healthy = (plumbing.healthy)
    porcelain.host_override = (plumbing.host_override)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.url = (plumbing.url)
    return porcelain


def convert_http_auth_to_plumbing(porcelain):
    plumbing = HTTPAuth()
    if porcelain is None:
        return plumbing
    plumbing.auth_header = (porcelain.auth_header)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.default_path = (porcelain.default_path)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.headers_blacklist = (porcelain.headers_blacklist)
    plumbing.healthcheck_path = (porcelain.healthcheck_path)
    plumbing.healthy = (porcelain.healthy)
    plumbing.host_override = (porcelain.host_override)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.url = (porcelain.url)
    return plumbing


def convert_repeated_http_auth_to_plumbing(porcelains):
    return [
        convert_http_auth_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_http_auth_to_porcelain(plumbings):
    return [convert_http_auth_to_porcelain(plumbing) for plumbing in plumbings]


def convert_http_basic_auth_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.HTTPBasicAuth()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.default_path = (plumbing.default_path)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.headers_blacklist = (plumbing.headers_blacklist)
    porcelain.healthcheck_path = (plumbing.healthcheck_path)
    porcelain.healthy = (plumbing.healthy)
    porcelain.host_override = (plumbing.host_override)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.url = (plumbing.url)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_http_basic_auth_to_plumbing(porcelain):
    plumbing = HTTPBasicAuth()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.default_path = (porcelain.default_path)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.headers_blacklist = (porcelain.headers_blacklist)
    plumbing.healthcheck_path = (porcelain.healthcheck_path)
    plumbing.healthy = (porcelain.healthy)
    plumbing.host_override = (porcelain.host_override)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.url = (porcelain.url)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_http_basic_auth_to_plumbing(porcelains):
    return [
        convert_http_basic_auth_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_http_basic_auth_to_porcelain(plumbings):
    return [
        convert_http_basic_auth_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_http_no_auth_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.HTTPNoAuth()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.default_path = (plumbing.default_path)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.headers_blacklist = (plumbing.headers_blacklist)
    porcelain.healthcheck_path = (plumbing.healthcheck_path)
    porcelain.healthy = (plumbing.healthy)
    porcelain.host_override = (plumbing.host_override)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.url = (plumbing.url)
    return porcelain


def convert_http_no_auth_to_plumbing(porcelain):
    plumbing = HTTPNoAuth()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.default_path = (porcelain.default_path)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.headers_blacklist = (porcelain.headers_blacklist)
    plumbing.healthcheck_path = (porcelain.healthcheck_path)
    plumbing.healthy = (porcelain.healthy)
    plumbing.host_override = (porcelain.host_override)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.url = (porcelain.url)
    return plumbing


def convert_repeated_http_no_auth_to_plumbing(porcelains):
    return [
        convert_http_no_auth_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_http_no_auth_to_porcelain(plumbings):
    return [
        convert_http_no_auth_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_healthcheck_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Healthcheck()
    porcelain.error_msg = (plumbing.error_msg)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.node_id = (plumbing.node_id)
    porcelain.node_name = (plumbing.node_name)
    porcelain.resource_id = (plumbing.resource_id)
    porcelain.resource_name = (plumbing.resource_name)
    porcelain.timestamp = convert_timestamp_to_porcelain(plumbing.timestamp)
    return porcelain


def convert_healthcheck_to_plumbing(porcelain):
    plumbing = Healthcheck()
    if porcelain is None:
        return plumbing
    plumbing.error_msg = (porcelain.error_msg)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.node_id = (porcelain.node_id)
    plumbing.node_name = (porcelain.node_name)
    plumbing.resource_id = (porcelain.resource_id)
    plumbing.resource_name = (porcelain.resource_name)
    plumbing.timestamp.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.timestamp))
    return plumbing


def convert_repeated_healthcheck_to_plumbing(porcelains):
    return [
        convert_healthcheck_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_healthcheck_to_porcelain(plumbings):
    return [
        convert_healthcheck_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_healthcheck_list_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.HealthcheckListResponse()
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_healthcheck_list_response_to_plumbing(porcelain):
    plumbing = HealthcheckListResponse()
    if porcelain is None:
        return plumbing
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_healthcheck_list_response_to_plumbing(porcelains):
    return [
        convert_healthcheck_list_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_healthcheck_list_response_to_porcelain(plumbings):
    return [
        convert_healthcheck_list_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_healthcheck_request_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.HealthcheckRequest()
    porcelain.secret_engine_id = (plumbing.secret_engine_id)
    return porcelain


def convert_healthcheck_request_to_plumbing(porcelain):
    plumbing = HealthcheckRequest()
    if porcelain is None:
        return plumbing
    plumbing.secret_engine_id = (porcelain.secret_engine_id)
    return plumbing


def convert_repeated_healthcheck_request_to_plumbing(porcelains):
    return [
        convert_healthcheck_request_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_healthcheck_request_to_porcelain(plumbings):
    return [
        convert_healthcheck_request_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_healthcheck_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.HealthcheckResponse()
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.status = convert_repeated_healthcheck_status_to_porcelain(
        plumbing.status)
    return porcelain


def convert_healthcheck_response_to_plumbing(porcelain):
    plumbing = HealthcheckResponse()
    if porcelain is None:
        return plumbing
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    del plumbing.status[:]
    plumbing.status.extend(
        convert_repeated_healthcheck_status_to_plumbing(porcelain.status))
    return plumbing


def convert_repeated_healthcheck_response_to_plumbing(porcelains):
    return [
        convert_healthcheck_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_healthcheck_response_to_porcelain(plumbings):
    return [
        convert_healthcheck_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_healthcheck_status_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.HealthcheckStatus()
    porcelain.node_id = (plumbing.node_id)
    porcelain.status = (plumbing.status)
    return porcelain


def convert_healthcheck_status_to_plumbing(porcelain):
    plumbing = HealthcheckStatus()
    if porcelain is None:
        return plumbing
    plumbing.node_id = (porcelain.node_id)
    plumbing.status = (porcelain.status)
    return plumbing


def convert_repeated_healthcheck_status_to_plumbing(porcelains):
    return [
        convert_healthcheck_status_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_healthcheck_status_to_porcelain(plumbings):
    return [
        convert_healthcheck_status_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_identity_alias_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.IdentityAlias()
    porcelain.account_id = (plumbing.account_id)
    porcelain.id = (plumbing.id)
    porcelain.identity_set_id = (plumbing.identity_set_id)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_identity_alias_to_plumbing(porcelain):
    plumbing = IdentityAlias()
    if porcelain is None:
        return plumbing
    plumbing.account_id = (porcelain.account_id)
    plumbing.id = (porcelain.id)
    plumbing.identity_set_id = (porcelain.identity_set_id)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_identity_alias_to_plumbing(porcelains):
    return [
        convert_identity_alias_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_identity_alias_to_porcelain(plumbings):
    return [
        convert_identity_alias_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_identity_alias_create_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.IdentityAliasCreateResponse()
    porcelain.identity_alias = convert_identity_alias_to_porcelain(
        plumbing.identity_alias)
    porcelain.meta = convert_create_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_identity_alias_create_response_to_plumbing(porcelain):
    plumbing = IdentityAliasCreateResponse()
    if porcelain is None:
        return plumbing
    plumbing.identity_alias.CopyFrom(
        convert_identity_alias_to_plumbing(porcelain.identity_alias))
    plumbing.meta.CopyFrom(
        convert_create_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_identity_alias_create_response_to_plumbing(porcelains):
    return [
        convert_identity_alias_create_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_identity_alias_create_response_to_porcelain(plumbings):
    return [
        convert_identity_alias_create_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_identity_alias_delete_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.IdentityAliasDeleteResponse()
    porcelain.meta = convert_delete_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_identity_alias_delete_response_to_plumbing(porcelain):
    plumbing = IdentityAliasDeleteResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_delete_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_identity_alias_delete_response_to_plumbing(porcelains):
    return [
        convert_identity_alias_delete_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_identity_alias_delete_response_to_porcelain(plumbings):
    return [
        convert_identity_alias_delete_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_identity_alias_get_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.IdentityAliasGetResponse()
    porcelain.identity_alias = convert_identity_alias_to_porcelain(
        plumbing.identity_alias)
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_identity_alias_get_response_to_plumbing(porcelain):
    plumbing = IdentityAliasGetResponse()
    if porcelain is None:
        return plumbing
    plumbing.identity_alias.CopyFrom(
        convert_identity_alias_to_plumbing(porcelain.identity_alias))
    plumbing.meta.CopyFrom(
        convert_get_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_identity_alias_get_response_to_plumbing(porcelains):
    return [
        convert_identity_alias_get_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_identity_alias_get_response_to_porcelain(plumbings):
    return [
        convert_identity_alias_get_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_identity_alias_history_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.IdentityAliasHistory()
    porcelain.activity_id = (plumbing.activity_id)
    porcelain.deleted_at = convert_timestamp_to_porcelain(plumbing.deleted_at)
    porcelain.identity_alias = convert_identity_alias_to_porcelain(
        plumbing.identity_alias)
    porcelain.timestamp = convert_timestamp_to_porcelain(plumbing.timestamp)
    return porcelain


def convert_identity_alias_history_to_plumbing(porcelain):
    plumbing = IdentityAliasHistory()
    if porcelain is None:
        return plumbing
    plumbing.activity_id = (porcelain.activity_id)
    plumbing.deleted_at.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.deleted_at))
    plumbing.identity_alias.CopyFrom(
        convert_identity_alias_to_plumbing(porcelain.identity_alias))
    plumbing.timestamp.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.timestamp))
    return plumbing


def convert_repeated_identity_alias_history_to_plumbing(porcelains):
    return [
        convert_identity_alias_history_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_identity_alias_history_to_porcelain(plumbings):
    return [
        convert_identity_alias_history_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_identity_alias_update_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.IdentityAliasUpdateResponse()
    porcelain.identity_alias = convert_identity_alias_to_porcelain(
        plumbing.identity_alias)
    porcelain.meta = convert_update_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_identity_alias_update_response_to_plumbing(porcelain):
    plumbing = IdentityAliasUpdateResponse()
    if porcelain is None:
        return plumbing
    plumbing.identity_alias.CopyFrom(
        convert_identity_alias_to_plumbing(porcelain.identity_alias))
    plumbing.meta.CopyFrom(
        convert_update_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_identity_alias_update_response_to_plumbing(porcelains):
    return [
        convert_identity_alias_update_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_identity_alias_update_response_to_porcelain(plumbings):
    return [
        convert_identity_alias_update_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_identity_set_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.IdentitySet()
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    return porcelain


def convert_identity_set_to_plumbing(porcelain):
    plumbing = IdentitySet()
    if porcelain is None:
        return plumbing
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    return plumbing


def convert_repeated_identity_set_to_plumbing(porcelains):
    return [
        convert_identity_set_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_identity_set_to_porcelain(plumbings):
    return [
        convert_identity_set_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_identity_set_create_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.IdentitySetCreateResponse()
    porcelain.identity_set = convert_identity_set_to_porcelain(
        plumbing.identity_set)
    porcelain.meta = convert_create_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_identity_set_create_response_to_plumbing(porcelain):
    plumbing = IdentitySetCreateResponse()
    if porcelain is None:
        return plumbing
    plumbing.identity_set.CopyFrom(
        convert_identity_set_to_plumbing(porcelain.identity_set))
    plumbing.meta.CopyFrom(
        convert_create_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_identity_set_create_response_to_plumbing(porcelains):
    return [
        convert_identity_set_create_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_identity_set_create_response_to_porcelain(plumbings):
    return [
        convert_identity_set_create_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_identity_set_delete_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.IdentitySetDeleteResponse()
    porcelain.meta = convert_delete_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_identity_set_delete_response_to_plumbing(porcelain):
    plumbing = IdentitySetDeleteResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_delete_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_identity_set_delete_response_to_plumbing(porcelains):
    return [
        convert_identity_set_delete_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_identity_set_delete_response_to_porcelain(plumbings):
    return [
        convert_identity_set_delete_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_identity_set_get_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.IdentitySetGetResponse()
    porcelain.identity_set = convert_identity_set_to_porcelain(
        plumbing.identity_set)
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_identity_set_get_response_to_plumbing(porcelain):
    plumbing = IdentitySetGetResponse()
    if porcelain is None:
        return plumbing
    plumbing.identity_set.CopyFrom(
        convert_identity_set_to_plumbing(porcelain.identity_set))
    plumbing.meta.CopyFrom(
        convert_get_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_identity_set_get_response_to_plumbing(porcelains):
    return [
        convert_identity_set_get_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_identity_set_get_response_to_porcelain(plumbings):
    return [
        convert_identity_set_get_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_identity_set_history_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.IdentitySetHistory()
    porcelain.activity_id = (plumbing.activity_id)
    porcelain.deleted_at = convert_timestamp_to_porcelain(plumbing.deleted_at)
    porcelain.identity_set = convert_identity_set_to_porcelain(
        plumbing.identity_set)
    porcelain.timestamp = convert_timestamp_to_porcelain(plumbing.timestamp)
    return porcelain


def convert_identity_set_history_to_plumbing(porcelain):
    plumbing = IdentitySetHistory()
    if porcelain is None:
        return plumbing
    plumbing.activity_id = (porcelain.activity_id)
    plumbing.deleted_at.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.deleted_at))
    plumbing.identity_set.CopyFrom(
        convert_identity_set_to_plumbing(porcelain.identity_set))
    plumbing.timestamp.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.timestamp))
    return plumbing


def convert_repeated_identity_set_history_to_plumbing(porcelains):
    return [
        convert_identity_set_history_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_identity_set_history_to_porcelain(plumbings):
    return [
        convert_identity_set_history_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_identity_set_update_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.IdentitySetUpdateResponse()
    porcelain.identity_set = convert_identity_set_to_porcelain(
        plumbing.identity_set)
    porcelain.meta = convert_update_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_identity_set_update_response_to_plumbing(porcelain):
    plumbing = IdentitySetUpdateResponse()
    if porcelain is None:
        return plumbing
    plumbing.identity_set.CopyFrom(
        convert_identity_set_to_plumbing(porcelain.identity_set))
    plumbing.meta.CopyFrom(
        convert_update_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_identity_set_update_response_to_plumbing(porcelains):
    return [
        convert_identity_set_update_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_identity_set_update_response_to_porcelain(plumbings):
    return [
        convert_identity_set_update_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_key_value_engine_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.KeyValueEngine()
    porcelain.id = (plumbing.id)
    porcelain.key_rotation_interval_days = (
        plumbing.key_rotation_interval_days)
    porcelain.name = (plumbing.name)
    porcelain.public_key = (plumbing.public_key)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.secret_store_root_path = (plumbing.secret_store_root_path)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_key_value_engine_to_plumbing(porcelain):
    plumbing = KeyValueEngine()
    if porcelain is None:
        return plumbing
    plumbing.id = (porcelain.id)
    plumbing.key_rotation_interval_days = (
        porcelain.key_rotation_interval_days)
    plumbing.name = (porcelain.name)
    plumbing.public_key = (porcelain.public_key)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.secret_store_root_path = (porcelain.secret_store_root_path)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_key_value_engine_to_plumbing(porcelains):
    return [
        convert_key_value_engine_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_key_value_engine_to_porcelain(plumbings):
    return [
        convert_key_value_engine_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_keyfactor_ssh_store_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.KeyfactorSSHStore()
    porcelain.ca_file_path = (plumbing.ca_file_path)
    porcelain.certificate_file_path = (plumbing.certificate_file_path)
    porcelain.default_certificate_authority_name = (
        plumbing.default_certificate_authority_name)
    porcelain.default_certificate_profile_name = (
        plumbing.default_certificate_profile_name)
    porcelain.default_end_entity_profile_name = (
        plumbing.default_end_entity_profile_name)
    porcelain.enrollment_code_env_var = (plumbing.enrollment_code_env_var)
    porcelain.enrollment_username_env_var = (
        plumbing.enrollment_username_env_var)
    porcelain.id = (plumbing.id)
    porcelain.key_file_path = (plumbing.key_file_path)
    porcelain.name = (plumbing.name)
    porcelain.server_address = (plumbing.server_address)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_keyfactor_ssh_store_to_plumbing(porcelain):
    plumbing = KeyfactorSSHStore()
    if porcelain is None:
        return plumbing
    plumbing.ca_file_path = (porcelain.ca_file_path)
    plumbing.certificate_file_path = (porcelain.certificate_file_path)
    plumbing.default_certificate_authority_name = (
        porcelain.default_certificate_authority_name)
    plumbing.default_certificate_profile_name = (
        porcelain.default_certificate_profile_name)
    plumbing.default_end_entity_profile_name = (
        porcelain.default_end_entity_profile_name)
    plumbing.enrollment_code_env_var = (porcelain.enrollment_code_env_var)
    plumbing.enrollment_username_env_var = (
        porcelain.enrollment_username_env_var)
    plumbing.id = (porcelain.id)
    plumbing.key_file_path = (porcelain.key_file_path)
    plumbing.name = (porcelain.name)
    plumbing.server_address = (porcelain.server_address)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_keyfactor_ssh_store_to_plumbing(porcelains):
    return [
        convert_keyfactor_ssh_store_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_keyfactor_ssh_store_to_porcelain(plumbings):
    return [
        convert_keyfactor_ssh_store_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_keyfactor_x_509_store_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.KeyfactorX509Store()
    porcelain.ca_file_path = (plumbing.ca_file_path)
    porcelain.certificate_file_path = (plumbing.certificate_file_path)
    porcelain.default_certificate_authority_name = (
        plumbing.default_certificate_authority_name)
    porcelain.default_certificate_profile_name = (
        plumbing.default_certificate_profile_name)
    porcelain.default_end_entity_profile_name = (
        plumbing.default_end_entity_profile_name)
    porcelain.enrollment_code_env_var = (plumbing.enrollment_code_env_var)
    porcelain.enrollment_username_env_var = (
        plumbing.enrollment_username_env_var)
    porcelain.id = (plumbing.id)
    porcelain.key_file_path = (plumbing.key_file_path)
    porcelain.name = (plumbing.name)
    porcelain.server_address = (plumbing.server_address)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_keyfactor_x_509_store_to_plumbing(porcelain):
    plumbing = KeyfactorX509Store()
    if porcelain is None:
        return plumbing
    plumbing.ca_file_path = (porcelain.ca_file_path)
    plumbing.certificate_file_path = (porcelain.certificate_file_path)
    plumbing.default_certificate_authority_name = (
        porcelain.default_certificate_authority_name)
    plumbing.default_certificate_profile_name = (
        porcelain.default_certificate_profile_name)
    plumbing.default_end_entity_profile_name = (
        porcelain.default_end_entity_profile_name)
    plumbing.enrollment_code_env_var = (porcelain.enrollment_code_env_var)
    plumbing.enrollment_username_env_var = (
        porcelain.enrollment_username_env_var)
    plumbing.id = (porcelain.id)
    plumbing.key_file_path = (porcelain.key_file_path)
    plumbing.name = (porcelain.name)
    plumbing.server_address = (porcelain.server_address)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_keyfactor_x_509_store_to_plumbing(porcelains):
    return [
        convert_keyfactor_x_509_store_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_keyfactor_x_509_store_to_porcelain(plumbings):
    return [
        convert_keyfactor_x_509_store_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_kubernetes_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Kubernetes()
    porcelain.allow_resource_role_bypass = (
        plumbing.allow_resource_role_bypass)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.certificate_authority = (plumbing.certificate_authority)
    porcelain.client_certificate = (plumbing.client_certificate)
    porcelain.client_key = (plumbing.client_key)
    porcelain.discovery_enabled = (plumbing.discovery_enabled)
    porcelain.discovery_username = (plumbing.discovery_username)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.identity_alias_healthcheck_username = (
        plumbing.identity_alias_healthcheck_username)
    porcelain.identity_set_id = (plumbing.identity_set_id)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_kubernetes_to_plumbing(porcelain):
    plumbing = Kubernetes()
    if porcelain is None:
        return plumbing
    plumbing.allow_resource_role_bypass = (
        porcelain.allow_resource_role_bypass)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.certificate_authority = (porcelain.certificate_authority)
    plumbing.client_certificate = (porcelain.client_certificate)
    plumbing.client_key = (porcelain.client_key)
    plumbing.discovery_enabled = (porcelain.discovery_enabled)
    plumbing.discovery_username = (porcelain.discovery_username)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.identity_alias_healthcheck_username = (
        porcelain.identity_alias_healthcheck_username)
    plumbing.identity_set_id = (porcelain.identity_set_id)
    plumbing.name = (porcelain.name)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_kubernetes_to_plumbing(porcelains):
    return [
        convert_kubernetes_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_kubernetes_to_porcelain(plumbings):
    return [
        convert_kubernetes_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_kubernetes_basic_auth_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.KubernetesBasicAuth()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_kubernetes_basic_auth_to_plumbing(porcelain):
    plumbing = KubernetesBasicAuth()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_kubernetes_basic_auth_to_plumbing(porcelains):
    return [
        convert_kubernetes_basic_auth_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_kubernetes_basic_auth_to_porcelain(plumbings):
    return [
        convert_kubernetes_basic_auth_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_kubernetes_pod_identity_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.KubernetesPodIdentity()
    porcelain.allow_resource_role_bypass = (
        plumbing.allow_resource_role_bypass)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.certificate_authority = (plumbing.certificate_authority)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.identity_alias_healthcheck_username = (
        plumbing.identity_alias_healthcheck_username)
    porcelain.identity_set_id = (plumbing.identity_set_id)
    porcelain.name = (plumbing.name)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_kubernetes_pod_identity_to_plumbing(porcelain):
    plumbing = KubernetesPodIdentity()
    if porcelain is None:
        return plumbing
    plumbing.allow_resource_role_bypass = (
        porcelain.allow_resource_role_bypass)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.certificate_authority = (porcelain.certificate_authority)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.identity_alias_healthcheck_username = (
        porcelain.identity_alias_healthcheck_username)
    plumbing.identity_set_id = (porcelain.identity_set_id)
    plumbing.name = (porcelain.name)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_kubernetes_pod_identity_to_plumbing(porcelains):
    return [
        convert_kubernetes_pod_identity_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_kubernetes_pod_identity_to_porcelain(plumbings):
    return [
        convert_kubernetes_pod_identity_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_kubernetes_service_account_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.KubernetesServiceAccount()
    porcelain.allow_resource_role_bypass = (
        plumbing.allow_resource_role_bypass)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.discovery_enabled = (plumbing.discovery_enabled)
    porcelain.discovery_username = (plumbing.discovery_username)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.identity_alias_healthcheck_username = (
        plumbing.identity_alias_healthcheck_username)
    porcelain.identity_set_id = (plumbing.identity_set_id)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.token = (plumbing.token)
    return porcelain


def convert_kubernetes_service_account_to_plumbing(porcelain):
    plumbing = KubernetesServiceAccount()
    if porcelain is None:
        return plumbing
    plumbing.allow_resource_role_bypass = (
        porcelain.allow_resource_role_bypass)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.discovery_enabled = (porcelain.discovery_enabled)
    plumbing.discovery_username = (porcelain.discovery_username)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.identity_alias_healthcheck_username = (
        porcelain.identity_alias_healthcheck_username)
    plumbing.identity_set_id = (porcelain.identity_set_id)
    plumbing.name = (porcelain.name)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.token = (porcelain.token)
    return plumbing


def convert_repeated_kubernetes_service_account_to_plumbing(porcelains):
    return [
        convert_kubernetes_service_account_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_kubernetes_service_account_to_porcelain(plumbings):
    return [
        convert_kubernetes_service_account_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_kubernetes_service_account_user_impersonation_to_porcelain(
        plumbing):
    if plumbing is None:
        return None
    porcelain = models.KubernetesServiceAccountUserImpersonation()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.token = (plumbing.token)
    return porcelain


def convert_kubernetes_service_account_user_impersonation_to_plumbing(
        porcelain):
    plumbing = KubernetesServiceAccountUserImpersonation()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.token = (porcelain.token)
    return plumbing


def convert_repeated_kubernetes_service_account_user_impersonation_to_plumbing(
        porcelains):
    return [
        convert_kubernetes_service_account_user_impersonation_to_plumbing(
            porcelain) for porcelain in porcelains
    ]


def convert_repeated_kubernetes_service_account_user_impersonation_to_porcelain(
        plumbings):
    return [
        convert_kubernetes_service_account_user_impersonation_to_porcelain(
            plumbing) for plumbing in plumbings
    ]


def convert_kubernetes_user_impersonation_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.KubernetesUserImpersonation()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.certificate_authority = (plumbing.certificate_authority)
    porcelain.client_certificate = (plumbing.client_certificate)
    porcelain.client_key = (plumbing.client_key)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_kubernetes_user_impersonation_to_plumbing(porcelain):
    plumbing = KubernetesUserImpersonation()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.certificate_authority = (porcelain.certificate_authority)
    plumbing.client_certificate = (porcelain.client_certificate)
    plumbing.client_key = (porcelain.client_key)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_kubernetes_user_impersonation_to_plumbing(porcelains):
    return [
        convert_kubernetes_user_impersonation_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_kubernetes_user_impersonation_to_porcelain(plumbings):
    return [
        convert_kubernetes_user_impersonation_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_mtls_mysql_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.MTLSMysql()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.certificate_authority = (plumbing.certificate_authority)
    porcelain.client_certificate = (plumbing.client_certificate)
    porcelain.client_key = (plumbing.client_key)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.require_native_auth = (plumbing.require_native_auth)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.server_name = (plumbing.server_name)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.use_azure_single_server_usernames = (
        plumbing.use_azure_single_server_usernames)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_mtls_mysql_to_plumbing(porcelain):
    plumbing = MTLSMysql()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.certificate_authority = (porcelain.certificate_authority)
    plumbing.client_certificate = (porcelain.client_certificate)
    plumbing.client_key = (porcelain.client_key)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.require_native_auth = (porcelain.require_native_auth)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.server_name = (porcelain.server_name)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.use_azure_single_server_usernames = (
        porcelain.use_azure_single_server_usernames)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_mtls_mysql_to_plumbing(porcelains):
    return [
        convert_mtls_mysql_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_mtls_mysql_to_porcelain(plumbings):
    return [
        convert_mtls_mysql_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_mtls_postgres_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.MTLSPostgres()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.certificate_authority = (plumbing.certificate_authority)
    porcelain.client_certificate = (plumbing.client_certificate)
    porcelain.client_key = (plumbing.client_key)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.override_database = (plumbing.override_database)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.server_name = (plumbing.server_name)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_mtls_postgres_to_plumbing(porcelain):
    plumbing = MTLSPostgres()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.certificate_authority = (porcelain.certificate_authority)
    plumbing.client_certificate = (porcelain.client_certificate)
    plumbing.client_key = (porcelain.client_key)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.override_database = (porcelain.override_database)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.server_name = (porcelain.server_name)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_mtls_postgres_to_plumbing(porcelains):
    return [
        convert_mtls_postgres_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_mtls_postgres_to_porcelain(plumbings):
    return [
        convert_mtls_postgres_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_managed_secret_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ManagedSecret()
    porcelain.config = (plumbing.config)
    porcelain.expires_at = convert_timestamp_to_porcelain(plumbing.expires_at)
    porcelain.id = (plumbing.id)
    porcelain.last_rotated_at = convert_timestamp_to_porcelain(
        plumbing.last_rotated_at)
    porcelain.name = (plumbing.name)
    porcelain.policy = convert_managed_secret_policy_to_porcelain(
        plumbing.policy)
    porcelain.secret_engine_id = (plumbing.secret_engine_id)
    porcelain.secret_store_path = (plumbing.secret_store_path)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.value = (plumbing.value)
    return porcelain


def convert_managed_secret_to_plumbing(porcelain):
    plumbing = ManagedSecret()
    if porcelain is None:
        return plumbing
    plumbing.config = (porcelain.config)
    plumbing.expires_at.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.expires_at))
    plumbing.id = (porcelain.id)
    plumbing.last_rotated_at.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.last_rotated_at))
    plumbing.name = (porcelain.name)
    plumbing.policy.CopyFrom(
        convert_managed_secret_policy_to_plumbing(porcelain.policy))
    plumbing.secret_engine_id = (porcelain.secret_engine_id)
    plumbing.secret_store_path = (porcelain.secret_store_path)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.value = (porcelain.value)
    return plumbing


def convert_repeated_managed_secret_to_plumbing(porcelains):
    return [
        convert_managed_secret_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_managed_secret_to_porcelain(plumbings):
    return [
        convert_managed_secret_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_managed_secret_create_request_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ManagedSecretCreateRequest()
    porcelain.managed_secret = convert_managed_secret_to_porcelain(
        plumbing.managed_secret)
    return porcelain


def convert_managed_secret_create_request_to_plumbing(porcelain):
    plumbing = ManagedSecretCreateRequest()
    if porcelain is None:
        return plumbing
    plumbing.managed_secret.CopyFrom(
        convert_managed_secret_to_plumbing(porcelain.managed_secret))
    return plumbing


def convert_repeated_managed_secret_create_request_to_plumbing(porcelains):
    return [
        convert_managed_secret_create_request_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_managed_secret_create_request_to_porcelain(plumbings):
    return [
        convert_managed_secret_create_request_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_managed_secret_create_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ManagedSecretCreateResponse()
    porcelain.managed_secret = convert_managed_secret_to_porcelain(
        plumbing.managed_secret)
    porcelain.meta = convert_create_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_managed_secret_create_response_to_plumbing(porcelain):
    plumbing = ManagedSecretCreateResponse()
    if porcelain is None:
        return plumbing
    plumbing.managed_secret.CopyFrom(
        convert_managed_secret_to_plumbing(porcelain.managed_secret))
    plumbing.meta.CopyFrom(
        convert_create_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_managed_secret_create_response_to_plumbing(porcelains):
    return [
        convert_managed_secret_create_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_managed_secret_create_response_to_porcelain(plumbings):
    return [
        convert_managed_secret_create_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_managed_secret_delete_request_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ManagedSecretDeleteRequest()
    porcelain.id = (plumbing.id)
    return porcelain


def convert_managed_secret_delete_request_to_plumbing(porcelain):
    plumbing = ManagedSecretDeleteRequest()
    if porcelain is None:
        return plumbing
    plumbing.id = (porcelain.id)
    return plumbing


def convert_repeated_managed_secret_delete_request_to_plumbing(porcelains):
    return [
        convert_managed_secret_delete_request_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_managed_secret_delete_request_to_porcelain(plumbings):
    return [
        convert_managed_secret_delete_request_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_managed_secret_delete_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ManagedSecretDeleteResponse()
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_managed_secret_delete_response_to_plumbing(porcelain):
    plumbing = ManagedSecretDeleteResponse()
    if porcelain is None:
        return plumbing
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_managed_secret_delete_response_to_plumbing(porcelains):
    return [
        convert_managed_secret_delete_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_managed_secret_delete_response_to_porcelain(plumbings):
    return [
        convert_managed_secret_delete_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_managed_secret_get_request_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ManagedSecretGetRequest()
    porcelain.id = (plumbing.id)
    return porcelain


def convert_managed_secret_get_request_to_plumbing(porcelain):
    plumbing = ManagedSecretGetRequest()
    if porcelain is None:
        return plumbing
    plumbing.id = (porcelain.id)
    return plumbing


def convert_repeated_managed_secret_get_request_to_plumbing(porcelains):
    return [
        convert_managed_secret_get_request_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_managed_secret_get_request_to_porcelain(plumbings):
    return [
        convert_managed_secret_get_request_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_managed_secret_get_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ManagedSecretGetResponse()
    porcelain.managed_secret = convert_managed_secret_to_porcelain(
        plumbing.managed_secret)
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_managed_secret_get_response_to_plumbing(porcelain):
    plumbing = ManagedSecretGetResponse()
    if porcelain is None:
        return plumbing
    plumbing.managed_secret.CopyFrom(
        convert_managed_secret_to_plumbing(porcelain.managed_secret))
    plumbing.meta.CopyFrom(
        convert_get_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_managed_secret_get_response_to_plumbing(porcelains):
    return [
        convert_managed_secret_get_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_managed_secret_get_response_to_porcelain(plumbings):
    return [
        convert_managed_secret_get_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_managed_secret_list_request_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ManagedSecretListRequest()
    porcelain.filter = (plumbing.filter)
    return porcelain


def convert_managed_secret_list_request_to_plumbing(porcelain):
    plumbing = ManagedSecretListRequest()
    if porcelain is None:
        return plumbing
    plumbing.filter = (porcelain.filter)
    return plumbing


def convert_repeated_managed_secret_list_request_to_plumbing(porcelains):
    return [
        convert_managed_secret_list_request_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_managed_secret_list_request_to_porcelain(plumbings):
    return [
        convert_managed_secret_list_request_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_managed_secret_list_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ManagedSecretListResponse()
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_managed_secret_list_response_to_plumbing(porcelain):
    plumbing = ManagedSecretListResponse()
    if porcelain is None:
        return plumbing
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_managed_secret_list_response_to_plumbing(porcelains):
    return [
        convert_managed_secret_list_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_managed_secret_list_response_to_porcelain(plumbings):
    return [
        convert_managed_secret_list_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_managed_secret_log_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ManagedSecretLog()
    porcelain.account_id = (plumbing.account_id)
    porcelain.action = (plumbing.action)
    porcelain.created_at = convert_timestamp_to_porcelain(plumbing.created_at)
    porcelain.debug = (plumbing.debug)
    porcelain.id = (plumbing.id)
    porcelain.managed_secret_id = (plumbing.managed_secret_id)
    porcelain.secret_engine_id = (plumbing.secret_engine_id)
    return porcelain


def convert_managed_secret_log_to_plumbing(porcelain):
    plumbing = ManagedSecretLog()
    if porcelain is None:
        return plumbing
    plumbing.account_id = (porcelain.account_id)
    plumbing.action = (porcelain.action)
    plumbing.created_at.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.created_at))
    plumbing.debug = (porcelain.debug)
    plumbing.id = (porcelain.id)
    plumbing.managed_secret_id = (porcelain.managed_secret_id)
    plumbing.secret_engine_id = (porcelain.secret_engine_id)
    return plumbing


def convert_repeated_managed_secret_log_to_plumbing(porcelains):
    return [
        convert_managed_secret_log_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_managed_secret_log_to_porcelain(plumbings):
    return [
        convert_managed_secret_log_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_managed_secret_logs_request_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ManagedSecretLogsRequest()
    porcelain.filter = (plumbing.filter)
    return porcelain


def convert_managed_secret_logs_request_to_plumbing(porcelain):
    plumbing = ManagedSecretLogsRequest()
    if porcelain is None:
        return plumbing
    plumbing.filter = (porcelain.filter)
    return plumbing


def convert_repeated_managed_secret_logs_request_to_plumbing(porcelains):
    return [
        convert_managed_secret_logs_request_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_managed_secret_logs_request_to_porcelain(plumbings):
    return [
        convert_managed_secret_logs_request_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_managed_secret_logs_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ManagedSecretLogsResponse()
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_managed_secret_logs_response_to_plumbing(porcelain):
    plumbing = ManagedSecretLogsResponse()
    if porcelain is None:
        return plumbing
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_managed_secret_logs_response_to_plumbing(porcelains):
    return [
        convert_managed_secret_logs_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_managed_secret_logs_response_to_porcelain(plumbings):
    return [
        convert_managed_secret_logs_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_managed_secret_password_policy_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ManagedSecretPasswordPolicy()
    porcelain.allow_repeat = (plumbing.allow_repeat)
    porcelain.exclude_characters = (plumbing.exclude_characters)
    porcelain.exclude_upper_case = (plumbing.exclude_upper_case)
    porcelain.length = (plumbing.length)
    porcelain.num_digits = (plumbing.num_digits)
    porcelain.num_symbols = (plumbing.num_symbols)
    return porcelain


def convert_managed_secret_password_policy_to_plumbing(porcelain):
    plumbing = ManagedSecretPasswordPolicy()
    if porcelain is None:
        return plumbing
    plumbing.allow_repeat = (porcelain.allow_repeat)
    plumbing.exclude_characters = (porcelain.exclude_characters)
    plumbing.exclude_upper_case = (porcelain.exclude_upper_case)
    plumbing.length = (porcelain.length)
    plumbing.num_digits = (porcelain.num_digits)
    plumbing.num_symbols = (porcelain.num_symbols)
    return plumbing


def convert_repeated_managed_secret_password_policy_to_plumbing(porcelains):
    return [
        convert_managed_secret_password_policy_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_managed_secret_password_policy_to_porcelain(plumbings):
    return [
        convert_managed_secret_password_policy_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_managed_secret_policy_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ManagedSecretPolicy()
    porcelain.password_policy = convert_managed_secret_password_policy_to_porcelain(
        plumbing.password_policy)
    porcelain.rotation_policy = convert_managed_secret_rotation_policy_to_porcelain(
        plumbing.rotation_policy)
    return porcelain


def convert_managed_secret_policy_to_plumbing(porcelain):
    plumbing = ManagedSecretPolicy()
    if porcelain is None:
        return plumbing
    plumbing.password_policy.CopyFrom(
        convert_managed_secret_password_policy_to_plumbing(
            porcelain.password_policy))
    plumbing.rotation_policy.CopyFrom(
        convert_managed_secret_rotation_policy_to_plumbing(
            porcelain.rotation_policy))
    return plumbing


def convert_repeated_managed_secret_policy_to_plumbing(porcelains):
    return [
        convert_managed_secret_policy_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_managed_secret_policy_to_porcelain(plumbings):
    return [
        convert_managed_secret_policy_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_managed_secret_retrieve_request_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ManagedSecretRetrieveRequest()
    porcelain.id = (plumbing.id)
    porcelain.public_key = (plumbing.public_key)
    return porcelain


def convert_managed_secret_retrieve_request_to_plumbing(porcelain):
    plumbing = ManagedSecretRetrieveRequest()
    if porcelain is None:
        return plumbing
    plumbing.id = (porcelain.id)
    plumbing.public_key = (porcelain.public_key)
    return plumbing


def convert_repeated_managed_secret_retrieve_request_to_plumbing(porcelains):
    return [
        convert_managed_secret_retrieve_request_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_managed_secret_retrieve_request_to_porcelain(plumbings):
    return [
        convert_managed_secret_retrieve_request_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_managed_secret_retrieve_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ManagedSecretRetrieveResponse()
    porcelain.managed_secret = convert_managed_secret_to_porcelain(
        plumbing.managed_secret)
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_managed_secret_retrieve_response_to_plumbing(porcelain):
    plumbing = ManagedSecretRetrieveResponse()
    if porcelain is None:
        return plumbing
    plumbing.managed_secret.CopyFrom(
        convert_managed_secret_to_plumbing(porcelain.managed_secret))
    plumbing.meta.CopyFrom(
        convert_get_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_managed_secret_retrieve_response_to_plumbing(porcelains):
    return [
        convert_managed_secret_retrieve_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_managed_secret_retrieve_response_to_porcelain(plumbings):
    return [
        convert_managed_secret_retrieve_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_managed_secret_rotate_request_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ManagedSecretRotateRequest()
    porcelain.id = (plumbing.id)
    return porcelain


def convert_managed_secret_rotate_request_to_plumbing(porcelain):
    plumbing = ManagedSecretRotateRequest()
    if porcelain is None:
        return plumbing
    plumbing.id = (porcelain.id)
    return plumbing


def convert_repeated_managed_secret_rotate_request_to_plumbing(porcelains):
    return [
        convert_managed_secret_rotate_request_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_managed_secret_rotate_request_to_porcelain(plumbings):
    return [
        convert_managed_secret_rotate_request_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_managed_secret_rotate_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ManagedSecretRotateResponse()
    porcelain.meta = convert_generic_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_managed_secret_rotate_response_to_plumbing(porcelain):
    plumbing = ManagedSecretRotateResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_generic_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_managed_secret_rotate_response_to_plumbing(porcelains):
    return [
        convert_managed_secret_rotate_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_managed_secret_rotate_response_to_porcelain(plumbings):
    return [
        convert_managed_secret_rotate_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_managed_secret_rotation_policy_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ManagedSecretRotationPolicy()
    return porcelain


def convert_managed_secret_rotation_policy_to_plumbing(porcelain):
    plumbing = ManagedSecretRotationPolicy()
    if porcelain is None:
        return plumbing
    return plumbing


def convert_repeated_managed_secret_rotation_policy_to_plumbing(porcelains):
    return [
        convert_managed_secret_rotation_policy_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_managed_secret_rotation_policy_to_porcelain(plumbings):
    return [
        convert_managed_secret_rotation_policy_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_managed_secret_update_request_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ManagedSecretUpdateRequest()
    porcelain.managed_secret = convert_managed_secret_to_porcelain(
        plumbing.managed_secret)
    return porcelain


def convert_managed_secret_update_request_to_plumbing(porcelain):
    plumbing = ManagedSecretUpdateRequest()
    if porcelain is None:
        return plumbing
    plumbing.managed_secret.CopyFrom(
        convert_managed_secret_to_plumbing(porcelain.managed_secret))
    return plumbing


def convert_repeated_managed_secret_update_request_to_plumbing(porcelains):
    return [
        convert_managed_secret_update_request_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_managed_secret_update_request_to_porcelain(plumbings):
    return [
        convert_managed_secret_update_request_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_managed_secret_update_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ManagedSecretUpdateResponse()
    porcelain.managed_secret = convert_managed_secret_to_porcelain(
        plumbing.managed_secret)
    porcelain.meta = convert_update_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_managed_secret_update_response_to_plumbing(porcelain):
    plumbing = ManagedSecretUpdateResponse()
    if porcelain is None:
        return plumbing
    plumbing.managed_secret.CopyFrom(
        convert_managed_secret_to_plumbing(porcelain.managed_secret))
    plumbing.meta.CopyFrom(
        convert_update_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_managed_secret_update_response_to_plumbing(porcelains):
    return [
        convert_managed_secret_update_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_managed_secret_update_response_to_porcelain(plumbings):
    return [
        convert_managed_secret_update_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_managed_secret_validate_request_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ManagedSecretValidateRequest()
    porcelain.id = (plumbing.id)
    return porcelain


def convert_managed_secret_validate_request_to_plumbing(porcelain):
    plumbing = ManagedSecretValidateRequest()
    if porcelain is None:
        return plumbing
    plumbing.id = (porcelain.id)
    return plumbing


def convert_repeated_managed_secret_validate_request_to_plumbing(porcelains):
    return [
        convert_managed_secret_validate_request_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_managed_secret_validate_request_to_porcelain(plumbings):
    return [
        convert_managed_secret_validate_request_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_managed_secret_validate_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ManagedSecretValidateResponse()
    porcelain.invalid_info = (plumbing.invalid_info)
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.valid = (plumbing.valid)
    return porcelain


def convert_managed_secret_validate_response_to_plumbing(porcelain):
    plumbing = ManagedSecretValidateResponse()
    if porcelain is None:
        return plumbing
    plumbing.invalid_info = (porcelain.invalid_info)
    plumbing.meta.CopyFrom(
        convert_get_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    plumbing.valid = (porcelain.valid)
    return plumbing


def convert_repeated_managed_secret_validate_response_to_plumbing(porcelains):
    return [
        convert_managed_secret_validate_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_managed_secret_validate_response_to_porcelain(plumbings):
    return [
        convert_managed_secret_validate_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_maria_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Maria()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.require_native_auth = (plumbing.require_native_auth)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.use_azure_single_server_usernames = (
        plumbing.use_azure_single_server_usernames)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_maria_to_plumbing(porcelain):
    plumbing = Maria()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.require_native_auth = (porcelain.require_native_auth)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.use_azure_single_server_usernames = (
        porcelain.use_azure_single_server_usernames)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_maria_to_plumbing(porcelains):
    return [convert_maria_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_maria_to_porcelain(plumbings):
    return [convert_maria_to_porcelain(plumbing) for plumbing in plumbings]


def convert_memcached_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Memcached()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_memcached_to_plumbing(porcelain):
    plumbing = Memcached()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_memcached_to_plumbing(porcelains):
    return [
        convert_memcached_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_memcached_to_porcelain(plumbings):
    return [convert_memcached_to_porcelain(plumbing) for plumbing in plumbings]


def convert_memsql_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Memsql()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.require_native_auth = (plumbing.require_native_auth)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.use_azure_single_server_usernames = (
        plumbing.use_azure_single_server_usernames)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_memsql_to_plumbing(porcelain):
    plumbing = Memsql()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.require_native_auth = (porcelain.require_native_auth)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.use_azure_single_server_usernames = (
        porcelain.use_azure_single_server_usernames)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_memsql_to_plumbing(porcelains):
    return [convert_memsql_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_memsql_to_porcelain(plumbings):
    return [convert_memsql_to_porcelain(plumbing) for plumbing in plumbings]


def convert_mongo_host_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.MongoHost()
    porcelain.auth_database = (plumbing.auth_database)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tls_required = (plumbing.tls_required)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_mongo_host_to_plumbing(porcelain):
    plumbing = MongoHost()
    if porcelain is None:
        return plumbing
    plumbing.auth_database = (porcelain.auth_database)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.tls_required = (porcelain.tls_required)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_mongo_host_to_plumbing(porcelains):
    return [
        convert_mongo_host_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_mongo_host_to_porcelain(plumbings):
    return [
        convert_mongo_host_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_mongo_legacy_host_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.MongoLegacyHost()
    porcelain.auth_database = (plumbing.auth_database)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tls_required = (plumbing.tls_required)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_mongo_legacy_host_to_plumbing(porcelain):
    plumbing = MongoLegacyHost()
    if porcelain is None:
        return plumbing
    plumbing.auth_database = (porcelain.auth_database)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.tls_required = (porcelain.tls_required)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_mongo_legacy_host_to_plumbing(porcelains):
    return [
        convert_mongo_legacy_host_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_mongo_legacy_host_to_porcelain(plumbings):
    return [
        convert_mongo_legacy_host_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_mongo_legacy_replicaset_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.MongoLegacyReplicaset()
    porcelain.auth_database = (plumbing.auth_database)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.connect_to_replica = (plumbing.connect_to_replica)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.replica_set = (plumbing.replica_set)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tls_required = (plumbing.tls_required)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_mongo_legacy_replicaset_to_plumbing(porcelain):
    plumbing = MongoLegacyReplicaset()
    if porcelain is None:
        return plumbing
    plumbing.auth_database = (porcelain.auth_database)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.connect_to_replica = (porcelain.connect_to_replica)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.replica_set = (porcelain.replica_set)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.tls_required = (porcelain.tls_required)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_mongo_legacy_replicaset_to_plumbing(porcelains):
    return [
        convert_mongo_legacy_replicaset_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_mongo_legacy_replicaset_to_porcelain(plumbings):
    return [
        convert_mongo_legacy_replicaset_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_mongo_replica_set_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.MongoReplicaSet()
    porcelain.auth_database = (plumbing.auth_database)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.connect_to_replica = (plumbing.connect_to_replica)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.replica_set = (plumbing.replica_set)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tls_required = (plumbing.tls_required)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_mongo_replica_set_to_plumbing(porcelain):
    plumbing = MongoReplicaSet()
    if porcelain is None:
        return plumbing
    plumbing.auth_database = (porcelain.auth_database)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.connect_to_replica = (porcelain.connect_to_replica)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.replica_set = (porcelain.replica_set)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.tls_required = (porcelain.tls_required)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_mongo_replica_set_to_plumbing(porcelains):
    return [
        convert_mongo_replica_set_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_mongo_replica_set_to_porcelain(plumbings):
    return [
        convert_mongo_replica_set_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_mongo_sharded_cluster_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.MongoShardedCluster()
    porcelain.auth_database = (plumbing.auth_database)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tls_required = (plumbing.tls_required)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_mongo_sharded_cluster_to_plumbing(porcelain):
    plumbing = MongoShardedCluster()
    if porcelain is None:
        return plumbing
    plumbing.auth_database = (porcelain.auth_database)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.tls_required = (porcelain.tls_required)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_mongo_sharded_cluster_to_plumbing(porcelains):
    return [
        convert_mongo_sharded_cluster_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_mongo_sharded_cluster_to_porcelain(plumbings):
    return [
        convert_mongo_sharded_cluster_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_mysql_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Mysql()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.require_native_auth = (plumbing.require_native_auth)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.use_azure_single_server_usernames = (
        plumbing.use_azure_single_server_usernames)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_mysql_to_plumbing(porcelain):
    plumbing = Mysql()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.require_native_auth = (porcelain.require_native_auth)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.use_azure_single_server_usernames = (
        porcelain.use_azure_single_server_usernames)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_mysql_to_plumbing(porcelains):
    return [convert_mysql_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_mysql_to_porcelain(plumbings):
    return [convert_mysql_to_porcelain(plumbing) for plumbing in plumbings]


def convert_neptune_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Neptune()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.endpoint = (plumbing.endpoint)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_neptune_to_plumbing(porcelain):
    plumbing = Neptune()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.endpoint = (porcelain.endpoint)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_neptune_to_plumbing(porcelains):
    return [convert_neptune_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_neptune_to_porcelain(plumbings):
    return [convert_neptune_to_porcelain(plumbing) for plumbing in plumbings]


def convert_neptune_iam_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.NeptuneIAM()
    porcelain.access_key = (plumbing.access_key)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.endpoint = (plumbing.endpoint)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.region = (plumbing.region)
    porcelain.role_arn = (plumbing.role_arn)
    porcelain.role_external_id = (plumbing.role_external_id)
    porcelain.secret_access_key = (plumbing.secret_access_key)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_neptune_iam_to_plumbing(porcelain):
    plumbing = NeptuneIAM()
    if porcelain is None:
        return plumbing
    plumbing.access_key = (porcelain.access_key)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.endpoint = (porcelain.endpoint)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.region = (porcelain.region)
    plumbing.role_arn = (porcelain.role_arn)
    plumbing.role_external_id = (porcelain.role_external_id)
    plumbing.secret_access_key = (porcelain.secret_access_key)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_neptune_iam_to_plumbing(porcelains):
    return [
        convert_neptune_iam_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_neptune_iam_to_porcelain(plumbings):
    return [
        convert_neptune_iam_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_node_to_plumbing(porcelain):
    plumbing = Node()
    if porcelain is None:
        return plumbing
    if isinstance(porcelain, models.Gateway):
        plumbing.gateway.CopyFrom(convert_gateway_to_plumbing(porcelain))
    if isinstance(porcelain, models.ProxyCluster):
        plumbing.proxy_cluster.CopyFrom(
            convert_proxy_cluster_to_plumbing(porcelain))
    if isinstance(porcelain, models.Relay):
        plumbing.relay.CopyFrom(convert_relay_to_plumbing(porcelain))
    return plumbing


def convert_node_to_porcelain(plumbing):
    if plumbing is None:
        return None
    if plumbing.HasField('gateway'):
        return convert_gateway_to_porcelain(plumbing.gateway)
    if plumbing.HasField('proxy_cluster'):
        return convert_proxy_cluster_to_porcelain(plumbing.proxy_cluster)
    if plumbing.HasField('relay'):
        return convert_relay_to_porcelain(plumbing.relay)
    raise errors.UnknownError(
        "unknown polymorphic type, please upgrade your SDK")


def convert_repeated_node_to_plumbing(porcelains):
    return [convert_node_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_node_to_porcelain(plumbings):
    return [convert_node_to_porcelain(plumbing) for plumbing in plumbings]


def convert_node_create_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.NodeCreateResponse()
    porcelain.meta = convert_create_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.node = convert_node_to_porcelain(plumbing.node)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.token = (plumbing.token)
    return porcelain


def convert_node_create_response_to_plumbing(porcelain):
    plumbing = NodeCreateResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_create_response_metadata_to_plumbing(porcelain.meta))
    plumbing.node.CopyFrom(convert_node_to_plumbing(porcelain.node))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    plumbing.token = (porcelain.token)
    return plumbing


def convert_repeated_node_create_response_to_plumbing(porcelains):
    return [
        convert_node_create_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_node_create_response_to_porcelain(plumbings):
    return [
        convert_node_create_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_node_delete_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.NodeDeleteResponse()
    porcelain.meta = convert_delete_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_node_delete_response_to_plumbing(porcelain):
    plumbing = NodeDeleteResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_delete_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_node_delete_response_to_plumbing(porcelains):
    return [
        convert_node_delete_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_node_delete_response_to_porcelain(plumbings):
    return [
        convert_node_delete_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_node_get_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.NodeGetResponse()
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.node = convert_node_to_porcelain(plumbing.node)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_node_get_response_to_plumbing(porcelain):
    plumbing = NodeGetResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_get_response_metadata_to_plumbing(porcelain.meta))
    plumbing.node.CopyFrom(convert_node_to_plumbing(porcelain.node))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_node_get_response_to_plumbing(porcelains):
    return [
        convert_node_get_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_node_get_response_to_porcelain(plumbings):
    return [
        convert_node_get_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_node_history_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.NodeHistory()
    porcelain.activity_id = (plumbing.activity_id)
    porcelain.deleted_at = convert_timestamp_to_porcelain(plumbing.deleted_at)
    porcelain.node = convert_node_to_porcelain(plumbing.node)
    porcelain.timestamp = convert_timestamp_to_porcelain(plumbing.timestamp)
    return porcelain


def convert_node_history_to_plumbing(porcelain):
    plumbing = NodeHistory()
    if porcelain is None:
        return plumbing
    plumbing.activity_id = (porcelain.activity_id)
    plumbing.deleted_at.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.deleted_at))
    plumbing.node.CopyFrom(convert_node_to_plumbing(porcelain.node))
    plumbing.timestamp.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.timestamp))
    return plumbing


def convert_repeated_node_history_to_plumbing(porcelains):
    return [
        convert_node_history_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_node_history_to_porcelain(plumbings):
    return [
        convert_node_history_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_node_maintenance_window_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.NodeMaintenanceWindow()
    porcelain.cron_schedule = (plumbing.cron_schedule)
    porcelain.require_idleness = (plumbing.require_idleness)
    return porcelain


def convert_node_maintenance_window_to_plumbing(porcelain):
    plumbing = NodeMaintenanceWindow()
    if porcelain is None:
        return plumbing
    plumbing.cron_schedule = (porcelain.cron_schedule)
    plumbing.require_idleness = (porcelain.require_idleness)
    return plumbing


def convert_repeated_node_maintenance_window_to_plumbing(porcelains):
    return [
        convert_node_maintenance_window_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_node_maintenance_window_to_porcelain(plumbings):
    return [
        convert_node_maintenance_window_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_node_update_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.NodeUpdateResponse()
    porcelain.meta = convert_update_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.node = convert_node_to_porcelain(plumbing.node)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_node_update_response_to_plumbing(porcelain):
    plumbing = NodeUpdateResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_update_response_metadata_to_plumbing(porcelain.meta))
    plumbing.node.CopyFrom(convert_node_to_plumbing(porcelain.node))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_node_update_response_to_plumbing(porcelains):
    return [
        convert_node_update_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_node_update_response_to_porcelain(plumbings):
    return [
        convert_node_update_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_oracle_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Oracle()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tls_required = (plumbing.tls_required)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_oracle_to_plumbing(porcelain):
    plumbing = Oracle()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.tls_required = (porcelain.tls_required)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_oracle_to_plumbing(porcelains):
    return [convert_oracle_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_oracle_to_porcelain(plumbings):
    return [convert_oracle_to_porcelain(plumbing) for plumbing in plumbings]


def convert_oracle_nne_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.OracleNNE()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_oracle_nne_to_plumbing(porcelain):
    plumbing = OracleNNE()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_oracle_nne_to_plumbing(porcelains):
    return [
        convert_oracle_nne_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_oracle_nne_to_porcelain(plumbings):
    return [
        convert_oracle_nne_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_organization_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Organization()
    porcelain.auth_provider = (plumbing.auth_provider)
    porcelain.created_at = convert_timestamp_to_porcelain(plumbing.created_at)
    porcelain.device_trust_enabled = (plumbing.device_trust_enabled)
    porcelain.device_trust_provider = (plumbing.device_trust_provider)
    porcelain.enforce_single_session = (plumbing.enforce_single_session)
    porcelain.idle_timeout = convert_duration_to_porcelain(
        plumbing.idle_timeout)
    porcelain.idle_timeout_enabled = (plumbing.idle_timeout_enabled)
    porcelain.kind = (plumbing.kind)
    porcelain.log_local_encoder = (plumbing.log_local_encoder)
    porcelain.log_local_format = (plumbing.log_local_format)
    porcelain.log_local_storage = (plumbing.log_local_storage)
    porcelain.log_remote_encoder = (plumbing.log_remote_encoder)
    porcelain.log_socket_path = (plumbing.log_socket_path)
    porcelain.log_tcp_address = (plumbing.log_tcp_address)
    porcelain.loopback_range = (plumbing.loopback_range)
    porcelain.mfa_enabled = (plumbing.mfa_enabled)
    porcelain.mfa_provider = (plumbing.mfa_provider)
    porcelain.name = (plumbing.name)
    porcelain.require_secret_store = (plumbing.require_secret_store)
    porcelain.saml_metadata_url = (plumbing.saml_metadata_url)
    porcelain.scim_provider = (plumbing.scim_provider)
    porcelain.sensitive_label = (plumbing.sensitive_label)
    porcelain.session_timeout = convert_duration_to_porcelain(
        plumbing.session_timeout)
    porcelain.session_timeout_enabled = (plumbing.session_timeout_enabled)
    porcelain.ssh_certificate_authority_public_key = (
        plumbing.ssh_certificate_authority_public_key)
    porcelain.ssh_certificate_authority_updated_at = convert_timestamp_to_porcelain(
        plumbing.ssh_certificate_authority_updated_at)
    porcelain.updated_at = convert_timestamp_to_porcelain(plumbing.updated_at)
    porcelain.websites_subdomain = (plumbing.websites_subdomain)
    return porcelain


def convert_organization_to_plumbing(porcelain):
    plumbing = Organization()
    if porcelain is None:
        return plumbing
    plumbing.auth_provider = (porcelain.auth_provider)
    plumbing.created_at.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.created_at))
    plumbing.device_trust_enabled = (porcelain.device_trust_enabled)
    plumbing.device_trust_provider = (porcelain.device_trust_provider)
    plumbing.enforce_single_session = (porcelain.enforce_single_session)
    plumbing.idle_timeout.CopyFrom(
        convert_duration_to_plumbing(porcelain.idle_timeout))
    plumbing.idle_timeout_enabled = (porcelain.idle_timeout_enabled)
    plumbing.kind = (porcelain.kind)
    plumbing.log_local_encoder = (porcelain.log_local_encoder)
    plumbing.log_local_format = (porcelain.log_local_format)
    plumbing.log_local_storage = (porcelain.log_local_storage)
    plumbing.log_remote_encoder = (porcelain.log_remote_encoder)
    plumbing.log_socket_path = (porcelain.log_socket_path)
    plumbing.log_tcp_address = (porcelain.log_tcp_address)
    plumbing.loopback_range = (porcelain.loopback_range)
    plumbing.mfa_enabled = (porcelain.mfa_enabled)
    plumbing.mfa_provider = (porcelain.mfa_provider)
    plumbing.name = (porcelain.name)
    plumbing.require_secret_store = (porcelain.require_secret_store)
    plumbing.saml_metadata_url = (porcelain.saml_metadata_url)
    plumbing.scim_provider = (porcelain.scim_provider)
    plumbing.sensitive_label = (porcelain.sensitive_label)
    plumbing.session_timeout.CopyFrom(
        convert_duration_to_plumbing(porcelain.session_timeout))
    plumbing.session_timeout_enabled = (porcelain.session_timeout_enabled)
    plumbing.ssh_certificate_authority_public_key = (
        porcelain.ssh_certificate_authority_public_key)
    plumbing.ssh_certificate_authority_updated_at.CopyFrom(
        convert_timestamp_to_plumbing(
            porcelain.ssh_certificate_authority_updated_at))
    plumbing.updated_at.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.updated_at))
    plumbing.websites_subdomain = (porcelain.websites_subdomain)
    return plumbing


def convert_repeated_organization_to_plumbing(porcelains):
    return [
        convert_organization_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_organization_to_porcelain(plumbings):
    return [
        convert_organization_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_organization_history_record_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.OrganizationHistoryRecord()
    porcelain.activity_id = (plumbing.activity_id)
    porcelain.organization = convert_organization_to_porcelain(
        plumbing.organization)
    porcelain.timestamp = convert_timestamp_to_porcelain(plumbing.timestamp)
    return porcelain


def convert_organization_history_record_to_plumbing(porcelain):
    plumbing = OrganizationHistoryRecord()
    if porcelain is None:
        return plumbing
    plumbing.activity_id = (porcelain.activity_id)
    plumbing.organization.CopyFrom(
        convert_organization_to_plumbing(porcelain.organization))
    plumbing.timestamp.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.timestamp))
    return plumbing


def convert_repeated_organization_history_record_to_plumbing(porcelains):
    return [
        convert_organization_history_record_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_organization_history_record_to_porcelain(plumbings):
    return [
        convert_organization_history_record_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_peering_group_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.PeeringGroup()
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    return porcelain


def convert_peering_group_to_plumbing(porcelain):
    plumbing = PeeringGroup()
    if porcelain is None:
        return plumbing
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    return plumbing


def convert_repeated_peering_group_to_plumbing(porcelains):
    return [
        convert_peering_group_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_peering_group_to_porcelain(plumbings):
    return [
        convert_peering_group_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_peering_group_create_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.PeeringGroupCreateResponse()
    porcelain.meta = convert_create_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.peering_group = convert_peering_group_to_porcelain(
        plumbing.peering_group)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_peering_group_create_response_to_plumbing(porcelain):
    plumbing = PeeringGroupCreateResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_create_response_metadata_to_plumbing(porcelain.meta))
    plumbing.peering_group.CopyFrom(
        convert_peering_group_to_plumbing(porcelain.peering_group))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_peering_group_create_response_to_plumbing(porcelains):
    return [
        convert_peering_group_create_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_peering_group_create_response_to_porcelain(plumbings):
    return [
        convert_peering_group_create_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_peering_group_delete_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.PeeringGroupDeleteResponse()
    porcelain.meta = convert_delete_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_peering_group_delete_response_to_plumbing(porcelain):
    plumbing = PeeringGroupDeleteResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_delete_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_peering_group_delete_response_to_plumbing(porcelains):
    return [
        convert_peering_group_delete_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_peering_group_delete_response_to_porcelain(plumbings):
    return [
        convert_peering_group_delete_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_peering_group_get_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.PeeringGroupGetResponse()
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.peering_group = convert_peering_group_to_porcelain(
        plumbing.peering_group)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_peering_group_get_response_to_plumbing(porcelain):
    plumbing = PeeringGroupGetResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_get_response_metadata_to_plumbing(porcelain.meta))
    plumbing.peering_group.CopyFrom(
        convert_peering_group_to_plumbing(porcelain.peering_group))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_peering_group_get_response_to_plumbing(porcelains):
    return [
        convert_peering_group_get_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_peering_group_get_response_to_porcelain(plumbings):
    return [
        convert_peering_group_get_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_peering_group_node_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.PeeringGroupNode()
    porcelain.group_id = (plumbing.group_id)
    porcelain.id = (plumbing.id)
    porcelain.node_id = (plumbing.node_id)
    return porcelain


def convert_peering_group_node_to_plumbing(porcelain):
    plumbing = PeeringGroupNode()
    if porcelain is None:
        return plumbing
    plumbing.group_id = (porcelain.group_id)
    plumbing.id = (porcelain.id)
    plumbing.node_id = (porcelain.node_id)
    return plumbing


def convert_repeated_peering_group_node_to_plumbing(porcelains):
    return [
        convert_peering_group_node_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_peering_group_node_to_porcelain(plumbings):
    return [
        convert_peering_group_node_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_peering_group_node_create_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.PeeringGroupNodeCreateResponse()
    porcelain.meta = convert_create_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.peering_group_node = convert_peering_group_node_to_porcelain(
        plumbing.peering_group_node)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_peering_group_node_create_response_to_plumbing(porcelain):
    plumbing = PeeringGroupNodeCreateResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_create_response_metadata_to_plumbing(porcelain.meta))
    plumbing.peering_group_node.CopyFrom(
        convert_peering_group_node_to_plumbing(porcelain.peering_group_node))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_peering_group_node_create_response_to_plumbing(
        porcelains):
    return [
        convert_peering_group_node_create_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_peering_group_node_create_response_to_porcelain(
        plumbings):
    return [
        convert_peering_group_node_create_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_peering_group_node_delete_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.PeeringGroupNodeDeleteResponse()
    porcelain.meta = convert_delete_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_peering_group_node_delete_response_to_plumbing(porcelain):
    plumbing = PeeringGroupNodeDeleteResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_delete_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_peering_group_node_delete_response_to_plumbing(
        porcelains):
    return [
        convert_peering_group_node_delete_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_peering_group_node_delete_response_to_porcelain(
        plumbings):
    return [
        convert_peering_group_node_delete_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_peering_group_node_get_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.PeeringGroupNodeGetResponse()
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.peering_group_node = convert_peering_group_node_to_porcelain(
        plumbing.peering_group_node)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_peering_group_node_get_response_to_plumbing(porcelain):
    plumbing = PeeringGroupNodeGetResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_get_response_metadata_to_plumbing(porcelain.meta))
    plumbing.peering_group_node.CopyFrom(
        convert_peering_group_node_to_plumbing(porcelain.peering_group_node))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_peering_group_node_get_response_to_plumbing(porcelains):
    return [
        convert_peering_group_node_get_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_peering_group_node_get_response_to_porcelain(plumbings):
    return [
        convert_peering_group_node_get_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_peering_group_peer_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.PeeringGroupPeer()
    porcelain.group_id = (plumbing.group_id)
    porcelain.id = (plumbing.id)
    porcelain.peers_with_group_id = (plumbing.peers_with_group_id)
    return porcelain


def convert_peering_group_peer_to_plumbing(porcelain):
    plumbing = PeeringGroupPeer()
    if porcelain is None:
        return plumbing
    plumbing.group_id = (porcelain.group_id)
    plumbing.id = (porcelain.id)
    plumbing.peers_with_group_id = (porcelain.peers_with_group_id)
    return plumbing


def convert_repeated_peering_group_peer_to_plumbing(porcelains):
    return [
        convert_peering_group_peer_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_peering_group_peer_to_porcelain(plumbings):
    return [
        convert_peering_group_peer_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_peering_group_peer_create_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.PeeringGroupPeerCreateResponse()
    porcelain.meta = convert_create_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.peering_group_peer = convert_peering_group_peer_to_porcelain(
        plumbing.peering_group_peer)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_peering_group_peer_create_response_to_plumbing(porcelain):
    plumbing = PeeringGroupPeerCreateResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_create_response_metadata_to_plumbing(porcelain.meta))
    plumbing.peering_group_peer.CopyFrom(
        convert_peering_group_peer_to_plumbing(porcelain.peering_group_peer))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_peering_group_peer_create_response_to_plumbing(
        porcelains):
    return [
        convert_peering_group_peer_create_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_peering_group_peer_create_response_to_porcelain(
        plumbings):
    return [
        convert_peering_group_peer_create_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_peering_group_peer_delete_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.PeeringGroupPeerDeleteResponse()
    porcelain.meta = convert_delete_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_peering_group_peer_delete_response_to_plumbing(porcelain):
    plumbing = PeeringGroupPeerDeleteResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_delete_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_peering_group_peer_delete_response_to_plumbing(
        porcelains):
    return [
        convert_peering_group_peer_delete_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_peering_group_peer_delete_response_to_porcelain(
        plumbings):
    return [
        convert_peering_group_peer_delete_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_peering_group_peer_get_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.PeeringGroupPeerGetResponse()
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.peering_group_peer = convert_peering_group_peer_to_porcelain(
        plumbing.peering_group_peer)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_peering_group_peer_get_response_to_plumbing(porcelain):
    plumbing = PeeringGroupPeerGetResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_get_response_metadata_to_plumbing(porcelain.meta))
    plumbing.peering_group_peer.CopyFrom(
        convert_peering_group_peer_to_plumbing(porcelain.peering_group_peer))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_peering_group_peer_get_response_to_plumbing(porcelains):
    return [
        convert_peering_group_peer_get_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_peering_group_peer_get_response_to_porcelain(plumbings):
    return [
        convert_peering_group_peer_get_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_peering_group_resource_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.PeeringGroupResource()
    porcelain.group_id = (plumbing.group_id)
    porcelain.id = (plumbing.id)
    porcelain.resource_id = (plumbing.resource_id)
    return porcelain


def convert_peering_group_resource_to_plumbing(porcelain):
    plumbing = PeeringGroupResource()
    if porcelain is None:
        return plumbing
    plumbing.group_id = (porcelain.group_id)
    plumbing.id = (porcelain.id)
    plumbing.resource_id = (porcelain.resource_id)
    return plumbing


def convert_repeated_peering_group_resource_to_plumbing(porcelains):
    return [
        convert_peering_group_resource_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_peering_group_resource_to_porcelain(plumbings):
    return [
        convert_peering_group_resource_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_peering_group_resource_create_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.PeeringGroupResourceCreateResponse()
    porcelain.meta = convert_create_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.peering_group_resource = convert_peering_group_resource_to_porcelain(
        plumbing.peering_group_resource)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_peering_group_resource_create_response_to_plumbing(porcelain):
    plumbing = PeeringGroupResourceCreateResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_create_response_metadata_to_plumbing(porcelain.meta))
    plumbing.peering_group_resource.CopyFrom(
        convert_peering_group_resource_to_plumbing(
            porcelain.peering_group_resource))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_peering_group_resource_create_response_to_plumbing(
        porcelains):
    return [
        convert_peering_group_resource_create_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_peering_group_resource_create_response_to_porcelain(
        plumbings):
    return [
        convert_peering_group_resource_create_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_peering_group_resource_delete_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.PeeringGroupResourceDeleteResponse()
    porcelain.meta = convert_delete_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_peering_group_resource_delete_response_to_plumbing(porcelain):
    plumbing = PeeringGroupResourceDeleteResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_delete_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_peering_group_resource_delete_response_to_plumbing(
        porcelains):
    return [
        convert_peering_group_resource_delete_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_peering_group_resource_delete_response_to_porcelain(
        plumbings):
    return [
        convert_peering_group_resource_delete_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_peering_group_resource_get_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.PeeringGroupResourceGetResponse()
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.peering_group_resource = convert_peering_group_resource_to_porcelain(
        plumbing.peering_group_resource)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_peering_group_resource_get_response_to_plumbing(porcelain):
    plumbing = PeeringGroupResourceGetResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_get_response_metadata_to_plumbing(porcelain.meta))
    plumbing.peering_group_resource.CopyFrom(
        convert_peering_group_resource_to_plumbing(
            porcelain.peering_group_resource))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_peering_group_resource_get_response_to_plumbing(
        porcelains):
    return [
        convert_peering_group_resource_get_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_peering_group_resource_get_response_to_porcelain(
        plumbings):
    return [
        convert_peering_group_resource_get_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_policy_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Policy()
    porcelain.description = (plumbing.description)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.policy = (plumbing.policy)
    return porcelain


def convert_policy_to_plumbing(porcelain):
    plumbing = Policy()
    if porcelain is None:
        return plumbing
    plumbing.description = (porcelain.description)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.policy = (porcelain.policy)
    return plumbing


def convert_repeated_policy_to_plumbing(porcelains):
    return [convert_policy_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_policy_to_porcelain(plumbings):
    return [convert_policy_to_porcelain(plumbing) for plumbing in plumbings]


def convert_policy_create_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.PolicyCreateResponse()
    porcelain.policy = convert_policy_to_porcelain(plumbing.policy)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_policy_create_response_to_plumbing(porcelain):
    plumbing = PolicyCreateResponse()
    if porcelain is None:
        return plumbing
    plumbing.policy.CopyFrom(convert_policy_to_plumbing(porcelain.policy))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_policy_create_response_to_plumbing(porcelains):
    return [
        convert_policy_create_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_policy_create_response_to_porcelain(plumbings):
    return [
        convert_policy_create_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_policy_delete_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.PolicyDeleteResponse()
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_policy_delete_response_to_plumbing(porcelain):
    plumbing = PolicyDeleteResponse()
    if porcelain is None:
        return plumbing
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_policy_delete_response_to_plumbing(porcelains):
    return [
        convert_policy_delete_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_policy_delete_response_to_porcelain(plumbings):
    return [
        convert_policy_delete_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_policy_get_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.PolicyGetResponse()
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.policy = convert_policy_to_porcelain(plumbing.policy)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_policy_get_response_to_plumbing(porcelain):
    plumbing = PolicyGetResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_get_response_metadata_to_plumbing(porcelain.meta))
    plumbing.policy.CopyFrom(convert_policy_to_plumbing(porcelain.policy))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_policy_get_response_to_plumbing(porcelains):
    return [
        convert_policy_get_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_policy_get_response_to_porcelain(plumbings):
    return [
        convert_policy_get_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_policy_history_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.PolicyHistory()
    porcelain.activity_id = (plumbing.activity_id)
    porcelain.deleted_at = convert_timestamp_to_porcelain(plumbing.deleted_at)
    porcelain.policy = convert_policy_to_porcelain(plumbing.policy)
    porcelain.timestamp = convert_timestamp_to_porcelain(plumbing.timestamp)
    return porcelain


def convert_policy_history_to_plumbing(porcelain):
    plumbing = PolicyHistory()
    if porcelain is None:
        return plumbing
    plumbing.activity_id = (porcelain.activity_id)
    plumbing.deleted_at.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.deleted_at))
    plumbing.policy.CopyFrom(convert_policy_to_plumbing(porcelain.policy))
    plumbing.timestamp.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.timestamp))
    return plumbing


def convert_repeated_policy_history_to_plumbing(porcelains):
    return [
        convert_policy_history_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_policy_history_to_porcelain(plumbings):
    return [
        convert_policy_history_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_policy_list_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.PolicyListResponse()
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_policy_list_response_to_plumbing(porcelain):
    plumbing = PolicyListResponse()
    if porcelain is None:
        return plumbing
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_policy_list_response_to_plumbing(porcelains):
    return [
        convert_policy_list_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_policy_list_response_to_porcelain(plumbings):
    return [
        convert_policy_list_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_policy_update_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.PolicyUpdateResponse()
    porcelain.policy = convert_policy_to_porcelain(plumbing.policy)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_policy_update_response_to_plumbing(porcelain):
    plumbing = PolicyUpdateResponse()
    if porcelain is None:
        return plumbing
    plumbing.policy.CopyFrom(convert_policy_to_plumbing(porcelain.policy))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_policy_update_response_to_plumbing(porcelains):
    return [
        convert_policy_update_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_policy_update_response_to_porcelain(plumbings):
    return [
        convert_policy_update_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_postgres_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Postgres()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.override_database = (plumbing.override_database)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_postgres_to_plumbing(porcelain):
    plumbing = Postgres()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.override_database = (porcelain.override_database)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_postgres_to_plumbing(porcelains):
    return [
        convert_postgres_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_postgres_to_porcelain(plumbings):
    return [convert_postgres_to_porcelain(plumbing) for plumbing in plumbings]


def convert_presto_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Presto()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tls_required = (plumbing.tls_required)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_presto_to_plumbing(porcelain):
    plumbing = Presto()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.tls_required = (porcelain.tls_required)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_presto_to_plumbing(porcelains):
    return [convert_presto_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_presto_to_porcelain(plumbings):
    return [convert_presto_to_porcelain(plumbing) for plumbing in plumbings]


def convert_proxy_cluster_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ProxyCluster()
    porcelain.address = (plumbing.address)
    porcelain.id = (plumbing.id)
    porcelain.maintenance_windows = convert_repeated_node_maintenance_window_to_porcelain(
        plumbing.maintenance_windows)
    porcelain.name = (plumbing.name)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_proxy_cluster_to_plumbing(porcelain):
    plumbing = ProxyCluster()
    if porcelain is None:
        return plumbing
    plumbing.address = (porcelain.address)
    plumbing.id = (porcelain.id)
    del plumbing.maintenance_windows[:]
    plumbing.maintenance_windows.extend(
        convert_repeated_node_maintenance_window_to_plumbing(
            porcelain.maintenance_windows))
    plumbing.name = (porcelain.name)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_proxy_cluster_to_plumbing(porcelains):
    return [
        convert_proxy_cluster_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_proxy_cluster_to_porcelain(plumbings):
    return [
        convert_proxy_cluster_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_proxy_cluster_key_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ProxyClusterKey()
    porcelain.created_at = convert_timestamp_to_porcelain(plumbing.created_at)
    porcelain.id = (plumbing.id)
    porcelain.last_used_at = convert_timestamp_to_porcelain(
        plumbing.last_used_at)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    return porcelain


def convert_proxy_cluster_key_to_plumbing(porcelain):
    plumbing = ProxyClusterKey()
    if porcelain is None:
        return plumbing
    plumbing.created_at.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.created_at))
    plumbing.id = (porcelain.id)
    plumbing.last_used_at.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.last_used_at))
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    return plumbing


def convert_repeated_proxy_cluster_key_to_plumbing(porcelains):
    return [
        convert_proxy_cluster_key_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_proxy_cluster_key_to_porcelain(plumbings):
    return [
        convert_proxy_cluster_key_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_proxy_cluster_key_create_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ProxyClusterKeyCreateResponse()
    porcelain.meta = convert_create_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.proxy_cluster_key = convert_proxy_cluster_key_to_porcelain(
        plumbing.proxy_cluster_key)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.secret_key = (plumbing.secret_key)
    return porcelain


def convert_proxy_cluster_key_create_response_to_plumbing(porcelain):
    plumbing = ProxyClusterKeyCreateResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_create_response_metadata_to_plumbing(porcelain.meta))
    plumbing.proxy_cluster_key.CopyFrom(
        convert_proxy_cluster_key_to_plumbing(porcelain.proxy_cluster_key))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    plumbing.secret_key = (porcelain.secret_key)
    return plumbing


def convert_repeated_proxy_cluster_key_create_response_to_plumbing(porcelains):
    return [
        convert_proxy_cluster_key_create_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_proxy_cluster_key_create_response_to_porcelain(plumbings):
    return [
        convert_proxy_cluster_key_create_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_proxy_cluster_key_delete_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ProxyClusterKeyDeleteResponse()
    porcelain.meta = convert_delete_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_proxy_cluster_key_delete_response_to_plumbing(porcelain):
    plumbing = ProxyClusterKeyDeleteResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_delete_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_proxy_cluster_key_delete_response_to_plumbing(porcelains):
    return [
        convert_proxy_cluster_key_delete_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_proxy_cluster_key_delete_response_to_porcelain(plumbings):
    return [
        convert_proxy_cluster_key_delete_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_proxy_cluster_key_get_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ProxyClusterKeyGetResponse()
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.proxy_cluster_key = convert_proxy_cluster_key_to_porcelain(
        plumbing.proxy_cluster_key)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_proxy_cluster_key_get_response_to_plumbing(porcelain):
    plumbing = ProxyClusterKeyGetResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_get_response_metadata_to_plumbing(porcelain.meta))
    plumbing.proxy_cluster_key.CopyFrom(
        convert_proxy_cluster_key_to_plumbing(porcelain.proxy_cluster_key))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_proxy_cluster_key_get_response_to_plumbing(porcelains):
    return [
        convert_proxy_cluster_key_get_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_proxy_cluster_key_get_response_to_porcelain(plumbings):
    return [
        convert_proxy_cluster_key_get_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_query_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Query()
    porcelain.account_email = (plumbing.account_email)
    porcelain.account_first_name = (plumbing.account_first_name)
    porcelain.account_id = (plumbing.account_id)
    porcelain.account_last_name = (plumbing.account_last_name)
    porcelain.account_tags = convert_tags_to_porcelain(plumbing.account_tags)
    porcelain.authzjson = (plumbing.authzJson)
    porcelain.capture = convert_query_capture_to_porcelain(plumbing.capture)
    porcelain.client_ip = (plumbing.client_ip)
    porcelain.completed_at = convert_timestamp_to_porcelain(
        plumbing.completed_at)
    porcelain.duration = convert_duration_to_porcelain(plumbing.duration)
    porcelain.egress_node_id = (plumbing.egress_node_id)
    porcelain.encrypted = (plumbing.encrypted)
    porcelain.id = (plumbing.id)
    porcelain.identity_alias_username = (plumbing.identity_alias_username)
    porcelain.query_body = (plumbing.query_body)
    porcelain.query_category = (plumbing.query_category)
    porcelain.query_hash = (plumbing.query_hash)
    porcelain.query_key = (plumbing.query_key)
    porcelain.record_count = (plumbing.record_count)
    porcelain.remote_identity_username = (plumbing.remote_identity_username)
    porcelain.replayable = (plumbing.replayable)
    porcelain.resource_id = (plumbing.resource_id)
    porcelain.resource_name = (plumbing.resource_name)
    porcelain.resource_tags = convert_tags_to_porcelain(plumbing.resource_tags)
    porcelain.resource_type = (plumbing.resource_type)
    porcelain.source_ip = (plumbing.source_ip)
    porcelain.target = (plumbing.target)
    porcelain.timestamp = convert_timestamp_to_porcelain(plumbing.timestamp)
    return porcelain


def convert_query_to_plumbing(porcelain):
    plumbing = Query()
    if porcelain is None:
        return plumbing
    plumbing.account_email = (porcelain.account_email)
    plumbing.account_first_name = (porcelain.account_first_name)
    plumbing.account_id = (porcelain.account_id)
    plumbing.account_last_name = (porcelain.account_last_name)
    plumbing.account_tags.CopyFrom(
        convert_tags_to_plumbing(porcelain.account_tags))
    plumbing.authzJson = (porcelain.authzjson)
    plumbing.capture.CopyFrom(
        convert_query_capture_to_plumbing(porcelain.capture))
    plumbing.client_ip = (porcelain.client_ip)
    plumbing.completed_at.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.completed_at))
    plumbing.duration.CopyFrom(convert_duration_to_plumbing(
        porcelain.duration))
    plumbing.egress_node_id = (porcelain.egress_node_id)
    plumbing.encrypted = (porcelain.encrypted)
    plumbing.id = (porcelain.id)
    plumbing.identity_alias_username = (porcelain.identity_alias_username)
    plumbing.query_body = (porcelain.query_body)
    plumbing.query_category = (porcelain.query_category)
    plumbing.query_hash = (porcelain.query_hash)
    plumbing.query_key = (porcelain.query_key)
    plumbing.record_count = (porcelain.record_count)
    plumbing.remote_identity_username = (porcelain.remote_identity_username)
    plumbing.replayable = (porcelain.replayable)
    plumbing.resource_id = (porcelain.resource_id)
    plumbing.resource_name = (porcelain.resource_name)
    plumbing.resource_tags.CopyFrom(
        convert_tags_to_plumbing(porcelain.resource_tags))
    plumbing.resource_type = (porcelain.resource_type)
    plumbing.source_ip = (porcelain.source_ip)
    plumbing.target = (porcelain.target)
    plumbing.timestamp.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.timestamp))
    return plumbing


def convert_repeated_query_to_plumbing(porcelains):
    return [convert_query_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_query_to_porcelain(plumbings):
    return [convert_query_to_porcelain(plumbing) for plumbing in plumbings]


def convert_query_capture_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.QueryCapture()
    porcelain.client_command = (plumbing.client_command)
    porcelain.command = (plumbing.command)
    porcelain.container = (plumbing.container)
    porcelain.env = (plumbing.env)
    porcelain.file_name = (plumbing.file_name)
    porcelain.file_size = (plumbing.file_size)
    porcelain.height = (plumbing.height)
    porcelain.impersonation_groups = (plumbing.impersonation_groups)
    porcelain.impersonation_user = (plumbing.impersonation_user)
    porcelain.pod = (plumbing.pod)
    porcelain.privilege_groups = (plumbing.privilege_groups)
    porcelain.request_body = (plumbing.request_body)
    porcelain.request_method = (plumbing.request_method)
    porcelain.request_uri = (plumbing.request_uri)
    porcelain.type = (plumbing.type)
    porcelain.width = (plumbing.width)
    return porcelain


def convert_query_capture_to_plumbing(porcelain):
    plumbing = QueryCapture()
    if porcelain is None:
        return plumbing
    plumbing.client_command = (porcelain.client_command)
    plumbing.command = (porcelain.command)
    plumbing.container = (porcelain.container)
    plumbing.env.CopyFrom((porcelain.env))
    plumbing.file_name = (porcelain.file_name)
    plumbing.file_size = (porcelain.file_size)
    plumbing.height = (porcelain.height)
    del plumbing.impersonation_groups[:]
    plumbing.impersonation_groups.extend((porcelain.impersonation_groups))
    plumbing.impersonation_user = (porcelain.impersonation_user)
    plumbing.pod = (porcelain.pod)
    del plumbing.privilege_groups[:]
    plumbing.privilege_groups.extend((porcelain.privilege_groups))
    plumbing.request_body = (porcelain.request_body)
    plumbing.request_method = (porcelain.request_method)
    plumbing.request_uri = (porcelain.request_uri)
    plumbing.type = (porcelain.type)
    plumbing.width = (porcelain.width)
    return plumbing


def convert_repeated_query_capture_to_plumbing(porcelains):
    return [
        convert_query_capture_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_query_capture_to_porcelain(plumbings):
    return [
        convert_query_capture_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_rdp_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RDP()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.downgrade_nla_connections = (plumbing.downgrade_nla_connections)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.lock_required = (plumbing.lock_required)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_rdp_to_plumbing(porcelain):
    plumbing = RDP()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.downgrade_nla_connections = (porcelain.downgrade_nla_connections)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.lock_required = (porcelain.lock_required)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_rdp_to_plumbing(porcelains):
    return [convert_rdp_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_rdp_to_porcelain(plumbings):
    return [convert_rdp_to_porcelain(plumbing) for plumbing in plumbings]


def convert_rdp_cert_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RDPCert()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.identity_alias_healthcheck_username = (
        plumbing.identity_alias_healthcheck_username)
    porcelain.identity_set_id = (plumbing.identity_set_id)
    porcelain.lock_required = (plumbing.lock_required)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_rdp_cert_to_plumbing(porcelain):
    plumbing = RDPCert()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.identity_alias_healthcheck_username = (
        porcelain.identity_alias_healthcheck_username)
    plumbing.identity_set_id = (porcelain.identity_set_id)
    plumbing.lock_required = (porcelain.lock_required)
    plumbing.name = (porcelain.name)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_rdp_cert_to_plumbing(porcelains):
    return [
        convert_rdp_cert_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_rdp_cert_to_porcelain(plumbings):
    return [convert_rdp_cert_to_porcelain(plumbing) for plumbing in plumbings]


def convert_rds_postgres_iam_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RDSPostgresIAM()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.override_database = (plumbing.override_database)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.region = (plumbing.region)
    porcelain.role_assumption_arn = (plumbing.role_assumption_arn)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_rds_postgres_iam_to_plumbing(porcelain):
    plumbing = RDSPostgresIAM()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.override_database = (porcelain.override_database)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.region = (porcelain.region)
    plumbing.role_assumption_arn = (porcelain.role_assumption_arn)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_rds_postgres_iam_to_plumbing(porcelains):
    return [
        convert_rds_postgres_iam_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_rds_postgres_iam_to_porcelain(plumbings):
    return [
        convert_rds_postgres_iam_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_rabbit_mqamqp_091_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RabbitMQAMQP091()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tls_required = (plumbing.tls_required)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_rabbit_mqamqp_091_to_plumbing(porcelain):
    plumbing = RabbitMQAMQP091()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.tls_required = (porcelain.tls_required)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_rabbit_mqamqp_091_to_plumbing(porcelains):
    return [
        convert_rabbit_mqamqp_091_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_rabbit_mqamqp_091_to_porcelain(plumbings):
    return [
        convert_rabbit_mqamqp_091_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_rate_limit_metadata_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RateLimitMetadata()
    porcelain.bucket = (plumbing.bucket)
    porcelain.limit = (plumbing.limit)
    porcelain.remaining = (plumbing.remaining)
    porcelain.reset_at = convert_timestamp_to_porcelain(plumbing.reset_at)
    return porcelain


def convert_rate_limit_metadata_to_plumbing(porcelain):
    plumbing = RateLimitMetadata()
    if porcelain is None:
        return plumbing
    plumbing.bucket = (porcelain.bucket)
    plumbing.limit = (porcelain.limit)
    plumbing.remaining = (porcelain.remaining)
    plumbing.reset_at.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.reset_at))
    return plumbing


def convert_repeated_rate_limit_metadata_to_plumbing(porcelains):
    return [
        convert_rate_limit_metadata_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_rate_limit_metadata_to_porcelain(plumbings):
    return [
        convert_rate_limit_metadata_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_raw_tcp_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RawTCP()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_raw_tcp_to_plumbing(porcelain):
    plumbing = RawTCP()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_raw_tcp_to_plumbing(porcelains):
    return [convert_raw_tcp_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_raw_tcp_to_porcelain(plumbings):
    return [convert_raw_tcp_to_porcelain(plumbing) for plumbing in plumbings]


def convert_redis_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Redis()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tls_required = (plumbing.tls_required)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_redis_to_plumbing(porcelain):
    plumbing = Redis()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.tls_required = (porcelain.tls_required)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_redis_to_plumbing(porcelains):
    return [convert_redis_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_redis_to_porcelain(plumbings):
    return [convert_redis_to_porcelain(plumbing) for plumbing in plumbings]


def convert_redis_cluster_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RedisCluster()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tls_required = (plumbing.tls_required)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_redis_cluster_to_plumbing(porcelain):
    plumbing = RedisCluster()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.tls_required = (porcelain.tls_required)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_redis_cluster_to_plumbing(porcelains):
    return [
        convert_redis_cluster_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_redis_cluster_to_porcelain(plumbings):
    return [
        convert_redis_cluster_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_redshift_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Redshift()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.override_database = (plumbing.override_database)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_redshift_to_plumbing(porcelain):
    plumbing = Redshift()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.override_database = (porcelain.override_database)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_redshift_to_plumbing(porcelains):
    return [
        convert_redshift_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_redshift_to_porcelain(plumbings):
    return [convert_redshift_to_porcelain(plumbing) for plumbing in plumbings]


def convert_redshift_iam_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RedshiftIAM()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.cluster_id = (plumbing.cluster_id)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.override_database = (plumbing.override_database)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.region = (plumbing.region)
    porcelain.role_assumption_arn = (plumbing.role_assumption_arn)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_redshift_iam_to_plumbing(porcelain):
    plumbing = RedshiftIAM()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.cluster_id = (porcelain.cluster_id)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.override_database = (porcelain.override_database)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.region = (porcelain.region)
    plumbing.role_assumption_arn = (porcelain.role_assumption_arn)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_redshift_iam_to_plumbing(porcelains):
    return [
        convert_redshift_iam_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_redshift_iam_to_porcelain(plumbings):
    return [
        convert_redshift_iam_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_redshift_serverless_iam_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RedshiftServerlessIAM()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.override_database = (plumbing.override_database)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.region = (plumbing.region)
    porcelain.role_assumption_arn = (plumbing.role_assumption_arn)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.workgroup = (plumbing.workgroup)
    return porcelain


def convert_redshift_serverless_iam_to_plumbing(porcelain):
    plumbing = RedshiftServerlessIAM()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.override_database = (porcelain.override_database)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.region = (porcelain.region)
    plumbing.role_assumption_arn = (porcelain.role_assumption_arn)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.workgroup = (porcelain.workgroup)
    return plumbing


def convert_repeated_redshift_serverless_iam_to_plumbing(porcelains):
    return [
        convert_redshift_serverless_iam_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_redshift_serverless_iam_to_porcelain(plumbings):
    return [
        convert_redshift_serverless_iam_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_relay_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Relay()
    porcelain.device = (plumbing.device)
    porcelain.gateway_filter = (plumbing.gateway_filter)
    porcelain.id = (plumbing.id)
    porcelain.location = (plumbing.location)
    porcelain.maintenance_windows = convert_repeated_node_maintenance_window_to_porcelain(
        plumbing.maintenance_windows)
    porcelain.name = (plumbing.name)
    porcelain.state = (plumbing.state)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.version = (plumbing.version)
    return porcelain


def convert_relay_to_plumbing(porcelain):
    plumbing = Relay()
    if porcelain is None:
        return plumbing
    plumbing.device = (porcelain.device)
    plumbing.gateway_filter = (porcelain.gateway_filter)
    plumbing.id = (porcelain.id)
    plumbing.location = (porcelain.location)
    del plumbing.maintenance_windows[:]
    plumbing.maintenance_windows.extend(
        convert_repeated_node_maintenance_window_to_plumbing(
            porcelain.maintenance_windows))
    plumbing.name = (porcelain.name)
    plumbing.state = (porcelain.state)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.version = (porcelain.version)
    return plumbing


def convert_repeated_relay_to_plumbing(porcelains):
    return [convert_relay_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_relay_to_porcelain(plumbings):
    return [convert_relay_to_porcelain(plumbing) for plumbing in plumbings]


def convert_remote_identity_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RemoteIdentity()
    porcelain.account_id = (plumbing.account_id)
    porcelain.id = (plumbing.id)
    porcelain.remote_identity_group_id = (plumbing.remote_identity_group_id)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_remote_identity_to_plumbing(porcelain):
    plumbing = RemoteIdentity()
    if porcelain is None:
        return plumbing
    plumbing.account_id = (porcelain.account_id)
    plumbing.id = (porcelain.id)
    plumbing.remote_identity_group_id = (porcelain.remote_identity_group_id)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_remote_identity_to_plumbing(porcelains):
    return [
        convert_remote_identity_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_remote_identity_to_porcelain(plumbings):
    return [
        convert_remote_identity_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_remote_identity_create_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RemoteIdentityCreateResponse()
    porcelain.meta = convert_create_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.remote_identity = convert_remote_identity_to_porcelain(
        plumbing.remote_identity)
    return porcelain


def convert_remote_identity_create_response_to_plumbing(porcelain):
    plumbing = RemoteIdentityCreateResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_create_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    plumbing.remote_identity.CopyFrom(
        convert_remote_identity_to_plumbing(porcelain.remote_identity))
    return plumbing


def convert_repeated_remote_identity_create_response_to_plumbing(porcelains):
    return [
        convert_remote_identity_create_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_remote_identity_create_response_to_porcelain(plumbings):
    return [
        convert_remote_identity_create_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_remote_identity_delete_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RemoteIdentityDeleteResponse()
    porcelain.meta = convert_delete_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_remote_identity_delete_response_to_plumbing(porcelain):
    plumbing = RemoteIdentityDeleteResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_delete_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_remote_identity_delete_response_to_plumbing(porcelains):
    return [
        convert_remote_identity_delete_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_remote_identity_delete_response_to_porcelain(plumbings):
    return [
        convert_remote_identity_delete_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_remote_identity_get_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RemoteIdentityGetResponse()
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.remote_identity = convert_remote_identity_to_porcelain(
        plumbing.remote_identity)
    return porcelain


def convert_remote_identity_get_response_to_plumbing(porcelain):
    plumbing = RemoteIdentityGetResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_get_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    plumbing.remote_identity.CopyFrom(
        convert_remote_identity_to_plumbing(porcelain.remote_identity))
    return plumbing


def convert_repeated_remote_identity_get_response_to_plumbing(porcelains):
    return [
        convert_remote_identity_get_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_remote_identity_get_response_to_porcelain(plumbings):
    return [
        convert_remote_identity_get_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_remote_identity_group_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RemoteIdentityGroup()
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    return porcelain


def convert_remote_identity_group_to_plumbing(porcelain):
    plumbing = RemoteIdentityGroup()
    if porcelain is None:
        return plumbing
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    return plumbing


def convert_repeated_remote_identity_group_to_plumbing(porcelains):
    return [
        convert_remote_identity_group_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_remote_identity_group_to_porcelain(plumbings):
    return [
        convert_remote_identity_group_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_remote_identity_group_get_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RemoteIdentityGroupGetResponse()
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.remote_identity_group = convert_remote_identity_group_to_porcelain(
        plumbing.remote_identity_group)
    return porcelain


def convert_remote_identity_group_get_response_to_plumbing(porcelain):
    plumbing = RemoteIdentityGroupGetResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_get_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    plumbing.remote_identity_group.CopyFrom(
        convert_remote_identity_group_to_plumbing(
            porcelain.remote_identity_group))
    return plumbing


def convert_repeated_remote_identity_group_get_response_to_plumbing(
        porcelains):
    return [
        convert_remote_identity_group_get_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_remote_identity_group_get_response_to_porcelain(
        plumbings):
    return [
        convert_remote_identity_group_get_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_remote_identity_group_history_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RemoteIdentityGroupHistory()
    porcelain.activity_id = (plumbing.activity_id)
    porcelain.deleted_at = convert_timestamp_to_porcelain(plumbing.deleted_at)
    porcelain.remote_identity_group = convert_remote_identity_group_to_porcelain(
        plumbing.remote_identity_group)
    porcelain.timestamp = convert_timestamp_to_porcelain(plumbing.timestamp)
    return porcelain


def convert_remote_identity_group_history_to_plumbing(porcelain):
    plumbing = RemoteIdentityGroupHistory()
    if porcelain is None:
        return plumbing
    plumbing.activity_id = (porcelain.activity_id)
    plumbing.deleted_at.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.deleted_at))
    plumbing.remote_identity_group.CopyFrom(
        convert_remote_identity_group_to_plumbing(
            porcelain.remote_identity_group))
    plumbing.timestamp.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.timestamp))
    return plumbing


def convert_repeated_remote_identity_group_history_to_plumbing(porcelains):
    return [
        convert_remote_identity_group_history_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_remote_identity_group_history_to_porcelain(plumbings):
    return [
        convert_remote_identity_group_history_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_remote_identity_history_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RemoteIdentityHistory()
    porcelain.activity_id = (plumbing.activity_id)
    porcelain.deleted_at = convert_timestamp_to_porcelain(plumbing.deleted_at)
    porcelain.remote_identity = convert_remote_identity_to_porcelain(
        plumbing.remote_identity)
    porcelain.timestamp = convert_timestamp_to_porcelain(plumbing.timestamp)
    return porcelain


def convert_remote_identity_history_to_plumbing(porcelain):
    plumbing = RemoteIdentityHistory()
    if porcelain is None:
        return plumbing
    plumbing.activity_id = (porcelain.activity_id)
    plumbing.deleted_at.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.deleted_at))
    plumbing.remote_identity.CopyFrom(
        convert_remote_identity_to_plumbing(porcelain.remote_identity))
    plumbing.timestamp.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.timestamp))
    return plumbing


def convert_repeated_remote_identity_history_to_plumbing(porcelains):
    return [
        convert_remote_identity_history_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_remote_identity_history_to_porcelain(plumbings):
    return [
        convert_remote_identity_history_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_remote_identity_update_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RemoteIdentityUpdateResponse()
    porcelain.meta = convert_update_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.remote_identity = convert_remote_identity_to_porcelain(
        plumbing.remote_identity)
    return porcelain


def convert_remote_identity_update_response_to_plumbing(porcelain):
    plumbing = RemoteIdentityUpdateResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_update_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    plumbing.remote_identity.CopyFrom(
        convert_remote_identity_to_plumbing(porcelain.remote_identity))
    return plumbing


def convert_repeated_remote_identity_update_response_to_plumbing(porcelains):
    return [
        convert_remote_identity_update_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_remote_identity_update_response_to_porcelain(plumbings):
    return [
        convert_remote_identity_update_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_replay_chunk_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ReplayChunk()
    porcelain.data = (plumbing.data)
    porcelain.events = convert_repeated_replay_chunk_event_to_porcelain(
        plumbing.events)
    porcelain.symmetric_key = (plumbing.symmetric_key)
    return porcelain


def convert_replay_chunk_to_plumbing(porcelain):
    plumbing = ReplayChunk()
    if porcelain is None:
        return plumbing
    plumbing.data = (porcelain.data)
    del plumbing.events[:]
    plumbing.events.extend(
        convert_repeated_replay_chunk_event_to_plumbing(porcelain.events))
    plumbing.symmetric_key = (porcelain.symmetric_key)
    return plumbing


def convert_repeated_replay_chunk_to_plumbing(porcelains):
    return [
        convert_replay_chunk_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_replay_chunk_to_porcelain(plumbings):
    return [
        convert_replay_chunk_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_replay_chunk_event_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ReplayChunkEvent()
    porcelain.data = (plumbing.data)
    porcelain.duration = convert_duration_to_porcelain(plumbing.duration)
    return porcelain


def convert_replay_chunk_event_to_plumbing(porcelain):
    plumbing = ReplayChunkEvent()
    if porcelain is None:
        return plumbing
    plumbing.data = (porcelain.data)
    plumbing.duration.CopyFrom(convert_duration_to_plumbing(
        porcelain.duration))
    return plumbing


def convert_repeated_replay_chunk_event_to_plumbing(porcelains):
    return [
        convert_replay_chunk_event_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_replay_chunk_event_to_porcelain(plumbings):
    return [
        convert_replay_chunk_event_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_requestable_resource_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RequestableResource()
    porcelain.access = (plumbing.access)
    porcelain.authentication = (plumbing.authentication)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.type = (plumbing.type)
    return porcelain


def convert_requestable_resource_to_plumbing(porcelain):
    plumbing = RequestableResource()
    if porcelain is None:
        return plumbing
    plumbing.access = (porcelain.access)
    plumbing.authentication = (porcelain.authentication)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.type = (porcelain.type)
    return plumbing


def convert_repeated_requestable_resource_to_plumbing(porcelains):
    return [
        convert_requestable_resource_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_requestable_resource_to_porcelain(plumbings):
    return [
        convert_requestable_resource_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_resource_to_plumbing(porcelain):
    plumbing = Resource()
    if porcelain is None:
        return plumbing
    if isinstance(porcelain, models.Aerospike):
        plumbing.aerospike.CopyFrom(convert_aerospike_to_plumbing(porcelain))
    if isinstance(porcelain, models.AKS):
        plumbing.aks.CopyFrom(convert_aks_to_plumbing(porcelain))
    if isinstance(porcelain, models.AKSBasicAuth):
        plumbing.aks_basic_auth.CopyFrom(
            convert_aks_basic_auth_to_plumbing(porcelain))
    if isinstance(porcelain, models.AKSServiceAccount):
        plumbing.aks_service_account.CopyFrom(
            convert_aks_service_account_to_plumbing(porcelain))
    if isinstance(porcelain, models.AKSServiceAccountUserImpersonation):
        plumbing.aks_service_account_user_impersonation.CopyFrom(
            convert_aks_service_account_user_impersonation_to_plumbing(
                porcelain))
    if isinstance(porcelain, models.AKSUserImpersonation):
        plumbing.aks_user_impersonation.CopyFrom(
            convert_aks_user_impersonation_to_plumbing(porcelain))
    if isinstance(porcelain, models.AmazonEKS):
        plumbing.amazon_eks.CopyFrom(convert_amazon_eks_to_plumbing(porcelain))
    if isinstance(porcelain, models.AmazonEKSInstanceProfile):
        plumbing.amazon_eks_instance_profile.CopyFrom(
            convert_amazon_eks_instance_profile_to_plumbing(porcelain))
    if isinstance(porcelain, models.AmazonEKSInstanceProfileUserImpersonation):
        plumbing.amazon_eks_instance_profile_user_impersonation.CopyFrom(
            convert_amazon_eks_instance_profile_user_impersonation_to_plumbing(
                porcelain))
    if isinstance(porcelain, models.AmazonEKSUserImpersonation):
        plumbing.amazon_eks_user_impersonation.CopyFrom(
            convert_amazon_eks_user_impersonation_to_plumbing(porcelain))
    if isinstance(porcelain, models.AmazonES):
        plumbing.amazon_es.CopyFrom(convert_amazon_es_to_plumbing(porcelain))
    if isinstance(porcelain, models.AmazonESIAM):
        plumbing.amazon_esiam.CopyFrom(
            convert_amazon_esiam_to_plumbing(porcelain))
    if isinstance(porcelain, models.AmazonMQAMQP091):
        plumbing.amazon_mqamqp_091.CopyFrom(
            convert_amazon_mqamqp_091_to_plumbing(porcelain))
    if isinstance(porcelain, models.Athena):
        plumbing.athena.CopyFrom(convert_athena_to_plumbing(porcelain))
    if isinstance(porcelain, models.AthenaIAM):
        plumbing.athena_iam.CopyFrom(convert_athena_iam_to_plumbing(porcelain))
    if isinstance(porcelain, models.AuroraMysql):
        plumbing.aurora_mysql.CopyFrom(
            convert_aurora_mysql_to_plumbing(porcelain))
    if isinstance(porcelain, models.AuroraMysqlIAM):
        plumbing.aurora_mysql_iam.CopyFrom(
            convert_aurora_mysql_iam_to_plumbing(porcelain))
    if isinstance(porcelain, models.AuroraPostgres):
        plumbing.aurora_postgres.CopyFrom(
            convert_aurora_postgres_to_plumbing(porcelain))
    if isinstance(porcelain, models.AuroraPostgresIAM):
        plumbing.aurora_postgres_iam.CopyFrom(
            convert_aurora_postgres_iam_to_plumbing(porcelain))
    if isinstance(porcelain, models.AWS):
        plumbing.aws.CopyFrom(convert_aws_to_plumbing(porcelain))
    if isinstance(porcelain, models.AWSConsole):
        plumbing.aws_console.CopyFrom(
            convert_aws_console_to_plumbing(porcelain))
    if isinstance(porcelain, models.AWSConsoleStaticKeyPair):
        plumbing.aws_console_static_key_pair.CopyFrom(
            convert_aws_console_static_key_pair_to_plumbing(porcelain))
    if isinstance(porcelain, models.AWSInstanceProfile):
        plumbing.aws_instance_profile.CopyFrom(
            convert_aws_instance_profile_to_plumbing(porcelain))
    if isinstance(porcelain, models.Azure):
        plumbing.azure.CopyFrom(convert_azure_to_plumbing(porcelain))
    if isinstance(porcelain, models.AzureCertificate):
        plumbing.azure_certificate.CopyFrom(
            convert_azure_certificate_to_plumbing(porcelain))
    if isinstance(porcelain, models.AzureMysql):
        plumbing.azure_mysql.CopyFrom(
            convert_azure_mysql_to_plumbing(porcelain))
    if isinstance(porcelain, models.AzurePostgres):
        plumbing.azure_postgres.CopyFrom(
            convert_azure_postgres_to_plumbing(porcelain))
    if isinstance(porcelain, models.AzurePostgresManagedIdentity):
        plumbing.azure_postgres_managed_identity.CopyFrom(
            convert_azure_postgres_managed_identity_to_plumbing(porcelain))
    if isinstance(porcelain, models.BigQuery):
        plumbing.big_query.CopyFrom(convert_big_query_to_plumbing(porcelain))
    if isinstance(porcelain, models.Cassandra):
        plumbing.cassandra.CopyFrom(convert_cassandra_to_plumbing(porcelain))
    if isinstance(porcelain, models.Citus):
        plumbing.citus.CopyFrom(convert_citus_to_plumbing(porcelain))
    if isinstance(porcelain, models.ClickHouseHTTP):
        plumbing.click_house_http.CopyFrom(
            convert_click_house_http_to_plumbing(porcelain))
    if isinstance(porcelain, models.ClickHouseMySQL):
        plumbing.click_house_my_sql.CopyFrom(
            convert_click_house_my_sql_to_plumbing(porcelain))
    if isinstance(porcelain, models.ClickHouseTCP):
        plumbing.click_house_tcp.CopyFrom(
            convert_click_house_tcp_to_plumbing(porcelain))
    if isinstance(porcelain, models.Clustrix):
        plumbing.clustrix.CopyFrom(convert_clustrix_to_plumbing(porcelain))
    if isinstance(porcelain, models.Cockroach):
        plumbing.cockroach.CopyFrom(convert_cockroach_to_plumbing(porcelain))
    if isinstance(porcelain, models.CouchbaseDatabase):
        plumbing.couchbase_database.CopyFrom(
            convert_couchbase_database_to_plumbing(porcelain))
    if isinstance(porcelain, models.CouchbaseWebUI):
        plumbing.couchbase_web_ui.CopyFrom(
            convert_couchbase_web_ui_to_plumbing(porcelain))
    if isinstance(porcelain, models.DB2I):
        plumbing.db_2_i.CopyFrom(convert_db_2_i_to_plumbing(porcelain))
    if isinstance(porcelain, models.DB2LUW):
        plumbing.db_2_luw.CopyFrom(convert_db_2_luw_to_plumbing(porcelain))
    if isinstance(porcelain, models.DocumentDBHost):
        plumbing.document_db_host.CopyFrom(
            convert_document_db_host_to_plumbing(porcelain))
    if isinstance(porcelain, models.DocumentDBHostIAM):
        plumbing.document_db_host_iam.CopyFrom(
            convert_document_db_host_iam_to_plumbing(porcelain))
    if isinstance(porcelain, models.DocumentDBReplicaSet):
        plumbing.document_db_replica_set.CopyFrom(
            convert_document_db_replica_set_to_plumbing(porcelain))
    if isinstance(porcelain, models.DocumentDBReplicaSetIAM):
        plumbing.document_db_replica_set_iam.CopyFrom(
            convert_document_db_replica_set_iam_to_plumbing(porcelain))
    if isinstance(porcelain, models.Druid):
        plumbing.druid.CopyFrom(convert_druid_to_plumbing(porcelain))
    if isinstance(porcelain, models.DynamoDB):
        plumbing.dynamo_db.CopyFrom(convert_dynamo_db_to_plumbing(porcelain))
    if isinstance(porcelain, models.DynamoDBIAM):
        plumbing.dynamo_dbiam.CopyFrom(
            convert_dynamo_dbiam_to_plumbing(porcelain))
    if isinstance(porcelain, models.Elastic):
        plumbing.elastic.CopyFrom(convert_elastic_to_plumbing(porcelain))
    if isinstance(porcelain, models.ElasticacheRedis):
        plumbing.elasticache_redis.CopyFrom(
            convert_elasticache_redis_to_plumbing(porcelain))
    if isinstance(porcelain, models.GCP):
        plumbing.gcp.CopyFrom(convert_gcp_to_plumbing(porcelain))
    if isinstance(porcelain, models.GCPConsole):
        plumbing.gcp_console.CopyFrom(
            convert_gcp_console_to_plumbing(porcelain))
    if isinstance(porcelain, models.GCPWIF):
        plumbing.gcpwif.CopyFrom(convert_gcpwif_to_plumbing(porcelain))
    if isinstance(porcelain, models.GoogleGKE):
        plumbing.google_gke.CopyFrom(convert_google_gke_to_plumbing(porcelain))
    if isinstance(porcelain, models.GoogleGKEUserImpersonation):
        plumbing.google_gke_user_impersonation.CopyFrom(
            convert_google_gke_user_impersonation_to_plumbing(porcelain))
    if isinstance(porcelain, models.Greenplum):
        plumbing.greenplum.CopyFrom(convert_greenplum_to_plumbing(porcelain))
    if isinstance(porcelain, models.HTTPAuth):
        plumbing.http_auth.CopyFrom(convert_http_auth_to_plumbing(porcelain))
    if isinstance(porcelain, models.HTTPBasicAuth):
        plumbing.http_basic_auth.CopyFrom(
            convert_http_basic_auth_to_plumbing(porcelain))
    if isinstance(porcelain, models.HTTPNoAuth):
        plumbing.http_no_auth.CopyFrom(
            convert_http_no_auth_to_plumbing(porcelain))
    if isinstance(porcelain, models.Kubernetes):
        plumbing.kubernetes.CopyFrom(convert_kubernetes_to_plumbing(porcelain))
    if isinstance(porcelain, models.KubernetesBasicAuth):
        plumbing.kubernetes_basic_auth.CopyFrom(
            convert_kubernetes_basic_auth_to_plumbing(porcelain))
    if isinstance(porcelain, models.KubernetesPodIdentity):
        plumbing.kubernetes_pod_identity.CopyFrom(
            convert_kubernetes_pod_identity_to_plumbing(porcelain))
    if isinstance(porcelain, models.KubernetesServiceAccount):
        plumbing.kubernetes_service_account.CopyFrom(
            convert_kubernetes_service_account_to_plumbing(porcelain))
    if isinstance(porcelain, models.KubernetesServiceAccountUserImpersonation):
        plumbing.kubernetes_service_account_user_impersonation.CopyFrom(
            convert_kubernetes_service_account_user_impersonation_to_plumbing(
                porcelain))
    if isinstance(porcelain, models.KubernetesUserImpersonation):
        plumbing.kubernetes_user_impersonation.CopyFrom(
            convert_kubernetes_user_impersonation_to_plumbing(porcelain))
    if isinstance(porcelain, models.Maria):
        plumbing.maria.CopyFrom(convert_maria_to_plumbing(porcelain))
    if isinstance(porcelain, models.Memcached):
        plumbing.memcached.CopyFrom(convert_memcached_to_plumbing(porcelain))
    if isinstance(porcelain, models.Memsql):
        plumbing.memsql.CopyFrom(convert_memsql_to_plumbing(porcelain))
    if isinstance(porcelain, models.MongoHost):
        plumbing.mongo_host.CopyFrom(convert_mongo_host_to_plumbing(porcelain))
    if isinstance(porcelain, models.MongoLegacyHost):
        plumbing.mongo_legacy_host.CopyFrom(
            convert_mongo_legacy_host_to_plumbing(porcelain))
    if isinstance(porcelain, models.MongoLegacyReplicaset):
        plumbing.mongo_legacy_replicaset.CopyFrom(
            convert_mongo_legacy_replicaset_to_plumbing(porcelain))
    if isinstance(porcelain, models.MongoReplicaSet):
        plumbing.mongo_replica_set.CopyFrom(
            convert_mongo_replica_set_to_plumbing(porcelain))
    if isinstance(porcelain, models.MongoShardedCluster):
        plumbing.mongo_sharded_cluster.CopyFrom(
            convert_mongo_sharded_cluster_to_plumbing(porcelain))
    if isinstance(porcelain, models.MTLSMysql):
        plumbing.mtls_mysql.CopyFrom(convert_mtls_mysql_to_plumbing(porcelain))
    if isinstance(porcelain, models.MTLSPostgres):
        plumbing.mtls_postgres.CopyFrom(
            convert_mtls_postgres_to_plumbing(porcelain))
    if isinstance(porcelain, models.Mysql):
        plumbing.mysql.CopyFrom(convert_mysql_to_plumbing(porcelain))
    if isinstance(porcelain, models.Neptune):
        plumbing.neptune.CopyFrom(convert_neptune_to_plumbing(porcelain))
    if isinstance(porcelain, models.NeptuneIAM):
        plumbing.neptune_iam.CopyFrom(
            convert_neptune_iam_to_plumbing(porcelain))
    if isinstance(porcelain, models.Oracle):
        plumbing.oracle.CopyFrom(convert_oracle_to_plumbing(porcelain))
    if isinstance(porcelain, models.OracleNNE):
        plumbing.oracle_nne.CopyFrom(convert_oracle_nne_to_plumbing(porcelain))
    if isinstance(porcelain, models.Postgres):
        plumbing.postgres.CopyFrom(convert_postgres_to_plumbing(porcelain))
    if isinstance(porcelain, models.Presto):
        plumbing.presto.CopyFrom(convert_presto_to_plumbing(porcelain))
    if isinstance(porcelain, models.RabbitMQAMQP091):
        plumbing.rabbit_mqamqp_091.CopyFrom(
            convert_rabbit_mqamqp_091_to_plumbing(porcelain))
    if isinstance(porcelain, models.RawTCP):
        plumbing.raw_tcp.CopyFrom(convert_raw_tcp_to_plumbing(porcelain))
    if isinstance(porcelain, models.RDP):
        plumbing.rdp.CopyFrom(convert_rdp_to_plumbing(porcelain))
    if isinstance(porcelain, models.RDPCert):
        plumbing.rdp_cert.CopyFrom(convert_rdp_cert_to_plumbing(porcelain))
    if isinstance(porcelain, models.RDSPostgresIAM):
        plumbing.rds_postgres_iam.CopyFrom(
            convert_rds_postgres_iam_to_plumbing(porcelain))
    if isinstance(porcelain, models.Redis):
        plumbing.redis.CopyFrom(convert_redis_to_plumbing(porcelain))
    if isinstance(porcelain, models.RedisCluster):
        plumbing.redis_cluster.CopyFrom(
            convert_redis_cluster_to_plumbing(porcelain))
    if isinstance(porcelain, models.Redshift):
        plumbing.redshift.CopyFrom(convert_redshift_to_plumbing(porcelain))
    if isinstance(porcelain, models.RedshiftIAM):
        plumbing.redshift_iam.CopyFrom(
            convert_redshift_iam_to_plumbing(porcelain))
    if isinstance(porcelain, models.RedshiftServerlessIAM):
        plumbing.redshift_serverless_iam.CopyFrom(
            convert_redshift_serverless_iam_to_plumbing(porcelain))
    if isinstance(porcelain, models.SingleStore):
        plumbing.single_store.CopyFrom(
            convert_single_store_to_plumbing(porcelain))
    if isinstance(porcelain, models.Snowflake):
        plumbing.snowflake.CopyFrom(convert_snowflake_to_plumbing(porcelain))
    if isinstance(porcelain, models.Snowsight):
        plumbing.snowsight.CopyFrom(convert_snowsight_to_plumbing(porcelain))
    if isinstance(porcelain, models.SQLServer):
        plumbing.sql_server.CopyFrom(convert_sql_server_to_plumbing(porcelain))
    if isinstance(porcelain, models.SQLServerAzureAD):
        plumbing.sql_server_azure_ad.CopyFrom(
            convert_sql_server_azure_ad_to_plumbing(porcelain))
    if isinstance(porcelain, models.SQLServerKerberosAD):
        plumbing.sql_server_kerberos_ad.CopyFrom(
            convert_sql_server_kerberos_ad_to_plumbing(porcelain))
    if isinstance(porcelain, models.SSH):
        plumbing.ssh.CopyFrom(convert_ssh_to_plumbing(porcelain))
    if isinstance(porcelain, models.SSHCert):
        plumbing.ssh_cert.CopyFrom(convert_ssh_cert_to_plumbing(porcelain))
    if isinstance(porcelain, models.SSHCustomerKey):
        plumbing.ssh_customer_key.CopyFrom(
            convert_ssh_customer_key_to_plumbing(porcelain))
    if isinstance(porcelain, models.SSHPassword):
        plumbing.ssh_password.CopyFrom(
            convert_ssh_password_to_plumbing(porcelain))
    if isinstance(porcelain, models.Sybase):
        plumbing.sybase.CopyFrom(convert_sybase_to_plumbing(porcelain))
    if isinstance(porcelain, models.SybaseIQ):
        plumbing.sybase_iq.CopyFrom(convert_sybase_iq_to_plumbing(porcelain))
    if isinstance(porcelain, models.Teradata):
        plumbing.teradata.CopyFrom(convert_teradata_to_plumbing(porcelain))
    if isinstance(porcelain, models.Trino):
        plumbing.trino.CopyFrom(convert_trino_to_plumbing(porcelain))
    if isinstance(porcelain, models.Vertica):
        plumbing.vertica.CopyFrom(convert_vertica_to_plumbing(porcelain))
    return plumbing


def convert_resource_to_porcelain(plumbing):
    if plumbing is None:
        return None
    if plumbing.HasField('aerospike'):
        return convert_aerospike_to_porcelain(plumbing.aerospike)
    if plumbing.HasField('aks'):
        return convert_aks_to_porcelain(plumbing.aks)
    if plumbing.HasField('aks_basic_auth'):
        return convert_aks_basic_auth_to_porcelain(plumbing.aks_basic_auth)
    if plumbing.HasField('aks_service_account'):
        return convert_aks_service_account_to_porcelain(
            plumbing.aks_service_account)
    if plumbing.HasField('aks_service_account_user_impersonation'):
        return convert_aks_service_account_user_impersonation_to_porcelain(
            plumbing.aks_service_account_user_impersonation)
    if plumbing.HasField('aks_user_impersonation'):
        return convert_aks_user_impersonation_to_porcelain(
            plumbing.aks_user_impersonation)
    if plumbing.HasField('amazon_eks'):
        return convert_amazon_eks_to_porcelain(plumbing.amazon_eks)
    if plumbing.HasField('amazon_eks_instance_profile'):
        return convert_amazon_eks_instance_profile_to_porcelain(
            plumbing.amazon_eks_instance_profile)
    if plumbing.HasField('amazon_eks_instance_profile_user_impersonation'):
        return convert_amazon_eks_instance_profile_user_impersonation_to_porcelain(
            plumbing.amazon_eks_instance_profile_user_impersonation)
    if plumbing.HasField('amazon_eks_user_impersonation'):
        return convert_amazon_eks_user_impersonation_to_porcelain(
            plumbing.amazon_eks_user_impersonation)
    if plumbing.HasField('amazon_es'):
        return convert_amazon_es_to_porcelain(plumbing.amazon_es)
    if plumbing.HasField('amazon_esiam'):
        return convert_amazon_esiam_to_porcelain(plumbing.amazon_esiam)
    if plumbing.HasField('amazon_mqamqp_091'):
        return convert_amazon_mqamqp_091_to_porcelain(
            plumbing.amazon_mqamqp_091)
    if plumbing.HasField('athena'):
        return convert_athena_to_porcelain(plumbing.athena)
    if plumbing.HasField('athena_iam'):
        return convert_athena_iam_to_porcelain(plumbing.athena_iam)
    if plumbing.HasField('aurora_mysql'):
        return convert_aurora_mysql_to_porcelain(plumbing.aurora_mysql)
    if plumbing.HasField('aurora_mysql_iam'):
        return convert_aurora_mysql_iam_to_porcelain(plumbing.aurora_mysql_iam)
    if plumbing.HasField('aurora_postgres'):
        return convert_aurora_postgres_to_porcelain(plumbing.aurora_postgres)
    if plumbing.HasField('aurora_postgres_iam'):
        return convert_aurora_postgres_iam_to_porcelain(
            plumbing.aurora_postgres_iam)
    if plumbing.HasField('aws'):
        return convert_aws_to_porcelain(plumbing.aws)
    if plumbing.HasField('aws_console'):
        return convert_aws_console_to_porcelain(plumbing.aws_console)
    if plumbing.HasField('aws_console_static_key_pair'):
        return convert_aws_console_static_key_pair_to_porcelain(
            plumbing.aws_console_static_key_pair)
    if plumbing.HasField('aws_instance_profile'):
        return convert_aws_instance_profile_to_porcelain(
            plumbing.aws_instance_profile)
    if plumbing.HasField('azure'):
        return convert_azure_to_porcelain(plumbing.azure)
    if plumbing.HasField('azure_certificate'):
        return convert_azure_certificate_to_porcelain(
            plumbing.azure_certificate)
    if plumbing.HasField('azure_mysql'):
        return convert_azure_mysql_to_porcelain(plumbing.azure_mysql)
    if plumbing.HasField('azure_postgres'):
        return convert_azure_postgres_to_porcelain(plumbing.azure_postgres)
    if plumbing.HasField('azure_postgres_managed_identity'):
        return convert_azure_postgres_managed_identity_to_porcelain(
            plumbing.azure_postgres_managed_identity)
    if plumbing.HasField('big_query'):
        return convert_big_query_to_porcelain(plumbing.big_query)
    if plumbing.HasField('cassandra'):
        return convert_cassandra_to_porcelain(plumbing.cassandra)
    if plumbing.HasField('citus'):
        return convert_citus_to_porcelain(plumbing.citus)
    if plumbing.HasField('click_house_http'):
        return convert_click_house_http_to_porcelain(plumbing.click_house_http)
    if plumbing.HasField('click_house_my_sql'):
        return convert_click_house_my_sql_to_porcelain(
            plumbing.click_house_my_sql)
    if plumbing.HasField('click_house_tcp'):
        return convert_click_house_tcp_to_porcelain(plumbing.click_house_tcp)
    if plumbing.HasField('clustrix'):
        return convert_clustrix_to_porcelain(plumbing.clustrix)
    if plumbing.HasField('cockroach'):
        return convert_cockroach_to_porcelain(plumbing.cockroach)
    if plumbing.HasField('couchbase_database'):
        return convert_couchbase_database_to_porcelain(
            plumbing.couchbase_database)
    if plumbing.HasField('couchbase_web_ui'):
        return convert_couchbase_web_ui_to_porcelain(plumbing.couchbase_web_ui)
    if plumbing.HasField('db_2_i'):
        return convert_db_2_i_to_porcelain(plumbing.db_2_i)
    if plumbing.HasField('db_2_luw'):
        return convert_db_2_luw_to_porcelain(plumbing.db_2_luw)
    if plumbing.HasField('document_db_host'):
        return convert_document_db_host_to_porcelain(plumbing.document_db_host)
    if plumbing.HasField('document_db_host_iam'):
        return convert_document_db_host_iam_to_porcelain(
            plumbing.document_db_host_iam)
    if plumbing.HasField('document_db_replica_set'):
        return convert_document_db_replica_set_to_porcelain(
            plumbing.document_db_replica_set)
    if plumbing.HasField('document_db_replica_set_iam'):
        return convert_document_db_replica_set_iam_to_porcelain(
            plumbing.document_db_replica_set_iam)
    if plumbing.HasField('druid'):
        return convert_druid_to_porcelain(plumbing.druid)
    if plumbing.HasField('dynamo_db'):
        return convert_dynamo_db_to_porcelain(plumbing.dynamo_db)
    if plumbing.HasField('dynamo_dbiam'):
        return convert_dynamo_dbiam_to_porcelain(plumbing.dynamo_dbiam)
    if plumbing.HasField('elastic'):
        return convert_elastic_to_porcelain(plumbing.elastic)
    if plumbing.HasField('elasticache_redis'):
        return convert_elasticache_redis_to_porcelain(
            plumbing.elasticache_redis)
    if plumbing.HasField('gcp'):
        return convert_gcp_to_porcelain(plumbing.gcp)
    if plumbing.HasField('gcp_console'):
        return convert_gcp_console_to_porcelain(plumbing.gcp_console)
    if plumbing.HasField('gcpwif'):
        return convert_gcpwif_to_porcelain(plumbing.gcpwif)
    if plumbing.HasField('google_gke'):
        return convert_google_gke_to_porcelain(plumbing.google_gke)
    if plumbing.HasField('google_gke_user_impersonation'):
        return convert_google_gke_user_impersonation_to_porcelain(
            plumbing.google_gke_user_impersonation)
    if plumbing.HasField('greenplum'):
        return convert_greenplum_to_porcelain(plumbing.greenplum)
    if plumbing.HasField('http_auth'):
        return convert_http_auth_to_porcelain(plumbing.http_auth)
    if plumbing.HasField('http_basic_auth'):
        return convert_http_basic_auth_to_porcelain(plumbing.http_basic_auth)
    if plumbing.HasField('http_no_auth'):
        return convert_http_no_auth_to_porcelain(plumbing.http_no_auth)
    if plumbing.HasField('kubernetes'):
        return convert_kubernetes_to_porcelain(plumbing.kubernetes)
    if plumbing.HasField('kubernetes_basic_auth'):
        return convert_kubernetes_basic_auth_to_porcelain(
            plumbing.kubernetes_basic_auth)
    if plumbing.HasField('kubernetes_pod_identity'):
        return convert_kubernetes_pod_identity_to_porcelain(
            plumbing.kubernetes_pod_identity)
    if plumbing.HasField('kubernetes_service_account'):
        return convert_kubernetes_service_account_to_porcelain(
            plumbing.kubernetes_service_account)
    if plumbing.HasField('kubernetes_service_account_user_impersonation'):
        return convert_kubernetes_service_account_user_impersonation_to_porcelain(
            plumbing.kubernetes_service_account_user_impersonation)
    if plumbing.HasField('kubernetes_user_impersonation'):
        return convert_kubernetes_user_impersonation_to_porcelain(
            plumbing.kubernetes_user_impersonation)
    if plumbing.HasField('maria'):
        return convert_maria_to_porcelain(plumbing.maria)
    if plumbing.HasField('memcached'):
        return convert_memcached_to_porcelain(plumbing.memcached)
    if plumbing.HasField('memsql'):
        return convert_memsql_to_porcelain(plumbing.memsql)
    if plumbing.HasField('mongo_host'):
        return convert_mongo_host_to_porcelain(plumbing.mongo_host)
    if plumbing.HasField('mongo_legacy_host'):
        return convert_mongo_legacy_host_to_porcelain(
            plumbing.mongo_legacy_host)
    if plumbing.HasField('mongo_legacy_replicaset'):
        return convert_mongo_legacy_replicaset_to_porcelain(
            plumbing.mongo_legacy_replicaset)
    if plumbing.HasField('mongo_replica_set'):
        return convert_mongo_replica_set_to_porcelain(
            plumbing.mongo_replica_set)
    if plumbing.HasField('mongo_sharded_cluster'):
        return convert_mongo_sharded_cluster_to_porcelain(
            plumbing.mongo_sharded_cluster)
    if plumbing.HasField('mtls_mysql'):
        return convert_mtls_mysql_to_porcelain(plumbing.mtls_mysql)
    if plumbing.HasField('mtls_postgres'):
        return convert_mtls_postgres_to_porcelain(plumbing.mtls_postgres)
    if plumbing.HasField('mysql'):
        return convert_mysql_to_porcelain(plumbing.mysql)
    if plumbing.HasField('neptune'):
        return convert_neptune_to_porcelain(plumbing.neptune)
    if plumbing.HasField('neptune_iam'):
        return convert_neptune_iam_to_porcelain(plumbing.neptune_iam)
    if plumbing.HasField('oracle'):
        return convert_oracle_to_porcelain(plumbing.oracle)
    if plumbing.HasField('oracle_nne'):
        return convert_oracle_nne_to_porcelain(plumbing.oracle_nne)
    if plumbing.HasField('postgres'):
        return convert_postgres_to_porcelain(plumbing.postgres)
    if plumbing.HasField('presto'):
        return convert_presto_to_porcelain(plumbing.presto)
    if plumbing.HasField('rabbit_mqamqp_091'):
        return convert_rabbit_mqamqp_091_to_porcelain(
            plumbing.rabbit_mqamqp_091)
    if plumbing.HasField('raw_tcp'):
        return convert_raw_tcp_to_porcelain(plumbing.raw_tcp)
    if plumbing.HasField('rdp'):
        return convert_rdp_to_porcelain(plumbing.rdp)
    if plumbing.HasField('rdp_cert'):
        return convert_rdp_cert_to_porcelain(plumbing.rdp_cert)
    if plumbing.HasField('rds_postgres_iam'):
        return convert_rds_postgres_iam_to_porcelain(plumbing.rds_postgres_iam)
    if plumbing.HasField('redis'):
        return convert_redis_to_porcelain(plumbing.redis)
    if plumbing.HasField('redis_cluster'):
        return convert_redis_cluster_to_porcelain(plumbing.redis_cluster)
    if plumbing.HasField('redshift'):
        return convert_redshift_to_porcelain(plumbing.redshift)
    if plumbing.HasField('redshift_iam'):
        return convert_redshift_iam_to_porcelain(plumbing.redshift_iam)
    if plumbing.HasField('redshift_serverless_iam'):
        return convert_redshift_serverless_iam_to_porcelain(
            plumbing.redshift_serverless_iam)
    if plumbing.HasField('single_store'):
        return convert_single_store_to_porcelain(plumbing.single_store)
    if plumbing.HasField('snowflake'):
        return convert_snowflake_to_porcelain(plumbing.snowflake)
    if plumbing.HasField('snowsight'):
        return convert_snowsight_to_porcelain(plumbing.snowsight)
    if plumbing.HasField('sql_server'):
        return convert_sql_server_to_porcelain(plumbing.sql_server)
    if plumbing.HasField('sql_server_azure_ad'):
        return convert_sql_server_azure_ad_to_porcelain(
            plumbing.sql_server_azure_ad)
    if plumbing.HasField('sql_server_kerberos_ad'):
        return convert_sql_server_kerberos_ad_to_porcelain(
            plumbing.sql_server_kerberos_ad)
    if plumbing.HasField('ssh'):
        return convert_ssh_to_porcelain(plumbing.ssh)
    if plumbing.HasField('ssh_cert'):
        return convert_ssh_cert_to_porcelain(plumbing.ssh_cert)
    if plumbing.HasField('ssh_customer_key'):
        return convert_ssh_customer_key_to_porcelain(plumbing.ssh_customer_key)
    if plumbing.HasField('ssh_password'):
        return convert_ssh_password_to_porcelain(plumbing.ssh_password)
    if plumbing.HasField('sybase'):
        return convert_sybase_to_porcelain(plumbing.sybase)
    if plumbing.HasField('sybase_iq'):
        return convert_sybase_iq_to_porcelain(plumbing.sybase_iq)
    if plumbing.HasField('teradata'):
        return convert_teradata_to_porcelain(plumbing.teradata)
    if plumbing.HasField('trino'):
        return convert_trino_to_porcelain(plumbing.trino)
    if plumbing.HasField('vertica'):
        return convert_vertica_to_porcelain(plumbing.vertica)
    raise errors.UnknownError(
        "unknown polymorphic type, please upgrade your SDK")


def convert_repeated_resource_to_plumbing(porcelains):
    return [
        convert_resource_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_resource_to_porcelain(plumbings):
    return [convert_resource_to_porcelain(plumbing) for plumbing in plumbings]


def convert_resource_create_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ResourceCreateResponse()
    porcelain.meta = convert_create_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.resource = convert_resource_to_porcelain(plumbing.resource)
    return porcelain


def convert_resource_create_response_to_plumbing(porcelain):
    plumbing = ResourceCreateResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_create_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    plumbing.resource.CopyFrom(convert_resource_to_plumbing(
        porcelain.resource))
    return plumbing


def convert_repeated_resource_create_response_to_plumbing(porcelains):
    return [
        convert_resource_create_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_resource_create_response_to_porcelain(plumbings):
    return [
        convert_resource_create_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_resource_delete_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ResourceDeleteResponse()
    porcelain.meta = convert_delete_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_resource_delete_response_to_plumbing(porcelain):
    plumbing = ResourceDeleteResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_delete_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_resource_delete_response_to_plumbing(porcelains):
    return [
        convert_resource_delete_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_resource_delete_response_to_porcelain(plumbings):
    return [
        convert_resource_delete_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_resource_get_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ResourceGetResponse()
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.resource = convert_resource_to_porcelain(plumbing.resource)
    return porcelain


def convert_resource_get_response_to_plumbing(porcelain):
    plumbing = ResourceGetResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_get_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    plumbing.resource.CopyFrom(convert_resource_to_plumbing(
        porcelain.resource))
    return plumbing


def convert_repeated_resource_get_response_to_plumbing(porcelains):
    return [
        convert_resource_get_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_resource_get_response_to_porcelain(plumbings):
    return [
        convert_resource_get_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_resource_healthcheck_request_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ResourceHealthcheckRequest()
    porcelain.id = (plumbing.id)
    return porcelain


def convert_resource_healthcheck_request_to_plumbing(porcelain):
    plumbing = ResourceHealthcheckRequest()
    if porcelain is None:
        return plumbing
    plumbing.id = (porcelain.id)
    return plumbing


def convert_repeated_resource_healthcheck_request_to_plumbing(porcelains):
    return [
        convert_resource_healthcheck_request_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_resource_healthcheck_request_to_porcelain(plumbings):
    return [
        convert_resource_healthcheck_request_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_resource_healthcheck_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ResourceHealthcheckResponse()
    porcelain.meta = convert_update_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_resource_healthcheck_response_to_plumbing(porcelain):
    plumbing = ResourceHealthcheckResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_update_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_resource_healthcheck_response_to_plumbing(porcelains):
    return [
        convert_resource_healthcheck_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_resource_healthcheck_response_to_porcelain(plumbings):
    return [
        convert_resource_healthcheck_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_resource_history_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ResourceHistory()
    porcelain.activity_id = (plumbing.activity_id)
    porcelain.deleted_at = convert_timestamp_to_porcelain(plumbing.deleted_at)
    porcelain.resource = convert_resource_to_porcelain(plumbing.resource)
    porcelain.timestamp = convert_timestamp_to_porcelain(plumbing.timestamp)
    return porcelain


def convert_resource_history_to_plumbing(porcelain):
    plumbing = ResourceHistory()
    if porcelain is None:
        return plumbing
    plumbing.activity_id = (porcelain.activity_id)
    plumbing.deleted_at.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.deleted_at))
    plumbing.resource.CopyFrom(convert_resource_to_plumbing(
        porcelain.resource))
    plumbing.timestamp.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.timestamp))
    return plumbing


def convert_repeated_resource_history_to_plumbing(porcelains):
    return [
        convert_resource_history_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_resource_history_to_porcelain(plumbings):
    return [
        convert_resource_history_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_resource_update_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ResourceUpdateResponse()
    porcelain.meta = convert_update_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.resource = convert_resource_to_porcelain(plumbing.resource)
    return porcelain


def convert_resource_update_response_to_plumbing(porcelain):
    plumbing = ResourceUpdateResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_update_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    plumbing.resource.CopyFrom(convert_resource_to_plumbing(
        porcelain.resource))
    return plumbing


def convert_repeated_resource_update_response_to_plumbing(porcelains):
    return [
        convert_resource_update_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_resource_update_response_to_porcelain(plumbings):
    return [
        convert_resource_update_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_role_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Role()
    porcelain.access_rules = convert_access_rules_to_porcelain(
        plumbing.access_rules)
    porcelain.id = (plumbing.id)
    porcelain.managed_by = (plumbing.managed_by)
    porcelain.name = (plumbing.name)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_role_to_plumbing(porcelain):
    plumbing = Role()
    if porcelain is None:
        return plumbing
    plumbing.access_rules = convert_access_rules_to_plumbing(
        porcelain.access_rules)
    plumbing.id = (porcelain.id)
    plumbing.managed_by = (porcelain.managed_by)
    plumbing.name = (porcelain.name)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_role_to_plumbing(porcelains):
    return [convert_role_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_role_to_porcelain(plumbings):
    return [convert_role_to_porcelain(plumbing) for plumbing in plumbings]


def convert_role_create_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RoleCreateResponse()
    porcelain.meta = convert_create_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.role = convert_role_to_porcelain(plumbing.role)
    return porcelain


def convert_role_create_response_to_plumbing(porcelain):
    plumbing = RoleCreateResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_create_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    plumbing.role.CopyFrom(convert_role_to_plumbing(porcelain.role))
    return plumbing


def convert_repeated_role_create_response_to_plumbing(porcelains):
    return [
        convert_role_create_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_role_create_response_to_porcelain(plumbings):
    return [
        convert_role_create_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_role_delete_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RoleDeleteResponse()
    porcelain.meta = convert_delete_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_role_delete_response_to_plumbing(porcelain):
    plumbing = RoleDeleteResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_delete_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_role_delete_response_to_plumbing(porcelains):
    return [
        convert_role_delete_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_role_delete_response_to_porcelain(plumbings):
    return [
        convert_role_delete_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_role_get_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RoleGetResponse()
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.role = convert_role_to_porcelain(plumbing.role)
    return porcelain


def convert_role_get_response_to_plumbing(porcelain):
    plumbing = RoleGetResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_get_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    plumbing.role.CopyFrom(convert_role_to_plumbing(porcelain.role))
    return plumbing


def convert_repeated_role_get_response_to_plumbing(porcelains):
    return [
        convert_role_get_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_role_get_response_to_porcelain(plumbings):
    return [
        convert_role_get_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_role_history_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RoleHistory()
    porcelain.activity_id = (plumbing.activity_id)
    porcelain.deleted_at = convert_timestamp_to_porcelain(plumbing.deleted_at)
    porcelain.role = convert_role_to_porcelain(plumbing.role)
    porcelain.timestamp = convert_timestamp_to_porcelain(plumbing.timestamp)
    return porcelain


def convert_role_history_to_plumbing(porcelain):
    plumbing = RoleHistory()
    if porcelain is None:
        return plumbing
    plumbing.activity_id = (porcelain.activity_id)
    plumbing.deleted_at.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.deleted_at))
    plumbing.role.CopyFrom(convert_role_to_plumbing(porcelain.role))
    plumbing.timestamp.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.timestamp))
    return plumbing


def convert_repeated_role_history_to_plumbing(porcelains):
    return [
        convert_role_history_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_role_history_to_porcelain(plumbings):
    return [
        convert_role_history_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_role_resource_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RoleResource()
    porcelain.granted_at = convert_timestamp_to_porcelain(plumbing.granted_at)
    porcelain.resource_id = (plumbing.resource_id)
    porcelain.role_id = (plumbing.role_id)
    return porcelain


def convert_role_resource_to_plumbing(porcelain):
    plumbing = RoleResource()
    if porcelain is None:
        return plumbing
    plumbing.granted_at.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.granted_at))
    plumbing.resource_id = (porcelain.resource_id)
    plumbing.role_id = (porcelain.role_id)
    return plumbing


def convert_repeated_role_resource_to_plumbing(porcelains):
    return [
        convert_role_resource_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_role_resource_to_porcelain(plumbings):
    return [
        convert_role_resource_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_role_resource_history_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RoleResourceHistory()
    porcelain.activity_id = (plumbing.activity_id)
    porcelain.deleted_at = convert_timestamp_to_porcelain(plumbing.deleted_at)
    porcelain.role_resource = convert_role_resource_to_porcelain(
        plumbing.role_resource)
    porcelain.timestamp = convert_timestamp_to_porcelain(plumbing.timestamp)
    return porcelain


def convert_role_resource_history_to_plumbing(porcelain):
    plumbing = RoleResourceHistory()
    if porcelain is None:
        return plumbing
    plumbing.activity_id = (porcelain.activity_id)
    plumbing.deleted_at.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.deleted_at))
    plumbing.role_resource.CopyFrom(
        convert_role_resource_to_plumbing(porcelain.role_resource))
    plumbing.timestamp.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.timestamp))
    return plumbing


def convert_repeated_role_resource_history_to_plumbing(porcelains):
    return [
        convert_role_resource_history_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_role_resource_history_to_porcelain(plumbings):
    return [
        convert_role_resource_history_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_role_update_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RoleUpdateResponse()
    porcelain.meta = convert_update_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.role = convert_role_to_porcelain(plumbing.role)
    return porcelain


def convert_role_update_response_to_plumbing(porcelain):
    plumbing = RoleUpdateResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_update_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    plumbing.role.CopyFrom(convert_role_to_plumbing(porcelain.role))
    return plumbing


def convert_repeated_role_update_response_to_plumbing(porcelains):
    return [
        convert_role_update_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_role_update_response_to_porcelain(plumbings):
    return [
        convert_role_update_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_sql_server_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SQLServer()
    porcelain.allow_deprecated_encryption = (
        plumbing.allow_deprecated_encryption)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.override_database = (plumbing.override_database)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.schema = (plumbing.schema)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_sql_server_to_plumbing(porcelain):
    plumbing = SQLServer()
    if porcelain is None:
        return plumbing
    plumbing.allow_deprecated_encryption = (
        porcelain.allow_deprecated_encryption)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.override_database = (porcelain.override_database)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.schema = (porcelain.schema)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_sql_server_to_plumbing(porcelains):
    return [
        convert_sql_server_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_sql_server_to_porcelain(plumbings):
    return [
        convert_sql_server_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_sql_server_azure_ad_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SQLServerAzureAD()
    porcelain.allow_deprecated_encryption = (
        plumbing.allow_deprecated_encryption)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.client_id = (plumbing.client_id)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.override_database = (plumbing.override_database)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.schema = (plumbing.schema)
    porcelain.secret = (plumbing.secret)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tenant_id = (plumbing.tenant_id)
    return porcelain


def convert_sql_server_azure_ad_to_plumbing(porcelain):
    plumbing = SQLServerAzureAD()
    if porcelain is None:
        return plumbing
    plumbing.allow_deprecated_encryption = (
        porcelain.allow_deprecated_encryption)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.client_id = (porcelain.client_id)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.override_database = (porcelain.override_database)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.schema = (porcelain.schema)
    plumbing.secret = (porcelain.secret)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.tenant_id = (porcelain.tenant_id)
    return plumbing


def convert_repeated_sql_server_azure_ad_to_plumbing(porcelains):
    return [
        convert_sql_server_azure_ad_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_sql_server_azure_ad_to_porcelain(plumbings):
    return [
        convert_sql_server_azure_ad_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_sql_server_kerberos_ad_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SQLServerKerberosAD()
    porcelain.allow_deprecated_encryption = (
        plumbing.allow_deprecated_encryption)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.keytab = (plumbing.keytab)
    porcelain.krb_config = (plumbing.krb_config)
    porcelain.name = (plumbing.name)
    porcelain.override_database = (plumbing.override_database)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.realm = (plumbing.realm)
    porcelain.schema = (plumbing.schema)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.server_spn = (plumbing.server_spn)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_sql_server_kerberos_ad_to_plumbing(porcelain):
    plumbing = SQLServerKerberosAD()
    if porcelain is None:
        return plumbing
    plumbing.allow_deprecated_encryption = (
        porcelain.allow_deprecated_encryption)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.keytab = (porcelain.keytab)
    plumbing.krb_config = (porcelain.krb_config)
    plumbing.name = (porcelain.name)
    plumbing.override_database = (porcelain.override_database)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.realm = (porcelain.realm)
    plumbing.schema = (porcelain.schema)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.server_spn = (porcelain.server_spn)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_sql_server_kerberos_ad_to_plumbing(porcelains):
    return [
        convert_sql_server_kerberos_ad_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_sql_server_kerberos_ad_to_porcelain(plumbings):
    return [
        convert_sql_server_kerberos_ad_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_ssh_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SSH()
    porcelain.allow_deprecated_key_exchanges = (
        plumbing.allow_deprecated_key_exchanges)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.key_type = (plumbing.key_type)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.port_forwarding = (plumbing.port_forwarding)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.public_key = (plumbing.public_key)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_ssh_to_plumbing(porcelain):
    plumbing = SSH()
    if porcelain is None:
        return plumbing
    plumbing.allow_deprecated_key_exchanges = (
        porcelain.allow_deprecated_key_exchanges)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.key_type = (porcelain.key_type)
    plumbing.name = (porcelain.name)
    plumbing.port = (porcelain.port)
    plumbing.port_forwarding = (porcelain.port_forwarding)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.public_key = (porcelain.public_key)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_ssh_to_plumbing(porcelains):
    return [convert_ssh_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_ssh_to_porcelain(plumbings):
    return [convert_ssh_to_porcelain(plumbing) for plumbing in plumbings]


def convert_ssh_cert_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SSHCert()
    porcelain.allow_deprecated_key_exchanges = (
        plumbing.allow_deprecated_key_exchanges)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.identity_alias_healthcheck_username = (
        plumbing.identity_alias_healthcheck_username)
    porcelain.identity_set_id = (plumbing.identity_set_id)
    porcelain.key_type = (plumbing.key_type)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.port_forwarding = (plumbing.port_forwarding)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_ssh_cert_to_plumbing(porcelain):
    plumbing = SSHCert()
    if porcelain is None:
        return plumbing
    plumbing.allow_deprecated_key_exchanges = (
        porcelain.allow_deprecated_key_exchanges)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.identity_alias_healthcheck_username = (
        porcelain.identity_alias_healthcheck_username)
    plumbing.identity_set_id = (porcelain.identity_set_id)
    plumbing.key_type = (porcelain.key_type)
    plumbing.name = (porcelain.name)
    plumbing.port = (porcelain.port)
    plumbing.port_forwarding = (porcelain.port_forwarding)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_ssh_cert_to_plumbing(porcelains):
    return [
        convert_ssh_cert_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_ssh_cert_to_porcelain(plumbings):
    return [convert_ssh_cert_to_porcelain(plumbing) for plumbing in plumbings]


def convert_ssh_customer_key_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SSHCustomerKey()
    porcelain.allow_deprecated_key_exchanges = (
        plumbing.allow_deprecated_key_exchanges)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.identity_alias_healthcheck_username = (
        plumbing.identity_alias_healthcheck_username)
    porcelain.identity_set_id = (plumbing.identity_set_id)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.port_forwarding = (plumbing.port_forwarding)
    porcelain.port_override = (plumbing.port_override)
    porcelain.private_key = (plumbing.private_key)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_ssh_customer_key_to_plumbing(porcelain):
    plumbing = SSHCustomerKey()
    if porcelain is None:
        return plumbing
    plumbing.allow_deprecated_key_exchanges = (
        porcelain.allow_deprecated_key_exchanges)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.identity_alias_healthcheck_username = (
        porcelain.identity_alias_healthcheck_username)
    plumbing.identity_set_id = (porcelain.identity_set_id)
    plumbing.name = (porcelain.name)
    plumbing.port = (porcelain.port)
    plumbing.port_forwarding = (porcelain.port_forwarding)
    plumbing.port_override = (porcelain.port_override)
    plumbing.private_key = (porcelain.private_key)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_ssh_customer_key_to_plumbing(porcelains):
    return [
        convert_ssh_customer_key_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_ssh_customer_key_to_porcelain(plumbings):
    return [
        convert_ssh_customer_key_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_ssh_password_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SSHPassword()
    porcelain.allow_deprecated_key_exchanges = (
        plumbing.allow_deprecated_key_exchanges)
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_forwarding = (plumbing.port_forwarding)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_ssh_password_to_plumbing(porcelain):
    plumbing = SSHPassword()
    if porcelain is None:
        return plumbing
    plumbing.allow_deprecated_key_exchanges = (
        porcelain.allow_deprecated_key_exchanges)
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_forwarding = (porcelain.port_forwarding)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_ssh_password_to_plumbing(porcelains):
    return [
        convert_ssh_password_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_ssh_password_to_porcelain(plumbings):
    return [
        convert_ssh_password_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_secret_engine_to_plumbing(porcelain):
    plumbing = SecretEngine()
    if porcelain is None:
        return plumbing
    if isinstance(porcelain, models.ActiveDirectoryEngine):
        plumbing.active_directory.CopyFrom(
            convert_active_directory_engine_to_plumbing(porcelain))
    if isinstance(porcelain, models.KeyValueEngine):
        plumbing.key_value.CopyFrom(
            convert_key_value_engine_to_plumbing(porcelain))
    return plumbing


def convert_secret_engine_to_porcelain(plumbing):
    if plumbing is None:
        return None
    if plumbing.HasField('active_directory'):
        return convert_active_directory_engine_to_porcelain(
            plumbing.active_directory)
    if plumbing.HasField('key_value'):
        return convert_key_value_engine_to_porcelain(plumbing.key_value)
    raise errors.UnknownError(
        "unknown polymorphic type, please upgrade your SDK")


def convert_repeated_secret_engine_to_plumbing(porcelains):
    return [
        convert_secret_engine_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_secret_engine_to_porcelain(plumbings):
    return [
        convert_secret_engine_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_secret_engine_create_request_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SecretEngineCreateRequest()
    porcelain.secret_engine = convert_secret_engine_to_porcelain(
        plumbing.secret_engine)
    return porcelain


def convert_secret_engine_create_request_to_plumbing(porcelain):
    plumbing = SecretEngineCreateRequest()
    if porcelain is None:
        return plumbing
    plumbing.secret_engine.CopyFrom(
        convert_secret_engine_to_plumbing(porcelain.secret_engine))
    return plumbing


def convert_repeated_secret_engine_create_request_to_plumbing(porcelains):
    return [
        convert_secret_engine_create_request_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_secret_engine_create_request_to_porcelain(plumbings):
    return [
        convert_secret_engine_create_request_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_secret_engine_create_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SecretEngineCreateResponse()
    porcelain.meta = convert_create_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.secret_engine = convert_secret_engine_to_porcelain(
        plumbing.secret_engine)
    return porcelain


def convert_secret_engine_create_response_to_plumbing(porcelain):
    plumbing = SecretEngineCreateResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_create_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    plumbing.secret_engine.CopyFrom(
        convert_secret_engine_to_plumbing(porcelain.secret_engine))
    return plumbing


def convert_repeated_secret_engine_create_response_to_plumbing(porcelains):
    return [
        convert_secret_engine_create_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_secret_engine_create_response_to_porcelain(plumbings):
    return [
        convert_secret_engine_create_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_secret_engine_delete_request_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SecretEngineDeleteRequest()
    porcelain.id = (plumbing.id)
    return porcelain


def convert_secret_engine_delete_request_to_plumbing(porcelain):
    plumbing = SecretEngineDeleteRequest()
    if porcelain is None:
        return plumbing
    plumbing.id = (porcelain.id)
    return plumbing


def convert_repeated_secret_engine_delete_request_to_plumbing(porcelains):
    return [
        convert_secret_engine_delete_request_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_secret_engine_delete_request_to_porcelain(plumbings):
    return [
        convert_secret_engine_delete_request_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_secret_engine_delete_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SecretEngineDeleteResponse()
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_secret_engine_delete_response_to_plumbing(porcelain):
    plumbing = SecretEngineDeleteResponse()
    if porcelain is None:
        return plumbing
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_secret_engine_delete_response_to_plumbing(porcelains):
    return [
        convert_secret_engine_delete_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_secret_engine_delete_response_to_porcelain(plumbings):
    return [
        convert_secret_engine_delete_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_secret_engine_get_request_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SecretEngineGetRequest()
    porcelain.id = (plumbing.id)
    return porcelain


def convert_secret_engine_get_request_to_plumbing(porcelain):
    plumbing = SecretEngineGetRequest()
    if porcelain is None:
        return plumbing
    plumbing.id = (porcelain.id)
    return plumbing


def convert_repeated_secret_engine_get_request_to_plumbing(porcelains):
    return [
        convert_secret_engine_get_request_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_secret_engine_get_request_to_porcelain(plumbings):
    return [
        convert_secret_engine_get_request_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_secret_engine_get_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SecretEngineGetResponse()
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.secret_engine = convert_secret_engine_to_porcelain(
        plumbing.secret_engine)
    return porcelain


def convert_secret_engine_get_response_to_plumbing(porcelain):
    plumbing = SecretEngineGetResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_get_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    plumbing.secret_engine.CopyFrom(
        convert_secret_engine_to_plumbing(porcelain.secret_engine))
    return plumbing


def convert_repeated_secret_engine_get_response_to_plumbing(porcelains):
    return [
        convert_secret_engine_get_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_secret_engine_get_response_to_porcelain(plumbings):
    return [
        convert_secret_engine_get_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_secret_engine_list_request_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SecretEngineListRequest()
    porcelain.filter = (plumbing.filter)
    return porcelain


def convert_secret_engine_list_request_to_plumbing(porcelain):
    plumbing = SecretEngineListRequest()
    if porcelain is None:
        return plumbing
    plumbing.filter = (porcelain.filter)
    return plumbing


def convert_repeated_secret_engine_list_request_to_plumbing(porcelains):
    return [
        convert_secret_engine_list_request_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_secret_engine_list_request_to_porcelain(plumbings):
    return [
        convert_secret_engine_list_request_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_secret_engine_list_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SecretEngineListResponse()
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_secret_engine_list_response_to_plumbing(porcelain):
    plumbing = SecretEngineListResponse()
    if porcelain is None:
        return plumbing
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_secret_engine_list_response_to_plumbing(porcelains):
    return [
        convert_secret_engine_list_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_secret_engine_list_response_to_porcelain(plumbings):
    return [
        convert_secret_engine_list_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_secret_engine_password_policy_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SecretEnginePasswordPolicy()
    porcelain.allow_repeat = (plumbing.allow_repeat)
    porcelain.exclude_characters = (plumbing.exclude_characters)
    porcelain.exclude_upper_case = (plumbing.exclude_upper_case)
    porcelain.length = (plumbing.length)
    porcelain.num_digits = (plumbing.num_digits)
    porcelain.num_symbols = (plumbing.num_symbols)
    return porcelain


def convert_secret_engine_password_policy_to_plumbing(porcelain):
    plumbing = SecretEnginePasswordPolicy()
    if porcelain is None:
        return plumbing
    plumbing.allow_repeat = (porcelain.allow_repeat)
    plumbing.exclude_characters = (porcelain.exclude_characters)
    plumbing.exclude_upper_case = (porcelain.exclude_upper_case)
    plumbing.length = (porcelain.length)
    plumbing.num_digits = (porcelain.num_digits)
    plumbing.num_symbols = (porcelain.num_symbols)
    return plumbing


def convert_repeated_secret_engine_password_policy_to_plumbing(porcelains):
    return [
        convert_secret_engine_password_policy_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_secret_engine_password_policy_to_porcelain(plumbings):
    return [
        convert_secret_engine_password_policy_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_secret_engine_policy_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SecretEnginePolicy()
    porcelain.password_policy = convert_secret_engine_password_policy_to_porcelain(
        plumbing.password_policy)
    return porcelain


def convert_secret_engine_policy_to_plumbing(porcelain):
    plumbing = SecretEnginePolicy()
    if porcelain is None:
        return plumbing
    plumbing.password_policy.CopyFrom(
        convert_secret_engine_password_policy_to_plumbing(
            porcelain.password_policy))
    return plumbing


def convert_repeated_secret_engine_policy_to_plumbing(porcelains):
    return [
        convert_secret_engine_policy_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_secret_engine_policy_to_porcelain(plumbings):
    return [
        convert_secret_engine_policy_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_secret_engine_rotate_request_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SecretEngineRotateRequest()
    porcelain.id = (plumbing.id)
    porcelain.password_policy = convert_secret_engine_password_policy_to_porcelain(
        plumbing.password_policy)
    return porcelain


def convert_secret_engine_rotate_request_to_plumbing(porcelain):
    plumbing = SecretEngineRotateRequest()
    if porcelain is None:
        return plumbing
    plumbing.id = (porcelain.id)
    plumbing.password_policy.CopyFrom(
        convert_secret_engine_password_policy_to_plumbing(
            porcelain.password_policy))
    return plumbing


def convert_repeated_secret_engine_rotate_request_to_plumbing(porcelains):
    return [
        convert_secret_engine_rotate_request_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_secret_engine_rotate_request_to_porcelain(plumbings):
    return [
        convert_secret_engine_rotate_request_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_secret_engine_rotate_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SecretEngineRotateResponse()
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_secret_engine_rotate_response_to_plumbing(porcelain):
    plumbing = SecretEngineRotateResponse()
    if porcelain is None:
        return plumbing
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_secret_engine_rotate_response_to_plumbing(porcelains):
    return [
        convert_secret_engine_rotate_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_secret_engine_rotate_response_to_porcelain(plumbings):
    return [
        convert_secret_engine_rotate_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_secret_engine_update_request_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SecretEngineUpdateRequest()
    porcelain.secret_engine = convert_secret_engine_to_porcelain(
        plumbing.secret_engine)
    return porcelain


def convert_secret_engine_update_request_to_plumbing(porcelain):
    plumbing = SecretEngineUpdateRequest()
    if porcelain is None:
        return plumbing
    plumbing.secret_engine.CopyFrom(
        convert_secret_engine_to_plumbing(porcelain.secret_engine))
    return plumbing


def convert_repeated_secret_engine_update_request_to_plumbing(porcelains):
    return [
        convert_secret_engine_update_request_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_secret_engine_update_request_to_porcelain(plumbings):
    return [
        convert_secret_engine_update_request_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_secret_engine_update_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SecretEngineUpdateResponse()
    porcelain.meta = convert_update_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.secret_engine = convert_secret_engine_to_porcelain(
        plumbing.secret_engine)
    return porcelain


def convert_secret_engine_update_response_to_plumbing(porcelain):
    plumbing = SecretEngineUpdateResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_update_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    plumbing.secret_engine.CopyFrom(
        convert_secret_engine_to_plumbing(porcelain.secret_engine))
    return plumbing


def convert_repeated_secret_engine_update_response_to_plumbing(porcelains):
    return [
        convert_secret_engine_update_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_secret_engine_update_response_to_porcelain(plumbings):
    return [
        convert_secret_engine_update_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_secret_store_to_plumbing(porcelain):
    plumbing = SecretStore()
    if porcelain is None:
        return plumbing
    if isinstance(porcelain, models.ActiveDirectoryStore):
        plumbing.active_directory.CopyFrom(
            convert_active_directory_store_to_plumbing(porcelain))
    if isinstance(porcelain, models.AWSStore):
        plumbing.aws.CopyFrom(convert_aws_store_to_plumbing(porcelain))
    if isinstance(porcelain, models.AWSCertX509Store):
        plumbing.aws_cert_x_509.CopyFrom(
            convert_aws_cert_x_509_store_to_plumbing(porcelain))
    if isinstance(porcelain, models.AzureStore):
        plumbing.azure.CopyFrom(convert_azure_store_to_plumbing(porcelain))
    if isinstance(porcelain, models.CyberarkConjurStore):
        plumbing.cyberark_conjur.CopyFrom(
            convert_cyberark_conjur_store_to_plumbing(porcelain))
    if isinstance(porcelain, models.CyberarkPAMStore):
        plumbing.cyberark_pam.CopyFrom(
            convert_cyberark_pam_store_to_plumbing(porcelain))
    if isinstance(porcelain, models.CyberarkPAMExperimentalStore):
        plumbing.cyberark_pam_experimental.CopyFrom(
            convert_cyberark_pam_experimental_store_to_plumbing(porcelain))
    if isinstance(porcelain, models.DelineaStore):
        plumbing.delinea.CopyFrom(convert_delinea_store_to_plumbing(porcelain))
    if isinstance(porcelain, models.GCPStore):
        plumbing.gcp.CopyFrom(convert_gcp_store_to_plumbing(porcelain))
    if isinstance(porcelain, models.GCPCertX509Store):
        plumbing.gcp_cert_x_509.CopyFrom(
            convert_gcp_cert_x_509_store_to_plumbing(porcelain))
    if isinstance(porcelain, models.KeyfactorSSHStore):
        plumbing.keyfactor_ssh.CopyFrom(
            convert_keyfactor_ssh_store_to_plumbing(porcelain))
    if isinstance(porcelain, models.KeyfactorX509Store):
        plumbing.keyfactor_x_509.CopyFrom(
            convert_keyfactor_x_509_store_to_plumbing(porcelain))
    if isinstance(porcelain, models.VaultAppRoleStore):
        plumbing.vault_app_role.CopyFrom(
            convert_vault_app_role_store_to_plumbing(porcelain))
    if isinstance(porcelain, models.VaultAppRoleCertSSHStore):
        plumbing.vault_app_role_cert_ssh.CopyFrom(
            convert_vault_app_role_cert_ssh_store_to_plumbing(porcelain))
    if isinstance(porcelain, models.VaultAppRoleCertX509Store):
        plumbing.vault_app_role_cert_x_509.CopyFrom(
            convert_vault_app_role_cert_x_509_store_to_plumbing(porcelain))
    if isinstance(porcelain, models.VaultAWSEC2Store):
        plumbing.vault_awsec_2.CopyFrom(
            convert_vault_awsec_2_store_to_plumbing(porcelain))
    if isinstance(porcelain, models.VaultAWSIAMStore):
        plumbing.vault_awsiam.CopyFrom(
            convert_vault_awsiam_store_to_plumbing(porcelain))
    if isinstance(porcelain, models.VaultTLSStore):
        plumbing.vault_tls.CopyFrom(
            convert_vault_tls_store_to_plumbing(porcelain))
    if isinstance(porcelain, models.VaultTLSCertSSHStore):
        plumbing.vault_tls_cert_ssh.CopyFrom(
            convert_vault_tls_cert_ssh_store_to_plumbing(porcelain))
    if isinstance(porcelain, models.VaultTLSCertX509Store):
        plumbing.vault_tls_cert_x_509.CopyFrom(
            convert_vault_tls_cert_x_509_store_to_plumbing(porcelain))
    if isinstance(porcelain, models.VaultTokenStore):
        plumbing.vault_token.CopyFrom(
            convert_vault_token_store_to_plumbing(porcelain))
    if isinstance(porcelain, models.VaultTokenCertSSHStore):
        plumbing.vault_token_cert_ssh.CopyFrom(
            convert_vault_token_cert_ssh_store_to_plumbing(porcelain))
    if isinstance(porcelain, models.VaultTokenCertX509Store):
        plumbing.vault_token_cert_x_509.CopyFrom(
            convert_vault_token_cert_x_509_store_to_plumbing(porcelain))
    return plumbing


def convert_secret_store_to_porcelain(plumbing):
    if plumbing is None:
        return None
    if plumbing.HasField('active_directory'):
        return convert_active_directory_store_to_porcelain(
            plumbing.active_directory)
    if plumbing.HasField('aws'):
        return convert_aws_store_to_porcelain(plumbing.aws)
    if plumbing.HasField('aws_cert_x_509'):
        return convert_aws_cert_x_509_store_to_porcelain(
            plumbing.aws_cert_x_509)
    if plumbing.HasField('azure'):
        return convert_azure_store_to_porcelain(plumbing.azure)
    if plumbing.HasField('cyberark_conjur'):
        return convert_cyberark_conjur_store_to_porcelain(
            plumbing.cyberark_conjur)
    if plumbing.HasField('cyberark_pam'):
        return convert_cyberark_pam_store_to_porcelain(plumbing.cyberark_pam)
    if plumbing.HasField('cyberark_pam_experimental'):
        return convert_cyberark_pam_experimental_store_to_porcelain(
            plumbing.cyberark_pam_experimental)
    if plumbing.HasField('delinea'):
        return convert_delinea_store_to_porcelain(plumbing.delinea)
    if plumbing.HasField('gcp'):
        return convert_gcp_store_to_porcelain(plumbing.gcp)
    if plumbing.HasField('gcp_cert_x_509'):
        return convert_gcp_cert_x_509_store_to_porcelain(
            plumbing.gcp_cert_x_509)
    if plumbing.HasField('keyfactor_ssh'):
        return convert_keyfactor_ssh_store_to_porcelain(plumbing.keyfactor_ssh)
    if plumbing.HasField('keyfactor_x_509'):
        return convert_keyfactor_x_509_store_to_porcelain(
            plumbing.keyfactor_x_509)
    if plumbing.HasField('vault_app_role'):
        return convert_vault_app_role_store_to_porcelain(
            plumbing.vault_app_role)
    if plumbing.HasField('vault_app_role_cert_ssh'):
        return convert_vault_app_role_cert_ssh_store_to_porcelain(
            plumbing.vault_app_role_cert_ssh)
    if plumbing.HasField('vault_app_role_cert_x_509'):
        return convert_vault_app_role_cert_x_509_store_to_porcelain(
            plumbing.vault_app_role_cert_x_509)
    if plumbing.HasField('vault_awsec_2'):
        return convert_vault_awsec_2_store_to_porcelain(plumbing.vault_awsec_2)
    if plumbing.HasField('vault_awsiam'):
        return convert_vault_awsiam_store_to_porcelain(plumbing.vault_awsiam)
    if plumbing.HasField('vault_tls'):
        return convert_vault_tls_store_to_porcelain(plumbing.vault_tls)
    if plumbing.HasField('vault_tls_cert_ssh'):
        return convert_vault_tls_cert_ssh_store_to_porcelain(
            plumbing.vault_tls_cert_ssh)
    if plumbing.HasField('vault_tls_cert_x_509'):
        return convert_vault_tls_cert_x_509_store_to_porcelain(
            plumbing.vault_tls_cert_x_509)
    if plumbing.HasField('vault_token'):
        return convert_vault_token_store_to_porcelain(plumbing.vault_token)
    if plumbing.HasField('vault_token_cert_ssh'):
        return convert_vault_token_cert_ssh_store_to_porcelain(
            plumbing.vault_token_cert_ssh)
    if plumbing.HasField('vault_token_cert_x_509'):
        return convert_vault_token_cert_x_509_store_to_porcelain(
            plumbing.vault_token_cert_x_509)
    raise errors.UnknownError(
        "unknown polymorphic type, please upgrade your SDK")


def convert_repeated_secret_store_to_plumbing(porcelains):
    return [
        convert_secret_store_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_secret_store_to_porcelain(plumbings):
    return [
        convert_secret_store_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_secret_store_create_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SecretStoreCreateResponse()
    porcelain.meta = convert_create_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.secret_store = convert_secret_store_to_porcelain(
        plumbing.secret_store)
    return porcelain


def convert_secret_store_create_response_to_plumbing(porcelain):
    plumbing = SecretStoreCreateResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_create_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    plumbing.secret_store.CopyFrom(
        convert_secret_store_to_plumbing(porcelain.secret_store))
    return plumbing


def convert_repeated_secret_store_create_response_to_plumbing(porcelains):
    return [
        convert_secret_store_create_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_secret_store_create_response_to_porcelain(plumbings):
    return [
        convert_secret_store_create_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_secret_store_delete_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SecretStoreDeleteResponse()
    porcelain.meta = convert_delete_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_secret_store_delete_response_to_plumbing(porcelain):
    plumbing = SecretStoreDeleteResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_delete_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_secret_store_delete_response_to_plumbing(porcelains):
    return [
        convert_secret_store_delete_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_secret_store_delete_response_to_porcelain(plumbings):
    return [
        convert_secret_store_delete_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_secret_store_get_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SecretStoreGetResponse()
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.secret_store = convert_secret_store_to_porcelain(
        plumbing.secret_store)
    return porcelain


def convert_secret_store_get_response_to_plumbing(porcelain):
    plumbing = SecretStoreGetResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_get_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    plumbing.secret_store.CopyFrom(
        convert_secret_store_to_plumbing(porcelain.secret_store))
    return plumbing


def convert_repeated_secret_store_get_response_to_plumbing(porcelains):
    return [
        convert_secret_store_get_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_secret_store_get_response_to_porcelain(plumbings):
    return [
        convert_secret_store_get_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_secret_store_health_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SecretStoreHealth()
    porcelain.changed_at = convert_timestamp_to_porcelain(plumbing.changed_at)
    porcelain.checked_at = convert_timestamp_to_porcelain(plumbing.checked_at)
    porcelain.error = (plumbing.error)
    porcelain.flags = (plumbing.flags)
    porcelain.node_id = (plumbing.node_id)
    porcelain.reachability = (plumbing.reachability)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.status = (plumbing.status)
    return porcelain


def convert_secret_store_health_to_plumbing(porcelain):
    plumbing = SecretStoreHealth()
    if porcelain is None:
        return plumbing
    plumbing.changed_at.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.changed_at))
    plumbing.checked_at.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.checked_at))
    plumbing.error = (porcelain.error)
    del plumbing.flags[:]
    plumbing.flags.extend((porcelain.flags))
    plumbing.node_id = (porcelain.node_id)
    plumbing.reachability = (porcelain.reachability)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.status = (porcelain.status)
    return plumbing


def convert_repeated_secret_store_health_to_plumbing(porcelains):
    return [
        convert_secret_store_health_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_secret_store_health_to_porcelain(plumbings):
    return [
        convert_secret_store_health_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_secret_store_health_list_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SecretStoreHealthListResponse()
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_secret_store_health_list_response_to_plumbing(porcelain):
    plumbing = SecretStoreHealthListResponse()
    if porcelain is None:
        return plumbing
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_secret_store_health_list_response_to_plumbing(porcelains):
    return [
        convert_secret_store_health_list_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_secret_store_health_list_response_to_porcelain(plumbings):
    return [
        convert_secret_store_health_list_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_secret_store_healthcheck_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SecretStoreHealthcheckResponse()
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_secret_store_healthcheck_response_to_plumbing(porcelain):
    plumbing = SecretStoreHealthcheckResponse()
    if porcelain is None:
        return plumbing
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_secret_store_healthcheck_response_to_plumbing(porcelains):
    return [
        convert_secret_store_healthcheck_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_secret_store_healthcheck_response_to_porcelain(plumbings):
    return [
        convert_secret_store_healthcheck_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_secret_store_history_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SecretStoreHistory()
    porcelain.activity_id = (plumbing.activity_id)
    porcelain.deleted_at = convert_timestamp_to_porcelain(plumbing.deleted_at)
    porcelain.secret_store = convert_secret_store_to_porcelain(
        plumbing.secret_store)
    porcelain.timestamp = convert_timestamp_to_porcelain(plumbing.timestamp)
    return porcelain


def convert_secret_store_history_to_plumbing(porcelain):
    plumbing = SecretStoreHistory()
    if porcelain is None:
        return plumbing
    plumbing.activity_id = (porcelain.activity_id)
    plumbing.deleted_at.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.deleted_at))
    plumbing.secret_store.CopyFrom(
        convert_secret_store_to_plumbing(porcelain.secret_store))
    plumbing.timestamp.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.timestamp))
    return plumbing


def convert_repeated_secret_store_history_to_plumbing(porcelains):
    return [
        convert_secret_store_history_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_secret_store_history_to_porcelain(plumbings):
    return [
        convert_secret_store_history_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_secret_store_update_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SecretStoreUpdateResponse()
    porcelain.meta = convert_update_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.secret_store = convert_secret_store_to_porcelain(
        plumbing.secret_store)
    return porcelain


def convert_secret_store_update_response_to_plumbing(porcelain):
    plumbing = SecretStoreUpdateResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_update_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    plumbing.secret_store.CopyFrom(
        convert_secret_store_to_plumbing(porcelain.secret_store))
    return plumbing


def convert_repeated_secret_store_update_response_to_plumbing(porcelains):
    return [
        convert_secret_store_update_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_secret_store_update_response_to_porcelain(plumbings):
    return [
        convert_secret_store_update_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_service_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Service()
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.suspended = (plumbing.suspended)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_service_to_plumbing(porcelain):
    plumbing = Service()
    if porcelain is None:
        return plumbing
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.suspended = (porcelain.suspended)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_service_to_plumbing(porcelains):
    return [convert_service_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_service_to_porcelain(plumbings):
    return [convert_service_to_porcelain(plumbing) for plumbing in plumbings]


def convert_single_store_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SingleStore()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.require_native_auth = (plumbing.require_native_auth)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.use_azure_single_server_usernames = (
        plumbing.use_azure_single_server_usernames)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_single_store_to_plumbing(porcelain):
    plumbing = SingleStore()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.require_native_auth = (porcelain.require_native_auth)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.use_azure_single_server_usernames = (
        porcelain.use_azure_single_server_usernames)
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_single_store_to_plumbing(porcelains):
    return [
        convert_single_store_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_single_store_to_porcelain(plumbings):
    return [
        convert_single_store_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_snowflake_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Snowflake()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.schema = (plumbing.schema)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_snowflake_to_plumbing(porcelain):
    plumbing = Snowflake()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.schema = (porcelain.schema)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_snowflake_to_plumbing(porcelains):
    return [
        convert_snowflake_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_snowflake_to_porcelain(plumbings):
    return [convert_snowflake_to_porcelain(plumbing) for plumbing in plumbings]


def convert_snowsight_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Snowsight()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthcheck_username = (plumbing.healthcheck_username)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.samlmetadata = (plumbing.samlMetadata)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_snowsight_to_plumbing(porcelain):
    plumbing = Snowsight()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthcheck_username = (porcelain.healthcheck_username)
    plumbing.healthy = (porcelain.healthy)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.samlMetadata = (porcelain.samlmetadata)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_snowsight_to_plumbing(porcelains):
    return [
        convert_snowsight_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_snowsight_to_porcelain(plumbings):
    return [convert_snowsight_to_porcelain(plumbing) for plumbing in plumbings]


def convert_sybase_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Sybase()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_sybase_to_plumbing(porcelain):
    plumbing = Sybase()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_sybase_to_plumbing(porcelains):
    return [convert_sybase_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_sybase_to_porcelain(plumbings):
    return [convert_sybase_to_porcelain(plumbing) for plumbing in plumbings]


def convert_sybase_iq_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SybaseIQ()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_sybase_iq_to_plumbing(porcelain):
    plumbing = SybaseIQ()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_sybase_iq_to_plumbing(porcelains):
    return [
        convert_sybase_iq_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_sybase_iq_to_porcelain(plumbings):
    return [convert_sybase_iq_to_porcelain(plumbing) for plumbing in plumbings]


def convert_tag_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Tag()
    porcelain.name = (plumbing.name)
    porcelain.value = (plumbing.value)
    return porcelain


def convert_tag_to_plumbing(porcelain):
    plumbing = Tag()
    if porcelain is None:
        return plumbing
    plumbing.name = (porcelain.name)
    plumbing.value = (porcelain.value)
    return plumbing


def convert_repeated_tag_to_plumbing(porcelains):
    return [convert_tag_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_tag_to_porcelain(plumbings):
    return [convert_tag_to_porcelain(plumbing) for plumbing in plumbings]


def convert_teradata_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Teradata()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_teradata_to_plumbing(porcelain):
    plumbing = Teradata()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_teradata_to_plumbing(porcelains):
    return [
        convert_teradata_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_teradata_to_porcelain(plumbings):
    return [convert_teradata_to_porcelain(plumbing) for plumbing in plumbings]


def convert_token_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Token()
    porcelain.account_type = (plumbing.account_type)
    porcelain.deadline = convert_timestamp_to_porcelain(plumbing.deadline)
    porcelain.duration = convert_duration_to_porcelain(plumbing.duration)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.permissions = (plumbing.permissions)
    porcelain.rekeyed = convert_timestamp_to_porcelain(plumbing.rekeyed)
    porcelain.suspended = (plumbing.suspended)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_token_to_plumbing(porcelain):
    plumbing = Token()
    if porcelain is None:
        return plumbing
    plumbing.account_type = (porcelain.account_type)
    plumbing.deadline.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.deadline))
    plumbing.duration.CopyFrom(convert_duration_to_plumbing(
        porcelain.duration))
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    del plumbing.permissions[:]
    plumbing.permissions.extend((porcelain.permissions))
    plumbing.rekeyed.CopyFrom(convert_timestamp_to_plumbing(porcelain.rekeyed))
    plumbing.suspended = (porcelain.suspended)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_token_to_plumbing(porcelains):
    return [convert_token_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_token_to_porcelain(plumbings):
    return [convert_token_to_porcelain(plumbing) for plumbing in plumbings]


def convert_trino_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Trino()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_trino_to_plumbing(porcelain):
    plumbing = Trino()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_trino_to_plumbing(porcelains):
    return [convert_trino_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_trino_to_porcelain(plumbings):
    return [convert_trino_to_porcelain(plumbing) for plumbing in plumbings]


def convert_update_response_metadata_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.UpdateResponseMetadata()
    return porcelain


def convert_update_response_metadata_to_plumbing(porcelain):
    plumbing = UpdateResponseMetadata()
    if porcelain is None:
        return plumbing
    return plumbing


def convert_repeated_update_response_metadata_to_plumbing(porcelains):
    return [
        convert_update_response_metadata_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_update_response_metadata_to_porcelain(plumbings):
    return [
        convert_update_response_metadata_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_user_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.User()
    porcelain.scim = (plumbing.SCIM)
    porcelain.email = (plumbing.email)
    porcelain.external_id = (plumbing.external_id)
    porcelain.first_name = (plumbing.first_name)
    porcelain.id = (plumbing.id)
    porcelain.last_name = (plumbing.last_name)
    porcelain.managed_by = (plumbing.managed_by)
    porcelain.manager_id = (plumbing.manager_id)
    porcelain.password = (plumbing.password)
    porcelain.permission_level = (plumbing.permission_levelRW)
    porcelain.resolved_manager_id = (plumbing.resolved_manager_id)
    porcelain.suspended = (plumbing.suspendedRO)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_user_to_plumbing(porcelain):
    plumbing = User()
    if porcelain is None:
        return plumbing
    plumbing.SCIM = (porcelain.scim)
    plumbing.email = (porcelain.email)
    plumbing.external_id = (porcelain.external_id)
    plumbing.first_name = (porcelain.first_name)
    plumbing.id = (porcelain.id)
    plumbing.last_name = (porcelain.last_name)
    plumbing.managed_by = (porcelain.managed_by)
    plumbing.manager_id = (porcelain.manager_id)
    plumbing.password = (porcelain.password)
    plumbing.permission_levelRW = (porcelain.permission_level)
    plumbing.resolved_manager_id = (porcelain.resolved_manager_id)
    plumbing.suspendedRO = (porcelain.suspended)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_user_to_plumbing(porcelains):
    return [convert_user_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_user_to_porcelain(plumbings):
    return [convert_user_to_porcelain(plumbing) for plumbing in plumbings]


def convert_vault_awsec_2_store_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.VaultAWSEC2Store()
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.namespace = (plumbing.namespace)
    porcelain.server_address = (plumbing.server_address)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_vault_awsec_2_store_to_plumbing(porcelain):
    plumbing = VaultAWSEC2Store()
    if porcelain is None:
        return plumbing
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.namespace = (porcelain.namespace)
    plumbing.server_address = (porcelain.server_address)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_vault_awsec_2_store_to_plumbing(porcelains):
    return [
        convert_vault_awsec_2_store_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_vault_awsec_2_store_to_porcelain(plumbings):
    return [
        convert_vault_awsec_2_store_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_vault_awsiam_store_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.VaultAWSIAMStore()
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.namespace = (plumbing.namespace)
    porcelain.server_address = (plumbing.server_address)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_vault_awsiam_store_to_plumbing(porcelain):
    plumbing = VaultAWSIAMStore()
    if porcelain is None:
        return plumbing
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.namespace = (porcelain.namespace)
    plumbing.server_address = (porcelain.server_address)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_vault_awsiam_store_to_plumbing(porcelains):
    return [
        convert_vault_awsiam_store_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_vault_awsiam_store_to_porcelain(plumbings):
    return [
        convert_vault_awsiam_store_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_vault_app_role_cert_ssh_store_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.VaultAppRoleCertSSHStore()
    porcelain.id = (plumbing.id)
    porcelain.issuedcertttlminutes = (plumbing.issuedCertTTLMinutes)
    porcelain.name = (plumbing.name)
    porcelain.namespace = (plumbing.namespace)
    porcelain.server_address = (plumbing.server_address)
    porcelain.signing_role = (plumbing.signing_role)
    porcelain.ssh_mount_point = (plumbing.ssh_mount_point)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_vault_app_role_cert_ssh_store_to_plumbing(porcelain):
    plumbing = VaultAppRoleCertSSHStore()
    if porcelain is None:
        return plumbing
    plumbing.id = (porcelain.id)
    plumbing.issuedCertTTLMinutes = (porcelain.issuedcertttlminutes)
    plumbing.name = (porcelain.name)
    plumbing.namespace = (porcelain.namespace)
    plumbing.server_address = (porcelain.server_address)
    plumbing.signing_role = (porcelain.signing_role)
    plumbing.ssh_mount_point = (porcelain.ssh_mount_point)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_vault_app_role_cert_ssh_store_to_plumbing(porcelains):
    return [
        convert_vault_app_role_cert_ssh_store_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_vault_app_role_cert_ssh_store_to_porcelain(plumbings):
    return [
        convert_vault_app_role_cert_ssh_store_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_vault_app_role_cert_x_509_store_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.VaultAppRoleCertX509Store()
    porcelain.id = (plumbing.id)
    porcelain.issuedcertttlminutes = (plumbing.issuedCertTTLMinutes)
    porcelain.name = (plumbing.name)
    porcelain.namespace = (plumbing.namespace)
    porcelain.pki_mount_point = (plumbing.pki_mount_point)
    porcelain.server_address = (plumbing.server_address)
    porcelain.signing_role = (plumbing.signing_role)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_vault_app_role_cert_x_509_store_to_plumbing(porcelain):
    plumbing = VaultAppRoleCertX509Store()
    if porcelain is None:
        return plumbing
    plumbing.id = (porcelain.id)
    plumbing.issuedCertTTLMinutes = (porcelain.issuedcertttlminutes)
    plumbing.name = (porcelain.name)
    plumbing.namespace = (porcelain.namespace)
    plumbing.pki_mount_point = (porcelain.pki_mount_point)
    plumbing.server_address = (porcelain.server_address)
    plumbing.signing_role = (porcelain.signing_role)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_vault_app_role_cert_x_509_store_to_plumbing(porcelains):
    return [
        convert_vault_app_role_cert_x_509_store_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_vault_app_role_cert_x_509_store_to_porcelain(plumbings):
    return [
        convert_vault_app_role_cert_x_509_store_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_vault_app_role_store_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.VaultAppRoleStore()
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.namespace = (plumbing.namespace)
    porcelain.server_address = (plumbing.server_address)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_vault_app_role_store_to_plumbing(porcelain):
    plumbing = VaultAppRoleStore()
    if porcelain is None:
        return plumbing
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.namespace = (porcelain.namespace)
    plumbing.server_address = (porcelain.server_address)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_vault_app_role_store_to_plumbing(porcelains):
    return [
        convert_vault_app_role_store_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_vault_app_role_store_to_porcelain(plumbings):
    return [
        convert_vault_app_role_store_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_vault_tls_cert_ssh_store_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.VaultTLSCertSSHStore()
    porcelain.ca_cert_path = (plumbing.CA_cert_path)
    porcelain.client_cert_path = (plumbing.client_cert_path)
    porcelain.client_key_path = (plumbing.client_key_path)
    porcelain.id = (plumbing.id)
    porcelain.issuedcertttlminutes = (plumbing.issuedCertTTLMinutes)
    porcelain.name = (plumbing.name)
    porcelain.namespace = (plumbing.namespace)
    porcelain.server_address = (plumbing.server_address)
    porcelain.signing_role = (plumbing.signing_role)
    porcelain.ssh_mount_point = (plumbing.ssh_mount_point)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_vault_tls_cert_ssh_store_to_plumbing(porcelain):
    plumbing = VaultTLSCertSSHStore()
    if porcelain is None:
        return plumbing
    plumbing.CA_cert_path = (porcelain.ca_cert_path)
    plumbing.client_cert_path = (porcelain.client_cert_path)
    plumbing.client_key_path = (porcelain.client_key_path)
    plumbing.id = (porcelain.id)
    plumbing.issuedCertTTLMinutes = (porcelain.issuedcertttlminutes)
    plumbing.name = (porcelain.name)
    plumbing.namespace = (porcelain.namespace)
    plumbing.server_address = (porcelain.server_address)
    plumbing.signing_role = (porcelain.signing_role)
    plumbing.ssh_mount_point = (porcelain.ssh_mount_point)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_vault_tls_cert_ssh_store_to_plumbing(porcelains):
    return [
        convert_vault_tls_cert_ssh_store_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_vault_tls_cert_ssh_store_to_porcelain(plumbings):
    return [
        convert_vault_tls_cert_ssh_store_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_vault_tls_cert_x_509_store_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.VaultTLSCertX509Store()
    porcelain.ca_cert_path = (plumbing.CA_cert_path)
    porcelain.client_cert_path = (plumbing.client_cert_path)
    porcelain.client_key_path = (plumbing.client_key_path)
    porcelain.id = (plumbing.id)
    porcelain.issuedcertttlminutes = (plumbing.issuedCertTTLMinutes)
    porcelain.name = (plumbing.name)
    porcelain.namespace = (plumbing.namespace)
    porcelain.pki_mount_point = (plumbing.pki_mount_point)
    porcelain.server_address = (plumbing.server_address)
    porcelain.signing_role = (plumbing.signing_role)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_vault_tls_cert_x_509_store_to_plumbing(porcelain):
    plumbing = VaultTLSCertX509Store()
    if porcelain is None:
        return plumbing
    plumbing.CA_cert_path = (porcelain.ca_cert_path)
    plumbing.client_cert_path = (porcelain.client_cert_path)
    plumbing.client_key_path = (porcelain.client_key_path)
    plumbing.id = (porcelain.id)
    plumbing.issuedCertTTLMinutes = (porcelain.issuedcertttlminutes)
    plumbing.name = (porcelain.name)
    plumbing.namespace = (porcelain.namespace)
    plumbing.pki_mount_point = (porcelain.pki_mount_point)
    plumbing.server_address = (porcelain.server_address)
    plumbing.signing_role = (porcelain.signing_role)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_vault_tls_cert_x_509_store_to_plumbing(porcelains):
    return [
        convert_vault_tls_cert_x_509_store_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_vault_tls_cert_x_509_store_to_porcelain(plumbings):
    return [
        convert_vault_tls_cert_x_509_store_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_vault_tls_store_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.VaultTLSStore()
    porcelain.ca_cert_path = (plumbing.CA_cert_path)
    porcelain.client_cert_path = (plumbing.client_cert_path)
    porcelain.client_key_path = (plumbing.client_key_path)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.namespace = (plumbing.namespace)
    porcelain.server_address = (plumbing.server_address)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_vault_tls_store_to_plumbing(porcelain):
    plumbing = VaultTLSStore()
    if porcelain is None:
        return plumbing
    plumbing.CA_cert_path = (porcelain.ca_cert_path)
    plumbing.client_cert_path = (porcelain.client_cert_path)
    plumbing.client_key_path = (porcelain.client_key_path)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.namespace = (porcelain.namespace)
    plumbing.server_address = (porcelain.server_address)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_vault_tls_store_to_plumbing(porcelains):
    return [
        convert_vault_tls_store_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_vault_tls_store_to_porcelain(plumbings):
    return [
        convert_vault_tls_store_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_vault_token_cert_ssh_store_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.VaultTokenCertSSHStore()
    porcelain.id = (plumbing.id)
    porcelain.issuedcertttlminutes = (plumbing.issuedCertTTLMinutes)
    porcelain.name = (plumbing.name)
    porcelain.namespace = (plumbing.namespace)
    porcelain.server_address = (plumbing.server_address)
    porcelain.signing_role = (plumbing.signing_role)
    porcelain.ssh_mount_point = (plumbing.ssh_mount_point)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_vault_token_cert_ssh_store_to_plumbing(porcelain):
    plumbing = VaultTokenCertSSHStore()
    if porcelain is None:
        return plumbing
    plumbing.id = (porcelain.id)
    plumbing.issuedCertTTLMinutes = (porcelain.issuedcertttlminutes)
    plumbing.name = (porcelain.name)
    plumbing.namespace = (porcelain.namespace)
    plumbing.server_address = (porcelain.server_address)
    plumbing.signing_role = (porcelain.signing_role)
    plumbing.ssh_mount_point = (porcelain.ssh_mount_point)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_vault_token_cert_ssh_store_to_plumbing(porcelains):
    return [
        convert_vault_token_cert_ssh_store_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_vault_token_cert_ssh_store_to_porcelain(plumbings):
    return [
        convert_vault_token_cert_ssh_store_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_vault_token_cert_x_509_store_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.VaultTokenCertX509Store()
    porcelain.id = (plumbing.id)
    porcelain.issuedcertttlminutes = (plumbing.issuedCertTTLMinutes)
    porcelain.name = (plumbing.name)
    porcelain.namespace = (plumbing.namespace)
    porcelain.pki_mount_point = (plumbing.pki_mount_point)
    porcelain.server_address = (plumbing.server_address)
    porcelain.signing_role = (plumbing.signing_role)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_vault_token_cert_x_509_store_to_plumbing(porcelain):
    plumbing = VaultTokenCertX509Store()
    if porcelain is None:
        return plumbing
    plumbing.id = (porcelain.id)
    plumbing.issuedCertTTLMinutes = (porcelain.issuedcertttlminutes)
    plumbing.name = (porcelain.name)
    plumbing.namespace = (porcelain.namespace)
    plumbing.pki_mount_point = (porcelain.pki_mount_point)
    plumbing.server_address = (porcelain.server_address)
    plumbing.signing_role = (porcelain.signing_role)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_vault_token_cert_x_509_store_to_plumbing(porcelains):
    return [
        convert_vault_token_cert_x_509_store_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_vault_token_cert_x_509_store_to_porcelain(plumbings):
    return [
        convert_vault_token_cert_x_509_store_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_vault_token_store_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.VaultTokenStore()
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.namespace = (plumbing.namespace)
    porcelain.server_address = (plumbing.server_address)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_vault_token_store_to_plumbing(porcelain):
    plumbing = VaultTokenStore()
    if porcelain is None:
        return plumbing
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.namespace = (porcelain.namespace)
    plumbing.server_address = (porcelain.server_address)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_vault_token_store_to_plumbing(porcelains):
    return [
        convert_vault_token_store_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_vault_token_store_to_porcelain(plumbings):
    return [
        convert_vault_token_store_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_vertica_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Vertica()
    porcelain.bind_interface = (plumbing.bind_interface)
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.proxy_cluster_id = (plumbing.proxy_cluster_id)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_vertica_to_plumbing(porcelain):
    plumbing = Vertica()
    if porcelain is None:
        return plumbing
    plumbing.bind_interface = (porcelain.bind_interface)
    plumbing.database = (porcelain.database)
    plumbing.egress_filter = (porcelain.egress_filter)
    plumbing.healthy = (porcelain.healthy)
    plumbing.hostname = (porcelain.hostname)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.password = (porcelain.password)
    plumbing.port = (porcelain.port)
    plumbing.port_override = (porcelain.port_override)
    plumbing.proxy_cluster_id = (porcelain.proxy_cluster_id)
    plumbing.secret_store_id = (porcelain.secret_store_id)
    plumbing.subdomain = (porcelain.subdomain)
    plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_vertica_to_plumbing(porcelains):
    return [convert_vertica_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_vertica_to_porcelain(plumbings):
    return [convert_vertica_to_porcelain(plumbing) for plumbing in plumbings]


def convert_workflow_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Workflow()
    porcelain.access_request_fixed_duration = convert_duration_to_porcelain(
        plumbing.access_request_fixed_duration)
    porcelain.access_request_max_duration = convert_duration_to_porcelain(
        plumbing.access_request_max_duration)
    porcelain.access_rules = convert_access_rules_to_porcelain(
        plumbing.access_rules)
    porcelain.approval_flow_id = (plumbing.approval_flow_id)
    porcelain.auto_grant = (plumbing.auto_grant)
    porcelain.description = (plumbing.description)
    porcelain.enabled = (plumbing.enabled)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.weight = (plumbing.weight)
    return porcelain


def convert_workflow_to_plumbing(porcelain):
    plumbing = Workflow()
    if porcelain is None:
        return plumbing
    plumbing.access_request_fixed_duration.CopyFrom(
        convert_duration_to_plumbing(porcelain.access_request_fixed_duration))
    plumbing.access_request_max_duration.CopyFrom(
        convert_duration_to_plumbing(porcelain.access_request_max_duration))
    plumbing.access_rules = convert_access_rules_to_plumbing(
        porcelain.access_rules)
    plumbing.approval_flow_id = (porcelain.approval_flow_id)
    plumbing.auto_grant = (porcelain.auto_grant)
    plumbing.description = (porcelain.description)
    plumbing.enabled = (porcelain.enabled)
    plumbing.id = (porcelain.id)
    plumbing.name = (porcelain.name)
    plumbing.weight = (porcelain.weight)
    return plumbing


def convert_repeated_workflow_to_plumbing(porcelains):
    return [
        convert_workflow_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_workflow_to_porcelain(plumbings):
    return [convert_workflow_to_porcelain(plumbing) for plumbing in plumbings]


def convert_workflow_approver_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.WorkflowApprover()
    porcelain.account_id = (plumbing.account_id)
    porcelain.id = (plumbing.id)
    porcelain.role_id = (plumbing.role_id)
    porcelain.workflow_id = (plumbing.workflow_id)
    return porcelain


def convert_workflow_approver_to_plumbing(porcelain):
    plumbing = WorkflowApprover()
    if porcelain is None:
        return plumbing
    plumbing.account_id = (porcelain.account_id)
    plumbing.id = (porcelain.id)
    plumbing.role_id = (porcelain.role_id)
    plumbing.workflow_id = (porcelain.workflow_id)
    return plumbing


def convert_repeated_workflow_approver_to_plumbing(porcelains):
    return [
        convert_workflow_approver_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_workflow_approver_to_porcelain(plumbings):
    return [
        convert_workflow_approver_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_workflow_approver_get_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.WorkflowApproverGetResponse()
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.workflow_approver = convert_workflow_approver_to_porcelain(
        plumbing.workflow_approver)
    return porcelain


def convert_workflow_approver_get_response_to_plumbing(porcelain):
    plumbing = WorkflowApproverGetResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_get_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    plumbing.workflow_approver.CopyFrom(
        convert_workflow_approver_to_plumbing(porcelain.workflow_approver))
    return plumbing


def convert_repeated_workflow_approver_get_response_to_plumbing(porcelains):
    return [
        convert_workflow_approver_get_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_workflow_approver_get_response_to_porcelain(plumbings):
    return [
        convert_workflow_approver_get_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_workflow_approver_history_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.WorkflowApproverHistory()
    porcelain.activity_id = (plumbing.activity_id)
    porcelain.deleted_at = convert_timestamp_to_porcelain(plumbing.deleted_at)
    porcelain.timestamp = convert_timestamp_to_porcelain(plumbing.timestamp)
    porcelain.workflow_approver = convert_workflow_approver_to_porcelain(
        plumbing.workflow_approver)
    return porcelain


def convert_workflow_approver_history_to_plumbing(porcelain):
    plumbing = WorkflowApproverHistory()
    if porcelain is None:
        return plumbing
    plumbing.activity_id = (porcelain.activity_id)
    plumbing.deleted_at.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.deleted_at))
    plumbing.timestamp.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.timestamp))
    plumbing.workflow_approver.CopyFrom(
        convert_workflow_approver_to_plumbing(porcelain.workflow_approver))
    return plumbing


def convert_repeated_workflow_approver_history_to_plumbing(porcelains):
    return [
        convert_workflow_approver_history_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_workflow_approver_history_to_porcelain(plumbings):
    return [
        convert_workflow_approver_history_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_workflow_approvers_create_request_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.WorkflowApproversCreateRequest()
    porcelain.workflow_approver = convert_workflow_approver_to_porcelain(
        plumbing.workflow_approver)
    return porcelain


def convert_workflow_approvers_create_request_to_plumbing(porcelain):
    plumbing = WorkflowApproversCreateRequest()
    if porcelain is None:
        return plumbing
    plumbing.workflow_approver.CopyFrom(
        convert_workflow_approver_to_plumbing(porcelain.workflow_approver))
    return plumbing


def convert_repeated_workflow_approvers_create_request_to_plumbing(porcelains):
    return [
        convert_workflow_approvers_create_request_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_workflow_approvers_create_request_to_porcelain(plumbings):
    return [
        convert_workflow_approvers_create_request_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_workflow_approvers_create_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.WorkflowApproversCreateResponse()
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.workflow_approver = convert_workflow_approver_to_porcelain(
        plumbing.workflow_approver)
    return porcelain


def convert_workflow_approvers_create_response_to_plumbing(porcelain):
    plumbing = WorkflowApproversCreateResponse()
    if porcelain is None:
        return plumbing
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    plumbing.workflow_approver.CopyFrom(
        convert_workflow_approver_to_plumbing(porcelain.workflow_approver))
    return plumbing


def convert_repeated_workflow_approvers_create_response_to_plumbing(
        porcelains):
    return [
        convert_workflow_approvers_create_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_workflow_approvers_create_response_to_porcelain(
        plumbings):
    return [
        convert_workflow_approvers_create_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_workflow_approvers_delete_request_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.WorkflowApproversDeleteRequest()
    porcelain.id = (plumbing.id)
    return porcelain


def convert_workflow_approvers_delete_request_to_plumbing(porcelain):
    plumbing = WorkflowApproversDeleteRequest()
    if porcelain is None:
        return plumbing
    plumbing.id = (porcelain.id)
    return plumbing


def convert_repeated_workflow_approvers_delete_request_to_plumbing(porcelains):
    return [
        convert_workflow_approvers_delete_request_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_workflow_approvers_delete_request_to_porcelain(plumbings):
    return [
        convert_workflow_approvers_delete_request_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_workflow_approvers_delete_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.WorkflowApproversDeleteResponse()
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_workflow_approvers_delete_response_to_plumbing(porcelain):
    plumbing = WorkflowApproversDeleteResponse()
    if porcelain is None:
        return plumbing
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_workflow_approvers_delete_response_to_plumbing(
        porcelains):
    return [
        convert_workflow_approvers_delete_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_workflow_approvers_delete_response_to_porcelain(
        plumbings):
    return [
        convert_workflow_approvers_delete_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_workflow_approvers_list_request_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.WorkflowApproversListRequest()
    porcelain.filter = (plumbing.filter)
    return porcelain


def convert_workflow_approvers_list_request_to_plumbing(porcelain):
    plumbing = WorkflowApproversListRequest()
    if porcelain is None:
        return plumbing
    plumbing.filter = (porcelain.filter)
    return plumbing


def convert_repeated_workflow_approvers_list_request_to_plumbing(porcelains):
    return [
        convert_workflow_approvers_list_request_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_workflow_approvers_list_request_to_porcelain(plumbings):
    return [
        convert_workflow_approvers_list_request_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_workflow_approvers_list_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.WorkflowApproversListResponse()
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_workflow_approvers_list_response_to_plumbing(porcelain):
    plumbing = WorkflowApproversListResponse()
    if porcelain is None:
        return plumbing
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_workflow_approvers_list_response_to_plumbing(porcelains):
    return [
        convert_workflow_approvers_list_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_workflow_approvers_list_response_to_porcelain(plumbings):
    return [
        convert_workflow_approvers_list_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_workflow_assignment_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.WorkflowAssignment()
    porcelain.resource_id = (plumbing.resource_id)
    porcelain.workflow_id = (plumbing.workflow_id)
    return porcelain


def convert_workflow_assignment_to_plumbing(porcelain):
    plumbing = WorkflowAssignment()
    if porcelain is None:
        return plumbing
    plumbing.resource_id = (porcelain.resource_id)
    plumbing.workflow_id = (porcelain.workflow_id)
    return plumbing


def convert_repeated_workflow_assignment_to_plumbing(porcelains):
    return [
        convert_workflow_assignment_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_workflow_assignment_to_porcelain(plumbings):
    return [
        convert_workflow_assignment_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_workflow_assignment_history_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.WorkflowAssignmentHistory()
    porcelain.activity_id = (plumbing.activity_id)
    porcelain.deleted_at = convert_timestamp_to_porcelain(plumbing.deleted_at)
    porcelain.timestamp = convert_timestamp_to_porcelain(plumbing.timestamp)
    porcelain.workflow_assignment = convert_workflow_assignment_to_porcelain(
        plumbing.workflow_assignment)
    return porcelain


def convert_workflow_assignment_history_to_plumbing(porcelain):
    plumbing = WorkflowAssignmentHistory()
    if porcelain is None:
        return plumbing
    plumbing.activity_id = (porcelain.activity_id)
    plumbing.deleted_at.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.deleted_at))
    plumbing.timestamp.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.timestamp))
    plumbing.workflow_assignment.CopyFrom(
        convert_workflow_assignment_to_plumbing(porcelain.workflow_assignment))
    return plumbing


def convert_repeated_workflow_assignment_history_to_plumbing(porcelains):
    return [
        convert_workflow_assignment_history_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_workflow_assignment_history_to_porcelain(plumbings):
    return [
        convert_workflow_assignment_history_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_workflow_assignments_list_request_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.WorkflowAssignmentsListRequest()
    porcelain.filter = (plumbing.filter)
    return porcelain


def convert_workflow_assignments_list_request_to_plumbing(porcelain):
    plumbing = WorkflowAssignmentsListRequest()
    if porcelain is None:
        return plumbing
    plumbing.filter = (porcelain.filter)
    return plumbing


def convert_repeated_workflow_assignments_list_request_to_plumbing(porcelains):
    return [
        convert_workflow_assignments_list_request_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_workflow_assignments_list_request_to_porcelain(plumbings):
    return [
        convert_workflow_assignments_list_request_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_workflow_assignments_list_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.WorkflowAssignmentsListResponse()
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_workflow_assignments_list_response_to_plumbing(porcelain):
    plumbing = WorkflowAssignmentsListResponse()
    if porcelain is None:
        return plumbing
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_workflow_assignments_list_response_to_plumbing(
        porcelains):
    return [
        convert_workflow_assignments_list_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_workflow_assignments_list_response_to_porcelain(
        plumbings):
    return [
        convert_workflow_assignments_list_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_workflow_create_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.WorkflowCreateResponse()
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.workflow = convert_workflow_to_porcelain(plumbing.workflow)
    return porcelain


def convert_workflow_create_response_to_plumbing(porcelain):
    plumbing = WorkflowCreateResponse()
    if porcelain is None:
        return plumbing
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    plumbing.workflow.CopyFrom(convert_workflow_to_plumbing(
        porcelain.workflow))
    return plumbing


def convert_repeated_workflow_create_response_to_plumbing(porcelains):
    return [
        convert_workflow_create_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_workflow_create_response_to_porcelain(plumbings):
    return [
        convert_workflow_create_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_workflow_delete_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.WorkflowDeleteResponse()
    porcelain.id = (plumbing.id)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_workflow_delete_response_to_plumbing(porcelain):
    plumbing = WorkflowDeleteResponse()
    if porcelain is None:
        return plumbing
    plumbing.id = (porcelain.id)
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_workflow_delete_response_to_plumbing(porcelains):
    return [
        convert_workflow_delete_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_workflow_delete_response_to_porcelain(plumbings):
    return [
        convert_workflow_delete_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_workflow_get_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.WorkflowGetResponse()
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.workflow = convert_workflow_to_porcelain(plumbing.workflow)
    return porcelain


def convert_workflow_get_response_to_plumbing(porcelain):
    plumbing = WorkflowGetResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_get_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    plumbing.workflow.CopyFrom(convert_workflow_to_plumbing(
        porcelain.workflow))
    return plumbing


def convert_repeated_workflow_get_response_to_plumbing(porcelains):
    return [
        convert_workflow_get_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_workflow_get_response_to_porcelain(plumbings):
    return [
        convert_workflow_get_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_workflow_history_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.WorkflowHistory()
    porcelain.activity_id = (plumbing.activity_id)
    porcelain.deleted_at = convert_timestamp_to_porcelain(plumbing.deleted_at)
    porcelain.timestamp = convert_timestamp_to_porcelain(plumbing.timestamp)
    porcelain.workflow = convert_workflow_to_porcelain(plumbing.workflow)
    return porcelain


def convert_workflow_history_to_plumbing(porcelain):
    plumbing = WorkflowHistory()
    if porcelain is None:
        return plumbing
    plumbing.activity_id = (porcelain.activity_id)
    plumbing.deleted_at.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.deleted_at))
    plumbing.timestamp.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.timestamp))
    plumbing.workflow.CopyFrom(convert_workflow_to_plumbing(
        porcelain.workflow))
    return plumbing


def convert_repeated_workflow_history_to_plumbing(porcelains):
    return [
        convert_workflow_history_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_workflow_history_to_porcelain(plumbings):
    return [
        convert_workflow_history_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_workflow_list_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.WorkflowListResponse()
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_workflow_list_response_to_plumbing(porcelain):
    plumbing = WorkflowListResponse()
    if porcelain is None:
        return plumbing
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_workflow_list_response_to_plumbing(porcelains):
    return [
        convert_workflow_list_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_workflow_list_response_to_porcelain(plumbings):
    return [
        convert_workflow_list_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_workflow_role_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.WorkflowRole()
    porcelain.id = (plumbing.id)
    porcelain.role_id = (plumbing.role_id)
    porcelain.workflow_id = (plumbing.workflow_id)
    return porcelain


def convert_workflow_role_to_plumbing(porcelain):
    plumbing = WorkflowRole()
    if porcelain is None:
        return plumbing
    plumbing.id = (porcelain.id)
    plumbing.role_id = (porcelain.role_id)
    plumbing.workflow_id = (porcelain.workflow_id)
    return plumbing


def convert_repeated_workflow_role_to_plumbing(porcelains):
    return [
        convert_workflow_role_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_workflow_role_to_porcelain(plumbings):
    return [
        convert_workflow_role_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_workflow_role_get_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.WorkflowRoleGetResponse()
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.workflow_role = convert_workflow_role_to_porcelain(
        plumbing.workflow_role)
    return porcelain


def convert_workflow_role_get_response_to_plumbing(porcelain):
    plumbing = WorkflowRoleGetResponse()
    if porcelain is None:
        return plumbing
    plumbing.meta.CopyFrom(
        convert_get_response_metadata_to_plumbing(porcelain.meta))
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    plumbing.workflow_role.CopyFrom(
        convert_workflow_role_to_plumbing(porcelain.workflow_role))
    return plumbing


def convert_repeated_workflow_role_get_response_to_plumbing(porcelains):
    return [
        convert_workflow_role_get_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_workflow_role_get_response_to_porcelain(plumbings):
    return [
        convert_workflow_role_get_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_workflow_role_history_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.WorkflowRoleHistory()
    porcelain.activity_id = (plumbing.activity_id)
    porcelain.deleted_at = convert_timestamp_to_porcelain(plumbing.deleted_at)
    porcelain.timestamp = convert_timestamp_to_porcelain(plumbing.timestamp)
    porcelain.workflow_role = convert_workflow_role_to_porcelain(
        plumbing.workflow_role)
    return porcelain


def convert_workflow_role_history_to_plumbing(porcelain):
    plumbing = WorkflowRoleHistory()
    if porcelain is None:
        return plumbing
    plumbing.activity_id = (porcelain.activity_id)
    plumbing.deleted_at.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.deleted_at))
    plumbing.timestamp.CopyFrom(
        convert_timestamp_to_plumbing(porcelain.timestamp))
    plumbing.workflow_role.CopyFrom(
        convert_workflow_role_to_plumbing(porcelain.workflow_role))
    return plumbing


def convert_repeated_workflow_role_history_to_plumbing(porcelains):
    return [
        convert_workflow_role_history_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_workflow_role_history_to_porcelain(plumbings):
    return [
        convert_workflow_role_history_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_workflow_roles_create_request_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.WorkflowRolesCreateRequest()
    porcelain.workflow_role = convert_workflow_role_to_porcelain(
        plumbing.workflow_role)
    return porcelain


def convert_workflow_roles_create_request_to_plumbing(porcelain):
    plumbing = WorkflowRolesCreateRequest()
    if porcelain is None:
        return plumbing
    plumbing.workflow_role.CopyFrom(
        convert_workflow_role_to_plumbing(porcelain.workflow_role))
    return plumbing


def convert_repeated_workflow_roles_create_request_to_plumbing(porcelains):
    return [
        convert_workflow_roles_create_request_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_workflow_roles_create_request_to_porcelain(plumbings):
    return [
        convert_workflow_roles_create_request_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_workflow_roles_create_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.WorkflowRolesCreateResponse()
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.workflow_role = convert_workflow_role_to_porcelain(
        plumbing.workflow_role)
    return porcelain


def convert_workflow_roles_create_response_to_plumbing(porcelain):
    plumbing = WorkflowRolesCreateResponse()
    if porcelain is None:
        return plumbing
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    plumbing.workflow_role.CopyFrom(
        convert_workflow_role_to_plumbing(porcelain.workflow_role))
    return plumbing


def convert_repeated_workflow_roles_create_response_to_plumbing(porcelains):
    return [
        convert_workflow_roles_create_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_workflow_roles_create_response_to_porcelain(plumbings):
    return [
        convert_workflow_roles_create_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_workflow_roles_delete_request_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.WorkflowRolesDeleteRequest()
    porcelain.id = (plumbing.id)
    return porcelain


def convert_workflow_roles_delete_request_to_plumbing(porcelain):
    plumbing = WorkflowRolesDeleteRequest()
    if porcelain is None:
        return plumbing
    plumbing.id = (porcelain.id)
    return plumbing


def convert_repeated_workflow_roles_delete_request_to_plumbing(porcelains):
    return [
        convert_workflow_roles_delete_request_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_workflow_roles_delete_request_to_porcelain(plumbings):
    return [
        convert_workflow_roles_delete_request_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_workflow_roles_delete_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.WorkflowRolesDeleteResponse()
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_workflow_roles_delete_response_to_plumbing(porcelain):
    plumbing = WorkflowRolesDeleteResponse()
    if porcelain is None:
        return plumbing
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_workflow_roles_delete_response_to_plumbing(porcelains):
    return [
        convert_workflow_roles_delete_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_workflow_roles_delete_response_to_porcelain(plumbings):
    return [
        convert_workflow_roles_delete_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_workflow_roles_list_request_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.WorkflowRolesListRequest()
    porcelain.filter = (plumbing.filter)
    return porcelain


def convert_workflow_roles_list_request_to_plumbing(porcelain):
    plumbing = WorkflowRolesListRequest()
    if porcelain is None:
        return plumbing
    plumbing.filter = (porcelain.filter)
    return plumbing


def convert_repeated_workflow_roles_list_request_to_plumbing(porcelains):
    return [
        convert_workflow_roles_list_request_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_workflow_roles_list_request_to_porcelain(plumbings):
    return [
        convert_workflow_roles_list_request_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_workflow_roles_list_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.WorkflowRolesListResponse()
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_workflow_roles_list_response_to_plumbing(porcelain):
    plumbing = WorkflowRolesListResponse()
    if porcelain is None:
        return plumbing
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_workflow_roles_list_response_to_plumbing(porcelains):
    return [
        convert_workflow_roles_list_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_workflow_roles_list_response_to_porcelain(plumbings):
    return [
        convert_workflow_roles_list_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_workflow_update_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.WorkflowUpdateResponse()
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.workflow = convert_workflow_to_porcelain(plumbing.workflow)
    return porcelain


def convert_workflow_update_response_to_plumbing(porcelain):
    plumbing = WorkflowUpdateResponse()
    if porcelain is None:
        return plumbing
    plumbing.rate_limit.CopyFrom(
        convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    plumbing.workflow.CopyFrom(convert_workflow_to_plumbing(
        porcelain.workflow))
    return plumbing


def convert_repeated_workflow_update_response_to_plumbing(porcelains):
    return [
        convert_workflow_update_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_workflow_update_response_to_porcelain(plumbings):
    return [
        convert_workflow_update_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def is_status_detail(x):
    # Return True if a metadata is a grpc-status-details
    if (hasattr(x, 'key') and (hasattr(x, 'value'))
            and x.key.startswith('grpc-status-details')):
        return True
    return False


def get_status_metadata(err):
    # Extracts error details from a grpc.RpcError.
    # Returns a status object and a list of details.
    metadata = err.trailing_metadata()

    # get only metadata relevant to status details
    status_md = [x for x in metadata if is_status_detail(x)]
    st = None
    if status_md:
        for md in status_md:
            st = status_pb2.Status()
            # there should be exactly one status for every RpcError
            # so MergeFromString should at worst append more details
            # but never override st.message and st.code in every loop
            st.MergeFromString(md.value)

    return st


def convert_error_to_porcelain(err):
    if not isinstance(err, grpc.RpcError):
        return errors.UnknownError(str(err))
    # get_status_metadata fails for deadline exceeded
    if err.code().name == 'DEADLINE_EXCEEDED':
        return errors.TimeoutError()
    status = get_status_metadata(err)
    if status is None:
        code, name = err.code().value
        return errors.RPCError(name, code)
    if err.code() == grpc.StatusCode.INVALID_ARGUMENT:
        return errors.BadRequestError(status.message)
    elif err.code() == grpc.StatusCode.NOT_FOUND:
        return errors.NotFoundError(status.message)
    elif err.code() == grpc.StatusCode.ALREADY_EXISTS:
        return errors.AlreadyExistsError(status.message)
    elif err.code() == grpc.StatusCode.PERMISSION_DENIED:
        return errors.PermissionError(status.message)
    elif err.code() == grpc.StatusCode.RESOURCE_EXHAUSTED:
        for detail in status.details:
            if detail.Is(RateLimitMetadata.DESCRIPTOR):
                rate_limit = RateLimitMetadata()
                detail.Unpack(rate_limit)
                return errors.RateLimitError(
                    status.message,
                    convert_rate_limit_metadata_to_porcelain(rate_limit))
    elif err.code() == grpc.StatusCode.INTERNAL:
        return errors.InternalError(status.message)
    elif err.code() == grpc.StatusCode.UNAUTHENTICATED:
        return errors.AuthenticationError(status.message)

    code = err.code().value[0]
    return errors.RPCError(status.message, code)
