# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AdultInfo(Model):
    """An object describing whether the image contains adult-oriented content
    and/or is racy.

    :param is_adult_content: A value indicating if the image contains
     adult-oriented content.
    :type is_adult_content: bool
    :param is_racy_content: A value indicating if the image is racy.
    :type is_racy_content: bool
    :param adult_score: Score from 0 to 1 that indicates how much the content
     is considered adult-oriented within the image.
    :type adult_score: float
    :param racy_score: Score from 0 to 1 that indicates how suggestive is the
     image.
    :type racy_score: float
    """

    _attribute_map = {
        'is_adult_content': {'key': 'isAdultContent', 'type': 'bool'},
        'is_racy_content': {'key': 'isRacyContent', 'type': 'bool'},
        'adult_score': {'key': 'adultScore', 'type': 'float'},
        'racy_score': {'key': 'racyScore', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(AdultInfo, self).__init__(**kwargs)
        self.is_adult_content = kwargs.get('is_adult_content', None)
        self.is_racy_content = kwargs.get('is_racy_content', None)
        self.adult_score = kwargs.get('adult_score', None)
        self.racy_score = kwargs.get('racy_score', None)
