/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.summary;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.brunel.data.Field;
import org.brunel.data.modify.Transform;
import org.brunel.data.summary.DimensionField;
import org.brunel.data.summary.Fit;
import org.brunel.translator.JSTranslation;

public class MeasureField
extends DimensionField {
    public final String method;
    public String option;
    public final Map<String, Fit> fits = new HashMap<String, Fit>();

    public MeasureField(Field field, String rename, String measureFunction) {
        super(field, rename == null && field == null ? measureFunction : rename);
        this.method = field != null && measureFunction.equals("mean") && !field.isNumeric() ? "mode" : measureFunction;
    }

    public Fit getFit(ArrayList<Field> groupFields, int index) {
        return this.fits.get(Transform.makeKey(groupFields, index));
    }

    public void setFit(ArrayList<Field> groupFields, int index, Fit fit) {
        this.fits.put(Transform.makeKey(groupFields, index), fit);
    }

    public boolean isPercent() {
        return this.method.equals("percent");
    }

    @Override
    @JSTranslation(ignore=true)
    public String toString() {
        if (this.field != null && this.field.name.equals(this.rename)) {
            return this.label();
        }
        return this.label() + "[->" + this.rename + "]";
    }

    @Override
    public String label() {
        if (this.method.equals("list")) {
            return this.field.label;
        }
        if (this.method.equals("count")) {
            return "Count";
        }
        if (this.field == null || this.field.name.equals("#count")) {
            if (this.method.equals("sum")) {
                return this.field.label;
            }
            if (this.method.equals("percent")) {
                return "Percent";
            }
        }
        String a = this.method.substring(0, 1).toUpperCase();
        String b = this.method.substring(1);
        return a + b + "(" + this.field.label + ")";
    }
}

