/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.stats;

import org.brunel.data.Field;
import org.brunel.data.util.MapInt;

public class NominalStats {
    public static void populate(Field f) {
        Object[] naturalOrder;
        MapInt counts = new MapInt();
        int N = f.rowCount();
        for (int i = 0; i < N; ++i) {
            counts.increment(f.value(i));
        }
        f.set("n", N);
        f.set("unique", counts.size());
        f.set("valid", counts.getTotalCount());
        f.set("mode", counts.mode());
        if (f.isProperty("categoriesOrdered")) {
            naturalOrder = f.categories();
        } else {
            naturalOrder = f.name.equals("#selection") ? new Object[]{"\u2717", "\u2713"} : counts.sortedKeys();
            f.set("categories", naturalOrder);
        }
        f.set("categoryCounts", counts.getCounts(naturalOrder));
    }

    public static boolean creates(String key) {
        return "n".equals(key) || "mode".equals(key) || "unique".equals(key) || "valid".equals(key) || "categories".equals(key) || "categoryCounts".equals(key);
    }
}

