/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data;

import org.brunel.data.Data;
import org.brunel.data.Field;
import org.brunel.data.values.ColumnProvider;
import org.brunel.data.values.ConstantProvider;
import org.brunel.data.values.ReorderedProvider;
import org.brunel.data.values.RowProvider;

public class Fields {
    public static Field makeConstantField(String name, String label, Object o, int len) {
        Field field = new Field(name, label, new ConstantProvider(o, len));
        if (Data.asNumeric(o) != null) {
            field.setNumeric();
        }
        return field;
    }

    public static Field makeIndexingField(String name, String label, int len) {
        Field field = new Field(name, label, new RowProvider(len));
        field.setNumeric();
        return field;
    }

    public static Field makeColumnField(String name, String label, Object[] data) {
        return new Field(name, label, new ColumnProvider(data));
    }

    public static Field permute(Field field, int[] order, boolean onlyOrderChanged) {
        if (field.provider instanceof ConstantProvider) {
            if (onlyOrderChanged) {
                return field;
            }
            return Fields.makeConstantField(field.name, field.label, field.value(0), order.length);
        }
        if (onlyOrderChanged) {
            return new Field(field.name, field.label, new ReorderedProvider(field.provider, order), field);
        }
        Field f = new Field(field.name, field.label, new ReorderedProvider(field.provider, order));
        Fields.copyBaseProperties(field, f);
        return f;
    }

    public static void copyBaseProperties(Field source, Field target) {
        target.copyProperties(source, "numeric", "binned", "summary", "transform", "list", "listCategories", "date", "categoriesOrdered", "dateUnit", "dateFormat");
        if (source.isProperty("categoriesOrdered")) {
            target.set("categories", source.property("categories"));
        }
    }
}

