/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.util;

import java.awt.Desktop;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.brunel.build.Builder;
import org.brunel.build.d3.D3Builder;
import org.brunel.build.util.BuilderOptions;
import org.brunel.data.Data;
import org.brunel.model.VisItem;

public class WebDisplay {
    private static final String NAV_LOCATION = "/org/brunel/util/webdisplay-navigation.html";
    private static final String SINGLE_LOCATION = "/org/brunel/util/webdisplay-single.html";
    private static final String NAV_BASE = new Scanner(WebDisplay.class.getResourceAsStream("/org/brunel/util/webdisplay-navigation.html"), "UTF-8").useDelimiter("\\A").next();
    private static final String BASE = new Scanner(WebDisplay.class.getResourceAsStream("/org/brunel/util/webdisplay-single.html"), "UTF-8").useDelimiter("\\A").next();
    private final File displayBaseDir;
    private static File home;
    private static File out;
    private final BuilderOptions options;
    private int count;
    private String menuString = "<html><head><title>Charts</title></head><body>\n";
    private final ArrayList<String> headers = new ArrayList();

    public static String writeHtml(D3Builder builder, int width, int height, List<String> moreHeaders, String brunel, String ... titles) {
        String css = builder.getStyleOverrides();
        String js = (String)builder.getVisualization();
        String imports = builder.makeImports();
        if (width < 5) {
            width = 800;
        }
        if (height < 5) {
            height = 600;
        }
        String title = WebDisplay.constructTitle(titles);
        String brunelTitle = WebDisplay.constructBrunelTitle(brunel);
        String stylesheets = builder.makeStyleSheets();
        if (moreHeaders != null) {
            for (String s : moreHeaders) {
                stylesheets = stylesheets + s + "\n";
            }
        }
        String header = imports + stylesheets;
        if (!css.isEmpty()) {
            header = header + WebDisplay.makeForHTML(css);
        }
        String controls = builder.getControls().isNeeded() ? "<div id=\"controls\" class=\"brunel\"></div>\n" : "";
        return BASE.replace("$WIDTH$", Data.formatNumeric((double)width, (boolean)true)).replace("$HEIGHT$", Data.formatNumeric((double)height, (boolean)true)).replace("$HEADER$", header).replace("$TITLE$", title).replace("$BRUNEL$", brunelTitle).replace("$CONTROLS$", controls).replace("$SCRIPT$", js);
    }

    private static String makeForHTML(String css) {
        StringBuilder b = new StringBuilder();
        b.append("\t<style>\n").append("\t\t/* Generated by Brunel style commands */\n");
        for (String s : css.split("\n")) {
            b.append("\t\t").append(s).append("\n");
        }
        b.append("\t</style>");
        return b.toString();
    }

    private static String constructBrunelTitle(String brunel) {
        if (brunel == null) {
            return "";
        }
        return "<small>" + brunel + "</small>\n";
    }

    private static String constructTitle(String[] titles) {
        if (titles == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < titles.length; ++i) {
            String a = titles[i];
            if (a.startsWith("<")) {
                builder.append(a);
            } else if (i == 0) {
                builder.append("<h2>").append(a).append("</h2>");
            } else {
                builder.append("<p>").append(a).append("</p>");
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    public WebDisplay(BuilderOptions options, String dirName) {
        this.options = options;
        this.ensureBaseDirectoriesBuilt();
        this.ensureResourceExists("BrunelD3.js");
        this.ensureResourceExists("BrunelData.js");
        this.ensureResourceExists("Brunel.css");
        this.ensureResourceExists("BrunelEventHandlers.js");
        this.ensureResourceExists("BrunelJQueryControlFactory.js");
        this.ensureResourceExists("sumoselect/jquery.sumoselect.min.js");
        this.ensureResourceExists("sumoselect/sumoselect.css");
        this.displayBaseDir = this.makeDir(dirName);
    }

    public File makeFile(String s) {
        return new File(this.displayBaseDir, s);
    }

    private void ensureBaseDirectoriesBuilt() {
        if (home != null) {
            return;
        }
        String brunelDir = System.getProperty("brunel.home");
        home = brunelDir != null ? new File(brunelDir) : new File(System.getProperty("user.home"), "brunel");
        home.mkdirs();
        if (!home.canWrite()) {
            throw new IllegalArgumentException("Cannot write to the Locations directory: " + home.getAbsolutePath());
        }
        out = new File(home, "out");
        out.mkdir();
        if (!out.canWrite()) {
            throw new IllegalArgumentException("Cannot write to the Locations directory: " + out.getAbsolutePath());
        }
        new File(out, "/sumoselect").mkdirs();
    }

    public void buildOneOfMultiple(VisItem target, String groupName, String name, Dimension size) {
        if (this.count == 0) {
            this.writeToFile("index.html", NAV_BASE.replace("$TITLE$", this.displayBaseDir.getName()));
        }
        String file = this.count + ".html";
        String text = this.count + ": " + groupName;
        this.menuString = this.menuString + "<a href=\"" + file + " \" target=\"content\">" + text + "</a><br>\n";
        this.writeToFile("menu.html", this.menuString + "</body></html>");
        try {
            ++this.count;
            this.buildSingle(target, size.width, size.height, file, name);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.buildError(file);
        }
    }

    public void buildSingle(VisItem target, int width, int height, String file, String ... titles) {
        D3Builder builder = D3Builder.make(this.options);
        builder.build(target, width, height);
        String html = WebDisplay.writeHtml(builder, width, height, this.headers, null, titles);
        this.writeToFile(file, html);
    }

    public File makeDir(String name) {
        File f = new File(home, name);
        f.mkdirs();
        if (!f.canWrite()) {
            throw new IllegalArgumentException("Cannot write to the Locations directory: " + f.getAbsolutePath());
        }
        return f;
    }

    public void showInBrowser() {
        try {
            Desktop desktop = Desktop.getDesktop();
            desktop.browse(new File(this.displayBaseDir, "index.html").toURI());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void buildError(String file) {
        try {
            this.writeToFile(file, BASE.replace("$SCRIPT$", "document.write('Error');"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void ensureResourceExists(String resourceName) {
        try {
            InputStream is = Builder.class.getResourceAsStream("/javascript/" + resourceName);
            if (is == null) {
                is = Builder.class.getResourceAsStream("/translated/" + resourceName);
            }
            if (is == null) {
                File file = new File("data/build/translated/");
                if (!file.exists()) {
                    file = new File("../data/build/translated/");
                }
                is = new FileInputStream(new File(file, resourceName));
            }
            File brunelD3 = new File(out, resourceName);
            Files.copy(is, brunelD3.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not copy required " + resourceName + " to output folder: " + out, e);
        }
    }

    private void writeToFile(String fileName, String html) {
        try {
            File file = new File(this.displayBaseDir, fileName);
            PrintWriter item = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf-8"));
            item.println(html);
            item.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

