/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.util;

import com.google.gson.Gson;
import org.brunel.action.Action;
import org.brunel.action.ActionUtil;
import org.brunel.action.Param;
import org.brunel.build.d3.D3Builder;
import org.brunel.build.util.BuilderOptions;
import org.brunel.build.util.DataCache;
import org.brunel.data.Dataset;
import org.brunel.data.Field;
import org.brunel.data.io.CSV;
import org.brunel.model.VisException;
import org.brunel.model.VisItem;
import org.brunel.util.BrunelD3Result;

public class D3Integration {
    private static final Gson gson = new Gson();

    public static String createBrunelJSON(String data, String brunelSrc, int width, int height, String visId, String controlsId) {
        try {
            BrunelD3Result result = D3Integration.createBrunelResult(data, brunelSrc, width, height, visId, controlsId);
            return gson.toJson((Object)result);
        }
        catch (Exception ex) {
            throw new RuntimeException(D3Integration.buildExceptionMessage(ex, ex.getMessage(), ".  "));
        }
    }

    public static void cacheData(String dataKey, Dataset data) {
        DataCache.store(dataKey, data);
    }

    public static void cacheData(String dataKey, String csv) {
        DataCache.store(dataKey, D3Integration.makeBrunelData(csv));
    }

    public static String[] getDatasetNames(String brunel) {
        Param[] params = ActionUtil.dataParameters(Action.parse(brunel));
        String[] names = new String[params.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = params[i].asString();
        }
        return names;
    }

    public static String prefixAllDataStatements(String brunel, String prefix) {
        return ActionUtil.prefixAllDataStatements(Action.parse(brunel), prefix);
    }

    public static BrunelD3Result createBrunelResult(String data, String brunelSrc, int width, int height, String visId, String controlsId) {
        Dataset dataset = D3Integration.makeBrunelData(data);
        D3Builder builder = D3Integration.makeD3(dataset, brunelSrc, width, height, visId, controlsId);
        BrunelD3Result result = new BrunelD3Result();
        result.css = builder.getStyleOverrides();
        result.js = builder.getVisualization().toString();
        result.controls = builder.getControls();
        return result;
    }

    public static String buildExceptionMessage(Throwable thrown, String message, String messageSeparator) {
        for (Throwable cause = thrown.getCause(); cause != null; cause = cause.getCause()) {
            message = message + messageSeparator + cause.getMessage();
            if (cause instanceof VisException) break;
        }
        return message;
    }

    public static D3Builder makeD3(Dataset data, String actionText, int width, int height, String visId, String controlsId) {
        try {
            BuilderOptions options = new BuilderOptions();
            options.visIdentifier = visId;
            options.controlsIdentifier = controlsId;
            D3Builder builder = D3Builder.make(options);
            VisItem item = D3Integration.makeVisItem(data, actionText);
            builder.build(item, width, height);
            return builder;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalArgumentException("Could not execute Brunel: " + actionText, ex);
        }
    }

    private static Dataset makeBrunelData(String data) {
        if (data == null || data.isEmpty()) {
            return null;
        }
        try {
            return Dataset.make((Field[])CSV.read((String)data));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not create data as CSV from content", e);
        }
    }

    private static VisItem makeVisItem(Dataset brunel, String actionText) {
        Action action = Action.parse(actionText);
        if (brunel == null) {
            return action.apply();
        }
        return action.apply(brunel);
    }
}

