/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.model;

import org.brunel.model.VisItem;

public class VisException
extends RuntimeException {
    private final String info;
    private final Throwable cause;
    private final Object source;

    public static VisException makeApplying(Throwable cause, Object action) {
        return cause instanceof VisException ? (VisException)cause : new VisException("applying action", cause, action);
    }

    public static VisException makeBuilding(Throwable cause, VisItem item) {
        return cause instanceof VisException ? (VisException)cause : new VisException("building the visualization", cause, item);
    }

    public static VisException makeParsing(Throwable cause, String action) {
        return cause instanceof VisException ? (VisException)cause : new VisException("parsing action text", cause, action);
    }

    private VisException(String info, Throwable cause, Object source) {
        super(VisException.makeMessage(cause) + " while " + info + ": " + source, cause);
        this.info = info;
        this.cause = cause;
        this.source = source;
        this.setStackTrace(cause.getStackTrace());
    }

    private static String makeMessage(Throwable cause) {
        String s;
        String message = "A programming error caused an exception";
        if (cause != null && cause.getMessage() != null && (s = cause.getMessage().replaceAll("\n", ". ").trim()).length() > 5) {
            message = s;
        }
        if (message.endsWith(".")) {
            message = message.substring(0, message.length() - 1).trim();
        }
        return message;
    }

    public Object getSource() {
        return this.source;
    }

    public String getType() {
        return this.info;
    }

    public String getShortMessage() {
        return VisException.makeMessage(this.cause);
    }
}

