/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.maps;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.brunel.action.Param;
import org.brunel.data.io.CSV;
import org.brunel.geom.Point;
import org.brunel.geom.Poly;
import org.brunel.maps.GeoFile;
import org.brunel.maps.GeoMapping;
import org.brunel.maps.GeoNaming;
import org.brunel.maps.IndexedFeature;
import org.brunel.maps.LabelPoint;
import org.brunel.util.MappedLists;

class GeoData {
    private static GeoData INSTANCE;
    private final Map<String, int[][]> featureMap;
    private final Map<String, GeoFile> filesByName;
    private final Map<String, LabelPoint> labelsByName;
    private final GeoFile[] geoFiles;
    private final LabelPoint[] labels;

    public static synchronized GeoData instance() {
        if (INSTANCE == null) {
            INSTANCE = new GeoData();
        }
        return INSTANCE;
    }

    MappedLists<GeoFile, Object> mapFeaturesToFiles(Object[] names, Collection<Object> unmatched) {
        MappedLists<GeoFile, Object> contained = new MappedLists<GeoFile, Object>();
        for (Object s : names) {
            String key = s.toString();
            int[][] item = this.featureByName(key);
            if (item == null) {
                unmatched.add(s);
                continue;
            }
            for (int[] i : item) {
                GeoFile file = this.geoFiles[i[0]];
                contained.add(file, new IndexedFeature(key, i[1]));
            }
        }
        return contained;
    }

    private GeoData() {
        try {
            InputStream is = GeoData.class.getResourceAsStream("/org/brunel/maps/geoindex.txt");
            LineNumberReader rdr = new LineNumberReader(new InputStreamReader(is, "utf-8"));
            this.geoFiles = this.readFileDescriptions(rdr);
            this.featureMap = this.readFeatureDescriptions(rdr);
            rdr.close();
            this.filesByName = this.makeFileNameMap(this.geoFiles);
            is = GeoData.class.getResourceAsStream("/org/brunel/maps/locations.txt");
            rdr = new LineNumberReader(new InputStreamReader(is, "utf-8"));
            this.labels = this.readLabels(rdr);
            rdr.close();
            this.labelsByName = this.makeLabelsMap();
            this.placeLabelsInFiles();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.addVariantFeatureNames();
    }

    private HashMap<String, LabelPoint> makeLabelsMap() {
        HashMap<String, LabelPoint> map = new HashMap<String, LabelPoint>();
        for (LabelPoint s : this.labels) {
            String name = GeoNaming.canonical(s.label);
            LabelPoint previous = map.put(name, s);
            if (previous == null || previous.compareTo(s) <= 0) continue;
            map.put(name, previous);
        }
        return map;
    }

    public int[][] featureByName(String s) {
        int[][] result = this.featureMap.get(s = GeoNaming.canonical(s));
        if (result != null) {
            return result;
        }
        for (String t : GeoNaming.variants(s)) {
            result = this.featureMap.get(t);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public GeoFile[] getGeoFiles() {
        return this.geoFiles;
    }

    private Map<String, GeoFile> makeFileNameMap(GeoFile[] geoFiles) {
        HashMap<String, GeoFile> map = new HashMap<String, GeoFile>();
        for (GeoFile s : geoFiles) {
            map.put(GeoNaming.canonical(s.name), s);
            map.put(GeoNaming.canonical(CSV.readable((String)s.name)), s);
        }
        return map;
    }

    private void addVariantFeatureNames() {
        ArrayList<String> keys = new ArrayList<String>(this.featureMap.keySet());
        for (String s : keys) {
            for (String t : GeoNaming.variants(s)) {
                if (this.featureMap.containsKey(t)) continue;
                this.featureMap.put(t, this.featureMap.get(s));
            }
        }
    }

    private void placeLabelsInFiles() {
        for (LabelPoint p : this.labels) {
            int[][] where = this.featureMap.get(GeoNaming.canonical(p.parent0));
            if (where != null) {
                for (int[] item : where) {
                    this.geoFiles[item[0]].pts.add(p);
                }
            }
            if ((where = this.featureMap.get(GeoNaming.canonical(p.parent1))) == null) continue;
            for (int[] item : where) {
                this.geoFiles[item[0]].pts.add(p);
            }
        }
    }

    private LabelPoint[] readLabels(LineNumberReader rdr) throws IOException {
        String line;
        ArrayList<LabelPoint> list = new ArrayList<LabelPoint>();
        while ((line = rdr.readLine()) != null) {
            list.add(LabelPoint.parse(line));
        }
        Collections.sort(list, new Comparator<LabelPoint>(){

            @Override
            public int compare(LabelPoint a, LabelPoint b) {
                if (a.rank != b.rank) {
                    return a.rank - b.rank;
                }
                if (a.size != b.size) {
                    return b.size - a.size;
                }
                return a.label.compareTo(b.label);
            }
        });
        return list.toArray(new LabelPoint[list.size()]);
    }

    private HashMap<String, int[][]> readFeatureDescriptions(LineNumberReader rdr) throws IOException {
        String line;
        HashMap<String, int[][]> map = new HashMap<String, int[][]>();
        while ((line = rdr.readLine()) != null) {
            if (line.trim().length() == 0) continue;
            String[] featureLine = line.split("\\|");
            String name = featureLine[0];
            int m = featureLine.length - 1;
            int[][] data = new int[m][2];
            for (int i = 0; i < m; ++i) {
                String[] s = featureLine[i + 1].split(":");
                data[i][0] = Integer.parseInt(s[0]);
                data[i][1] = Integer.parseInt(s[1]);
            }
            map.put(GeoNaming.canonical(name), data);
        }
        return map;
    }

    private GeoFile[] readFileDescriptions(LineNumberReader rdr) throws IOException {
        String[] fileLine;
        ArrayList<GeoFile> list = new ArrayList<GeoFile>();
        while ((fileLine = rdr.readLine().split("\\|")).length == 4) {
            list.add(new GeoFile(fileLine[0], fileLine[1], fileLine[2]));
        }
        return list.toArray(new GeoFile[list.size()]);
    }

    GeoMapping make(Object[] names, Param[] geoParameters) {
        return GeoMapping.createGeoMapping(names, this.makeRequiredFiles(geoParameters), this);
    }

    GeoMapping world() {
        return this.make(new Object[0], new Param[]{Param.makeString("world")});
    }

    private List<GeoFile> makeRequiredFiles(Param[] params) {
        if (params.length == 0) {
            return null;
        }
        HashSet<GeoFile> byFeature = new HashSet<GeoFile>();
        ArrayList<GeoFile> result = new ArrayList<GeoFile>();
        for (Param p : params) {
            String key = GeoNaming.canonical(p.asString());
            GeoFile f = this.filesByName.get(key);
            if (f != null) {
                result.add(f);
                continue;
            }
            int[][] feature = this.featureMap.get(key);
            if (feature != null) {
                byFeature.add(this.geoFiles[feature[0][0]]);
                continue;
            }
            LabelPoint location = this.labelsByName.get(key);
            if (location == null) continue;
            byFeature.add(this.smallestFileContaining(location));
        }
        result.addAll(byFeature);
        return result;
    }

    private GeoFile smallestFileContaining(Point point) {
        GeoFile result = null;
        for (GeoFile g : this.geoFiles) {
            if (!g.covers(point) || result != null && !(g.bounds.area() < result.bounds.area())) continue;
            result = g;
        }
        return result;
    }

    GeoMapping makeForPoints(Poly hull, Param[] geoParameters) {
        return GeoMapping.createGeoMapping(hull, this.makeRequiredFiles(geoParameters), this);
    }
}

