/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.geom;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Stack;
import org.brunel.geom.Point;
import org.brunel.geom.Poly;
import org.brunel.geom.Rect;

public class Geom {
    public static Poly makeConvexHull(Collection<Point> pts) {
        int i;
        Object[] points = pts.toArray(new Point[pts.size()]);
        Arrays.sort(points);
        Stack<Point> stack = new Stack<Point>();
        if (points.length == 0) {
            return new Poly(new Point[0]);
        }
        Object p0 = points[0];
        stack.push((Point)p0);
        int N = points.length;
        Arrays.sort(points, 1, N, new PolarComparator((Point)p0));
        for (i = 1; i < N && ((Point)p0).equals(points[i]); ++i) {
        }
        if (i == N) {
            return new Poly(new Point[]{p0});
        }
        Object p1 = points[i];
        ++i;
        while (i < N && Point.ccw((Point)p0, (Point)p1, (Point)points[i]) == 0) {
            ++i;
        }
        stack.push((Point)points[i - 1]);
        while (i < N) {
            Point top = (Point)stack.pop();
            while (Point.ccw(stack.peek(), top, (Point)points[i]) <= 0) {
                top = stack.pop();
            }
            stack.push(top);
            stack.push((Point)points[i]);
            ++i;
        }
        return new Poly(stack);
    }

    public static Rect bounds(Point[] points) {
        if (points.length == 0) {
            return null;
        }
        Rect r = new Rect(points[0].x, points[0].x, points[0].y, points[1].y);
        for (int i = 1; i < points.length; ++i) {
            r = r.union(points[i]);
        }
        return r;
    }

    static double distance(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }

    private static class PolarComparator
    implements Comparator<Point> {
        private final Point p;

        public PolarComparator(Point p) {
            this.p = p;
        }

        @Override
        public int compare(Point q1, Point q2) {
            return -Point.ccw(this.p, q1, q2);
        }
    }
}

