/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.info;

import java.util.Arrays;
import java.util.Comparator;
import org.brunel.build.info.ChartCoordinates;
import org.brunel.build.info.ElementStructure;
import org.brunel.data.Dataset;
import org.brunel.maps.GeoInformation;
import org.brunel.maps.GeoMapping;
import org.brunel.model.VisSingle;
import org.brunel.model.VisTypes;

public class ChartStructure {
    public final int sourceIndex;
    public final ChartCoordinates coordinates;
    public final int chartIndex;
    public final VisSingle[] elements;
    public final GeoInformation geo;
    public final VisTypes.Diagram diagram;
    public final ElementStructure[] elementStructure;
    public final ChartStructure outer;
    public final Integer innerChartIndex;
    private final Dataset[] baseDataSets;

    public ChartStructure(int chartIndex, VisSingle[] elements, Dataset[] data, Dataset[] dataSets, ChartStructure outer, Integer innerChartIndex) {
        this.baseDataSets = dataSets;
        this.chartIndex = chartIndex;
        this.elements = elements;
        this.outer = outer;
        this.innerChartIndex = innerChartIndex;
        this.coordinates = new ChartCoordinates(elements, data);
        this.elementStructure = new ElementStructure[elements.length];
        this.diagram = this.findDiagram();
        this.sourceIndex = this.findSourceElement(elements);
        this.geo = this.makeGeo(elements, data);
        for (int i = 0; i < elements.length; ++i) {
            VisSingle vis = elements[i];
            boolean isDependent = this.sourceIndex >= 0 && vis.tDiagram == null && vis.positionFields().length == 0;
            GeoMapping geoMapping = this.geo == null ? null : this.geo.getGeo(vis);
            this.elementStructure[i] = new ElementStructure(this, i, vis, data[i], geoMapping, isDependent);
        }
    }

    public static String makeChartID(int index) {
        return "" + (index + 1);
    }

    public boolean nested() {
        return this.outer != null;
    }

    private VisTypes.Diagram findDiagram() {
        for (VisSingle e : this.elements) {
            if (e.tDiagram == null) continue;
            return e.tDiagram;
        }
        return null;
    }

    private int findSourceElement(VisSingle[] elements) {
        int candidate = -1;
        for (int i = 0; i < elements.length; ++i) {
            VisSingle vis = elements[i];
            if (vis.fKeys.size() != 1) continue;
            if (candidate < 0) {
                candidate = i;
                continue;
            }
            if (vis.tDiagram != null) {
                return i;
            }
            if (vis.positionFields().length <= elements[candidate].positionFields().length) continue;
            candidate = i;
        }
        return candidate;
    }

    public GeoInformation makeGeo(VisSingle[] elements, Dataset[] data) {
        for (VisSingle vis : elements) {
            if (vis.tDiagram != VisTypes.Diagram.map) continue;
            return new GeoInformation(elements, data, this.coordinates);
        }
        return null;
    }

    public Integer[] elementBuildOrder() {
        Integer[] order = new Integer[this.elements.length];
        for (int i = 0; i < order.length; ++i) {
            order[i] = i;
        }
        Arrays.sort(order, new Comparator<Integer>(){

            @Override
            public int compare(Integer a, Integer b) {
                VisSingle aa = ChartStructure.this.elements[a];
                VisSingle bb = ChartStructure.this.elements[b];
                if (aa.tDiagram != null && bb.tDiagram == null) {
                    return -1;
                }
                if (aa.tDiagram == null && bb.tDiagram != null) {
                    return 1;
                }
                if (aa.tElement == VisTypes.Element.edge && bb.tElement != VisTypes.Element.edge) {
                    return 1;
                }
                if (aa.tElement != VisTypes.Element.edge && bb.tElement == VisTypes.Element.edge) {
                    return -1;
                }
                return aa.fKeys.size() - bb.fKeys.size();
            }
        });
        return order;
    }

    public int getBaseDatasetIndex(Dataset dataset) {
        for (int i = 0; i < this.baseDataSets.length; ++i) {
            if (dataset != this.baseDataSets[i]) continue;
            return i;
        }
        throw new IllegalStateException("Could not find data set in array of datasets");
    }

    public String chartID() {
        return ChartStructure.makeChartID(this.chartIndex);
    }

    public ElementStructure getEdge() {
        for (ElementStructure e : this.elementStructure) {
            if (!e.isGraphEdge()) continue;
            return e;
        }
        throw new IllegalStateException("Networks were requested, but no suitable edge elements were defined");
    }
}

