/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.info;

import org.brunel.action.Param;
import org.brunel.model.VisItem;

public class ChartLayout {
    public static final double[][][] LAYOUTS = new double[][][]{new double[][]{{0.0, 0.0, 100.0, 100.0}}, new double[][]{{0.0, 0.0, 100.0, 50.0}, {0.0, 50.0, 100.0, 100.0}}, new double[][]{{0.0, 0.0, 100.0, 50.0}, {0.0, 50.0, 50.0, 100.0}, {50.0, 50.0, 100.0, 100.0}}, new double[][]{{0.0, 0.0, 50.0, 50.0}, {0.0, 50.0, 50.0, 100.0}, {50.0, 0.0, 100.0, 50.0}, {50.0, 50.0, 100.0, 100.0}}};
    private final double[][] locations;

    public ChartLayout(int width, int height, VisItem ... charts) {
        this.locations = new double[charts.length][];
        double[][] unplacedLayouts = this.makeUnplacedLocations(width, height, charts);
        int nUnplaced = 0;
        for (int i = 0; i < charts.length; ++i) {
            VisItem chart = charts[i];
            Param[] bounds = this.findBounds(chart);
            this.locations[i] = bounds == null ? unplacedLayouts[nUnplaced++] : this.getLocation(bounds);
        }
    }

    public double[] getLocation(int chartIndex) {
        return this.locations[chartIndex];
    }

    private Param[] findBounds(VisItem chart) {
        if (chart.children() == null) {
            return chart.getSingle().bounds;
        }
        for (VisItem v : chart.children()) {
            Param[] result = this.findBounds(v);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private double[] getLocation(Param[] bounds) {
        double l = 0.0;
        double t = 0.0;
        double r = 100.0;
        double b = 100.0;
        if (bounds != null && bounds.length > 0) {
            l = bounds[0].asDouble();
        }
        if (bounds != null && bounds.length > 1) {
            t = bounds[1].asDouble();
        }
        if (bounds != null && bounds.length > 2) {
            r = bounds[2].asDouble();
        }
        if (bounds != null && bounds.length > 3) {
            b = bounds[3].asDouble();
        }
        return new double[]{t, l, b, r};
    }

    private double[][] makeUnplacedLocations(int width, int height, VisItem[] charts) {
        int unplacedCount = 0;
        for (VisItem chart : charts) {
            if (this.findBounds(chart) != null) continue;
            ++unplacedCount;
        }
        if (unplacedCount == 0) {
            return new double[0][];
        }
        return this.squarify(LAYOUTS[Math.min(unplacedCount - 1, 3)], width, height);
    }

    private double[][] squarify(double[][] layout, int width, int height) {
        double[][] alternate = new double[layout.length][];
        for (int i = 0; i < layout.length; ++i) {
            alternate[i] = new double[]{layout[i][1], layout[i][0], layout[i][3], layout[i][2]};
        }
        return this.squarifyDivergence(alternate, width, height) < this.squarifyDivergence(layout, width, height) ? alternate : (double[][])layout;
    }

    private double squarifyDivergence(double[][] rects, int width, int height) {
        double sum = 0.0;
        for (double[] r : rects) {
            double h = Math.abs(r[1] - r[3]) * (double)width;
            double v = Math.abs(r[0] - r[2]) * (double)height;
            double div = h / v - 1.62;
            sum += Math.sqrt(h * v) * div * div;
        }
        return sum;
    }
}

