/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3.diagrams;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.brunel.build.d3.diagrams.D3Diagram;
import org.brunel.build.d3.element.ElementDetails;
import org.brunel.build.d3.element.ElementRepresentation;
import org.brunel.build.info.ChartStructure;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Data;
import org.brunel.data.Dataset;
import org.brunel.geom.Point;
import org.brunel.geom.Rect;
import org.brunel.maps.LabelPoint;
import org.brunel.model.VisSingle;

public class GeoMapLabels
extends D3Diagram {
    private final NumberFormat F = new DecimalFormat("#.####");
    private final ChartStructure structure;

    public GeoMapLabels(VisSingle vis, Dataset data, ChartStructure structure, ScriptWriter out) {
        super(vis, data, out);
        this.structure = structure;
    }

    @Override
    public String getRowKey() {
        return "d[2]";
    }

    @Override
    public void preBuildDefinitions() {
        List<LabelPoint> points = this.structure.geo.getLabelsWithinScaleBounds();
        int maxPoints = 40;
        if (this.vis.tDiagramParameters[0].modifiers().length > 0) {
            maxPoints = (int)this.vis.tDiagramParameters[0].modifiers()[0].asDouble();
        }
        points = this.thin(points, maxPoints);
        int popHigh = 0;
        int popLow = 100;
        for (LabelPoint p : points) {
            popHigh = Math.max(popHigh, p.size);
            popLow = Math.min(popLow, p.size);
        }
        this.out.onNewLine().comment("lon, lat, label, size, type");
        this.out.add("var geo_labels = [").indentMore();
        boolean first = true;
        for (LabelPoint p : points) {
            if (!first) {
                this.out.add(", ");
            }
            String s = "[" + this.F.format(p.x) + "," + this.F.format(p.y) + "," + Data.quote((String)p.label) + "," + this.radiusFor(p, popHigh, popLow) + "," + p.type + "]";
            if (this.out.currentColumn() + s.length() > 120) {
                this.out.onNewLine();
            }
            this.out.add(s);
            first = false;
        }
        this.out.indentLess().add("]").endStatement();
    }

    @Override
    public ElementDetails initializeDiagram() {
        return ElementDetails.makeForDiagram(this.vis, ElementRepresentation.symbol, "point", "geo_labels");
    }

    @Override
    public void writeDefinition(ElementDetails details) {
        this.out.addChained("attr('d', function(d) { return BrunelD3.symbol(['star','star','square','circle'][d[4]-1], d[3]*geom.default_point_size/14)})").addChained("attr('class', function(d) { return 'mark L' + d[4] })");
        this.out.addChained("attr('transform', projectTransform)");
        this.out.endStatement();
        this.out.add("diagramLabels.classed('map', true)").endStatement();
        this.out.add("var labelSel = diagramLabels.selectAll('*').data(" + details.dataSource + ", function(d) { return d[2]})").endStatement();
        this.out.add("labelSel.enter().append('text')").addChained("attr('dy', '0.3em')").addChained("attr('dx', function(d) { return (2 + d[3]*geom.default_point_size/10) + 'px'})").addChained("attr('class', function(d) { return 'label L' + d[4] })").addChained("text(function(d) {return d[2]})").endStatement();
        this.out.add("labelSel");
        this.out.addChained("attr('transform', projectTransform)");
        this.out.endStatement();
    }

    @Override
    public boolean needsDiagramLabels() {
        return true;
    }

    @Override
    public void writeDiagramEnter() {
        this.out.addChained("classed('map', true)");
        this.out.endStatement();
    }

    private List<LabelPoint> thin(List<LabelPoint> points, int maxPoints) {
        Rect bds = this.structure.geo.projectedBounds();
        double scale = Math.min(800.0 / bds.width(), 600.0 / bds.height());
        ArrayList<LabelPoint> result = new ArrayList<LabelPoint>();
        ArrayList<Rect> accepted = new ArrayList<Rect>();
        Font font = new Font("Helvetica", 0, 12);
        FontRenderContext frc = new FontRenderContext(null, true, true);
        for (LabelPoint p : points) {
            boolean intersects = false;
            Point pp = this.structure.geo.transform(p);
            double x = pp.x * scale;
            double y = pp.y * scale;
            Rectangle2D size = font.getStringBounds(p.label, frc);
            Rect s = new Rect(x - 15.0, x + size.getWidth() + 15.0, y, y + size.getHeight());
            for (Rect r : accepted) {
                if (!r.intersects(s)) continue;
                intersects = true;
                break;
            }
            if (!intersects) {
                accepted.add(s);
                result.add(p);
            }
            if (result.size() < maxPoints) continue;
            break;
        }
        return result;
    }

    private int radiusFor(LabelPoint p, int high, int low) {
        return (int)Math.round((double)(p.size - low) * 4.0 / (double)(high - low) + 3.0);
    }
}

