/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3.diagrams;

import org.brunel.build.d3.diagrams.D3Diagram;
import org.brunel.build.d3.element.ElementDetails;
import org.brunel.build.d3.element.ElementRepresentation;
import org.brunel.build.util.ModelUtil;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Data;
import org.brunel.data.Dataset;
import org.brunel.model.VisSingle;

class Chord
extends D3Diagram {
    public Chord(VisSingle vis, Dataset data, ScriptWriter out) {
        super(vis, data, out);
    }

    @Override
    public String getRowKey() {
        return "d.source.index + '|' + d.target.index";
    }

    @Override
    public ElementDetails initializeDiagram() {
        String f1 = this.vis.positionFields()[0];
        String f2 = this.position[1];
        this.out.comment("Define chord data structures");
        this.out.add("var chordData = BrunelData.diagram_Chord.make(processed,");
        if (this.size == null) {
            this.out.addQuoted(f1, f2);
        } else {
            this.out.addQuoted(f1, f2, this.size);
        }
        this.out.add(")").endStatement();
        this.out.add("var chord = d3.layout.chord().padding(.025).sortSubgroups(d3.descending).matrix(chordData.matrix())").endStatement();
        ModelUtil.Size labelSize = ModelUtil.getAxisLabelFontSize(this.vis);
        double arcWidth = labelSize.valueInPixels(8.0);
        this.out.add("var arc_width =", Data.formatNumeric((double)arcWidth, (boolean)false), ";").comment("Width of exterior arc");
        this.out.add("function keyFunction(d) { return d.source.index + '|' + d.target.index };").comment(" special key function for the edges");
        return ElementDetails.makeForDiagram(this.vis, ElementRepresentation.polygon, "edge", "chord.chords()");
    }

    @Override
    public void writeDefinition(ElementDetails details) {
        this.out.addChained("attr('d', d3.svg.chord().radius(geom.inner_radius-arc_width))").addChained("attr('class', 'element " + this.element.name() + "')").endStatement();
        this.addAestheticsAndTooltips(details, true);
        this.out.onNewLine().ln().comment("Add in the arcs on the outside for the groups");
        this.out.add("diagramExtras.attr('class', 'diagram chord axis')").endStatement();
        this.out.add("var arcGroup = diagramExtras.selectAll('path').data(chord.groups)").endStatement();
        this.out.add("arcGroup.enter().append('path').attr('class', 'box')").endStatement();
        this.out.add("BrunelD3.trans(arcGroup,transitionMillis)").addChained("attr('d', d3.svg.arc().innerRadius(geom.inner_radius - arc_width).outerRadius(geom.inner_radius))").addChained("attr('id', function(d, i) { return 'arc' + i; })").endStatement();
        this.out.add("var arcText = diagramExtras.selectAll('text').data(chord.groups)").endStatement();
        this.out.add("arcText.enter().append('text').attr('class', 'axis label')").endStatement();
        this.out.add("arcText.filter(function() { return !this.firstChild } )").comment("Only add paths if nothing yet added").addChained("attr('dy', arc_width*0.72).attr('class', 'label')").addChained("append('textPath').attr('xlink:href', function(d, i) { return '#arc' + i })").addChained("text(function(d, i) { return chordData.group(i); })").endStatement();
        this.out.add("BrunelD3.tween(arcText, transitionMillis,").indentMore().ln().add("function(d,i) { var txt=this; return function() { BrunelD3.centerInWedge(txt, arcGroup[0][i], arc_width) } })").endStatement();
    }

    @Override
    public boolean needsDiagramExtras() {
        return true;
    }

    @Override
    public void writeDiagramEnter() {
        this.out.endStatement();
        this.out.add("selection.each(function(d) { d.row = chordData.index(d.target.index, d.target.subindex) })").endStatement();
    }
}

